/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Attribute;
import cerent.cms.model.FramingType;
import cerent.cms.model.IFramingType;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.circuits.SpanDataSource;
import cerent.cms.model.circuits.SpanRow;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.ProtectionSwitchError;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.circuits.CircuitColumnRenderer;
import cerent.cms.ui.circuits.CircuitEditDialog;
import cerent.cms.ui.circuits.SpanColumnRenderer;
import cerent.util.ErrorMsg;
import cerent.util.IAsyncObserver;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DetailedDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.RowTableModel;
import cerent.util.job.JobStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

public class SpanCircuitsPane
extends AbstractPane
implements ActionListener,
MouseListener,
PropertyChangeListener,
IAsyncObserver {
    public String UPSR_TERM;
    public String SWITCH;
    public static final String APPLY = "Apply";
    RowTableModel model;
    SpanDataSource source;
    private IFramingType[] allFramingTypes;
    private IFramingType currFramingType;
    private ButtonGroup framingTypeBG;
    private JRadioButton sdhAu4Button;
    private JRadioButton sdhAu3Button;
    private JComboBox swTypeCB;
    private JButton applyPB;
    private JPanel switchPanel;
    ImageIcon INFO_ICON = new ImageIcon(CerentDialog.class.getResource("/images/icons/informational32.gif"));
    private Map crMap = new HashMap();
    private static final SDebug db = new SDebug("SpanCircuitsPane");

    public SpanCircuitsPane() {
        super("SpanCircuitsPane", (IModel)NetworkModel.instance().getCmsHostModel(), null);
        this.setDefaultPrivilegeLevel(SecurityLevel.MAINTENANCE);
        Preferences.instance().addPropertyChangeListener((PropertyChangeListener)this);
        CircuitColumnRenderer.loadColors();
        INodeModel iNodeModel = NetworkModel.instance().getCmsHostModel().getNodeModel();
        this.UPSR_TERM = iNodeModel.getTDMTerminology().getRingTerms(0);
        this.SWITCH = "Perform " + this.UPSR_TERM + " span switching: ";
        this.allFramingTypes = Network.instance().getSupportedFramingTypes();
        this.currFramingType = this.allFramingTypes.length == 1 ? this.allFramingTypes[0] : FramingType.SDH_AU4;
        for (int i = 0; i < this.allFramingTypes.length; ++i) {
            ArrayList<ColumnRenderer[]> arrayList = new ArrayList<ColumnRenderer[]>(2);
            boolean bl = true;
            for (int j = 0; j < 2; ++j) {
                arrayList.add(SpanColumnRenderer.createTableRenderers(0, this.allFramingTypes[i].getEnum(), bl));
                bl = false;
            }
            this.crMap.put(this.allFramingTypes[i], arrayList);
        }
        ColumnRenderer[] columnRendererArray = (ColumnRenderer[])((List)this.crMap.get(this.currFramingType)).get(1);
        this.source = new SpanDataSource(this);
        this.model = new RowTableModel((RowDataSource)this.source, columnRendererArray);
        this.table = new UTable((TableModel)this.model);
        this.model.initTable(this.table);
        this.initPane();
        this.table.addMouseListener(this);
        this.getColumnPrefs(false, this.currFramingType);
    }

    protected void initPane() {
        this.setLayout(new BorderLayout(5, 5));
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.add((Component)uScrollPane, "Center");
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        JPanel jPanel3 = new JPanel(new FlowLayout(1, 5, 5));
        JPanel jPanel4 = new JPanel(new FlowLayout(2, 5, 5));
        jPanel2.add(this.getFramingTypesBar());
        this.switchPanel = this.getButtonBar();
        jPanel3.add(this.switchPanel);
        this.switchPanel.setVisible(false);
        jPanel4.add(new CSHelpButton(NetCSHelpConst.SpanCircuitsPane));
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "Center");
        jPanel.add((Component)jPanel4, "East");
        this.add(jPanel, "South");
    }

    public void setLink(INetLink iNetLink) {
        this.source.setNetLink(iNetLink);
    }

    public void showUpsrObjects(boolean bl) {
        if (this.switchPanel.isVisible() != bl) {
            db.fine("showUpsr=" + bl);
            this.setColumnPrefs(!bl, this.currFramingType);
            this.switchPanel.setVisible(bl);
            this.setColumnRenderers(bl, this.currFramingType);
            this.getColumnPrefs(bl, this.currFramingType);
        }
    }

    private void setColumnRenderers(IFramingType iFramingType, IFramingType iFramingType2) {
        db.fine("oldFrame=" + iFramingType.getFramingTypeString() + ",newFrame=" + iFramingType2.getFramingTypeString());
        boolean bl = this.switchPanel.isVisible();
        this.setColumnPrefs(bl, iFramingType);
        this.setColumnRenderers(bl, iFramingType2);
        this.getColumnPrefs(bl, iFramingType2);
    }

    private void setColumnRenderers(boolean bl, IFramingType iFramingType) {
        List list = (List)this.crMap.get(iFramingType);
        ColumnRenderer[] columnRendererArray = (ColumnRenderer[])(bl ? list.get(0) : list.get(1));
        this.model.setColumnRenderers(columnRendererArray);
        this.model.initTable(this.table);
    }

    protected void setApplyButtonEnabled(int n) {
        int n2 = 4;
        int n3 = this.source.getRowCount();
        for (int i = 0; i < n3; ++i) {
            int n4;
            SpanRow spanRow = (SpanRow)this.source.getObjectAtRow(i);
            INetCircuitSpan iNetCircuitSpan = spanRow.span;
            if (iNetCircuitSpan == null || !iNetCircuitSpan.isUpsr() || (n4 = iNetCircuitSpan.getProtectionOp()) >= n2) continue;
            n2 = n4;
        }
        if (n2 == 1 && n == 1) {
            this.applyPB.setEnabled(false);
        } else if (n2 == 3 && (n == 1 || n == 3)) {
            this.applyPB.setEnabled(false);
        } else if (n2 == 4 && n != 0) {
            this.applyPB.setEnabled(false);
        } else {
            this.applyPB.setEnabled(true);
        }
    }

    private boolean displaySwitchDialog(int n) {
        String string = "Traffic might not switch away from this span.  Verify\nthe proper switch of traffic prior to performing potentially\nservice affecting work on this span.\n\nIs it OK to continue?\n";
        String string2 = "Performing a lockout of protection does not switch traffic off \nthis span.  It disables " + this.UPSR_TERM + " protection \n" + "and should be applied for a limited time only.\n\n" + "Is it OK to continue?\n";
        return n != 0 && n != 4 ? CerentDialog.yesNoDialog((Component)((Object)this), (String)string, (String)("Confirm " + this.UPSR_TERM + " switch")) : (n == 4 ? CerentDialog.yesNoDialog((Component)((Object)this), (String)string2, (String)("Confirm " + this.UPSR_TERM + " switch")) : CerentDialog.yesNoDialog((Component)((Object)this), (String)"Are you sure you want to continue with the switch?\n", (String)("Confirm " + this.UPSR_TERM + " switch")));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        int n = -1;
        Object object2 = actionEvent.getSource();
        if (object2 == this.sdhAu4Button || object2 == this.sdhAu3Button) {
            object = this.currFramingType;
            this.currFramingType = object2 == this.sdhAu4Button ? FramingType.SDH_AU4 : FramingType.SDH_AU3;
            this.source.refreshCircuits();
            this.setColumnRenderers((IFramingType)object, this.currFramingType);
        }
        if ((object = (Attribute)this.swTypeCB.getSelectedItem()) != null) {
            n = ((Attribute)object).getValue();
            if (object2 == this.swTypeCB) {
                this.setApplyButtonEnabled(n);
            } else if (object2 == this.applyPB && this.displaySwitchDialog(n)) {
                ArrayList arrayList = new ArrayList(this.source.getAllObjects());
                this.switchCircuits(arrayList, n);
                this.swTypeCB.setSelectedItem(null);
            }
        }
    }

    private void switchCircuits(List list, int n) {
        int n2 = n;
        String string = NetworkDefaults.spanProtectionOPToString(n2);
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        LinkedList<INetCircuitSpan> linkedList = new LinkedList<INetCircuitSpan>();
        for (SpanRow spanRow : list) {
            if (spanRow.circuit == null || spanRow.span == null || !spanRow.span.isUpsr()) continue;
            linkedList.add(spanRow.span);
        }
        if (linkedList.size() > 0) {
            INetCircuitSpan[] iNetCircuitSpanArray = new INetCircuitSpan[]{};
            iNetCircuitSpanArray = linkedList.toArray(iNetCircuitSpanArray);
            try {
                NetCircuitManager.instance().performProtectionOp(iNetCircuitSpanArray, n2, string, this);
            }
            catch (ProtectionSwitchError protectionSwitchError) {
                String string4 = "The " + string + " request could not be completed.";
                SDebug.printStackTrace((Throwable)protectionSwitchError);
                ErrorMsg.displayError((Component)((Object)this), NEMC.EID_FAILED_TO_APPLY_UPSR_REQUEST_PARAM_2, this.UPSR_TERM, string4);
            }
        } else {
            CerentDialog.infoDialog((Component)((Object)this), (String)("No " + this.UPSR_TERM + "-protected circuits are on this span."), (String)("No " + string + " request was applied."));
        }
    }

    public void asyncUpdate(Object object, JobStatus jobStatus) {
        final String string = (String)object;
        final String string2 = (String)jobStatus.getResult();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DetailedDialog detailedDialog = DetailedDialog.instance((Frame)new JFrame(), (String)"Protection Switch Result");
                detailedDialog.setText(string, SpanCircuitsPane.this.INFO_ICON);
                detailedDialog.append(string2);
                detailedDialog.show();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    @Override
    public void destroy() {
        if (this.switchPanel != null) {
            this.setColumnPrefs(this.switchPanel.isVisible(), this.currFramingType);
        }
        Preferences.instance().removePropertyChangeListener((PropertyChangeListener)this);
        this.model.release();
        this.model = null;
        this.source.dispose();
        this.source = null;
        super.destroy();
    }

    private void getColumnPrefs(boolean bl, IFramingType iFramingType) {
        TablePropertyMgr.getColumnPrefs(this.table, this.getColumnPrefsName(bl, iFramingType));
    }

    private void setColumnPrefs(boolean bl, IFramingType iFramingType) {
        TablePropertyMgr.setColumnPrefs(this.table, this.getColumnPrefsName(bl, iFramingType));
    }

    private String getColumnPrefsName(boolean bl, IFramingType iFramingType) {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append("_" + iFramingType.getFramingTypeString());
        if (bl) {
            stringBuffer.append("_UPSR");
        }
        return stringBuffer.toString();
    }

    @Override
    public void enteringPage() throws Exception {
    }

    @Override
    public void leavingPage() throws Exception {
    }

    @Override
    public void refresh() {
    }

    private JPanel getFramingTypesBar() {
        JPanel jPanel = SpanCircuitsPane.createHorizontalPanel(null);
        if (this.allFramingTypes.length > 1) {
            this.sdhAu4Button = new JRadioButton("SDH-AU4");
            this.sdhAu3Button = new JRadioButton("SDH-AU3");
            this.framingTypeBG = new ButtonGroup();
            this.framingTypeBG.add(this.sdhAu4Button);
            this.framingTypeBG.add(this.sdhAu3Button);
            this.sdhAu4Button.addActionListener(this);
            this.sdhAu3Button.addActionListener(this);
            jPanel.add(this.sdhAu4Button);
            jPanel.add(this.sdhAu3Button);
            this.sdhAu4Button.setSelected(true);
        }
        return jPanel;
    }

    private JPanel getButtonBar() {
        JPanel jPanel = SpanCircuitsPane.createHorizontalPanel(null);
        this.swTypeCB = new JComboBox<Attribute>(NetworkDefaults.getAttributeMap().getAttributeArray("spanProtectionOp"));
        this.swTypeCB.setSelectedItem(null);
        this.swTypeCB.addActionListener(this);
        this.enableComponent(this.swTypeCB);
        jPanel.add(new JLabel(this.SWITCH));
        jPanel.add(this.swTypeCB);
        this.applyPB = new JButton(APPLY);
        this.applyPB.addActionListener(this);
        this.applyPB.setAlignmentY(0.5f);
        this.applyPB.setEnabled(false);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(this.applyPB);
        return jPanel;
    }

    public int getCurrentFramingType() {
        return this.currFramingType.getEnum();
    }

    public boolean supportsMultipleFramingTypes() {
        return this.framingTypeBG != null;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.getClickCount() == 2 && (n = this.table.rowAtPoint(mouseEvent.getPoint())) != -1) {
            SpanRow spanRow = (SpanRow)this.source.getObjectAtRow(n);
            INetCircuit iNetCircuit = spanRow.circuit;
            if (iNetCircuit != null) {
                CircuitEditDialog.instance(iNetCircuit).show();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        CircuitColumnRenderer.loadColors();
        this.table.repaint();
    }
}

