/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.INodeShelfModel;
import cerent.cms.model.NodeModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.circuits.SvlanCircuitDataSource;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.DeletionWarning;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitWatchDog;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.IPreselectCircuits;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.WzDialog;
import cerent.cms.ui.circuits.CcdWizardInfo;
import cerent.cms.ui.circuits.CircuitCreationDialog;
import cerent.cms.ui.circuits.CircuitEditDialog;
import cerent.cms.ui.circuits.CircuitSearchDialog;
import cerent.cms.ui.circuits.CircuitsByNameTable;
import cerent.cms.ui.circuits.CircuitsTableModel;
import cerent.cms.ui.circuits.SvlanCircuitColumnRenderer;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.EventBus;
import cerent.util.EventBusServices;
import cerent.util.EventMaskUtil;
import cerent.util.IAsyncObserver;
import cerent.util.NEMC;
import cerent.util.PluralisationUtil;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.SvlanRange;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DetailedDialog;
import cerent.util.gui.UFrame;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.VlanListPropertyEditor;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.job.JobStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumnModel;

public class SvlanCircuitsPane
extends AbstractPane
implements ActionListener,
IAsyncObserver,
IPreselectCircuits,
TableModelListener,
ListSelectionListener,
MouseListener,
PropertyChangeListener {
    private static final int MAX_DEL_CIRCUITS_NUM = 200;
    public static final String CREATE = "Create...";
    public static final String DELETE = "Delete...";
    public static final String EDIT = "Edit...";
    public static final String SEARCH = "Search...";
    public static final String QUERY = "Query...";
    public static final String REFRESH = "Refresh";
    protected static final String SCOPE_LABEL = "Scope:";
    protected static final String SCOPE_NET = "Network";
    protected static final String SCOPE_NODE = "Node";
    protected static final String SCOPE_SHELF = "Shelf";
    protected static final String SCOPE_CARD = "Card";
    private static final String SCOPE_NET_ALL = "Network (All)";
    private static final String SCOPE_NET_DWDM = "Network (DWDM)";
    private static final String SCOPE_NET_TDM = "Network (TDM)";
    private int netViewLayer;
    UScrollPane scrollPane;
    private JPanel buttons;
    private JButton createPB;
    private JButton deletePB;
    private JButton editPB;
    private JButton searchPB;
    private JButton refreshPB;
    protected JComboBox scopeCB;
    private VlanListPropertyEditor svlanList;
    private Vector circuitsVector;
    private CircuitsTableModel model;
    private SvlanCircuitDataSource source;
    private boolean inited = false;
    private CircuitSearchDialog csd = null;
    private ColumnRenderer[] columnRenderers = null;
    private List preselectedCircuitIds = null;
    protected static final int MAX_RECOMMENDED_DIALOGS = 7;
    private CcdWizardInfo wizardInfo = new CcdWizardInfo();
    private INodeModel srcNode = null;
    private INodeModel dstNode = null;
    private SvlanRange[] range;
    private boolean preselectionsActive = false;
    private boolean notifyCktDeletionCompletion = false;
    private static final SDebug db = new SDebug("SvlanCircuitsPane");

    public SvlanCircuitsPane(String string, IModel iModel, TabbedView tabbedView) {
        super(string, iModel, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
    }

    @Override
    public void enteringPage() {
        if (db.on()) {
            db.println(">>>  enteringPage");
        }
        if (!this.inited) {
            this.buttons = this.getButtonBar();
            this.setDefaultCircuitScope();
            this.source = new SvlanCircuitDataSource(this.getCurrentCircuitScope());
            this.columnRenderers = SvlanCircuitColumnRenderer.createTableRenderers();
            this.model = new CircuitsTableModel((RowDataSource)this.source, this.columnRenderers, INetCircuit.class);
            this.table = new CircuitsByNameTable(this.model){

                @Override
                protected void selectCircuits() {
                    SvlanCircuitsPane.this.selectPreselectedCircuits(false);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void setRowHeights(TableModelEvent tableModelEvent) {
                    try {
                        1 var2_2 = this;
                        synchronized (var2_2) {
                            this.setRowHeight(16);
                            int n = 0;
                            for (int i = 0; i < this.getRowCount(); ++i) {
                                INetCircuit iNetCircuit = (INetCircuit)this.getValueAt(i, 0);
                                if (iNetCircuit == null || iNetCircuit.getDrops() == null || iNetCircuit.getSources() == null) continue;
                                int n2 = iNetCircuit.getDrops().size();
                                int n3 = iNetCircuit.getSources().size();
                                int n4 = 0;
                                n4 = n2 + n3;
                                if (n4 == 0) continue;
                                n = UFrame.isWindowsPlatform() ? 2 : 0;
                                this.setRowHeight(i, n4 * (16 + n));
                            }
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        if (db.on()) {
                            db.println("ArrayIndexOutOfBoundsException in setRowHeights");
                        }
                        super.setRowHeights(tableModelEvent);
                    }
                }
            };
            this.updateCircuitSearchInfo();
            this.setLayout(new BorderLayout());
            this.scrollPane = new UScrollPane((Component)this.table);
            this.add((Component)this.scrollPane, "Center");
            this.add(this.buttons, "South");
            this.table.addMouseListener(this);
            this.table.getSelectionModel().addListSelectionListener(this);
            this.model.addTableModelListener(this);
            this.inited = true;
        }
        this.updateColumnWidths();
        this.refresh();
        this.source.setNetworkViewLayerFilter(this.netViewLayer);
        if (db.on()) {
            db.println("<<< enteringPage()");
        }
    }

    private void updateColumnWidths() {
        if (db.on()) {
            db.println(">>> updateColumnWidths()");
        }
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            SvlanCircuitColumnRenderer svlanCircuitColumnRenderer = (SvlanCircuitColumnRenderer)this.columnRenderers[i];
            svlanCircuitColumnRenderer.setWidth(tableColumnModel.getColumn(i).getPreferredWidth());
        }
    }

    @Override
    public void leavingPage() throws Exception {
        if (SvlanCircuitsPane.db.on) {
            db.println(">>> leavingPage()");
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
    }

    public void setNetworkViewLayerFilter(int n) {
        this.source.setNetworkViewLayerFilter(n);
        this.setDefaultCircuitScope();
    }

    @Override
    public void refresh() {
    }

    protected void removeActionListeners() {
        this.createPB.removeActionListener(this);
        this.editPB.removeActionListener(this);
        this.deletePB.removeActionListener(this);
        this.searchPB.removeActionListener(this);
        this.scopeCB.removeActionListener(this);
        this.svlanList.removePropertyChangeListener(this);
        this.refreshPB.removeActionListener(this);
    }

    @Override
    public void destroy() {
        if (db.on()) {
            db.println(">>>  destroy()");
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (this.inited) {
            this.removeActionListeners();
            this.table.removeMouseListener(this);
            this.table.getSelectionModel().removeListSelectionListener(this);
            this.model.removeTableModelListener(this);
            this.model.release();
            if (this.source != null) {
                this.source.dispose();
                this.source = null;
            }
        }
        this.preselectedCircuitIds = null;
        this.columnRenderers = null;
        super.destroy();
    }

    public boolean isInited() {
        return this.inited;
    }

    public List getAllCircuits() {
        return new ArrayList(this.source.getAllObjects());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.createPB) {
            boolean bl = EventMaskUtil.isCtrlShiftPressed(actionEvent);
            this.createCircuit(!bl);
        } else if (object == this.deletePB) {
            INetCircuit[] iNetCircuitArray = this.getSelectedCircuits("Delete", false, "");
            if (iNetCircuitArray.length > 0) {
                new CircuitDeletionDialog(iNetCircuitArray).show();
            }
        } else if (object == this.editPB) {
            this.editSelectedCircuits(this.getSelectedCircuits("Edit", false));
        } else if (object == this.refreshPB) {
            this.loadSvlanCircuit();
        } else if (object == this.searchPB) {
            this.csd = CircuitSearchDialog.instance((JComponent)((Object)this), this.table, this.scrollPane, this.circuitsVector);
            if (this.table.getSelectedRowCount() > 0) {
                INetCircuit iNetCircuit = (INetCircuit)this.table.getValueAt(this.table.getSelectedRow(), 0);
                this.csd.setSelectedCircuit(iNetCircuit);
            }
            this.csd.show();
        } else if (object == this.scopeCB && this.source != null) {
            IModel iModel = this.getCurrentCircuitScope();
            this.source.setCircuitScope(iModel);
        }
        this.syncButtons(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCircuit(boolean bl) {
        try {
            Object object;
            this.createPB.setEnabled(false);
            IModel iModel = this.getUiModel();
            if (iModel instanceof NodeModel) {
                this.srcNode = (NodeModel)iModel;
                this.dstNode = (NodeModel)iModel;
            } else if (iModel instanceof IModuleModel) {
                object = iModel.getNodeModel();
                if (object instanceof NodeModel) {
                    this.srcNode = (NodeModel)iModel;
                    this.dstNode = (NodeModel)iModel;
                } else {
                    this.srcNode = null;
                    this.dstNode = null;
                }
            }
            this.wizardInfo.srcNode = this.srcNode;
            this.wizardInfo.dstNode = this.dstNode;
            this.wizardInfo.circuitType = 16;
            object = new CircuitCreationDialog(this.wizardInfo, JOptionPane.getFrameForComponent((Component)((Object)this)), this.getParentView(), this.uiModel, bl);
            if (this.wizardInfo.srcNode != null) {
                ((CircuitCreationDialog)object).setSourceNode(this.wizardInfo.srcNode);
            }
            if (this.wizardInfo.dstNode != null) {
                ((CircuitCreationDialog)object).setDestNode(this.wizardInfo.dstNode);
            }
            ((WzDialog)object).showModal();
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("createCircuit: exception caught when attempting to display CCD.");
            }
            SDebug.printStackTrace((Throwable)exception);
        }
        finally {
            this.createPB.setEnabled(true);
        }
    }

    public boolean isCircuitSelected() {
        return this.getSelectedCircuitNum() != 0;
    }

    public int getSelectedCircuitNum() {
        return this.table.getSelectedRows().length;
    }

    public INetCircuit[] getSelectedCircuits(String string, boolean bl) {
        return this.getSelectedCircuits(string, bl, "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private INetCircuit[] getSelectedCircuits(String string, boolean bl, String string2) {
        INetCircuit[] iNetCircuitArray;
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length > 200) {
            String string3 = ErrorMsg.getString((EID)NEMC.WID_MAX_ERASEABLE_CIRCUIT_NUM);
            int n = JOptionPane.showConfirmDialog((Component)((Object)this), string3, "Delete Circuits", 0, 3, null);
            if (n != 0) return new INetCircuit[0];
            iNetCircuitArray = new INetCircuit[200];
        } else {
            iNetCircuitArray = new INetCircuit[nArray.length];
        }
        for (int i = 0; i < iNetCircuitArray.length; ++i) {
            iNetCircuitArray[i] = (INetCircuit)this.model.getValueAt(nArray[i], 0);
        }
        if (iNetCircuitArray.length != 0) {
            if (!bl) return iNetCircuitArray;
            string2 = string2 + "Are you sure you want to " + string.toLowerCase() + (iNetCircuitArray.length == 1 ? " the selected circuit?" : " " + iNetCircuitArray.length + " the selected circuits?");
            if (CerentDialog.yesNoDialog((Component)((Object)this), (String)string2, (String)(string + " Circuit"))) return iNetCircuitArray;
            return new INetCircuit[0];
        }
        ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_NO_CIRCUITS_SELECTED_PARAM_1, (Object)(string + " circuit."));
        return iNetCircuitArray;
    }

    private void deleteSelectedCircuits(INetCircuit[] iNetCircuitArray) {
        int[] nArray = NetCircuitManager.instance().deleteCheck(iNetCircuitArray);
        INetCircuit[] iNetCircuitArray2 = iNetCircuitArray;
        int n = iNetCircuitArray.length;
        if (nArray != null) {
            int n2;
            String string = "Deleting partial circuit";
            Object[] objectArray = new String[]{"Yes", "Yes to All", "No", "Cancel"};
            boolean bl = false;
            int n3 = 2;
            n = iNetCircuitArray.length - nArray.length;
            INetCircuit iNetCircuit = null;
            for (n2 = 0; n2 < nArray.length && !bl; ++n2) {
                iNetCircuit = iNetCircuitArray[nArray[n2]];
                String string2 = "The circuit \"" + iNetCircuitArray[nArray[n2]].getCircuitName() + "\"" + "is in the PARTIAL state.  Deleting this circuit might strand its bandwidth." + "\nIs it OK to force the circuit deletion?";
                n3 = CerentDialog.optionDialog((Component)((Object)this), (String)string2, (String)string, (Object[])objectArray, (Object)objectArray[2]);
                if (n3 == 1) {
                    n = iNetCircuitArray.length;
                    bl = true;
                    break;
                }
                if (n3 == 2) continue;
                if (n3 == 3) {
                    n = 0;
                    break;
                }
                if (n3 != 0) continue;
                nArray[n2] = -1;
                ++n;
            }
            if (n > 0) {
                if (bl) {
                    iNetCircuitArray2 = iNetCircuitArray;
                } else {
                    iNetCircuitArray2 = new INetCircuit[n];
                    n2 = 0;
                    int n4 = 0;
                    for (int i = 0; i < iNetCircuitArray.length; ++i) {
                        if (n2 < nArray.length && i == nArray[n2]) {
                            ++n2;
                            continue;
                        }
                        if (n4 >= n) continue;
                        iNetCircuitArray2[n4++] = iNetCircuitArray[i];
                        if (n2 >= nArray.length || nArray[n2] != -1) continue;
                        ++n2;
                    }
                }
            }
        }
        try {
            if (n > 0) {
                for (int i = 0; i < iNetCircuitArray2.length; ++i) {
                    CircuitEditDialog.closeCircuitWindow(iNetCircuitArray2[i]);
                }
                NetCircuitManager.instance().deleteSelectedCircuits(iNetCircuitArray2, -1, this);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayDetailed((Component)((Object)this), NEMC.EID_CIRCUIT_DELETION_ERROR, exception.getMessage());
        }
    }

    private void editSelectedCircuits(INetCircuit[] iNetCircuitArray) {
        String string;
        if (iNetCircuitArray.length > 7 && !CerentDialog.yesNoDialog((Component)((Object)this), (String)(string = "You have chosen to open " + iNetCircuitArray.length + " Edit Circuit Dialogs at once.\n" + "The recommended maximum is " + 7 + ".\n" + "Are you sure you wish to do this?"), (String)("Open " + iNetCircuitArray.length + " Edit Circuit Dialogs"))) {
            return;
        }
        for (int i = 0; i < iNetCircuitArray.length; ++i) {
            CircuitEditDialog.instance(iNetCircuitArray[i]).show();
        }
    }

    protected JPanel getButtonBar() {
        this.createPB = this.makeActionButton(CREATE);
        this.editPB = this.makeActionButton(EDIT);
        this.deletePB = this.makeActionButton(DELETE);
        this.refreshPB = this.makeActionButton(REFRESH);
        this.refreshPB.setEnabled(true);
        this.svlanList = new VlanListPropertyEditor("SVLANs", 10, true, true);
        this.enableComponent(this.svlanList);
        this.svlanList.addPropertyChangeListener(this);
        this.enableComponent(this.editPB, this.getUiModel(), SecurityLevel.MAINTENANCE);
        this.editPB.setEnabled(true);
        this.searchPB = this.makeActionButton(SEARCH);
        this.searchPB.setEnabled(true);
        this.scopeCB = new JComboBox<Object>(new Object[]{SCOPE_NET_ALL});
        this.scopeCB.addActionListener(this);
        JPanel jPanel = SvlanCircuitsPane.createHorizontalPanel(null);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 5, 5));
        jPanel2.add(this.createPB);
        jPanel2.add(this.editPB);
        jPanel2.add(this.deletePB);
        jPanel2.add(this.searchPB);
        jPanel2.add(Box.createHorizontalStrut(50));
        jPanel2.add(this.svlanList);
        jPanel2.add(this.refreshPB);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2, 5, 5));
        jPanel2.add(new JLabel(SCOPE_LABEL, 4));
        jPanel2.add(this.scopeCB);
        jPanel2.add(new CSHelpButton(this.getHelpID()));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jPanel2);
        return jPanel;
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.SvlanCircuitsPane;
    }

    protected JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        jButton.setFocusPainted(false);
        this.enableComponent(jButton);
        return jButton;
    }

    private void setDefaultCircuitScope() {
        String string;
        IModel iModel = this.getUiModel();
        String string2 = Preferences.instance().getProperty("ctc", "network.view.filter.node.type", "");
        if (string2.equals("DWDM")) {
            string = SCOPE_NET_DWDM;
            this.netViewLayer = 1;
        } else if (string2.equals("TDM")) {
            string = SCOPE_NET_TDM;
            this.netViewLayer = 2;
        } else {
            string = SCOPE_NET_ALL;
            this.netViewLayer = 0;
        }
        this.scopeCB.removeAllItems();
        boolean bl = false;
        if (iModel instanceof IEntityModel && iModel.getNodeModel().provides(Feature.MULTISHELF) && iModel.getNodeModel().isMultishelf()) {
            bl = true;
        }
        if (iModel instanceof IModuleModel) {
            this.scopeCB.setEnabled(true);
            this.scopeCB.addItem(string);
            this.scopeCB.addItem(SCOPE_NODE);
            if (bl) {
                this.scopeCB.addItem(SCOPE_SHELF);
            }
            this.scopeCB.addItem(SCOPE_CARD);
            this.scopeCB.setSelectedItem(SCOPE_CARD);
        } else if (iModel instanceof INodeShelfModel) {
            this.scopeCB.setEnabled(true);
            this.scopeCB.addItem(string);
            this.scopeCB.addItem(SCOPE_NODE);
            if (bl) {
                this.scopeCB.addItem(SCOPE_SHELF);
                this.scopeCB.setSelectedItem(SCOPE_SHELF);
            } else {
                this.scopeCB.setSelectedItem(SCOPE_NODE);
            }
        } else {
            this.scopeCB.setEnabled(false);
            this.scopeCB.addItem(string);
            this.scopeCB.setSelectedItem(string);
        }
    }

    public IModel getCurrentCircuitScope() {
        Object object = this.scopeCB.getSelectedItem();
        INodeModel iNodeModel = null;
        if (SCOPE_NET_ALL.equals(object) || SCOPE_NET_TDM.equals(object) || SCOPE_NET_DWDM.equals(object)) {
            iNodeModel = null;
        } else if (SCOPE_NODE.equals(object)) {
            iNodeModel = this.getUiModel().getNodeModel();
        } else if (SCOPE_SHELF.equals(object)) {
            iNodeModel = this.getUiModel();
        } else if (SCOPE_CARD.equals(object)) {
            iNodeModel = this.getUiModel();
        }
        return iNodeModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCircuitSearchInfo() {
        if (db.on()) {
            db.println(">>> updateCircuitSearchInfo()");
        }
        int n = this.model.getRowCount();
        this.circuitsVector = new Vector(n);
        for (int i = 0; i < n; ++i) {
            try {
                INetCircuit iNetCircuit = (INetCircuit)this.table.getValueAt(i, 0);
                this.circuitsVector.add(iNetCircuit);
                continue;
            }
            catch (Exception exception) {
                db.finest("Exception in updateCircuitSearchInfo() " + exception);
            }
        }
        if (SvlanCircuitsPane.db.on) {
            db.println("CircuitsPane:updateCircuitSearchInfo: " + this.circuitsVector.toString());
        }
        if (this.csd == null) {
            return;
        }
        CircuitSearchDialog circuitSearchDialog = this.csd;
        synchronized (circuitSearchDialog) {
            this.csd.setCircuitsVector(this.circuitsVector);
            this.csd.setTable(this.table);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        INetCircuit iNetCircuit;
        if (db.on()) {
            db.println(">>> tableChanged()");
        }
        this.updateCircuitSearchInfo();
        if (this.csd != null && (iNetCircuit = this.csd.getSelectedCircuit()) != null && this.circuitsVector.contains(iNetCircuit)) {
            if (db.on()) {
                db.println("relocating the circuit  " + iNetCircuit.getCircuitName());
            }
            this.csd.setSelectedCircuit(iNetCircuit);
        }
        this.syncButtons(false);
    }

    protected boolean selectThisCircuit(INetCircuit iNetCircuit) {
        if (SvlanCircuitsPane.db.on) {
            db.println("selectThisCircuit(" + iNetCircuit + ") called");
        }
        boolean bl = false;
        if (iNetCircuit != null && this.preselectedCircuitIds != null) {
            ICircuitId iCircuitId;
            if (SvlanCircuitsPane.db.on) {
                db.println("   circuit is not null - it is: " + iNetCircuit.getCircuitName());
            }
            if (this.preselectedCircuitIds.contains(iCircuitId = iNetCircuit.getCircuitId())) {
                if (db.on()) {
                    db.println("selecting CircuitId " + iCircuitId.longValue());
                }
                bl = true;
            }
        }
        return bl;
    }

    private void selectPreselectedCircuits(boolean bl) {
        int n = 0;
        if (null != this.table) {
            this.table.clearSelection();
            INetCircuit iNetCircuit = null;
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                iNetCircuit = (INetCircuit)this.table.getValueAt(i, 0);
                if (SvlanCircuitsPane.db.on) {
                    db.println("Evaluating circuit: " + iNetCircuit);
                }
                if (null != iNetCircuit) {
                    if (!this.selectThisCircuit(iNetCircuit)) continue;
                    if (n == 0) {
                        this.table.getSelectionModel().setSelectionInterval(i, i);
                    } else {
                        this.table.getSelectionModel().addSelectionInterval(i, i);
                    }
                    ++n;
                    continue;
                }
                if (!SvlanCircuitsPane.db.on) continue;
                db.println("netCircuit was null");
            }
            if (bl && n < 1) {
                String string = this.netViewLayer == 1 ? "No circuits were affected by this alarm\nin the current network view scope (DWDM)." : (this.netViewLayer == 2 ? "No circuits were affected by this alarm\nin the current network view scope (TDM)." : "No circuits were affected by this alarm.");
                CerentDialog.infoDialog((Component)((Object)this), (String)string, (String)"Select Affected Circuits");
            }
        } else if (SvlanCircuitsPane.db.on) {
            db.println("table was null");
        }
    }

    public void asyncUpdate(Object object, JobStatus jobStatus) {
        db.fine("asynchronous update received:" + jobStatus.getResult());
        db.fine("asynchronous update received value:" + jobStatus.value());
        Object object2 = jobStatus.getResult();
        DetailedLog detailedLog = null;
        if (jobStatus.value() == 2) {
            String string = ErrorMsg.getString((EID)NEMC.EID_CIRCUIT_DELETION_ERROR) + "\n" + object2.toString();
            detailedLog = new DetailedLog(3, string);
        } else if (object2 instanceof DeletionWarning) {
            SwingUtilities.invokeLater(new DeletionWarningMsg(object2));
        } else if (object2 instanceof DeletionError) {
            Exception exception = null;
            if (object2 instanceof Exception) {
                exception = (Exception)object2;
            }
            String string = ErrorMsg.getString((EID)NEMC.EID_CIRCUIT_DELETION_ERROR) + "\n" + exception.getMessage();
            detailedLog = new DetailedLog(3, string);
        } else if (this.notifyCktDeletionCompletion) {
            detailedLog = new DetailedLog(1, object2.toString());
        }
        if (detailedLog != null) {
            EventBus.instance().notifyEvent((Object)EventBusServices.BG_STATUS_COLLECTOR, detailedLog);
        }
    }

    public void setPreselectedCircuitIds(List list) {
        this.preselectedCircuitIds = list;
        this.preselectionsActive = true;
        this.delayedSelectPreselectedCircuits(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.syncButtons(true);
        }
    }

    protected void syncButtons(boolean bl) {
        int n;
        int n2 = this.table != null ? this.table.getSelectedRowCount() : -1;
        int n3 = n = this.table != null ? this.table.getRowCount() : -1;
        if (db.on()) {
            db.println("syncButtons " + (n2 != -1 && n != -1 ? n2 + "/" + n + " (Sel/Tot)" + (n2 > n ? " !!!" : "") : "table is null"));
        }
        if (this.table != null) {
            boolean bl2;
            boolean bl3 = bl2 = n > 0 && n2 > 0;
            if (bl2) {
                this.enableComponent(this.deletePB);
                this.editPB.setEnabled(true);
                if (bl) {
                    this.updateCircuitSearchInfo();
                }
            } else {
                this.editPB.setEnabled(false);
                this.deletePB.setEnabled(false);
            }
        } else {
            this.editPB.setEnabled(false);
            this.deletePB.setEnabled(false);
        }
    }

    private void loadSvlanCircuit() {
        NetCircuitManager.instance().disposeSvlanCircuits();
        this.source.updateAllCircuits();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                NetCircuitManager.instance().discoverSvlanCircuits(SvlanCircuitsPane.this.range);
                Object object = NetCircuitWatchDog.instance().svlanDiscoveryObj;
                synchronized (object) {
                    try {
                        NetCircuitWatchDog.instance().svlanDiscoveryObj.wait(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    SvlanCircuitsPane.this.refreshPB.setEnabled(true);
                }
            }
        };
        if (this.range != null && this.range.length != 0) {
            this.refreshPB.setEnabled(false);
            Thread thread = new Thread(runnable);
            thread.start();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.svlanList.getVlanList() != null) {
            this.range = this.svlanList.getVlanList().getRanges();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        this.preselectionsActive = false;
        this.preselectedCircuitIds = null;
        if (mouseEvent.getClickCount() == 2 && (n = this.table.rowAtPoint(mouseEvent.getPoint())) != -1) {
            this.table.setRowSelectionInterval(n, n);
            this.editSelectedCircuits(this.getSelectedCircuits("Edit", false));
        }
        this.preselectedCircuitIds = new ArrayList();
        int[] nArray = this.table.getSelectedRows();
        INetCircuit[] iNetCircuitArray = new INetCircuit[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            iNetCircuitArray[i] = (INetCircuit)this.model.getValueAt(nArray[i], 0);
            this.preselectedCircuitIds.add(iNetCircuitArray[i].getCircuitId());
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void delayedSelectPreselectedCircuits(boolean bl) {
        PreselectCircuitsThread preselectCircuitsThread = new PreselectCircuitsThread(bl);
        SwingUtilities.invokeLater(preselectCircuitsThread);
    }

    class CircuitDeletionDialog {
        private INetCircuit[] circuitsToDelete;

        public CircuitDeletionDialog(INetCircuit[] iNetCircuitArray) {
            this.circuitsToDelete = iNetCircuitArray;
        }

        public void show() {
            JLabel jLabel = new JLabel(ErrorMsg.getString((EID)NEMC.WID_DELETING_SERVICE_AFFECTING_PARAM_1, (Object)((this.circuitsToDelete.length < 2 ? "a " : "") + PluralisationUtil.s("circuit", this.circuitsToDelete.length))));
            String string = this.circuitsToDelete.length < 2 ? "" : " " + this.circuitsToDelete.length;
            String string2 = "Do you really want to delete the " + string + " selected " + PluralisationUtil.s("circuit", this.circuitsToDelete.length) + "?";
            boolean bl = false;
            String string3 = "";
            String string4 = "Notify when completed";
            JCheckBox jCheckBox = new JCheckBox(string4, false);
            Object[] objectArray = null;
            objectArray = new Object[]{jLabel, new JLabel(string2), new JLabel("\n"), jCheckBox};
            Object[] objectArray2 = new Object[]{"Yes", "No"};
            int n = JOptionPane.showOptionDialog((Component)((Object)SvlanCircuitsPane.this), objectArray, "Delete Circuits", -1, 3, null, objectArray2, objectArray2[1]);
            if (n == 0) {
                SvlanCircuitsPane.this.notifyCktDeletionCompletion = jCheckBox.isSelected();
                SvlanCircuitsPane.this.deleteSelectedCircuits(this.circuitsToDelete);
            }
            jCheckBox = null;
        }
    }

    class DeletionWarningMsg
    implements Runnable {
        private Object res = null;

        DeletionWarningMsg(Object object) {
            this.res = object;
        }

        @Override
        public void run() {
            DetailedDialog detailedDialog = DetailedDialog.instance((Frame)JOptionPane.getFrameForComponent((Component)((Object)SvlanCircuitsPane.this)), (String)"Circuit Deletion Warning");
            DeletionWarning deletionWarning = (DeletionWarning)this.res;
            int n = deletionWarning.getPortCount();
            detailedDialog.setText(ErrorMsg.getString((EID)NEMC.WID_ADMIN_STATE_NOT_ALLOWED_PARAM_2, (Object)deletionWarning.getAdminStateTerm(), (Object)(n + " " + PluralisationUtil.s("port", n))), CerentDialog.WARNING_ICON);
            detailedDialog.append(((Exception)this.res).getMessage());
            detailedDialog.setSize(500, detailedDialog.getHeight());
            detailedDialog.show();
        }
    }

    class PreselectCircuitsThread
    implements Runnable {
        boolean show = false;

        public PreselectCircuitsThread(boolean bl) {
            this.show = bl;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(300L);
                SvlanCircuitsPane.this.selectPreselectedCircuits(this.show);
            }
            catch (Exception exception) {
                db.finest("Exception in delayedSelectPreselectedCircuits() " + exception);
            }
        }
    }
}

