/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Feature;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SvlanCircuitHelper;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.SvlanCircuit;
import cerent.cms.ncp.SvlanCircuitEnd;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.circuits.CcdEndpointsPane;
import cerent.cms.ui.circuits.CircuitColumnRenderer;
import cerent.cms.ui.circuits.CircuitDropCreationDialog;
import cerent.cms.ui.circuits.IDropCreationPane;
import cerent.cms.ui.circuits.WzCcdPane;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.EID;
import cerent.util.KErrorMsg;
import cerent.util.NEMC;
import cerent.util.gui.CerentDialog;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;

public class SvlanDropCreationPane
extends WzCcdPane
implements Observer,
IDropCreationPane {
    private CircuitDropCreationDialog parent;
    CcdEndpointsPane newDropPane;
    protected RoutePrefs routePrefs;
    private boolean isSameCktDrop = false;

    @Override
    public RoutePrefs getRoutePrefs() {
        return this.routePrefs;
    }

    public SvlanDropCreationPane(CircuitDropCreationDialog circuitDropCreationDialog, WzDiagDebug wzDiagDebug, String string) {
        super(circuitDropCreationDialog, wzDiagDebug, string);
        this.parent = circuitDropCreationDialog;
    }

    @Override
    protected void initPane() {
        this.setLayout(new BoxLayout(this, 0));
        Box box = Box.createVerticalBox();
        box.add(this.getMainPanel());
        box.add(Box.createVerticalStrut(15));
        this.add(box);
    }

    private JComponent getMainPanel() {
        this.newDropPane = new CcdEndpointsPane(this.parent, this.db, "New Drop", "Drop", false, true);
        this.newDropPane.enteringPane();
        if (this.newDropPane.getNodeCB() != null) {
            this.startObserving();
        }
        return this.newDropPane;
    }

    void startObserving() {
        if (this.newDropPane != null) {
            CcdEndpointsPane.NodeChangedObservable nodeChangedObservable = this.newDropPane.nodeChangeObservable;
            nodeChangedObservable.addObserver(this);
            if (this.db.on()) {
                this.db.println("start observing the nodeChangeObservable");
            }
        }
    }

    @Override
    public void stopObserving() {
        if (this.newDropPane != null) {
            CcdEndpointsPane.NodeChangedObservable nodeChangedObservable = this.newDropPane.nodeChangeObservable;
            nodeChangedObservable.deleteObserver(this);
            if (this.db.on()) {
                this.db.println("stop observing the nodeChangeObservable");
            }
        }
    }

    public void cleanUpQinQ(short s) throws AbstractCmsNoSuchEntityException, ProvisionError, NoSuchInterface, WrongInterfaceType {
        if (this.newDropPane != null) {
            this.newDropPane.cleanUpQinQ(s);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        HashSet<INodeModel> hashSet = new HashSet<INodeModel>();
        for (INetCircuitNode iNetCircuitNode : this.parent.getCircuit().getCircuitNodes()) {
            hashSet.add(iNetCircuitNode.getNodeModel());
        }
        this.isSameCktDrop = this.parent.getSourceNode() == this.newDropPane.nodeModel || hashSet.contains(this.newDropPane.nodeModel) || this.newDropPane.nodeModel == null;
        this.syncButtons();
    }

    private void syncButtons() {
        this.parent.setNextEnabled(!this.isSameCktDrop);
        this.parent.setFinishEnabled(this.isSameCktDrop);
    }

    void resetMainPanel() {
        this.newDropPane.reset();
    }

    @Override
    public void validatePage() throws Exception {
        Object object22;
        this.newDropPane.validatePage();
        this.routePrefs = new RoutePrefs();
        this.routePrefs.setSvlan(((SvlanCircuit)this.parent.getCircuit()).getSvlan());
        INetElement iNetElement = this.parent.getCircuit().getSrcNetElement();
        List list = this.parent.getCircuit().getSources();
        INetCircuitEnd iNetCircuitEnd = null;
        for (Object object22 : list) {
            if (((INetCircuitEnd)object22).getNetElement().getNodeId() != iNetElement.getNodeId()) continue;
            iNetCircuitEnd = (INetCircuitEnd)object22;
            break;
        }
        this.routePrefs.setSrc(iNetElement);
        this.routePrefs.setcktSrcEntityIndex(iNetCircuitEnd.getEntityIndex());
        INetCircuitEnd iNetCircuitEnd2 = (INetCircuitEnd)this.newDropPane.getEndpoints().get(0);
        object22 = new SvlanCircuitEnd(this.routePrefs.getSvlan());
        ((NetCircuitEnd)object22).setNodeModel(iNetCircuitEnd2.getNodeModel());
        ((NetCircuitEnd)object22).setEntityIndex(iNetCircuitEnd2.getEntityIndex());
        this.parent.setNewCircuitEnd((INetCircuitEnd)object22);
        this.routePrefs.setDst(((NetCircuitEnd)object22).getNetElement());
        this.routePrefs.setcktDstEntityIndex(((NetCircuitEnd)object22).getEntityIndex());
        try {
            this.parent.addDestination(!this.isSameCktDrop);
            if (this.getAbstractCktDlg().getSourceNode().provides(Feature.CHANNEL_GROUP) && this.getAbstractCktDlg().getDestNode().provides(Feature.CHANNEL_GROUP)) {
                SvlanCircuit svlanCircuit = (SvlanCircuit)this.parent.getCircuit();
                if (((CircuitDropCreationDialog)this.getAbstractCktDlg()).getCircuitInfo().getSrcQinQInfo() != null && ((CircuitDropCreationDialog)this.getAbstractCktDlg()).getCircuitInfo().getSrcQinQInfo().getQinQMode() == 1 || SvlanCircuitHelper.isTransparent(svlanCircuit.getSourceNE().getNodeModel(), ((INetCircuitEnd)svlanCircuit.getCktSources().get(0)).getEntityIndex()) && SvlanCircuitHelper.isTransparent(svlanCircuit.getDropNE().getNodeModel(), ((INetCircuitEnd)svlanCircuit.getCktDrops().get(0)).getEntityIndex())) {
                    int n;
                    String string = "";
                    ArrayList<SvlanCircuit.NetlinkBandwidthWrapper> arrayList = new ArrayList<SvlanCircuit.NetlinkBandwidthWrapper>();
                    SvlanCircuit.NetlinkBandwidthWrapper[] netlinkBandwidthWrapperArray = svlanCircuit.checkSvlanBandwidth(false, iNetCircuitEnd2);
                    for (n = 0; n < netlinkBandwidthWrapperArray.length; ++n) {
                        arrayList.add(netlinkBandwidthWrapperArray[n]);
                    }
                    netlinkBandwidthWrapperArray = svlanCircuit.checkSvlanBandwidth(true, iNetCircuitEnd2);
                    for (n = 0; n < netlinkBandwidthWrapperArray.length; ++n) {
                        for (SvlanCircuit.NetlinkBandwidthWrapper abstractCmsNoSuchEntityException : arrayList) {
                        }
                        arrayList.add(netlinkBandwidthWrapperArray[n]);
                    }
                    if (arrayList.size() > 0) {
                        for (SvlanCircuit.NetlinkBandwidthWrapper netlinkBandwidthWrapper : arrayList) {
                            try {
                                String string2;
                                int n2 = netlinkBandwidthWrapper.getLink().getSrcEntityIndex();
                                IPortModel iPortModel = (IPortModel)netlinkBandwidthWrapper.getLink().getSrc().getNodeModel().getEntityTable().getEntityModelByIndex(n2);
                                String string3 = netlinkBandwidthWrapper.getLink().getSrc().getHostName();
                                if (netlinkBandwidthWrapper.getLink().getSrc().getNodeModel().provides(Feature.MULTISHELF) && netlinkBandwidthWrapper.getLink().getSrc().getNodeModel().isMultishelf()) {
                                    string3 = string3 + "/sh" + netlinkBandwidthWrapper.getLink().getSrcShelfNumber();
                                }
                                string3 = string3 + "/s" + netlinkBandwidthWrapper.getLink().getSrcSlotNumber() + "/p" + PortHelper.getPortNumString((IPortModel)iPortModel);
                                int n3 = netlinkBandwidthWrapper.getLink().getDstEntityIndex();
                                IPortModel iPortModel2 = (IPortModel)netlinkBandwidthWrapper.getLink().getDst().getNodeModel().getEntityTable().getEntityModelByIndex(n3);
                                String string4 = netlinkBandwidthWrapper.getLink().getDst().getHostName();
                                if (netlinkBandwidthWrapper.getLink().getDst().getNodeModel().provides(Feature.MULTISHELF) && netlinkBandwidthWrapper.getLink().getDst().getNodeModel().isMultishelf()) {
                                    string4 = string4 + "/sh" + netlinkBandwidthWrapper.getLink().getDstShelfNumber();
                                }
                                string4 = string4 + "/s" + netlinkBandwidthWrapper.getLink().getDstSlotNumber() + "/p" + PortHelper.getPortNumString((IPortModel)iPortModel2);
                                if (netlinkBandwidthWrapper.getCurrentBW() > netlinkBandwidthWrapper.getMaxBW()) {
                                    string2 = string3 + " -> " + string4 + " with a bandwidth of " + Math.round((float)netlinkBandwidthWrapper.getCurrentBW() / ((float)netlinkBandwidthWrapper.getMaxBW() / 100.0f)) + "%";
                                    string = string.equals("") ? string + string2 : string + "\n" + string2;
                                }
                                if (netlinkBandwidthWrapper.getCurrentReverseBW() <= netlinkBandwidthWrapper.getMaxBW()) continue;
                                string2 = string4 + " -> " + string3 + " with a bandwidth of " + Math.round((float)netlinkBandwidthWrapper.getCurrentReverseBW() / ((float)netlinkBandwidthWrapper.getMaxBW() / 100.0f)) + "%";
                                if (string.equals("")) {
                                    string = string + string2;
                                    continue;
                                }
                                string = string + "\n" + string2;
                            }
                            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                                this.db.println("Couldn't show invalid svlan spans due to exception:" + abstractCmsNoSuchEntityException.getMessage());
                                WzDiagDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                            }
                        }
                    }
                    svlanCircuit.clearSvlanTagsAndBandwidthData();
                    if (arrayList.size() > 0) {
                        String string5 = KErrorMsg.getString((EID)NEMC.EID_SVLAN_OVERLOAD, (Object)string);
                        CerentDialog.warningDialog(null, (String)string5);
                    }
                }
            }
            if (this.db.on) {
                this.db.println("validatePage: addDestination() succeeded");
            }
        }
        catch (Exception exception) {
            try {
                this.parent.deleteDestination();
            }
            catch (Exception exception2) {
                this.db.finer("validatePage: deleteDestination exception caught");
            }
            throw exception;
        }
    }

    @Override
    public void revalidateData() {
        this.syncButtons();
        this.revalidate();
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.DropCreationPane;
    }

    @Override
    protected JComponent getStatusComponent() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        arrayList.add(new String[]{"Name: ", this.parent.getCircuit().getCircuitName()});
        INetCircuitEnd[] iNetCircuitEndArray = new INetCircuitEnd[]{this.parent.getCircuit().getPrimarySource()};
        arrayList.add(new String[]{"From: ", CircuitColumnRenderer.getEndpoints(this.parent.getCircuit(), iNetCircuitEndArray)});
        String string = this.newDropPane.getStatusText();
        int n = string.indexOf(58);
        String string2 = string.substring(0, n + 1);
        String string3 = string.substring(n + 1, string.length());
        arrayList.add(new String[]{string2, string3});
        int n2 = this.routePrefs.getPathProt();
        String string4 = "";
        String string5 = "N/A";
        if (n2 == 0) {
            string4 = "Fully Protected";
            int n3 = this.routePrefs.getDiversityOption();
            if (n3 == 1) {
                string5 = "Node-diverse";
            } else if (n3 == 3) {
                string5 = "Link-diverse";
            }
        } else if (n2 == 2) {
            string4 = "Unprotected";
        }
        if (!string4.equals("")) {
            arrayList.add(new String[]{"Protection:", string4});
        }
        if (string4.equals("Fully Protected")) {
            arrayList.add(new String[]{"Diversity:", string5});
        }
        return SvlanDropCreationPane.getGridPanel(arrayList);
    }

    @Override
    protected String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Name: ");
        stringBuffer.append(this.parent.getCircuit().getCircuitName());
        stringBuffer.append("\n");
        INetCircuitEnd[] iNetCircuitEndArray = new INetCircuitEnd[]{this.parent.getCircuit().getPrimarySource()};
        stringBuffer.append("\nFrom: ");
        stringBuffer.append(CircuitColumnRenderer.getEndpoints(this.parent.getCircuit(), iNetCircuitEndArray));
        stringBuffer.append(this.newDropPane.getStatusText());
        stringBuffer.append("\nRouting: ");
        int n = this.routePrefs.getPathProt();
        if (n == 0) {
            stringBuffer.append(" fully protected");
            int n2 = this.routePrefs.getDiversityOption();
            if (n2 == 1) {
                stringBuffer.append("\n  Node-diverse");
            } else if (n2 == 3) {
                stringBuffer.append("\n  Link-diverse");
            }
        } else if (n == 2) {
            stringBuffer.append(" unprotected");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    @Override
    public void enteringPane() {
        this.startObserving();
        super.enteringPane();
    }

    @Override
    protected String getNextPaneName() {
        return "SVLAN Circuit Routing Preview";
    }

    @Override
    public void removeListeners() {
        this.stopObserving();
        super.removeListeners();
    }

    @Override
    public void dispose() {
        this.routePrefs = null;
        super.dispose();
    }

    @Override
    public String getDiagString() {
        return super.getDiagString();
    }

    @Override
    public CcdEndpointsPane getDropPane() {
        return this.newDropPane;
    }

    @Override
    public boolean isAutoRoute() {
        return false;
    }

    @Override
    public boolean isPathProt() {
        return false;
    }

    @Override
    public boolean isPca() {
        return false;
    }

    @Override
    public boolean isRrbc() {
        return false;
    }

    @Override
    public boolean isUrn() {
        return false;
    }

    @Override
    public void setPathProt(boolean bl) {
    }

    @Override
    public void setPca(boolean bl) {
    }
}

