/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.ConfigError;
import cerent.cms.model.IDwdmTrkLineModel;
import cerent.cms.model.IGenericTraceLine;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ui.circuits.AbstractPathTrace;
import cerent.cms.ui.circuits.IJTrace;
import cerent.util.SDebug;

public class TrailTraceIdentifier
extends AbstractPathTrace
implements IJTrace {
    private static final SDebug db = new SDebug("TrailTraceIdentifier");
    private static final String DISABLE_AIS_CMD = "DISABLE_FDI";
    public static final String DISABLE_MISMATCH = "Disable Mis";
    private int PATH_MONITORING_LEVEL = 1;
    int oldState = 0;
    private IGenericTraceLine traceLineModel;
    private IDwdmTrkLineModel monLevLine;
    protected final boolean circuitLevel;
    protected INetCircuit netCircuit;

    public TrailTraceIdentifier(IInterfaceModel[] iInterfaceModelArray, INetCircuit iNetCircuit, boolean bl) {
        super(iInterfaceModelArray[0]);
        this.circuitLevel = bl;
        this.netCircuit = iNetCircuit;
        this.monLevLine = (IDwdmTrkLineModel)iInterfaceModelArray[0];
        this.setPathMonLevel();
        this.traceLineModel = (IGenericTraceLine)iInterfaceModelArray[0];
    }

    private void setPathMonLevel() {
        this.monLevLine.setMonitoringLevel(this.PATH_MONITORING_LEVEL);
    }

    @Override
    public boolean providesCommonFeature() {
        return false;
    }

    @Override
    public boolean providesNoAis() {
        return false;
    }

    @Override
    public boolean providesAutoMode(int n) {
        return false;
    }

    @Override
    public String getDisableAisString() {
        return DISABLE_AIS_CMD;
    }

    @Override
    public int numModels() {
        return 1;
    }

    @Override
    public String getDisableMismatchString() {
        return DISABLE_MISMATCH;
    }

    @Override
    public int getPathTraceMode() throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        this.setPathMonLevel();
        return this.traceLineModel.getTraceMode();
    }

    @Override
    public int getPayloadMode() throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        return 0;
    }

    @Override
    public void setPathTraceMode(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation, ProvisionError {
        block2: {
            this.setPathMonLevel();
            try {
                this.traceLineModel.setTraceMode(n2);
            }
            catch (ConfigError configError) {
                db.println("Caught Exception in setPathTraceMode");
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)configError);
            }
        }
    }

    @Override
    public void setPayloadMode(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        throw new UnsupportedOperation("setPayloadMode, TTI invalid request");
    }

    @Override
    public byte getCurrentPayloadLabel() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        this.setPathMonLevel();
        return this.traceLineModel.getCurrentPayloadLabel();
    }

    @Override
    public byte getExpectedPayloadLabel() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        return 0;
    }

    @Override
    public void setSendPathTrace(int n, String string) throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        block2: {
            this.setPathMonLevel();
            try {
                this.traceLineModel.setSendTrace(string);
            }
            catch (ConfigError configError) {
                db.println("Caught Exception in setSendPathTrace");
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)configError);
            }
        }
    }

    @Override
    public char[] getSendPathTrace() {
        char[] cArray;
        block2: {
            cArray = "<unable to retrieve transmit Trail Trace Identifier from card>".toCharArray();
            try {
                this.setPathMonLevel();
                cArray = this.traceLineModel.getSendTraceAsTrace().getTrace();
            }
            catch (Exception exception) {
                db.println("Caught Exception in getSendPathTrace");
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return cArray;
    }

    @Override
    public void setExpectedPathTrace(int n, String string) throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        block2: {
            this.setPathMonLevel();
            try {
                this.traceLineModel.setExpectedTrace(string);
            }
            catch (ConfigError configError) {
                db.println("Caught Exception in setExpectedPathTrace");
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)configError);
            }
        }
    }

    @Override
    public char[] getExpectedPathTrace() {
        char[] cArray;
        block2: {
            cArray = "<unable to retrieve expected Trail Trace Identifier from card>".toCharArray();
            this.setPathMonLevel();
            try {
                cArray = this.traceLineModel.getExpectedTrace();
            }
            catch (Exception exception) {
                db.println("Caught Exception in getExpectedPathTrace");
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return cArray;
    }

    @Override
    public char[] getReceivedPathTrace() {
        char[] cArray;
        block3: {
            cArray = "<not available for current card state>".toCharArray();
            this.setPathMonLevel();
            try {
                if (this.traceLineModel.canRequestReceivedTrace()) {
                    cArray = this.traceLineModel.getReceivedTrace();
                }
            }
            catch (Exception exception) {
                db.println("Caught Exception in getReceivedPathTrace");
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return cArray;
    }

    @Override
    public void setPathTraceFormat(int n, int n2) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, ProvisionError {
        block2: {
            this.setPathMonLevel();
            try {
                this.traceLineModel.setTraceFormat(n2);
            }
            catch (ConfigError configError) {
                db.println("Caught Exception in setPathTraceFormat");
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)configError);
            }
        }
    }

    @Override
    public int getPathTraceFormat() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        this.setPathMonLevel();
        return this.traceLineModel.getTraceFormat();
    }
}

