/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network;

import cerent.cms.model.event.IAlarmStatus;
import com.cisco.ctc.util.map.DetailedMapNode;
import com.cisco.ctc.util.map.MapToolkit;
import java.awt.Color;

public class AbstractMapNode
extends DetailedMapNode {
    public static final int OK_STATE = 0;
    public static final int MINOR_STATE = 1;
    public static final int MAJOR_STATE = 2;
    public static final int CRITICAL_STATE = 3;
    public static final int DISCONNECTED_STATE = 4;
    public static final int UNKNOWN_STATE = 5;
    public static final int OOS_MT_STATE = 6;
    public static final int IS_AINS_STATE = 7;
    public static final String OK_STRING = "OK";
    public static final String MINOR_STRING = "Minor";
    public static final String MAJOR_STRING = "Major";
    public static final String CRITICAL_STRING = "Critical";
    public static final String DISCONNECTED_STRING = "Disconnected";
    public static final String POSITION_XY = "PositionXY";
    public static final String OOS_MT_STRING = "OOS_MT";
    public static final String IS_AINS_STRING = "IS_AINS";
    public static final Color OK_COLOR = Color.green;
    public static final Color MINOR_COLOR = Color.yellow;
    public static final Color MAJOR_COLOR = Color.orange;
    public static final Color CRITICAL_COLOR = Color.red;
    public static final Color DISCONNECTED_COLOR = Color.gray;
    public static final Color OOS_MT_COLOR = Color.cyan;
    public static final Color IS_AINS_COLOR = new Color(205, 205, 255);
    protected int state = 5;
    private boolean instantiated = true;

    public AbstractMapNode(MapToolkit mapToolkit) {
        super(mapToolkit);
    }

    public Color stateToColor(int n) {
        switch (n) {
            case 0: {
                return OK_COLOR;
            }
            case 1: {
                return MINOR_COLOR;
            }
            case 2: {
                return MAJOR_COLOR;
            }
            case 3: {
                return CRITICAL_COLOR;
            }
            case 6: {
                return OOS_MT_COLOR;
            }
            case 7: {
                return IS_AINS_COLOR;
            }
        }
        return DISCONNECTED_COLOR;
    }

    public static String getStateDescription(int n) {
        switch (n) {
            case 0: {
                return OK_STRING;
            }
            case 1: {
                return MINOR_STRING;
            }
            case 2: {
                return MAJOR_STRING;
            }
            case 3: {
                return CRITICAL_STRING;
            }
            case 6: {
                return OOS_MT_STRING;
            }
            case 7: {
                return IS_AINS_STRING;
            }
        }
        return DISCONNECTED_STRING;
    }

    public int getState() {
        if (!this.instantiated) {
            return 5;
        }
        return this.state;
    }

    public static int getMapNodeState(IAlarmStatus iAlarmStatus) {
        int n = 0;
        if (iAlarmStatus != null) {
            switch (iAlarmStatus.getHighestSeverity()) {
                case 0: {
                    n = 0;
                    break;
                }
                case 1: {
                    n = 1;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                case 3: {
                    n = 3;
                    break;
                }
                default: {
                    n = 4;
                }
            }
        }
        return n;
    }

    public static Color getMapNodeColor(IAlarmStatus iAlarmStatus) {
        Color color = OK_COLOR;
        if (iAlarmStatus != null) {
            switch (iAlarmStatus.getHighestSeverity()) {
                case 0: {
                    color = OK_COLOR;
                    break;
                }
                case 1: {
                    color = MINOR_COLOR;
                    break;
                }
                case 2: {
                    color = MAJOR_COLOR;
                    break;
                }
                case 3: {
                    color = CRITICAL_COLOR;
                    break;
                }
                default: {
                    color = DISCONNECTED_COLOR;
                }
            }
        }
        return color;
    }

    protected void doOpenNode() {
        this.doubleClicked();
    }
}

