/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network.raman;

import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRamanOpticsLineModel;
import cerent.cms.model.ISideModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.WrongNodeSide;
import cerent.cms.ui.network.raman.RamanDayZeroInfo;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.List;
import org.omg.CORBA.UserException;

public class RamanAttribute {
    private INodeModel node = null;
    private IEntityModel singleRamanLinePort = null;
    private IEntityModel outRamanLinePort = null;
    private boolean isRamanAmpli = true;
    private static final SDebug db = new SDebug("RamanAttribute");

    public RamanAttribute(INodeModel iNodeModel, IEntityModel iEntityModel) {
        this.setNode(iNodeModel);
        if (iEntityModel != null) {
            int n = iEntityModel.getEqType();
            int n2 = 0;
            if (n == 287 || n == 321) {
                n2 = 17;
            } else {
                try {
                    ISideModel iSideModel = iNodeModel.getSideModels().getSideById(iEntityModel.getSide());
                    n2 = iSideModel.getLineIn() & 0xFF;
                }
                catch (WrongNodeSide wrongNodeSide) {
                    KDebug.printStackTrace((Throwable)wrongNodeSide);
                }
            }
            this.setSingleRamanLinePort(RamanAttribute.takePort(n2, iEntityModel), n);
        } else {
            this.setSingleRamanLinePort(null, 0);
        }
    }

    public RamanAttribute(INodeModel iNodeModel, IEntityModel iEntityModel, IEntityModel iEntityModel2) {
        this(iNodeModel, iEntityModel);
        int n = iEntityModel2.getEqType();
        int n2 = 0;
        if (n == 287 || n == 321) {
            n2 = 17;
        } else {
            try {
                ISideModel iSideModel = iNodeModel.getSideModels().getSideById(iEntityModel2.getSide());
                n2 = iSideModel.getLineOut() & 0xFF;
            }
            catch (WrongNodeSide wrongNodeSide) {
                KDebug.printStackTrace((Throwable)wrongNodeSide);
            }
        }
        this.setOutRamanLinePort(RamanAttribute.takePort(n2, iEntityModel2));
    }

    public static IEntityModel takePort(int n, IEntityModel iEntityModel) {
        List list = iEntityModel.getChildren();
        for (IEntityModel iEntityModel2 : list) {
            int n2 = iEntityModel2.getIndex();
            if ((n2 & n) != n) continue;
            if (db.on()) {
                db.println("<RamanAttribute> SingleLineIdx=" + n2);
            }
            return iEntityModel2;
        }
        return null;
    }

    public void setNode(INodeModel iNodeModel) {
        if (db.on()) {
            db.println("<RamanAttribute> The Node is " + iNodeModel.getName());
        }
        this.node = iNodeModel;
    }

    public String getName() {
        return this.node.getName();
    }

    public String toString() {
        return this.getName();
    }

    public INodeModel getNode() {
        return this.node;
    }

    public IEntityModel getSingleRamanLinePort() {
        return this.singleRamanLinePort;
    }

    public IEntityModel getOutRamanLinePort() {
        return this.outRamanLinePort;
    }

    public void setSingleRamanLinePort(IEntityModel iEntityModel, int n) {
        this.singleRamanLinePort = iEntityModel;
        this.isRamanAmpli = n == 287 || n == 321;
    }

    public void setOutRamanLinePort(IEntityModel iEntityModel) {
        this.outRamanLinePort = iEntityModel;
    }

    public boolean lineNeedToBeTuned(RamanDayZeroInfo ramanDayZeroInfo) {
        boolean bl;
        block12: {
            bl = true;
            if (db.on()) {
                db.print("for Node " + ramanDayZeroInfo.getEndNode().getName());
            }
            if (this.isRamanAmpli) {
                IInterfaceModel iInterfaceModel = ((IPortModel)this.singleRamanLinePort).getInterfaceModel();
                try {
                    if (iInterfaceModel instanceof IRamanOpticsLineModel) {
                        if (this.statusNotNeedTuning(iInterfaceModel) && ramanDayZeroInfo.isAutoSkip()) {
                            bl = false;
                        }
                        break block12;
                    }
                    return false;
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    KDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
                catch (FeatureUnsupported featureUnsupported) {
                    KDebug.printStackTrace((Throwable)featureUnsupported);
                }
                catch (NoSuchInterface noSuchInterface) {
                    KDebug.printStackTrace((Throwable)noSuchInterface);
                }
                catch (UserException userException) {
                    KDebug.printStackTrace((Throwable)userException);
                }
            } else {
                if (db.on()) {
                    db.print("It is not Raman Card ");
                }
                bl = false;
            }
        }
        if (db.on()) {
            db.println("the span need tuning = " + bl);
        }
        return bl;
    }

    private boolean statusNotNeedTuning(IInterfaceModel iInterfaceModel) throws WrongInterfaceType, FeatureUnsupported, NoSuchInterface, UserException {
        int n = ((IRamanOpticsLineModel)iInterfaceModel).getSetupStatus();
        boolean bl = n == 2;
        return bl;
    }

    public void setRamanAmpli(boolean bl) {
        this.isRamanAmpli = bl;
    }
}

