/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network.raman;

import cerent.cms.model.ConfigError;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IRamanDayZeroOperation;
import cerent.cms.model.IRamanModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SideInUse;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.WrongNodeSide;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzDialog;
import cerent.cms.ui.network.raman.RamanDayZeroCellRender;
import cerent.cms.ui.network.raman.RamanDayZeroDialog;
import cerent.cms.ui.network.raman.RamanDayZeroInfo;
import cerent.cms.ui.network.raman.RamanDayZeroTableModel;
import cerent.cms.ui.network.raman.RamanDayZeroWzPane;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.table.TableColumn;

public class RamanDayZeroAcpPane
extends RamanDayZeroWzPane
implements IRamanDayZeroOperation {
    private JButton forceButton;
    private JButton exportButton;
    private String hintStr = " If Raman is not calibrated pressing \"Force\" will continue the Wizard\n   and force the Raman in Calibrated state.";
    private String nextPage;
    private Component results;
    private RamanDayZeroTableModel ramanTableModel;
    private RamanDayZeroInfo.sm doMeasure;

    public RamanDayZeroAcpPane(WzDialog wzDialog, WzDiagDebug wzDiagDebug, String string, RamanDayZeroInfo ramanDayZeroInfo) {
        super(wzDialog, wzDiagDebug, string, ramanDayZeroInfo);
    }

    @Override
    public void validatePage() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getNextPaneName() {
        RamanDayZeroAcpPane ramanDayZeroAcpPane = this;
        synchronized (ramanDayZeroAcpPane) {
            return this.nextPage;
        }
    }

    @Override
    protected void initPane() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.addUpperPane(), null);
    }

    @Override
    public void enteringPane() {
        super.enteringPane();
        this.doMeasure = RamanDayZeroInfo.sm.Calculation;
        this.setRamanModel(this.getEndNode());
        this.doCommand(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void goOn() {
        RamanDayZeroAcpPane ramanDayZeroAcpPane = this;
        synchronized (ramanDayZeroAcpPane) {
            ((RamanDayZeroDialog)this.parent).nextButtonEnable(true, this.info.isAutoRun());
            if (this.info.allNodesCalibrated()) {
                if (this.info.isNeedReturn()) {
                    this.nextPage = this.info.prepareBackPath((IRamanDayZeroOperation)this.parent, false);
                } else {
                    ((RamanDayZeroDialog)this.parent).setFinishEnabled(true);
                    ((RamanDayZeroDialog)this.parent).nextButtonEnable(false);
                    this.nextPage = null;
                }
            } else {
                this.nextPage = "Setting Parameters Forward Path";
            }
        }
    }

    private void checkQuality() {
        if (this.db.on()) {
            this.db.print("The quality on node " + this.ramanTableModel.getLastNode() + "is =");
        }
        switch (this.ramanTableModel.getLastQuality()) {
            case 1: {
                if (this.db.on()) {
                    this.db.println("TRAMAN_QUALITY_SETUP_NEED_ACCEPT");
                }
                ((RamanDayZeroDialog)this.parent).nextButtonEnable(false);
                this.forceButton.setVisible(true);
                break;
            }
            case 0: {
                if (this.db.on()) {
                    this.db.println("RAMAN_QUALITY_SETUP_GOOD");
                }
                this.acceptTuning();
                break;
            }
            case 3: {
                if (this.db.on()) {
                    this.db.println("RAMAN_QUALITY_SETUP_FORCED");
                }
                this.forceButton.setVisible(true);
                break;
            }
            case 2: {
                if (this.db.on()) {
                    this.db.println("RAMAN_QUALITY_SETUP_UNACCEPT");
                }
                this.exitWizard();
            }
        }
    }

    private void exitWizard() {
        this.nextPage = "Error Page";
        ErrorMsg.displayError(this, NEMC.EID_RAMAN_NOT_TUNED, this.ramanModel.getNodeModel().getName(), " fail");
        this.showCommandResult("Calibration Failed");
        ((RamanDayZeroDialog)this.parent).setFinishEnabled(true);
        ((RamanDayZeroDialog)this.parent).nextButtonEnable(false);
        this.nextPage = null;
    }

    private void acceptTuning() {
        IEntityModel iEntityModel = this.info.getEndNode().getSingleRamanLinePort();
        try {
            this.ramanModel.acceptTuningParams(iEntityModel.getIndex(), (IRamanDayZeroOperation)this);
        }
        catch (ConfigError configError) {
            SDebug.printStackTrace((Throwable)configError);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        catch (ProvisionError provisionError) {
            SDebug.printStackTrace((Throwable)provisionError);
        }
    }

    private Component addUpperPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        jPanel.add(this.labelButtonResultPane(this.hintStr), null);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.forceButton = new JButton("Force Calibration");
        this.forceButton.setVisible(false);
        this.forceButton.addActionListener(this);
        jPanel2.add((Component)this.forceButton, null);
        this.exportButton = new JButton("  Exports  Data  ");
        this.exportButton.setVisible(true);
        this.exportButton.addActionListener(this);
        jPanel2.add((Component)this.exportButton, null);
        ++gridBagConstraints.gridy;
        gridBagConstraints.ipady = 15;
        jPanel.add((Component)jPanel2, null);
        gridBagConstraints.ipady = 0;
        ++gridBagConstraints.gridy;
        this.ramanTableModel = new RamanDayZeroTableModel(this.info.getNewRamanValues());
        this.info.setResultTable(this.ramanTableModel);
        UTable uTable = this.info.getResultTable();
        TableColumn tableColumn = uTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new RamanDayZeroCellRender(this.info));
        tableColumn = uTable.getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(new RamanDayZeroCellRender(this.info));
        uTable.setAutoResizeMode(0);
        this.info.removeColumns();
        UScrollPane uScrollPane = new UScrollPane((Component)uTable);
        jPanel.add((Component)uScrollPane, null);
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.forceButton) {
            this.acceptTuning();
        } else if (object == this.exportButton) {
            ((RamanDayZeroDialog)this.parent).exportData(true);
        }
    }

    @Override
    public void recovery() {
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.RamanDay0InstallationAcceptConfigDlg;
    }

    @Override
    public JComponent getStatusComponent() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        ArrayList<ArrayList> arrayList2 = this.info.getNewRamanValues();
        if (arrayList2.size() != 0) {
            ArrayList arrayList3 = arrayList2.get(arrayList2.size() - 1);
            arrayList.add(new String[]{"Quality: ", IRamanModel.QUALITY_STR[Integer.valueOf((String)arrayList3.get(0))]});
            arrayList.add(new String[]{"Tot Power (mW): ", (String)arrayList3.get(2)});
            arrayList.add(new String[]{"Ratio: ", (String)arrayList3.get(1)});
            arrayList.add(new String[]{"Gain: ", (String)arrayList3.get(4)});
            arrayList.add(new String[]{"Tilt: ", (String)arrayList3.get(5)});
        }
        return RamanDayZeroAcpPane.getGridPanel(arrayList);
    }

    public void doCommand(int n) {
        IEntityModel iEntityModel = this.info.getEndNode().getSingleRamanLinePort();
        switch (this.doMeasure) {
            case Calculation: {
                if (this.db.on) {
                    this.db.println("-----Calculation " + this.ramanModel.getNodeModel().getName());
                }
                this.doMeasure = RamanDayZeroInfo.sm.ReadNewValue;
                try {
                    this.ramanModel.calculation(iEntityModel.getIndex(), (IRamanDayZeroOperation)this);
                    this.showCommandResult(" executed");
                }
                catch (WrongNodeSide wrongNodeSide) {
                    this.nextPage = "Error Page";
                    KDebug.printStackTrace((Throwable)wrongNodeSide);
                }
                catch (SideInUse sideInUse) {
                    this.nextPage = "Error Page";
                    KDebug.printStackTrace((Throwable)sideInUse);
                }
                catch (ConfigError configError) {
                    this.nextPage = "Error Page";
                    KDebug.printStackTrace((Throwable)configError);
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    this.nextPage = "Error Page";
                    KDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
                catch (ProvisionError provisionError) {
                    this.nextPage = "Error Page";
                    KDebug.printStackTrace((Throwable)provisionError);
                }
                catch (NoSuchInterface noSuchInterface) {
                    this.nextPage = "Error Page";
                    KDebug.printStackTrace((Throwable)noSuchInterface);
                }
                String string = this.ramanModel.getNodeModel().getName() + " Raman Calculation";
                break;
            }
            case ReadNewValue: {
                if (this.db.on) {
                    this.db.println("-----ReadNewValue " + this.ramanModel.getNodeModel().getName());
                }
                this.doMeasure = RamanDayZeroInfo.sm.ReadNewValueEvent;
                this.info.addResultValues(this.ramanModel.getNewValues(iEntityModel, (IRamanDayZeroOperation)this));
                String string = this.ramanModel.getNodeModel().getName() + " get New Raman Values";
                break;
            }
            case ReadNewValueEvent: {
                this.doMeasure = RamanDayZeroInfo.sm.AcceptParam;
                ArrayList<ArrayList> arrayList = this.info.getNewRamanValues();
                if (arrayList.size() == 0) {
                    CerentDialog.warningDialog((Component)this, (String)"All the selected path was already tuned", (String)"No Path tuned");
                    ((RamanDayZeroDialog)this.parent).nextButtonEnable(false, this.info.isAutoRun());
                    ((RamanDayZeroDialog)this.parent).setFinishEnabled(true);
                    break;
                }
                if (this.results != null) {
                    this.remove(this.results);
                }
                this.ramanTableModel.update(this.info.getNewRamanValues());
                this.checkQuality();
                break;
            }
            case AcceptParam: {
                if (n != 0) break;
                this.goOn();
                this.forceButton.setVisible(false);
                if (!this.db.on()) break;
                this.db.println("Tuning Accepted");
            }
        }
    }

    public void objChanged(int n, String string) {
        this.doCommand(n);
    }

    public void timeOut(String string) {
    }
}

