/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network.raman;

import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRamanDayZeroOperation;
import cerent.cms.model.circuits.NetCircuitModel;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzDialog;
import cerent.cms.ui.network.raman.RamanDayZeroDialog;
import cerent.cms.ui.network.raman.RamanDayZeroInfo;
import cerent.cms.ui.network.raman.RamanDayZeroWzPane;
import cerent.cms.ui.network.raman.TxpPane;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JComponent;

public class RamanDayZeroDirLessPane
extends RamanDayZeroWzPane {
    private final String[] label = new String[]{"Start Node: ", "End Node: "};
    private String nextPage = "Calibrate Raman";
    private final String hintsStr = "Before starting:\n1) Verify that ANS has been launched on all NEs.\n2) Ensure that the selected TXP is tuned in \"First Tunable Wavelength\".\n3) In a single source NE ensure that it is correctly connected to the Booster.\n   In a double source NE ensure that both the select TXP are well connected \n   to the MUX/DMUX .\n\n";
    private boolean alreadySkip;
    private TxpPane txpContainer;

    public RamanDayZeroDirLessPane(WzDialog wzDialog, WzDiagDebug wzDiagDebug, String string, RamanDayZeroInfo ramanDayZeroInfo) {
        super(wzDialog, wzDiagDebug, string, ramanDayZeroInfo);
    }

    @Override
    public void validatePage() throws Exception {
        if (this.info.isAutoSkip() && !this.info.getEndNode().lineNeedToBeTuned(this.info)) {
            try {
                if (!this.alreadySkip) {
                    while (!this.info.setNextCurrentNode(0)) {
                        this.alreadySkip = true;
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.nextPage = "Accept Result";
            }
        }
        ((RamanDayZeroDialog)this.parent).setAutoRun(this.info.isAutoRun());
    }

    @Override
    protected String getNextPaneName() {
        return this.nextPage;
    }

    @Override
    public boolean handleBack() {
        boolean bl = super.handleBack();
        this.info.decTest();
        Map map = RamanDayZeroDirLessPane.setPortService(this.info.getTrunkCurrentTest(), 1);
        if (map.size() > 0) {
            this.nextPage = "Error Page";
            this.info.setErrorPane(this.getName(), 12);
        }
        return bl;
    }

    @Override
    protected void initPane() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.labelButtonResultPane("Before starting:\n1) Verify that ANS has been launched on all NEs.\n2) Ensure that the selected TXP is tuned in \"First Tunable Wavelength\".\n3) In a single source NE ensure that it is correctly connected to the Booster.\n   In a double source NE ensure that both the select TXP are well connected \n   to the MUX/DMUX .\n\n"));
        this.txpPane(this.info.isEven(), false);
    }

    private void txpPane(boolean bl, boolean bl2) {
        this.txpContainer = this.info.getTxpPane();
        this.add(this.txpContainer);
    }

    @Override
    public void enteringPane() {
        super.enteringPane();
        this.alreadySkip = false;
        if (this.info.isDmuxPresent()) {
            this.txpContainer.setVisible(true, 2, this.getName());
        } else {
            this.txpContainer.setVisible(true, 1, this.getName());
        }
    }

    private void initTxpPane(boolean bl, boolean bl2) {
        this.remove(this.txpContainer);
        this.txpPane(bl, bl2);
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.RamanDay0InstallationConfigDlg;
    }

    @Override
    public JComponent getStatusComponent() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        arrayList.add(new String[]{this.label[0], this.info.getStartNode().getName()});
        arrayList.add(new String[]{this.label[1], this.info.getEndNode().getName()});
        this.txpContainer.getStatusComponent(arrayList, this.getName());
        if (this.nextPage.equals("Calibrate Raman")) {
            arrayList.add(new String[]{"Selected Lambda: ", Wavelength.getWavelengthStringFromWavelength(this.info.getTxpLambdaCurrentTest())});
            return RamanDayZeroDirLessPane.getGridPanel(arrayList);
        }
        return super.getStatusComponent();
    }

    public static Map setPortService(IEntityModel iEntityModel, int n) {
        if (iEntityModel == null) {
            return new HashMap();
        }
        IPortModel[] iPortModelArray = new IPortModel[]{(IPortModel)iEntityModel};
        HashMap hashMap = new HashMap();
        NetCircuitModel.setUnusedPortsState(iPortModelArray, n, hashMap);
        return hashMap;
    }

    @Override
    public void recovery() {
        if (!this.alreadyRecovered) {
            this.alreadyRecovered = true;
            if (this.txpContainer != null) {
                RamanDayZeroDialog.restoreRaman(true, this.info, (IRamanDayZeroOperation)this.parent);
            }
        }
    }
}

