/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network.raman;

import cerent.cms.model.Attribute;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRamanDayZeroOperation;
import cerent.cms.model.circuits.NetCircuitModel;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzDialog;
import cerent.cms.ui.network.raman.RamanAttribute;
import cerent.cms.ui.network.raman.RamanDayZeroDialog;
import cerent.cms.ui.network.raman.RamanDayZeroInfo;
import cerent.cms.ui.network.raman.RamanDayZeroWzPane;
import cerent.cms.ui.network.raman.TxpPane;
import cerent.util.gui.UComboBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RamanDayZeroSrcPane
extends RamanDayZeroWzPane {
    private final String[] label = new String[]{"Start Node: ", "End Node: "};
    private UComboBox nodeListStart;
    private UComboBox nodeListEnd;
    private IntLambdaPane lambdaAttr = null;
    private TxpPane txpContainer;
    private String nextPage = "Calibrate Raman";
    private JCheckBox biDirectional;
    private JCheckBox dmuxPresent;
    private JCheckBox autoRun;
    private JCheckBox autoSkip;
    private JCheckBox evenSelection;
    private final String hintsStr = "Before starting:\n1) Verify that ANS has been launched on all NEs.\n2) Ensure that the selected TXP is tuned in \"First Tunable Wavelength\".\n3) In a single source NE ensure that it is correctly connected to the Booster.\n   In a double source NE ensure that both the select TXP are well connected \n   to the MUX/DMUX .\n\n";
    private GridBagConstraints nodePresentationGc;
    private JPanel nodePresentationPane;
    private boolean alreadySkip;
    private boolean clearedHistory = false;

    public RamanDayZeroSrcPane(WzDialog wzDialog, WzDiagDebug wzDiagDebug, String string, RamanDayZeroInfo ramanDayZeroInfo) {
        super(wzDialog, wzDiagDebug, string, ramanDayZeroInfo);
    }

    @Override
    public void validatePage() throws Exception {
        if (this.info.isAutoSkip() && !this.info.getEndNode().lineNeedToBeTuned(this.info)) {
            try {
                if (!this.alreadySkip) {
                    while (!this.info.setNextCurrentNode(0)) {
                        this.alreadySkip = true;
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.nextPage = this.goOn();
            }
        }
        if (((RamanDayZeroDialog)this.parent).startedFromLink()) {
            this.info.setStartNode((RamanAttribute)this.nodeListStart.getSelectedItem());
            this.info.setEndNode((RamanAttribute)this.nodeListEnd.getSelectedItem());
        }
        this.nextPage = this.txpContainer.setTrunkCurrentTest(this.nextPage, this.getName());
        boolean bl = false;
        if (this.info.getTestIndex() == 0 && this.nextPage.equals("Calibrate Raman")) {
            if (this.info.needReturnPage()) {
                this.nextPage = "Setting Parameters Return Path";
                bl = true;
            }
        } else if (this.info.getTestIndex() == 1 && this.info.isNeedReturn()) {
            this.nextPage = "Calibrate Raman";
        }
        if (this.info.getTestIndex() == 0) {
            if (this.info.isInReturn()) {
                this.info.setNeedReturn(false);
            } else {
                this.info.setNeedReturn(this.biDirectional.isSelected());
            }
            this.info.setDmuxPresent(this.dmuxPresent.isSelected());
        }
        this.info.setAutoRun(this.autoRun.isSelected());
        if (!bl) {
            ((RamanDayZeroDialog)this.parent).setAutoRun(this.autoRun.isSelected());
        }
    }

    private String goOn() {
        if (this.info.allNodesCalibrated()) {
            if (this.biDirectional.isSelected()) {
                return this.info.prepareBackPath((IRamanDayZeroOperation)this.parent, true);
            }
            ((RamanDayZeroDialog)this.parent).setFinishEnabled(true);
            ((RamanDayZeroDialog)this.parent).nextButtonEnable(false);
            return "Accept Result";
        }
        return "Setting Parameters Forward Path";
    }

    @Override
    protected String getNextPaneName() {
        return this.nextPage;
    }

    @Override
    public boolean handleBack() {
        boolean bl = super.handleBack();
        this.info.decTest();
        Map map = RamanDayZeroSrcPane.setPortService(this.info.getTrunkCurrentTest(), 1);
        if (map.size() > 0) {
            this.nextPage = "Error Page";
            this.info.setErrorPane(this.getName(), 12);
        }
        return bl;
    }

    @Override
    protected void initPane() {
        this.setLayout(new BoxLayout(this, 1));
        this.nodesPane();
        this.setNodeModelList();
        if (((RamanDayZeroDialog)this.parent).startedFromLink()) {
            this.info.setStartNode((RamanAttribute)this.nodeListStart.getSelectedItem());
            this.info.setEndNode((RamanAttribute)this.nodeListEnd.getSelectedItem());
        }
        this.add(this.labelButtonResultPane("Before starting:\n1) Verify that ANS has been launched on all NEs.\n2) Ensure that the selected TXP is tuned in \"First Tunable Wavelength\".\n3) In a single source NE ensure that it is correctly connected to the Booster.\n   In a double source NE ensure that both the select TXP are well connected \n   to the MUX/DMUX .\n\n"));
        this.buttonPane();
        this.txpPane(this.evenSelection.isSelected(), false);
    }

    private void buttonPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.biDirectional = new JCheckBox("Bidirectional Path");
        this.biDirectional.setMnemonic('R');
        jPanel.add((Component)this.biDirectional, gridBagConstraints);
        this.biDirectional.addActionListener(this);
        ++gridBagConstraints.gridx;
        this.dmuxPresent = new JCheckBox("MUX/DMUX Present");
        this.dmuxPresent.setMnemonic('P');
        jPanel.add((Component)this.dmuxPresent, gridBagConstraints);
        this.dmuxPresent.addActionListener(this);
        ++gridBagConstraints.gridx;
        this.evenSelection = new JCheckBox("Even Band");
        this.evenSelection.setMnemonic('E');
        jPanel.add((Component)this.evenSelection, gridBagConstraints);
        this.evenSelection.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.autoRun = new JCheckBox("AutoRun wizard");
        this.autoRun.setMnemonic('A');
        jPanel.add((Component)this.autoRun, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 13;
        this.autoSkip = new JCheckBox("Auto Skip Tune Path");
        this.autoSkip.setMnemonic('S');
        jPanel.add((Component)this.autoSkip, gridBagConstraints);
        this.autoSkip.addActionListener(this);
        if (this.info != null) {
            this.autoSkip.setSelected(this.info.isAutoSkip());
        }
        this.add(jPanel);
    }

    private void txpPane(boolean bl, boolean bl2) {
        if (this.txpContainer == null) {
            this.txpContainer = new TxpPane(new GridBagLayout(), bl, this.info);
            this.info.setTxpPane(this.txpContainer);
        }
        this.add(this.txpContainer);
        if (this.lambdaAttr == null) {
            this.lambdaAttr = new IntLambdaPane();
        }
        this.txpContainer.init(bl2, this.lambdaAttr);
    }

    private void nodesPane() {
        this.nodePresentationPane = new JPanel(new GridBagLayout());
        this.nodePresentationGc = new GridBagConstraints();
        this.nodePresentationGc.gridx = 0;
        this.nodePresentationGc.gridy = 0;
        this.nodePresentationGc.fill = 1;
        this.nodePresentationGc.insets = new Insets(5, 5, 0, 0);
        this.nodePresentationGc.anchor = 18;
        this.nodePresentationPane.add((Component)new JLabel(this.label[0]), this.nodePresentationGc);
        this.nodePresentationGc.gridx = 1;
        this.nodeListStart = new UComboBox();
        this.nodePresentationPane.add((Component)this.nodeListStart, this.nodePresentationGc);
        this.nodePresentationGc.gridx = 0;
        this.nodePresentationGc.gridy += 2;
        this.nodePresentationPane.add((Component)new JLabel(this.label[1]), this.nodePresentationGc);
        this.nodePresentationGc.gridx = 1;
        this.nodeListEnd = new UComboBox();
        this.nodePresentationPane.add((Component)this.nodeListEnd, this.nodePresentationGc);
        this.nodePresentationGc.gridx = 0;
        this.nodePresentationGc.gridy += 2;
        this.nodeListEnd.setEnabled(false);
        if (!((RamanDayZeroDialog)this.parent).startedFromLink()) {
            this.nodeListStart.setEnabled(false);
        } else {
            this.nodeListStart.addActionListener((ActionListener)this);
        }
        this.add(this.nodePresentationPane);
    }

    @Override
    public void enteringPane() {
        super.enteringPane();
        this.alreadySkip = false;
        this.setNodeModelList();
        this.lambdaAttr.setLambdaTest(this.info.getTestIndex());
        this.info.setTxpLambdaCurrentTest(this.lambdaAttr.getSelectedLambda());
        if (this.info.needTxpSelection() && !this.info.isInReturn()) {
            if (this.info.getTestIndex() == 0) {
                this.hintVisible(true);
                this.initTxpPane(this.evenSelection.isSelected(), false);
                if (this.dmuxPresent.isSelected()) {
                    this.txpContainer.setVisible(true, 2, this.getName());
                }
            }
            if (this.info.getTestIndex() > 0) {
                this.txpContainer.setVisible(false, 0, this.getName());
                this.biDirectional.setEnabled(false);
                this.dmuxPresent.setEnabled(false);
                this.evenSelection.setEnabled(false);
                this.hintVisible(false);
                this.autoSkip.setEnabled(false);
            }
        } else {
            this.txpContainer.setVisible(false, 0, this.getName());
            if (this.info.getTestIndex() == 0) {
                this.autoSkip.setEnabled(true);
                if (this.info.isInReturn() && !this.clearedHistory) {
                    ((RamanDayZeroDialog)this.parent).clearStatusHistory();
                    this.clearedHistory = true;
                }
            }
        }
        ((RamanDayZeroDialog)this.parent).nextButtonEnable(true, this.autoRun.isSelected());
    }

    private void initTxpPane(boolean bl, boolean bl2) {
        this.remove(this.txpContainer);
        this.txpContainer = null;
        this.txpPane(bl, bl2);
    }

    private void setNodeModelList() {
        RamanAttribute[] ramanAttributeArray = ((RamanDayZeroDialog)this.parent).getNodeList();
        boolean bl = ((RamanDayZeroDialog)this.parent).startedFromLink();
        if (this.info.getTestIndex() < 1) {
            if (ramanAttributeArray.length == 2) {
                RamanAttribute[] ramanAttributeArray2 = new RamanAttribute[]{ramanAttributeArray[1], ramanAttributeArray[0]};
                this.nodeListStart.setModel(new DefaultComboBoxModel<RamanAttribute>(ramanAttributeArray));
                this.nodeListEnd.setModel(new DefaultComboBoxModel<RamanAttribute>(ramanAttributeArray2));
            } else {
                this.nodeListStart.setModel(new DefaultComboBoxModel<RamanAttribute>(((RamanDayZeroDialog)this.parent).getNodeList()));
                this.nodeListEnd.setModel(new DefaultComboBoxModel<RamanAttribute>(((RamanDayZeroDialog)this.parent).getNodeList()));
            }
            if (!bl) {
                this.nodeListStart.setEnabled(false);
                this.nodeListEnd.setEnabled(false);
            }
        } else {
            this.nodeListStart.setEnabled(false);
            this.nodeListEnd.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.dmuxPresent) {
            if (this.dmuxPresent.isSelected()) {
                this.txpContainer.setVisible(true, 2, this.getName());
            } else {
                this.txpContainer.setVisible(false, 2, this.getName());
            }
        } else if (object == this.biDirectional) {
            this.info.setNeedReturn(this.biDirectional.isSelected());
        } else if (object == this.nodeListStart) {
            int n = this.nodeListStart.getSelectedIndex();
            this.nodeListEnd.setSelectedIndex(n);
            RamanAttribute ramanAttribute = this.info.getStartNode();
            this.info.setStartNode(this.info.getEndNode());
            this.info.setEndNode(ramanAttribute);
            this.initTxpPane(this.evenSelection.isSelected(), false);
        } else if (object == this.autoSkip) {
            this.info.setAutoSkip(this.autoSkip.isSelected());
        } else if (object == this.evenSelection) {
            this.info.setEvenSelection(this.evenSelection.isSelected());
            this.initTxpPane(this.info.isEven(), true);
            if (this.dmuxPresent.isSelected()) {
                this.txpContainer.setVisible(true, 2, this.getName());
            } else {
                this.txpContainer.setVisible(false, 2, this.getName());
            }
        }
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.RamanDay0InstallationConfigDlg;
    }

    @Override
    public JComponent getStatusComponent() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        arrayList.add(new String[]{this.label[0], this.info.getStartNode().getName()});
        arrayList.add(new String[]{this.label[1], this.info.getEndNode().getName()});
        String string = this.biDirectional.isSelected() ? "Doing the back Path" : "End of Wizard";
        arrayList.add(new String[]{string, ""});
        this.txpContainer.getStatusComponent(arrayList, this.getName());
        if (this.nextPage.equals("Calibrate Raman") || this.nextPage.equals("Setting Parameters Return Path")) {
            arrayList.add(new String[]{"Selected Lambda: ", Wavelength.getWavelengthStringFromWavelength(this.info.getTxpLambdaCurrentTest())});
            return RamanDayZeroSrcPane.getGridPanel(arrayList);
        }
        return super.getStatusComponent();
    }

    public static Map setPortService(IEntityModel iEntityModel, int n) {
        if (iEntityModel == null) {
            return new HashMap();
        }
        IPortModel[] iPortModelArray = new IPortModel[]{(IPortModel)iEntityModel};
        HashMap hashMap = new HashMap();
        NetCircuitModel.setUnusedPortsState(iPortModelArray, n, hashMap);
        return hashMap;
    }

    @Override
    public void recovery() {
        if (!this.alreadyRecovered) {
            this.alreadyRecovered = true;
            if (this.txpContainer != null) {
                RamanDayZeroDialog.restoreRaman(true, this.info, (IRamanDayZeroOperation)this.parent);
            }
        }
    }

    class IntLambdaPane {
        private JPanel p;
        private UComboBox lambdaList;

        public IntLambdaPane() {
            RamanDayZeroSrcPane.this.nodePresentationPane.add((Component)new JLabel("Wavelength:"), RamanDayZeroSrcPane.this.nodePresentationGc);
            ((RamanDayZeroSrcPane)RamanDayZeroSrcPane.this).nodePresentationGc.gridx = 1;
            int n = 0;
            if (RamanDayZeroSrcPane.this.evenSelection.isSelected()) {
                n = 1;
            }
            this.lambdaList = new UComboBox(RamanDayZeroInfo.lambdas[n]);
            this.lambdaList.setEnabled(false);
            RamanDayZeroSrcPane.this.nodePresentationPane.add((Component)this.lambdaList, RamanDayZeroSrcPane.this.nodePresentationGc);
            ((RamanDayZeroSrcPane)RamanDayZeroSrcPane.this).nodePresentationGc.gridx = 0;
            ((RamanDayZeroSrcPane)RamanDayZeroSrcPane.this).nodePresentationGc.gridy += 2;
        }

        public void setLambdaTest(int n) {
            this.lambdaList.setSelectedIndex(n);
        }

        public int getSelectedLambda() {
            return ((Attribute)this.lambdaList.getSelectedItem()).getIntValue();
        }

        public void changeLambdaCombo(int n) {
            this.lambdaList.removeAll();
            for (int i = 0; i < 2; ++i) {
                this.lambdaList.insertItemAt((Object)RamanDayZeroInfo.lambdas[n][i], i);
            }
        }

        JPanel getUI() {
            return this.p;
        }
    }
}

