/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.snmp;

import java.awt.Toolkit;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class Snmpv3EngineIDTextField
extends JTextField {
    private static String lettersString = "abcdefABCDEF";
    private static String digitsString = "0123456789";
    private static final int MAX_ENGINE_ID_LENGTH = 32;

    public Snmpv3EngineIDTextField() {
        super(32);
    }

    @Override
    protected Document createDefaultModel() {
        return new Snmpv3EngineDoc(this.getColumns());
    }

    static class Snmpv3EngineDoc
    extends PlainDocument {
        int documentMaxLength;

        public Snmpv3EngineDoc(int n) {
            this.documentMaxLength = n;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            boolean bl = true;
            if (string != null) {
                if (string.length() + this.getLength() > this.documentMaxLength) {
                    bl = false;
                } else {
                    for (int i = 0; bl && i < string.length(); ++i) {
                        char c = string.charAt(i);
                        if (-1 != lettersString.indexOf(c) || -1 != digitsString.indexOf(c)) continue;
                        bl = false;
                    }
                }
            }
            if (bl) {
                super.insertString(n, string, attributeSet);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

