/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.snmp;

import cerent.cms.model.INodeModel;
import cerent.cms.model.ISnmpModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SnmpProxyConfigAlreadyExists;
import cerent.cms.model.SnmpV3EngineContainer;
import cerent.cms.model.SnmpV3PassKey;
import cerent.cms.model.SnmpV3ProxyTrapFwd;
import cerent.cms.model.SnmpV3ProxyUser;
import cerent.cms.model.SnmpV3TargetAddressContainer;
import cerent.cms.model.SnmpV3TargetParamsContainer;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.snmp.SnmpProxyPane;
import cerent.cms.ui.snmp.Snmpv3EngineIDTextField;
import cerent.cms.ui.snmp.Snmpv3ProxyAutoConfigDialog;
import cerent.cms.ui.snmp.Snmpv3ProxyManualConfigDialog;
import cerent.cms.ui.snmp.Snmpv3TrapSelector;
import cerent.cms.ui.snmp.Snmpv3UserDetailsPanel;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.SnmpUtil;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.SnmpV3TagField;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class Snmpv3ProxyTrapTablePane
extends AbstractPane
implements ActionListener,
ListSelectionListener,
TableModelListener {
    public static final String AUTO_CREATE = "Auto Create...";
    public static final String MANUAL_CREATE = "Manual Create...";
    public static final String DELETE = "Delete...";
    protected Snmpv3ProxyTableModel dataModel;
    protected ArrayList tableDataList;
    UScrollPane scrollPane;
    private JPanel buttons;
    private JButton manualCreatePB;
    private JButton autoCreatePB;
    private JButton deletePB;
    private boolean inited = false;
    private SnmpProxyPane parentPane;
    private JComboBox trapSource;
    private Snmpv3EngineIDTextField ctxtEngIDTB;
    private SnmpV3TagField targetTagTB;
    private Snmpv3UserDetailsPanel udPane;
    private Snmpv3TrapSelector trapSelector;

    public Snmpv3ProxyTrapTablePane(String string, TabbedView tabbedView, SnmpProxyPane snmpProxyPane) {
        super(string, tabbedView.getUiModel(), tabbedView);
        this.parentPane = snmpProxyPane;
        this.init();
    }

    public boolean isInited() {
        return this.inited;
    }

    protected void init() {
        block5: {
            if (db.on()) {
                db.println(" Snmpv3ProxyTrapTablePane : init");
            }
            this.tableDataList = new ArrayList();
            this.dataModel = this.createTableModel();
            this.dataModel.addTableModelListener(this);
            this.table = new UTable((TableModel)this.dataModel);
            this.table.setRowSelectionAllowed(true);
            this.table.setSelectionMode(2);
            this.table.getSelectionModel().addListSelectionListener(this);
            this.prepareColumns();
            this.setLayout(new BorderLayout());
            this.scrollPane = new UScrollPane((Component)this.table);
            this.add((Component)this.scrollPane, "Center");
            this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
            this.buttons = this.getButtonBar();
            this.add(this.buttons, "South");
            ArrayList arrayList = this.parentPane.getAllGnes();
            for (int i = 0; i < arrayList.size(); ++i) {
                ((INodeModel)arrayList.get(i)).getSnmpModel().addObserver((Observer)((Object)this));
            }
            ISnmpModel iSnmpModel = this.parentPane.getCurrentGneSnmpModel();
            if (null != iSnmpModel) {
                try {
                    ArrayList arrayList2 = iSnmpModel.getSnmpV3ProxyTrapFwd();
                    this.tableDataList.add(arrayList2);
                    this.refreshTable();
                }
                catch (Exception exception) {
                    if (!db.on()) break block5;
                    SDebug.printStackTrace((Throwable)exception);
                    db.println("Error while getting the Proxy table entries");
                }
            }
        }
        this.inited = true;
    }

    protected Snmpv3ProxyTableModel createTableModel() {
        return new Snmpv3ProxyTableModel();
    }

    protected void prepareColumns() {
        Snmpv3ProxyTableRenderer snmpv3ProxyTableRenderer = new Snmpv3ProxyTableRenderer();
        for (int i = 0; i < this.dataModel.getColumnCount(); ++i) {
            this.table.getColumn(this.dataModel.getColumnName(i)).setCellRenderer(snmpv3ProxyTableRenderer);
        }
        this.table.getColumn(this.dataModel.getColumnName(0)).setMinWidth(230);
        this.table.getColumn(this.dataModel.getColumnName(2)).setMinWidth(200);
        this.table.getColumn(this.dataModel.getColumnName(1)).setMinWidth(200);
        this.table.getColumn(this.dataModel.getColumnName(3)).setMinWidth(100);
    }

    @Override
    public void enteringPage() {
        block5: {
            if (db.on()) {
                db.println("Snmpv3ProxyTrapTablePane >>> enteringPage ");
            }
            try {
                if (!this.inited) {
                    this.init();
                }
                this.refresh();
                TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
            }
            catch (Exception exception) {
                if (!db.on()) break block5;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (db.on()) {
            db.println("Snmpv3ProxyTrapTablePane <<< enteringPage()");
        }
    }

    @Override
    public void leavingPage() throws Exception {
        if (Snmpv3ProxyTrapTablePane.db.on) {
            db.println("Snmpv3ProxyTrapTablePane >>> leavingPage()");
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
    }

    @Override
    public void update(Observable observable, Object object) {
        db.fine("update(" + observable + ", " + object + ")");
        this.refresh();
    }

    @Override
    public void refresh() {
        block3: {
            ISnmpModel iSnmpModel = this.parentPane.getCurrentGneSnmpModel();
            this.tableDataList.clear();
            if (null != iSnmpModel) {
                try {
                    ArrayList arrayList = iSnmpModel.getSnmpV3ProxyTrapFwd();
                    this.tableDataList.addAll(arrayList);
                    this.refreshTable();
                }
                catch (Exception exception) {
                    if (!db.on()) break block3;
                    SDebug.printStackTrace((Throwable)exception);
                    db.println("Error while fetching SNMPv3 Proxy entries");
                }
            }
        }
    }

    protected void refreshTable() {
        this.dataModel.fireTableDataChanged();
        int n = this.table.getSelectedRow();
        if (n < 0 || n > this.dataModel.getRowCount()) {
            this.setEditDeleteEnabled(false);
        }
    }

    protected void setEditDeleteEnabled(boolean bl) {
        if (!this.isUserAuthorized()) {
            bl = false;
        }
        if (!bl) {
            this.clearTableSelection();
        }
        this.deletePB.setEnabled(bl && this.table.getSelectedRowCount() > 0);
    }

    protected void clearTableSelection() {
        if (this.table != null && this.tableDataList.size() != 0) {
            this.table.removeRowSelectionInterval(0, this.tableDataList.size() - 1);
        }
    }

    protected void removeActionListeners() {
        this.manualCreatePB.removeActionListener(this);
        this.autoCreatePB.removeActionListener(this);
        this.deletePB.removeActionListener(this);
    }

    @Override
    public void destroy() {
        if (db.on()) {
            db.println(">>>  destroy()");
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (this.inited) {
            this.removeActionListeners();
        }
        super.destroy();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.manualCreatePB) {
            this.doActionManualProxyConfigure();
        } else if (object == this.deletePB) {
            this.deleteProxyTableRows();
        } else if (object == this.autoCreatePB) {
            this.doActionAutoProxyConfigure();
        }
    }

    private boolean checkIfProxyEntryExistsAuto() {
        String string;
        boolean bl;
        block6: {
            bl = false;
            string = null;
            try {
                Object[] objectArray = this.trapSelector.gettrapList().getSelectedValues();
                String string2 = this.targetTagTB.getText();
                for (int i = 0; i < objectArray.length; ++i) {
                    NetElement netElement = (NetElement)Network.instance().findNetElemByIp((String)objectArray[i]);
                    if (null == netElement) {
                        netElement = (NetElement)Network.instance().findNetElemByIp(this.parentPane.getIpv4Address((String)objectArray[i]));
                    }
                    ISnmpModel iSnmpModel = netElement.getNodeModel().getSnmpModel();
                    SnmpV3EngineContainer snmpV3EngineContainer = iSnmpModel.getSnmpV3EngineWrapper();
                    String string3 = SnmpUtil.toStringEngineID(snmpV3EngineContainer.getContextEngID(), snmpV3EngineContainer.getContextEngIDLength());
                    for (int j = 0; j < this.dataModel.getRowCount(); ++j) {
                        if (!string3.equals((String)this.dataModel.getValueAt(j, 0)) || !string2.equals((String)this.dataModel.getValueAt(j, 1))) continue;
                        string = null == string ? (String)objectArray[i] : string + ", " + (String)objectArray[i];
                        bl = true;
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block6;
                SDebug.printStackTrace((Throwable)exception);
                db.println("Error while checking for duplicates.");
            }
        }
        if (bl) {
            ErrorMsg.displayError((Component)((Object)this), NEMC.EID_SNMPV3_PROXY_DUPLICATE, "SNMPv3 Proxy Trap Forwarder", "Remote Trap Source(s) : ", string);
        }
        return bl;
    }

    private void doActionAutoProxyConfigure() {
        block10: {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.parentPane.getClientsForGne());
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(gridBagLayout);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridx = 0;
            JPanel jPanel2 = new JPanel(new FlowLayout(0, 10, 0));
            JLabel jLabel = new JLabel("Target Tag: ");
            this.targetTagTB = new SnmpV3TagField(30);
            this.targetTagTB.setMaxLength(32);
            this.targetTagTB.setMaximumSize(this.targetTagTB.getPreferredSize());
            jPanel2.add(jLabel);
            jPanel2.add(this.targetTagTB);
            gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
            jPanel.add(jPanel2);
            gridBagConstraints.gridy = 1;
            this.trapSelector = new Snmpv3TrapSelector(arrayList, this.parentPane);
            gridBagLayout.setConstraints(this.trapSelector.getPanel(), gridBagConstraints);
            jPanel.add(this.trapSelector.getPanel());
            Object[] objectArray = new Object[]{"", jPanel};
            String string = "OK";
            String string2 = "Cancel";
            Object[] objectArray2 = new Object[]{string, string2, CSHelpButton.getCaption()};
            JOptionPane jOptionPane = new JOptionPane(objectArray, -1, 0, null, objectArray2, objectArray2[0]);
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            arrayList2.add(jOptionPane);
            arrayList2.add(this.trapSelector);
            Snmpv3ProxyAutoConfigDialog snmpv3ProxyAutoConfigDialog = Snmpv3ProxyAutoConfigDialog.instance((Component)((Object)this), true, "Automatic Configuration of SNMPv3 Proxy Trap Forwarder", arrayList2, true);
            snmpv3ProxyAutoConfigDialog.setResizable(false);
            try {
                snmpv3ProxyAutoConfigDialog.show();
                if (jOptionPane.getValue() != null && jOptionPane.getValue().equals(string)) {
                    Object[] objectArray3 = this.trapSelector.gettrapList().getSelectedValues();
                    for (int i = 0; i < objectArray3.length; ++i) {
                        String string3;
                        SnmpV3TargetAddressContainer snmpV3TargetAddressContainer;
                        Object object;
                        SnmpV3PassKey snmpV3PassKey;
                        Object object2;
                        NetElement netElement = (NetElement)Network.instance().findNetElemByIp((String)objectArray3[i]);
                        if (null == netElement) {
                            netElement = (NetElement)Network.instance().findNetElemByIp(this.parentPane.getIpv4Address((String)objectArray3[i]));
                        }
                        ISnmpModel iSnmpModel = netElement.getNodeModel().getSnmpModel();
                        SnmpV3EngineContainer snmpV3EngineContainer = iSnmpModel.getSnmpV3EngineWrapper();
                        SnmpV3ProxyUser snmpV3ProxyUser = iSnmpModel.checkIfUserExists("ons_trap_user");
                        String string4 = Long.toString(System.currentTimeMillis());
                        if (snmpV3ProxyUser == null) {
                            object2 = new byte[20];
                            int n = 0;
                            snmpV3PassKey = new SnmpV3PassKey(object2, n, string4, true);
                            object = new SnmpV3ProxyUser(snmpV3PassKey, 1, "default_group", snmpV3PassKey, 1, "ons_trap_user", snmpV3EngineContainer);
                            iSnmpModel.setSnmpV3UserWrapper(object);
                        }
                        snmpV3ProxyUser = iSnmpModel.checkIfUserExists("ons_trap_user");
                        object2 = new SnmpV3PassKey(snmpV3ProxyUser.getAuthKey().getKey(), snmpV3ProxyUser.getAuthKey().getKeyLen(), "", false);
                        SnmpV3PassKey snmpV3PassKey2 = new SnmpV3PassKey(snmpV3ProxyUser.getPrivKey().getKey(), snmpV3ProxyUser.getPrivKey().getKeyLen(), "", false);
                        snmpV3PassKey = new SnmpV3ProxyUser((SnmpV3PassKey)object2, 1, "default_group", snmpV3PassKey2, 1, "ons_trap_user", snmpV3EngineContainer);
                        this.parentPane.getCurrentGneSnmpModel().setSnmpV3UserWrapper((Object)snmpV3PassKey);
                        object = Long.toString(System.currentTimeMillis() + 1L);
                        SnmpV3TargetParamsContainer snmpV3TargetParamsContainer = iSnmpModel.checkIfTargetParamExists("ons_trap_user", 3, 3);
                        if (null == snmpV3TargetParamsContainer) {
                            snmpV3TargetParamsContainer = new SnmpV3TargetParamsContainer((String)object, 3, "ons_trap_user", 3);
                            iSnmpModel.setSnmpV3TargetParamsWrapper((Object)snmpV3TargetParamsContainer);
                        }
                        if (null == (snmpV3TargetAddressContainer = iSnmpModel.checkIfTargetAddressExists(this.parentPane.getCurrentGneNM().getHostName(), 161, 10000, 10, "_targetTag__", snmpV3TargetParamsContainer.getparamsName()))) {
                            string3 = Long.toString(System.currentTimeMillis() + 2L);
                            snmpV3TargetAddressContainer = new SnmpV3TargetAddressContainer(string3, this.parentPane.getCurrentGneNM().getHostName(), 161, 10000, 10, "_targetTag__", snmpV3TargetParamsContainer.getparamsName());
                            iSnmpModel.setSnmpV3TargetAddressWrapper((Object)snmpV3TargetAddressContainer);
                        }
                        string3 = SnmpUtil.toStringEngineID(snmpV3EngineContainer.getContextEngID(), snmpV3EngineContainer.getContextEngIDLength());
                        this.parentPane.getCurrentGneSnmpModel().setProxyTrapFwd(string3, this.targetTagTB.getText(), "ons_trap_user", "SecurityLevel_authPriv");
                    }
                }
            }
            catch (SnmpProxyConfigAlreadyExists snmpProxyConfigAlreadyExists) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_SNMPV3_PROXY_ALREADY_EXISTS);
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)snmpProxyConfigAlreadyExists);
                    db.println("Duplicate SNMPv3 Proxy configuration");
                }
            }
            catch (Exception exception) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_SNMPV3_PROXY_CONFIG_FAILURE);
                if (!db.on()) break block10;
                SDebug.printStackTrace((Throwable)exception);
                db.println("Error during SNMPv3 Proxy trap configuration");
            }
        }
    }

    private boolean checkIfProxyEntryExistsManual() {
        boolean bl = false;
        String string = SnmpUtil.getEngineIDPadded(this.ctxtEngIDTB.getText());
        String string2 = this.targetTagTB.getText();
        String string3 = this.udPane.getUserName();
        String string4 = SnmpUtil.securityLevel[this.udPane.getSecurityLevel()].getKey();
        for (int i = 0; i < this.dataModel.getRowCount(); ++i) {
            if (!string.equals((String)this.dataModel.getValueAt(i, 0)) || !string2.equals((String)this.dataModel.getValueAt(i, 1)) || !string3.equals((String)this.dataModel.getValueAt(i, 2)) || !string4.equals((String)this.dataModel.getValueAt(i, 3))) continue;
            bl = true;
        }
        if (bl) {
            ErrorMsg.displayError((Component)((Object)this), NEMC.EID_SNMPV3_PROXY_DUPLICATE, "SNMPv3 Proxy Trap Forwarder", "Tag : ", string2);
        }
        return bl;
    }

    public boolean validateAutoConfig() {
        boolean bl = false;
        if (this.trapSelector.gettrapList().getSelectedValues().length < 1) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_SNMPV3_MIN_SRC_OF_TRAP);
            return bl;
        }
        if (this.targetTagTB.getText().equals("")) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_SNMPV3_INVALID_TARGET_TAG);
            return bl;
        }
        if (!this.checkIfProxyEntryExistsAuto()) {
            bl = true;
        }
        return bl;
    }

    public boolean validateManualConfig() {
        boolean bl = false;
        if (this.ctxtEngIDTB.getText().equals("")) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_SNMPV3_INVALID_ENGINE_ID);
            return bl;
        }
        if (this.targetTagTB.getText().equals("")) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_SNMPV3_INVALID_TARGET_TAG);
            return bl;
        }
        if (this.udPane.validateUserAttr() && !this.checkIfProxyEntryExistsManual()) {
            bl = true;
        }
        return bl;
    }

    private void doActionManualProxyConfigure() {
        block7: {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(gridBagLayout);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridy = 0;
            JPanel jPanel2 = new JPanel(new FlowLayout(0, 10, 10));
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.parentPane.getClientsForGne());
            this.trapSource = new JComboBox();
            for (int i = 0; i < arrayList.size(); ++i) {
                this.trapSource.addItem(arrayList.get(i));
            }
            this.trapSource.setEditable(true);
            this.trapSource.setPreferredSize(new Dimension(265, 20));
            this.trapSource.setMaximumSize(this.trapSource.getPreferredSize());
            this.trapSource.setSelectedIndex(-1);
            jPanel2.add(new JLabel("Remote Trap Source:"));
            jPanel2.add(this.trapSource);
            gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
            jPanel.add(jPanel2);
            JPanel jPanel3 = new JPanel(new FlowLayout(0, 10, 10));
            gridBagConstraints.gridy = 1;
            JLabel jLabel = new JLabel("Context Engine ID:    ");
            this.ctxtEngIDTB = new Snmpv3EngineIDTextField();
            this.ctxtEngIDTB.setMaximumSize(this.ctxtEngIDTB.getPreferredSize());
            jPanel3.add(jLabel);
            jPanel3.add(this.ctxtEngIDTB);
            gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
            jPanel.add(jPanel3);
            gridBagConstraints.gridy = 2;
            JPanel jPanel4 = new JPanel(new FlowLayout(0, 10, 10));
            JLabel jLabel2 = new JLabel("Target Tag:                ");
            this.targetTagTB = new SnmpV3TagField(32);
            this.targetTagTB.setMaxLength(32);
            this.targetTagTB.setMaximumSize(this.targetTagTB.getPreferredSize());
            gridBagConstraints.anchor = 18;
            jPanel4.add(jLabel2);
            jPanel4.add(this.targetTagTB);
            gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
            jPanel.add(jPanel4);
            gridBagConstraints.gridy = 3;
            this.udPane = new Snmpv3UserDetailsPanel("Remote User Details", this.parentPane, true);
            gridBagLayout.setConstraints(this.udPane, gridBagConstraints);
            jPanel.add(this.udPane);
            this.trapSource.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    try {
                        String string = (String)Snmpv3ProxyTrapTablePane.this.trapSource.getSelectedItem();
                        if (null != string) {
                            NetElement netElement = (NetElement)Network.instance().findNetElemByIp(string);
                            if (null == netElement) {
                                netElement = (NetElement)Network.instance().findNetElemByIp(Snmpv3ProxyTrapTablePane.this.parentPane.getIpv4Address(string));
                            }
                            ISnmpModel iSnmpModel = netElement.getNodeModel().getSnmpModel();
                            SnmpV3EngineContainer snmpV3EngineContainer = iSnmpModel.getSnmpV3EngineWrapper();
                            Snmpv3ProxyTrapTablePane.this.udPane.refreshUserList(snmpV3EngineContainer);
                            Snmpv3ProxyTrapTablePane.this.ctxtEngIDTB.setText(SnmpUtil.toStringEngineID(snmpV3EngineContainer.getContextEngID(), snmpV3EngineContainer.getContextEngIDLength()));
                        }
                    }
                    catch (Exception exception) {
                        Snmpv3ProxyTrapTablePane.this.ctxtEngIDTB.setText("");
                        Snmpv3ProxyTrapTablePane.this.udPane.refreshUserList(null);
                    }
                }
            });
            KeyListener keyListener = new KeyListener(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    String string = SnmpUtil.getEngineIDPadded(Snmpv3ProxyTrapTablePane.this.ctxtEngIDTB.getText());
                    byte[] byArray = SnmpUtil.toBytesEngineID(string, string.length());
                    SnmpV3EngineContainer snmpV3EngineContainer = new SnmpV3EngineContainer(byArray, string.length() / 2, 0);
                    Snmpv3ProxyTrapTablePane.this.udPane.refreshUserList(snmpV3EngineContainer);
                }

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }
            };
            this.ctxtEngIDTB.addKeyListener(keyListener);
            Object[] objectArray = new Object[]{"", jPanel};
            String string = "OK";
            String string2 = "Cancel";
            Object[] objectArray2 = new Object[]{string, string2, CSHelpButton.getCaption()};
            JOptionPane jOptionPane = new JOptionPane(objectArray, -1, 0, null, objectArray2, objectArray2[0]);
            ArrayList<JOptionPane> arrayList2 = new ArrayList<JOptionPane>();
            arrayList2.add(jOptionPane);
            Snmpv3ProxyManualConfigDialog snmpv3ProxyManualConfigDialog = Snmpv3ProxyManualConfigDialog.instance((Component)((Object)this), true, "Manual Configuration of SNMPv3 Proxy Trap Forwarder", arrayList2, true);
            snmpv3ProxyManualConfigDialog.setResizable(false);
            try {
                snmpv3ProxyManualConfigDialog.show();
                if (jOptionPane.getValue() != null && jOptionPane.getValue().equals(string)) {
                    String string3;
                    String string4 = SnmpUtil.getEngineIDPadded(this.ctxtEngIDTB.getText());
                    byte[] byArray = SnmpUtil.toBytesEngineID(string4, string4.length());
                    if (!this.udPane.checkIfUserReUsed()) {
                        string3 = new SnmpV3ProxyUser(this.udPane.getAuthPassKey(), this.udPane.getAuthProtocol(), "", this.udPane.getPrivPassKey(), this.udPane.getPrivProtocol(), this.udPane.getUserName(), new SnmpV3EngineContainer(byArray, string4.length() / 2, 0));
                        this.parentPane.getCurrentGneSnmpModel().setSnmpV3UserWrapper((Object)string3);
                    }
                    string3 = this.udPane.getUserName();
                    this.parentPane.getCurrentGneSnmpModel().setProxyTrapFwd(string4, this.targetTagTB.getText(), string3, SnmpUtil.getSecLevelStdString(SnmpUtil.securityLevel[this.udPane.getSecurityLevel()].getKey()));
                }
            }
            catch (SnmpProxyConfigAlreadyExists snmpProxyConfigAlreadyExists) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_SNMPV3_PROXY_ALREADY_EXISTS);
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)snmpProxyConfigAlreadyExists);
                    db.println("Duplicate SNMPv3 Proxy configuration");
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block7;
                SDebug.printStackTrace((Throwable)exception);
                db.println("Error while performing SNMPv3 Proxy configuration");
            }
        }
    }

    private void deleteProxyTableRows() {
        int n;
        int[] nArray = this.table.getSelectedRows();
        if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)("Are you sure you want to delete the selected row" + (nArray.length > 1 ? "s?" : "?")), (String)"Confirmation Dialog")) {
            return;
        }
        this.setEditDeleteEnabled(false);
        String[] stringArray = new String[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] >= 0 && nArray[n] < this.dataModel.getRowCount()) {
                stringArray[n] = (String)this.dataModel.getValueAt(nArray[n], 4);
                continue;
            }
            db.severe("Selected entry does not exist, index: " + nArray[n]);
            stringArray[n] = null;
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] == null) continue;
            try {
                this.parentPane.getCurrentGneSnmpModel().setSnmpV3ProxyWrapper((Object)stringArray[n]);
                continue;
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)exception);
                db.println("Error while deleting SNMPv3 Proxy entry");
            }
        }
    }

    protected JPanel getButtonBar() {
        this.manualCreatePB = this.makeActionButton(MANUAL_CREATE);
        this.autoCreatePB = this.makeActionButton(AUTO_CREATE);
        this.deletePB = this.makeActionButton(DELETE);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.manualCreatePB);
        jPanel.add(this.autoCreatePB);
        jPanel.add(this.deletePB);
        return jPanel;
    }

    protected JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        jButton.setFocusPainted(false);
        this.enableComponent(jButton);
        return jButton;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 0) {
            try {
                int n = this.dataModel.getRowCount();
                boolean bl = n == 0;
                int n2 = this.table.getSelectedRow();
                if (n2 < 0 || n2 >= n) {
                    bl = true;
                }
                this.setEditDeleteEnabled(bl);
            }
            catch (Exception exception) {
                this.setEditDeleteEnabled(false);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        this.setEditDeleteEnabled(!listSelectionModel.isSelectionEmpty());
    }

    protected class Snmpv3ProxyTableModel
    extends AbstractTableModel {
        public static final int ContextEngineID_INDEX = 0;
        public static final int Tag_INDEX = 1;
        public static final int RemoteUser_INDEX = 2;
        public static final int SecurityLevel_INDEX = 3;
        public static final int ProxyName_INDEX = 4;
        public final String[] columnNames = new String[]{"Context Engine ID", "Target Tag", "Remote User", "Security Level"};

        protected Snmpv3ProxyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public int getRowCount() {
            return Snmpv3ProxyTrapTablePane.this.tableDataList.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (Snmpv3ProxyTrapTablePane.this.tableDataList != null && n < Snmpv3ProxyTrapTablePane.this.tableDataList.size()) {
                switch (n2) {
                    case 0: {
                        return ((SnmpV3ProxyTrapFwd)Snmpv3ProxyTrapTablePane.this.tableDataList.get((int)n)).contextEngID;
                    }
                    case 1: {
                        return ((SnmpV3ProxyTrapFwd)Snmpv3ProxyTrapTablePane.this.tableDataList.get((int)n)).targetTag;
                    }
                    case 2: {
                        return ((SnmpV3ProxyTrapFwd)Snmpv3ProxyTrapTablePane.this.tableDataList.get((int)n)).incomingUser;
                    }
                    case 4: {
                        return ((SnmpV3ProxyTrapFwd)Snmpv3ProxyTrapTablePane.this.tableDataList.get((int)n)).proxyName;
                    }
                    case 3: {
                        return ((SnmpV3ProxyTrapFwd)Snmpv3ProxyTrapTablePane.this.tableDataList.get((int)n)).secLevel;
                    }
                }
                return "";
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    protected class Snmpv3ProxyTableRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        @Override
        public int getWidth() {
            return 330;
        }
    }
}

