/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.tl1;

import cerent.cms.ui.tl1.EntryField;
import cerent.cms.ui.tl1.HistoryItem;
import cerent.cms.ui.tl1.TL1ClientPanel;
import cerent.cms.ui.tl1.TL1CtagGen;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RequestBox {
    private GridBagLayout gbl = new GridBagLayout();
    private GridBagConstraints gbc = new GridBagConstraints();
    private JPanel requestPanel;
    private EntryField tl1RequestTextField;
    private JTextField tl1ReqEndTextField;
    private JLabel tl1RequestLabel;
    private JPanel buttonPanel;
    private JButton connectButton;
    private JButton disconnectButton;
    private JButton closeButton;
    private TL1ClientPanel tl1Client;

    public RequestBox(TL1ClientPanel tL1ClientPanel) {
        this.tl1Client = tL1ClientPanel;
    }

    public JComponent getClientPanel() {
        return this.requestPanel;
    }

    public void display() {
        this.requestPanel = new JPanel();
        this.tl1RequestLabel = new JLabel("TL1 request (ctag can be generated automatically by using the $ symbol)");
        this.tl1RequestTextField = new EntryField(80);
        this.tl1RequestTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RequestBox.this.executeCommand(RequestBox.this.tl1RequestTextField.getText());
            }
        });
        this.buttonPanel = new JPanel();
        this.connectButton = new JButton("Connect");
        this.connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RequestBox.this.tl1Client.connect();
                }
                catch (IOException iOException) {
                    RequestBox.this.tl1Client.printlnError("\n\nTL1 client connection error.");
                    RequestBox.this.tl1Client.printlnError(iOException.toString());
                }
            }
        });
        this.buttonPanel.add(this.connectButton);
        this.disconnectButton = new JButton("Disconnect");
        this.disconnectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RequestBox.this.tl1Client.disconnect();
            }
        });
        this.disconnectButton.setEnabled(false);
        this.buttonPanel.add(this.disconnectButton);
        this.tl1ReqEndTextField = new JTextField("\\r\\n", 10);
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RequestBox.this.tl1Client.disconnect();
                Frame frame = JOptionPane.getFrameForComponent(RequestBox.this.tl1Client);
                frame.setVisible(false);
                frame.dispose();
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.requestPanel.setLayout(this.gbl);
        this.gbc.fill = 0;
        this.gbc.anchor = 17;
        this.gbc.gridy = 0;
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 10;
        this.requestPanel.add((Component)this.tl1RequestLabel, this.gbc);
        this.gbc.fill = 2;
        this.gbc.gridy = 1;
        this.gbc.weightx = 1.0;
        this.requestPanel.add((Component)this.tl1RequestTextField, this.gbc);
        this.gbc.fill = 0;
        this.gbc.gridy = 2;
        this.gbc.weightx = 0.0;
        this.requestPanel.add((Component)this.buttonPanel, this.gbc);
    }

    public void setTl1RequestText(HistoryItem historyItem) {
        if (historyItem == null) {
            this.tl1RequestTextField.setText("");
        } else {
            this.tl1RequestTextField.setText(historyItem.value());
        }
    }

    public void setConnectButtonEnabled(boolean bl) {
        this.connectButton.setEnabled(bl);
    }

    public void setDisconnectButtonEnabled(boolean bl) {
        this.disconnectButton.setEnabled(bl);
    }

    public String getReqEnd() {
        String string = this.tl1ReqEndTextField.getText();
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = null;
        while ((n2 = string.indexOf(92, n)) != -1) {
            if (n2 + 1 >= string.length()) continue;
            char c = '\u0000';
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            switch (string.charAt(n2 + 1)) {
                case 'n': {
                    c = '\n';
                    break;
                }
                case 't': {
                    c = '\t';
                    break;
                }
                case 'r': {
                    c = '\r';
                    break;
                }
                case '\\': {
                    c = '\\';
                    break;
                }
                default: {
                    stringBuffer.append(string.substring(n, n2 + 2));
                }
            }
            if (c != '\u0000') {
                stringBuffer.append(string.substring(n, n2));
                stringBuffer.append(c);
            }
            n = n2 + 2;
        }
        if (n != 0) {
            stringBuffer.append(string.substring(n));
            string = stringBuffer.toString();
        }
        return string;
    }

    public void executeCommand(String string) {
        if (string == null) {
            return;
        }
        if (string.length() <= 0) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        TL1CtagGen tL1CtagGen = TL1CtagGen.instance();
        char c = string.charAt(string.length() - 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";?", true);
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            String string2 = stringTokenizer.nextToken();
            String string3 = string2.trim();
            if (string3 == null || string3.length() <= 0) continue;
            String string4 = "";
            if (!string3.equals(";") && !string3.endsWith("?")) {
                string4 = stringTokenizer.countTokens() > 0 ? stringTokenizer.nextToken() : ";";
            }
            string3 = string3 + string4;
            StringBuffer stringBuffer = new StringBuffer(string3);
            int n2 = -1;
            String string5 = stringBuffer.toString();
            for (n = 0; n < 3 && (n2 = string5.indexOf(58, n2 + 1)) != -1; ++n) {
            }
            n = -1;
            if (n2 > -1) {
                char c2;
                for (int i = n2 + 1; i < string5.length() && (c2 = string5.charAt(i)) != ':' && c2 != ';' && c2 != '?'; ++i) {
                    if (c2 != '$') continue;
                    n = i;
                    break;
                }
            }
            String string6 = null;
            if (n != -1) {
                string6 = tL1CtagGen.getCtag();
                stringBuffer.replace(n, n + 1, string6);
            }
            this.tl1Client.write(stringBuffer.toString());
            this.tl1Client.appendToHistoryLog(string3);
            this.tl1Client.appendToSummaryLog(stringBuffer.toString());
            this.tl1RequestTextField.setText("");
        }
    }

    void inputFocus() {
        this.tl1RequestTextField.requestFocusInWindow();
    }
}

