/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.vlan;

import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IXPL2ModuleModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class NodeCheckBoxTree
extends JTree {
    private List<INodeModel> nodeList;
    private IModel scopeModel;
    private DefaultMutableTreeNode rootNode;
    private DefaultTreeModel treeModel;
    private CheckRenderer checkRenderer;
    private NodeSelectionListener nodeSelectionListener;

    public NodeCheckBoxTree(List<INodeModel> list, IModel iModel, boolean bl) {
        this.nodeList = list;
        this.scopeModel = iModel;
        this.buildTree();
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.setModel(this.treeModel);
        this.checkRenderer = new CheckRenderer(bl);
        this.setCellRenderer(this.checkRenderer);
        this.getSelectionModel().setSelectionMode(1);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.nodeSelectionListener = new NodeSelectionListener(this, bl);
        this.addMouseListener(this.nodeSelectionListener);
    }

    private void buildTree() {
        if (this.scopeModel == null) {
            this.rootNode = new CheckNode();
            Collections.sort(this.nodeList, new NodeComparator());
            for (INodeModel iNodeModel : this.nodeList) {
                TreeMap<String, List<IEntityModel>> treeMap = this.getGZL2Cards(iNodeModel);
                if (treeMap.isEmpty()) continue;
                this.addNode(iNodeModel, treeMap);
            }
        } else if (this.scopeModel instanceof INodeModel) {
            IEntityModel[] iEntityModelArray;
            INodeModel iNodeModel = (INodeModel)this.scopeModel;
            this.rootNode = new NETreeNode(iNodeModel);
            TreeMap<String, List<IEntityModel>> treeMap = this.getGZL2Cards(iNodeModel);
            if (!treeMap.isEmpty() && (iEntityModelArray = this.getChassis(iNodeModel)) != null) {
                for (int i = 0; i < iEntityModelArray.length; ++i) {
                    if (!treeMap.containsKey(this.getShelfString(iEntityModelArray[i]))) continue;
                    this.addShelf(this.rootNode, iEntityModelArray[i], treeMap.get(this.getShelfString(iEntityModelArray[i])));
                }
            }
        } else if (this.scopeModel instanceof IModuleModel) {
            this.rootNode = new CardTreeNode((IEntityModel)((IModuleModel)this.scopeModel));
        } else if (this.scopeModel instanceof IEntityModel) {
            IEntityModel iEntityModel = (IEntityModel)this.scopeModel;
            this.rootNode = iEntityModel.getNodeModel().isMultishelf() ? new ShelfTreeNode(iEntityModel) : new NETreeNode(iEntityModel.getNodeModel());
            TreeMap<String, List<IEntityModel>> treeMap = this.getGZL2Cards(null);
            if (!treeMap.isEmpty()) {
                List<IEntityModel> list = treeMap.get(this.getShelfString(iEntityModel));
                for (IEntityModel iEntityModel2 : list) {
                    this.addCard(this.rootNode, iEntityModel2);
                }
            }
        } else {
            this.rootNode = new DefaultMutableTreeNode("Invalid root node!");
        }
    }

    private IEntityModel[] getChassis(INodeModel iNodeModel) {
        IEntityModel[] iEntityModelArray = iNodeModel.getChassisModels();
        Arrays.sort(iEntityModelArray, new ShelfComparator());
        return iEntityModelArray;
    }

    private void addNode(INodeModel iNodeModel, TreeMap<String, List<IEntityModel>> treeMap) {
        block2: {
            IEntityModel[] iEntityModelArray;
            NETreeNode nETreeNode;
            block3: {
                nETreeNode = new NETreeNode(iNodeModel);
                this.rootNode.add(nETreeNode);
                iEntityModelArray = this.getChassis(iNodeModel);
                if (iEntityModelArray == null) break block2;
                if (!iNodeModel.isMultishelf()) break block3;
                for (int i = 0; i < iEntityModelArray.length; ++i) {
                    if (!treeMap.containsKey(this.getShelfString(iEntityModelArray[i]))) continue;
                    this.addShelf(nETreeNode, iEntityModelArray[i], treeMap.get(this.getShelfString(iEntityModelArray[i])));
                }
                break block2;
            }
            if (!treeMap.containsKey(this.getShelfString(iEntityModelArray[0]))) break block2;
            List<IEntityModel> list = treeMap.get(this.getShelfString(iEntityModelArray[0]));
            for (IEntityModel iEntityModel : list) {
                this.addCard(nETreeNode, iEntityModel);
            }
        }
    }

    private void addShelf(DefaultMutableTreeNode defaultMutableTreeNode, IEntityModel iEntityModel, List<IEntityModel> list) {
        ShelfTreeNode shelfTreeNode = new ShelfTreeNode(iEntityModel);
        defaultMutableTreeNode.add(shelfTreeNode);
        for (IEntityModel iEntityModel2 : list) {
            this.addCard(shelfTreeNode, iEntityModel2);
        }
    }

    private void addCard(DefaultMutableTreeNode defaultMutableTreeNode, IEntityModel iEntityModel) {
        CardTreeNode cardTreeNode = new CardTreeNode(iEntityModel);
        defaultMutableTreeNode.add(cardTreeNode);
    }

    private TreeMap<String, List<IEntityModel>> getGZL2Cards(INodeModel iNodeModel) {
        ArrayList<IEntityModel> arrayList = new ArrayList<IEntityModel>();
        TreeMap<String, List<IEntityModel>> treeMap = new TreeMap<String, List<IEntityModel>>();
        IEntityModel[] iEntityModelArray = null;
        iEntityModelArray = this.scopeModel instanceof IEntityModel ? new IEntityModel[]{(IEntityModel)this.scopeModel} : this.getChassis(iNodeModel);
        for (int i = 0; i < iEntityModelArray.length; ++i) {
            ArrayList<IEntityModel> arrayList2 = new ArrayList<IEntityModel>();
            IEntityModel iEntityModel = iEntityModelArray[i];
            arrayList.clear();
            this.retrieveAllGZCards(iEntityModel, arrayList);
            for (IEntityModel iEntityModel2 : arrayList) {
                if (iEntityModel2 instanceof IXPL2ModuleModel && ((IXPL2ModuleModel)iEntityModel2).isL2Switch()) {
                    arrayList2.add(iEntityModel2);
                }
                Collections.sort(arrayList2, new CardComparator());
            }
            if (arrayList2.isEmpty()) continue;
            treeMap.put(this.getShelfString(iEntityModelArray[i]), arrayList2);
        }
        return treeMap;
    }

    private String getSlotString(IEntityModel iEntityModel) {
        StringBuilder stringBuilder = new StringBuilder();
        IModuleModel iModuleModel = iEntityModel.getModuleModel();
        stringBuilder.append("Slot ");
        stringBuilder.append(iModuleModel.getSlot());
        stringBuilder.append(" - ");
        stringBuilder.append(iModuleModel.getEqLabel());
        return stringBuilder.toString();
    }

    private String getShelfString(IEntityModel iEntityModel) {
        if (Feature.provides((INodeModel)iEntityModel.getNodeModel(), (Feature)Feature.MULTISHELF)) {
            return Integer.toString(iEntityModel.getShelfId());
        }
        return "1";
    }

    private void retrieveAllGZCards(IEntityModel iEntityModel, List<IEntityModel> list) {
        int[] nArray;
        for (int n : nArray = new int[]{271, 272}) {
            List list2 = iEntityModel.getDescendantsOfEqType(n);
            list.addAll(list2);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        this.checkRenderer.setEnabled(bl);
        this.nodeSelectionListener.setEnabled(bl);
        super.setEnabled(bl);
    }

    public int getNumSelectedModels() {
        return this.getSelectedModels().size();
    }

    public Collection<IModel> getSelectedModels() {
        ArrayList<IModel> arrayList = new ArrayList<IModel>();
        CheckNode checkNode = (CheckNode)this.treeModel.getRoot();
        Enumeration<TreeNode> enumeration = checkNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            CheckNode checkNode2 = (CheckNode)enumeration.nextElement();
            if (!checkNode2.isLeaf() || !checkNode2.isSelected()) continue;
            arrayList.add(checkNode2.getModel());
        }
        return arrayList;
    }

    private class CardComparator
    implements Comparator<IEntityModel> {
        private CardComparator() {
        }

        @Override
        public int compare(IEntityModel iEntityModel, IEntityModel iEntityModel2) {
            if (iEntityModel.getSlot() == iEntityModel2.getSlot()) {
                return 0;
            }
            if (iEntityModel.getSlot() > iEntityModel2.getSlot()) {
                return 1;
            }
            return -1;
        }
    }

    class CardTreeNode
    extends CheckNode {
        private IEntityModel model;
        private ImageIcon icon;

        public CardTreeNode() {
            this(null);
        }

        public CardTreeNode(IEntityModel iEntityModel) {
            this(iEntityModel, true, false);
        }

        public CardTreeNode(IEntityModel iEntityModel, boolean bl, boolean bl2) {
            super(iEntityModel, bl, bl2);
            this.icon = new ImageIcon(CardTreeNode.class.getResource("/images/icons/DEFAULT_CARD_LOC.gif"));
            this.model = iEntityModel;
        }

        @Override
        public String toString() {
            return NodeCheckBoxTree.this.getSlotString(this.model);
        }

        @Override
        public ImageIcon getIcon() {
            return this.icon;
        }

        @Override
        public IModel getModel() {
            return this.model;
        }
    }

    class CheckNode
    extends DefaultMutableTreeNode {
        private ImageIcon icon;
        public static final int SINGLE_SELECTION = 0;
        public static final int DIG_IN_SELECTION = 4;
        protected int selectionMode;
        protected boolean isSelected;

        public CheckNode() {
            this(null);
        }

        public CheckNode(Object object) {
            this(object, true, false);
        }

        public CheckNode(Object object, boolean bl, boolean bl2) {
            super(object, bl);
            this.icon = new ImageIcon(CheckNode.class.getResource("/images/icons/network16.gif"));
            this.isSelected = bl2;
            this.setSelectionMode(4);
        }

        public void setSelectionMode(int n) {
            this.selectionMode = n;
        }

        public int getSelectionMode() {
            return this.selectionMode;
        }

        public void setSelected(boolean bl) {
            this.isSelected = bl;
            if (this.selectionMode == 4 && this.children != null) {
                Enumeration enumeration = this.children.elements();
                while (enumeration.hasMoreElements()) {
                    CheckNode checkNode = (CheckNode)enumeration.nextElement();
                    checkNode.setSelected(bl);
                }
            }
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        @Override
        public String toString() {
            return "Network";
        }

        public ImageIcon getIcon() {
            return this.icon;
        }

        public IModel getModel() {
            return null;
        }
    }

    class CheckRenderer
    extends JPanel
    implements TreeCellRenderer {
        protected JCheckBox check;
        protected TreeLabel label;
        private boolean isLoading;

        public CheckRenderer(boolean bl) {
            this.isLoading = bl;
            this.setLayout(new FlowLayout(0));
            this.check = new JCheckBox();
            this.add(this.check);
            this.label = new TreeLabel();
            this.add(this.label);
            this.check.setBackground(UIManager.getColor("Tree.textBackground"));
            this.label.setForeground(UIManager.getColor("Tree.textForeground"));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
            this.setEnabled(jTree.isEnabled());
            this.check.setSelected(((CheckNode)object).isSelected());
            this.label.setFont(jTree.getFont());
            this.label.setText(string);
            this.label.setSelected(bl);
            this.label.setFocus(bl4);
            this.label.setIcon(((CheckNode)object).getIcon());
            if (!bl3 && this.isLoading) {
                this.check.setVisible(false);
            } else {
                this.check.setVisible(true);
            }
            return this;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = this.check.getPreferredSize();
            if (!this.check.isVisible()) {
                dimension = new Dimension(0, 0);
            }
            Dimension dimension2 = this.label.getPreferredSize();
            return new Dimension(dimension.width + dimension2.width, dimension.height < dimension2.height ? dimension2.height : dimension.height);
        }

        @Override
        public void doLayout() {
            Dimension dimension = this.check.getPreferredSize();
            if (!this.check.isVisible()) {
                dimension = new Dimension(0, 0);
            }
            Dimension dimension2 = this.label.getPreferredSize();
            int n = 0;
            int n2 = 0;
            if (dimension.height < dimension2.height) {
                n = (dimension2.height - dimension.height) / 2;
            } else {
                n2 = (dimension.height - dimension2.height) / 2;
            }
            this.check.setLocation(0, n);
            this.check.setBounds(0, n, dimension.width, dimension.height);
            this.label.setLocation(dimension.width, n2);
            this.label.setBounds(dimension.width, n2, dimension2.width, dimension2.height);
        }

        @Override
        public void setBackground(Color color) {
            if (color instanceof ColorUIResource) {
                color = null;
            }
            super.setBackground(color);
        }

        @Override
        public void setEnabled(boolean bl) {
            this.check.setEnabled(bl);
        }

        public class TreeLabel
        extends JLabel {
            boolean isSelected;
            boolean hasFocus;

            @Override
            public void setBackground(Color color) {
                if (color instanceof ColorUIResource) {
                    color = null;
                }
                super.setBackground(color);
            }

            @Override
            public void paint(Graphics graphics) {
                String string = this.getText();
                if (string != null && 0 < string.length()) {
                    if (this.isSelected) {
                        graphics.setColor(UIManager.getColor("Tree.selectionBackground"));
                    } else {
                        graphics.setColor(UIManager.getColor("Tree.textBackground"));
                    }
                    Dimension dimension = this.getPreferredSize();
                    int n = 0;
                    Icon icon = this.getIcon();
                    if (icon != null) {
                        n = icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
                    }
                    graphics.fillRect(n, 0, dimension.width - 1 - n, dimension.height);
                    if (this.hasFocus) {
                        graphics.setColor(UIManager.getColor("Tree.selectionBorderColor"));
                        graphics.drawRect(n, 0, dimension.width - 1 - n, dimension.height - 1);
                    }
                }
                super.paint(graphics);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (dimension != null) {
                    dimension = new Dimension(dimension.width + 3, dimension.height);
                }
                return dimension;
            }

            public void setSelected(boolean bl) {
                this.isSelected = bl;
            }

            public void setFocus(boolean bl) {
                this.hasFocus = bl;
            }
        }
    }

    class NETreeNode
    extends CheckNode {
        private INodeModel node;
        private ImageIcon icon;

        public NETreeNode() {
            this(null);
        }

        public NETreeNode(INodeModel iNodeModel) {
            this(iNodeModel, true, false);
        }

        public NETreeNode(INodeModel iNodeModel, boolean bl, boolean bl2) {
            super(iNodeModel, bl, bl2);
            this.icon = new ImageIcon(NETreeNode.class.getResource("/images/icons/DISCONNECTED_LOC.gif"));
            this.node = iNodeModel;
        }

        @Override
        public String toString() {
            return this.node.getName();
        }

        @Override
        public ImageIcon getIcon() {
            return this.icon;
        }

        @Override
        public IModel getModel() {
            return this.node;
        }
    }

    private class NodeComparator
    implements Comparator<INodeModel> {
        private NodeComparator() {
        }

        @Override
        public int compare(INodeModel iNodeModel, INodeModel iNodeModel2) {
            return iNodeModel.getName().compareTo(iNodeModel2.getName());
        }
    }

    class NodeSelectionListener
    extends MouseAdapter {
        JTree tree;
        boolean isLoading;
        boolean isEnabled = false;

        NodeSelectionListener(JTree jTree, boolean bl) {
            this.tree = jTree;
            this.isLoading = bl;
        }

        public void setEnabled(boolean bl) {
            this.isEnabled = bl;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            int n2;
            int n3;
            TreePath treePath;
            if (this.isEnabled && (treePath = this.tree.getPathForRow(n3 = this.tree.getRowForLocation(n2 = mouseEvent.getX(), n = mouseEvent.getY()))) != null) {
                boolean bl;
                CheckNode checkNode = (CheckNode)treePath.getLastPathComponent();
                boolean bl2 = bl = !checkNode.isSelected();
                if (this.isLoading) {
                    if (checkNode.isLeaf()) {
                        if (bl) {
                            CheckNode checkNode2 = (CheckNode)this.tree.getModel().getRoot();
                            checkNode2.setSelected(false);
                        }
                        checkNode.setSelected(bl);
                    }
                } else {
                    checkNode.setSelected(bl);
                }
                ((DefaultTreeModel)this.tree.getModel()).nodeChanged(checkNode);
                this.tree.revalidate();
                this.tree.repaint();
            }
        }
    }

    private class ShelfComparator
    implements Comparator<IEntityModel> {
        private ShelfComparator() {
        }

        @Override
        public int compare(IEntityModel iEntityModel, IEntityModel iEntityModel2) {
            if (iEntityModel.getShelfId() == iEntityModel2.getShelfId()) {
                return 0;
            }
            if (iEntityModel.getShelfId() > iEntityModel2.getShelfId()) {
                return 1;
            }
            return -1;
        }
    }

    class ShelfTreeNode
    extends CheckNode {
        private IEntityModel model;
        private ImageIcon icon;

        public ShelfTreeNode() {
            this(null);
        }

        public ShelfTreeNode(IEntityModel iEntityModel) {
            this(iEntityModel, true, false);
        }

        public ShelfTreeNode(IEntityModel iEntityModel, boolean bl, boolean bl2) {
            super(iEntityModel, bl, bl2);
            this.icon = new ImageIcon(ShelfTreeNode.class.getResource("/images/icons/shelf.gif"));
            this.model = iEntityModel;
        }

        @Override
        public String toString() {
            return "Shelf" + NodeCheckBoxTree.this.getShelfString(this.model);
        }

        @Override
        public ImageIcon getIcon() {
            return this.icon;
        }

        @Override
        public IModel getModel() {
            return this.model;
        }
    }
}

