/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.vlan;

import cerent.cms.model.INodeModel;
import cerent.cms.model.IVlanModel;
import cerent.cms.ui.vlan.VlanStpPane;
import cerent.util.Preferences;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class VlanStpDialog
extends JDialog
implements WindowListener {
    private static final String TITLE = "Vlan / Spanning Tree Table on ";
    private static final String PROP_GEN_PATH = "ctc.vlanspt.window";
    private static final String PROP_WINX = "x";
    private static final String PROP_WINY = "y";
    private static final String PROP_WINH = "h";
    private static final String PROP_WINW = "w";
    private VlanStpPane pane;

    public VlanStpDialog(Component component, Object[] objectArray) throws IllegalArgumentException {
        super(JOptionPane.getFrameForComponent(component), "", true);
        if (objectArray == null || objectArray.length < 1 || !(objectArray[0] instanceof INodeModel) || objectArray.length > 1 && !(objectArray[1] instanceof IVlanModel[])) {
            throw new IllegalArgumentException("Expecting INodeModel");
        }
        INodeModel iNodeModel = (INodeModel)objectArray[0];
        IVlanModel[] iVlanModelArray = null;
        if (objectArray.length > 1) {
            if (objectArray[1] instanceof IVlanModel[]) {
                iVlanModelArray = (IVlanModel[])objectArray[1];
            } else {
                throw new IllegalArgumentException("Expecting IVlanModel[]");
            }
        }
        this.setTitle(TITLE + iNodeModel.getName());
        this.init(component, iNodeModel, iVlanModelArray);
    }

    public VlanStpDialog(Dialog dialog, INodeModel iNodeModel, IVlanModel[] iVlanModelArray) {
        super(dialog, TITLE + iNodeModel.getName(), true);
        this.init(dialog, iNodeModel, iVlanModelArray);
    }

    public VlanStpDialog(Frame frame, INodeModel iNodeModel, IVlanModel[] iVlanModelArray) {
        super(frame, TITLE + iNodeModel.getName());
        this.init(frame, iNodeModel, iVlanModelArray);
    }

    private void init(Component component, INodeModel iNodeModel, IVlanModel[] iVlanModelArray) {
        this.setDefaultCloseOperation(2);
        this.addWindowListener(this);
        this.pane = new VlanStpPane(this, iNodeModel.getEtherBridgeModel(), iVlanModelArray);
        this.getContentPane().add((Component)((Object)this.pane));
        this.pack();
        Preferences preferences = Preferences.instance();
        try {
            int n = Integer.parseInt(preferences.getProperty(PROP_GEN_PATH, PROP_WINX, ""));
            int n2 = Integer.parseInt(preferences.getProperty(PROP_GEN_PATH, PROP_WINY, ""));
            int n3 = Integer.parseInt(preferences.getProperty(PROP_GEN_PATH, PROP_WINW, ""));
            int n4 = Integer.parseInt(preferences.getProperty(PROP_GEN_PATH, PROP_WINH, ""));
            if (n3 > 0 && n4 > 0) {
                this.setSize(n3, n4);
            }
            if (n >= 0 && n2 >= 0) {
                this.setLocation(n, n2);
            }
        }
        catch (Exception exception) {
            this.setLocationRelativeTo(component);
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        try {
            this.pane.enteringPage();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        Preferences preferences = Preferences.instance();
        Point point = this.getLocation();
        Dimension dimension = this.getSize();
        preferences.setProperty(PROP_GEN_PATH, PROP_WINX, Integer.toString(point.x));
        preferences.setProperty(PROP_GEN_PATH, PROP_WINY, Integer.toString(point.y));
        preferences.setProperty(PROP_GEN_PATH, PROP_WINH, Integer.toString(dimension.height));
        preferences.setProperty(PROP_GEN_PATH, PROP_WINW, Integer.toString(dimension.width));
        try {
            this.pane.leavingPage();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

