/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.cms.model.CircuitSize;
import cerent.cms.model.FramingType;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.IFramingType;
import cerent.util.AbstractHoNum;
import cerent.util.AbstractLoNum;
import cerent.util.GapSplitter;
import cerent.util.HoLoComparator;
import cerent.util.HoLoNum;
import cerent.util.HoLoRange;
import cerent.util.HoNumCache;
import cerent.util.IHoLoNum;
import cerent.util.IHoLoRange;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.LoNumCache;
import cerent.util.SDebug;
import cerent.util.SdhAu3HoNum;
import cerent.util.SdhAu3LoNum;
import cerent.util.SdhAu4HoNum;
import cerent.util.SdhAu4LoNum;
import cerent.util.SonetHoNum;
import cerent.util.SonetLoNum;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class HoLoFactory {
    static final int NumGroupsInVc3 = 7;
    static HoNumCache[] HoNumCaches_ = new HoNumCache[]{null, null, null};
    static LoNumCache[] LoNumCaches_ = new LoNumCache[]{null, null, null};
    static LoNumCache PreFTGSdhCache_ = null;
    static int MAX_STS = 192;
    static final boolean UseCache = true;
    protected static List EmptyList_ = new ArrayList();
    private static SDebug db = new SDebug("HoLoFactory");

    static HoNumCache _GetHoCache(int n) {
        if (HoNumCaches_[n] == null) {
            HoLoFactory.HoNumCaches_[n] = new HoNumCache(n, MAX_STS);
        }
        return HoNumCaches_[n];
    }

    static HoNumCache _GetSonetHoCache() {
        return HoLoFactory._GetHoCache(0);
    }

    static SonetHoNum LookupSonetHoNum(int n) {
        HoNumCache hoNumCache = HoLoFactory._GetSonetHoCache();
        n = SonetHoNum.GetSonetSts((int)n);
        return (SonetHoNum)hoNumCache.getNumber(n);
    }

    protected static SonetHoNum MakeSonetHoNum(int n, boolean bl) {
        SonetHoNum sonetHoNum = null;
        if (n != 0) {
            if (bl) {
                sonetHoNum = HoLoFactory.LookupSonetHoNum(n);
            }
            if (sonetHoNum == null) {
                sonetHoNum = new SonetHoNum(n);
            }
        }
        return sonetHoNum;
    }

    public static SonetHoNum createSonetHoNum(int n) {
        return HoLoFactory.MakeSonetHoNum(n, true);
    }

    protected static SonetHoNum createSonetHoNum(int n, boolean bl) {
        return HoLoFactory.MakeSonetHoNum(n, bl);
    }

    public static IHoNum ho2HoNum(int n, int n2) {
        SonetHoNum sonetHoNum = null;
        switch (n) {
            case 0: {
                sonetHoNum = HoLoFactory.createSonetHoNum(n2);
                break;
            }
            case 1: {
                sonetHoNum = HoLoFactory.createSdhAu4HoNum(n2);
                break;
            }
            case 2: {
                sonetHoNum = HoLoFactory.createSdhAu3HoNum(n2);
            }
        }
        return sonetHoNum;
    }

    static HoNumCache _GetSdhAu3HoCache() {
        return HoLoFactory._GetHoCache(2);
    }

    static SdhAu3HoNum LookupSdhAu3HoNum(int n) {
        HoNumCache hoNumCache = HoLoFactory._GetSdhAu3HoCache();
        int n2 = SdhAu3HoNum.GetSonetSts((int)n);
        return (SdhAu3HoNum)hoNumCache.getNumber(n2);
    }

    protected static SdhAu3HoNum MakeSdhAu3HoNum(int n, boolean bl) {
        SdhAu3HoNum sdhAu3HoNum = null;
        if (n != 0) {
            if (bl) {
                sdhAu3HoNum = HoLoFactory.LookupSdhAu3HoNum(n);
            }
            if (sdhAu3HoNum == null) {
                sdhAu3HoNum = new SdhAu3HoNum(n);
            }
        }
        return sdhAu3HoNum;
    }

    public static SdhAu3HoNum createSdhAu3HoNum(int n) {
        return HoLoFactory.MakeSdhAu3HoNum(n, true);
    }

    protected static SdhAu3HoNum createSdhAu3HoNum(int n, boolean bl) {
        return HoLoFactory.MakeSdhAu3HoNum(n, bl);
    }

    static HoNumCache _GetSdhAu4HoCache() {
        return HoLoFactory._GetHoCache(1);
    }

    static SdhAu4HoNum LookupSdhAu4HoNum(int n) {
        HoNumCache hoNumCache = HoLoFactory._GetSdhAu4HoCache();
        int n2 = SdhAu4HoNum.GetSonetSts((int)n);
        return (SdhAu4HoNum)hoNumCache.getNumber(n2);
    }

    public static SdhAu4HoNum createSdhAu4HoNum(int n) {
        return HoLoFactory.MakeSdhAu4HoNum(n, true);
    }

    protected static SdhAu4HoNum createSdhAu4HoNum(int n, boolean bl) {
        return HoLoFactory.MakeSdhAu4HoNum(n, bl);
    }

    protected static SdhAu4HoNum MakeSdhAu4HoNum(int n, boolean bl) {
        SdhAu4HoNum sdhAu4HoNum = null;
        if (n != 0) {
            if (bl) {
                sdhAu4HoNum = HoLoFactory.LookupSdhAu4HoNum(n);
            }
            if (sdhAu4HoNum == null) {
                sdhAu4HoNum = new SdhAu4HoNum(n);
            }
        }
        return sdhAu4HoNum;
    }

    static LoNumCache _GetSonetLoCache() {
        if (LoNumCaches_[0] == null) {
            LoNumCache.LoStructure[] loStructureArray = new LoNumCache.LoStructure[2];
            int[] nArray = new int[]{0, 4};
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                int n2 = AbstractLoNum.GetCorrespondingCircuitSize((int)n);
                int n3 = SonetLoNum.NumOfGroups();
                int n4 = SonetLoNum.GroupSize((int)n);
                loStructureArray[i] = new LoNumCache.LoStructure(n2, n, 1, n3, n4);
            }
            HoLoFactory.LoNumCaches_[0] = new LoNumCache(0, loStructureArray, false);
        }
        return LoNumCaches_[0];
    }

    static SonetLoNum LookupSonetLoNum(int n, int n2, int n3) {
        LoNumCache loNumCache = HoLoFactory._GetSonetLoCache();
        return (SonetLoNum)loNumCache.getNumber(1, n, n2, n3);
    }

    protected static SonetLoNum MakeSonetLoNum(int n, int n2, int n3, boolean bl) {
        SonetLoNum sonetLoNum = null;
        if (bl) {
            int n4 = SonetLoNum._GetGroupNum((int)n);
            int n5 = SonetLoNum._GetNumInGroup((int)n2);
            sonetLoNum = HoLoFactory.LookupSonetLoNum(n4, n5, n3);
        }
        if (sonetLoNum == null) {
            ICircuitSize iCircuitSize = CircuitSize.getCircuitSize((int)AbstractLoNum.GetCorrespondingCircuitSize((int)n3));
            sonetLoNum = new SonetLoNum(n, n2, iCircuitSize);
        }
        return sonetLoNum;
    }

    protected static SonetLoNum MakeSonetLoNum(int n, int n2, boolean bl) {
        int n3 = SonetLoNum.GetGroupNum((int)n);
        int n4 = SonetLoNum.GetNumInGroup((int)n);
        return HoLoFactory.MakeSonetLoNum(n3, n4, n2, bl);
    }

    public static SonetLoNum createSonetLoNum(int n) {
        return HoLoFactory.createSonetLoNum((ICircuitSize)CircuitSize.SIZE_VT_1_5, n);
    }

    public static SonetLoNum createSonetLoNum(ICircuitSize iCircuitSize, int n) {
        return HoLoFactory.MakeSonetLoNum(n, AbstractLoNum.GetType((int)iCircuitSize.getEnum()), true);
    }

    public static SonetLoNum createSonetLoNum(int n, int n2) {
        return HoLoFactory.createSonetLoNum((ICircuitSize)CircuitSize.SIZE_VT_1_5, n, n2);
    }

    public static SonetLoNum createSonetLoNum(ICircuitSize iCircuitSize, int n, int n2) {
        return HoLoFactory.createSonetLoNum(iCircuitSize, n, n2, true);
    }

    protected static SonetLoNum createSonetLoNum(ICircuitSize iCircuitSize, int n, int n2, boolean bl) {
        return HoLoFactory.MakeSonetLoNum(n, n2, AbstractLoNum.GetType((int)iCircuitSize.getEnum()), bl);
    }

    static LoNumCache _GetSdhAu3LoCache() {
        if (LoNumCaches_[2] == null) {
            LoNumCache.LoStructure[] loStructureArray = new LoNumCache.LoStructure[2];
            int n = SdhAu3LoNum.LastTug2Group();
            int[] nArray = new int[]{2, 3};
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = nArray[i];
                int n3 = AbstractLoNum.GetCorrespondingCircuitSize((int)n2);
                int n4 = SdhAu3LoNum.GroupSize((int)n2);
                loStructureArray[i] = new LoNumCache.LoStructure(n3, n2, 1, n, n4);
            }
            HoLoFactory.LoNumCaches_[2] = new LoNumCache(2, loStructureArray, false);
        }
        return LoNumCaches_[2];
    }

    static SdhAu3LoNum LookupSdhAu3LoNum(int n, int n2, int n3) {
        LoNumCache loNumCache = HoLoFactory._GetSdhAu3LoCache();
        return (SdhAu3LoNum)loNumCache.getNumber(1, n, n2, n3);
    }

    protected static SdhAu3LoNum MakeSdhAu3LoNum(int n, int n2, int n3, boolean bl) {
        int n4 = SdhAu3LoNum._GetGroupNum((int)n);
        int n5 = SdhAu3LoNum._GetNumInGroup((int)n3, (int)n2, (int)n2);
        SdhAu3LoNum sdhAu3LoNum = null;
        if (bl) {
            sdhAu3LoNum = HoLoFactory.LookupSdhAu3LoNum(n4, n5, n3);
        }
        if (sdhAu3LoNum == null) {
            sdhAu3LoNum = new SdhAu3LoNum(n, n2, n3);
        }
        return sdhAu3LoNum;
    }

    protected static SdhAu3LoNum MakeSdhAu3LoNum(int n, int n2, boolean bl) {
        int n3 = SdhAu3LoNum.GetGroupNum((int)n);
        int n4 = SdhAu3LoNum.GetNumInGroup((int)n);
        return HoLoFactory.MakeSdhAu3LoNum(n3, n4, n2, bl);
    }

    public static SdhAu3LoNum createSdhAu3LoNum(int n, int n2) {
        return HoLoFactory.MakeSdhAu3LoNum(n, n2, true);
    }

    public static SdhAu3LoNum createSdhAu3LoNum(int n, int n2, int n3) {
        return HoLoFactory.createSdhAu3LoNum(n, n2, n3, true);
    }

    protected static SdhAu3LoNum createSdhAu3LoNum(int n, int n2, int n3, boolean bl) {
        switch (n) {
            case 9: {
                return HoLoFactory.MakeSdhAu3LoNum(n2, n3, 2, bl);
            }
            case 10: {
                return HoLoFactory.MakeSdhAu3LoNum(n2, n3, 3, bl);
            }
        }
        throw new IllegalArgumentException("The circuit type is invalid.");
    }

    static LoNumCache _GetSdhAu4LoCache(boolean bl) {
        Object var1_1 = null;
        if (bl) {
            if (PreFTGSdhCache_ == null) {
                PreFTGSdhCache_ = HoLoFactory.createSdhAu4LoCache(true);
            }
            return PreFTGSdhCache_;
        }
        if (LoNumCaches_[1] == null) {
            HoLoFactory.LoNumCaches_[1] = HoLoFactory.createSdhAu4LoCache(false);
        }
        return LoNumCaches_[1];
    }

    private static LoNumCache createSdhAu4LoCache(boolean bl) {
        int n = 3;
        int n2 = SdhAu4LoNum.LastTug2Group();
        int[] nArray = bl ? new int[]{3, 1} : new int[]{2, 3, 1};
        LoNumCache.LoStructure[] loStructureArray = new LoNumCache.LoStructure[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            int n4 = AbstractLoNum.GetCorrespondingCircuitSize((int)n3);
            int n5 = SdhAu4LoNum.GroupSize((int)n3);
            loStructureArray[i] = new LoNumCache.LoStructure(n4, n3, n, n2, n5);
        }
        return new LoNumCache(1, loStructureArray, bl);
    }

    static void _GetSdhAu4LoCache() {
        HoLoFactory._GetSdhAu4LoCache(false);
        HoLoFactory._GetSdhAu4LoCache(true);
    }

    static SdhAu4LoNum LookupSdhAu4LoNum(int n, int n2, int n3, int n4, boolean bl) {
        LoNumCache loNumCache = HoLoFactory._GetSdhAu4LoCache(bl);
        return (SdhAu4LoNum)loNumCache.getNumber(n, n2, n3, n4);
    }

    static SdhAu4LoNum LookupSdhAu4LoNum(int n, int n2, int n3, boolean bl) {
        LoNumCache loNumCache = HoLoFactory._GetSdhAu4LoCache(bl);
        int n4 = AbstractLoNum.group2Vc3((int)n);
        int n5 = AbstractLoNum.group2Tug2InVc3((int)n);
        return (SdhAu4LoNum)loNumCache.getNumber(n4, n5, n2, n3);
    }

    protected static SdhAu4LoNum MakeSdhAu4LoNum(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        SdhAu4LoNum sdhAu4LoNum = null;
        if (n4 == 1) {
            n2 = 1;
        }
        if (bl2) {
            sdhAu4LoNum = HoLoFactory.LookupSdhAu4LoNum(n, n2, n3, n4, bl);
        }
        if (sdhAu4LoNum == null) {
            return SdhAu4LoNum.buildSdhAu4LoNum((int)n, (int)n2, (int)n3, (int)n4);
        }
        return sdhAu4LoNum;
    }

    protected static SdhAu4LoNum MakeSdhAu4LoNum(int n, int n2, boolean bl) {
        int n3 = SdhAu4LoNum.GetGroupNumByType((int)n, (int)n2);
        int n4 = SdhAu4LoNum.GetNumInGroupByType((int)n, (int)n2);
        int n5 = AbstractLoNum.group2Vc3((int)n3);
        int n6 = AbstractLoNum.group2Tug2InVc3((int)n3);
        return HoLoFactory.MakeSdhAu4LoNum(n5, n6, n4, n2, false, bl);
    }

    public static SdhAu4LoNum createSdhAu4LoNum(int n, int n2) {
        return HoLoFactory.MakeSdhAu4LoNum(n, n2, true);
    }

    public static SdhAu4LoNum createSdhAu4LoNum(int n, int n2, int n3, int n4) {
        return HoLoFactory.createSdhAu4LoNum(n, n2, n3, n4, false, true);
    }

    public static SdhAu4LoNum createVc3SdhAu4LoNum(int n) {
        return HoLoFactory.createSdhAu4LoNum(11, n, 1, 0);
    }

    protected static SdhAu4LoNum createSdhAu4LoNum(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = AbstractLoNum.GetType((int)n);
        if (n == 11) {
            n4 = 0;
        } else if (n != 9 && n != 10) {
            throw new IllegalArgumentException("The circuit type is invalid.");
        }
        return HoLoFactory.MakeSdhAu4LoNum(n2, n3, n4, n5, bl, bl2);
    }

    public static ILoNum createVc3LoNum(int n) {
        return HoLoFactory.createVc3LoNum(n, false, true);
    }

    protected static SdhAu4LoNum createVc3LoNum(int n, boolean bl, boolean bl2) {
        return HoLoFactory.MakeSdhAu4LoNum(n, 1, 0, 1, bl, bl2);
    }

    public static IHoLoNum createHoLoNum(IHoNum iHoNum, ILoNum iLoNum) {
        return new HoLoNum(iHoNum, iLoNum);
    }

    public static IHoLoNum createHoLoNum(IHoLoNum iHoLoNum) {
        return iHoLoNum == null ? null : new HoLoNum(iHoLoNum.getHoNum(), iHoLoNum.getLoNum());
    }

    public static IHoLoNum createHoLoNum() {
        return HoLoFactory.createHoLoNum(null, null);
    }

    public static List getAllLoNums(int n, int n2) {
        return HoLoFactory.getAllLoNums(null, n, n2);
    }

    protected static LoNumCache getCache(int n, boolean bl) {
        if (bl) {
            return PreFTGSdhCache_;
        }
        return LoNumCaches_[n];
    }

    public static List getAllLoNums(ILoNum iLoNum, int n, int n2) {
        LoNumCache loNumCache;
        int n3;
        List list = null;
        int n4 = n3 = iLoNum != null ? iLoNum.getFramingType() : n;
        if (iLoNum == null && (loNumCache = HoLoFactory.getCache(n, false)) != null) {
            int n5 = AbstractLoNum.GetType((int)n2);
            return loNumCache.getAllLoNums(n5);
        }
        switch (n3) {
            case 0: {
                list = SonetLoNum.getAllLoNumsByCircuitSize((ILoNum)iLoNum, (int)n2);
                break;
            }
            case 1: {
                list = SdhAu4LoNum.getAllLoNumsByCircuitSize((ILoNum)iLoNum, (int)n2, (Comparator)HoLoComparator.instance());
                break;
            }
            case 2: {
                list = SdhAu3LoNum.getAllLoNumsByCircuitSize((ILoNum)iLoNum, (int)n2);
                break;
            }
            default: {
                list = EmptyList_;
            }
        }
        return list;
    }

    public static IHoNum createFirstHoNum(int n) {
        return HoLoFactory.idlSts2HoNum(n, 1);
    }

    public static ILoNum createFirstLoNum(int n, int n2) {
        return HoLoFactory.idlVtStruct2LoNum(n, n2, 1, 1);
    }

    public static IHoNum idlSts2HoNum(int n, int n2) {
        return HoLoFactory._idlSts2HoNum(n, n2, true);
    }

    static IHoNum _idlSts2HoNum(int n, int n2, boolean bl) {
        switch (n) {
            case 0: {
                return HoLoFactory.createSonetHoNum(n2, bl);
            }
            case 2: {
                return HoLoFactory.createSdhAu3HoNum(n2, bl);
            }
            case 1: {
                return HoLoFactory.createSdhAu4HoNum(AbstractHoNum.StsNum2Vc4((int)n2), bl);
            }
        }
        if (db.on()) {
            db.println("Invalid Framing Type " + n);
        }
        throw new IllegalArgumentException("Unknown framing type ");
    }

    public static ILoNum idlVtStruct2LoNum(int n, int n2, int n3, int n4) {
        return HoLoFactory._idlVtStruct2LoNum(n, false, n2, n3, n4, true);
    }

    static ILoNum _idlVtStruct2LoNum(int n, boolean bl, int n2, int n3, int n4, boolean bl2) {
        if (bl && !bl2) {
            int n5 = AbstractLoNum.GetType((int)n2);
            short s = CircuitSize.getCircuitSize((int)n2).size2widthOfLoCircuit();
            short s2 = HoLoFactory.GetPreFTGSdhFlatNum(n3, n4, s);
            return HoLoFactory.vtOfSdhLoStruct2LoNum(s2, n5, bl2);
        }
        int n6 = 7;
        int n7 = n3 - 1;
        int n8 = 1 + n7 % n6;
        int n9 = 1 + n7 / n6;
        return HoLoFactory._idlVtStruct2LoNum(n, n2, n9, n8, n4, bl2);
    }

    public static ILoNum idlVtStruct2LoNum(int n, int n2, int n3, int n4, int n5) {
        return HoLoFactory._idlVtStruct2LoNum(n, n2, n3, n4, n5, true);
    }

    static ILoNum _idlVtStruct2LoNum(int n, int n2, int n3, int n4, int n5, boolean bl) {
        ICircuitSize iCircuitSize = CircuitSize.getCircuitSize((int)n2);
        if (!iCircuitSize.isLo(n)) {
            throw new IllegalArgumentException("The circuit size is invalid.");
        }
        switch (n) {
            case 0: {
                return HoLoFactory.createSonetLoNum(iCircuitSize, n4, n5, bl);
            }
            case 2: {
                return HoLoFactory.createSdhAu3LoNum(n2, n4, n5, bl);
            }
            case 1: {
                return HoLoFactory.createSdhAu4LoNum(n2, n3, n4, n5, false, bl);
            }
        }
        throw new IllegalArgumentException("The framing type is unknown.");
    }

    static short GetPreFTGSdhFlatNum(int n, int n2, int n3) {
        return VtNumUtil.getVtNum((short)n, (short)n2, n3);
    }

    static boolean IsPreFTGSdhFlatNumValid(short s, int n) {
        int n2 = AbstractLoNum.GetType((int)n);
        boolean bl = n2 == 1;
        boolean bl2 = n2 == 3;
        return SdhLoStructure.IsValid(s, bl, bl2);
    }

    public static ILoNum idlVt2LoNum(int n, int n2, int n3) {
        return HoLoFactory._idlVt2LoNum(n, false, n2, n3, true);
    }

    public static ILoNum preFTGSdhIdlVt2LoNum(int n, int n2, int n3) {
        int n4 = SdhLoStructure.CalcIdlVt(n3);
        return HoLoFactory._idlVt2LoNum(n, false, n2, n4, true);
    }

    static ILoNum _idlVt2LoNum(int n, boolean bl, int n2, int n3, boolean bl2) {
        if (n3 == 0) {
            return null;
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("The flat LO must be greater than zero.");
        }
        ICircuitSize iCircuitSize = CircuitSize.getCircuitSize((int)n2);
        if (!iCircuitSize.isLo(n)) {
            throw new IllegalArgumentException("The circuit size is invalid.");
        }
        int n4 = AbstractLoNum.GetType((int)n2);
        switch (n) {
            case 0: {
                return HoLoFactory.createSonetLoNum(iCircuitSize, n3);
            }
            case 2: {
                return HoLoFactory.createSdhAu3LoNum(n3, n4);
            }
            case 1: {
                if (bl) {
                    return HoLoFactory.preFTGSdhIdlVt2LoNum(n, n2, n3);
                }
                return HoLoFactory.createSdhAu4LoNum(n3, n4);
            }
        }
        throw new IllegalArgumentException("The framing type is unknown.");
    }

    public static int getPreFTGSdhFlatNum(ILoNum iLoNum) {
        int n = 0;
        if (iLoNum != null) {
            int n2 = iLoNum.getCircuitSize();
            n = HoLoFactory.getPreFTGSdhFlatNum(iLoNum, n2);
        }
        return n;
    }

    static int getPreFTGSdhFlatNum(ILoNum iLoNum, int n) {
        short s;
        short s2 = s = iLoNum == null ? (short)0 : iLoNum.getIdlFlatNum();
        if (iLoNum.getFramingType() != 1) {
            throw new IllegalArgumentException("Only SDH AU4 LO numbers produced by Releases 3.30 and 3.40 are allowed.");
        }
        int n2 = SdhLoStructure.CalcCtcVt(s, n);
        return n2;
    }

    public static short getPreFTGSdhGroupNum(ILoNum iLoNum) {
        short s = 0;
        if (iLoNum != null) {
            short s2 = (short)HoLoFactory.getPreFTGSdhFlatNum(iLoNum);
            s = VtNumUtil.getVtGroupNum(s2, false);
        }
        return s;
    }

    public static short getPreFTGSdhNumInGroup(ILoNum iLoNum) {
        short s = 0;
        if (iLoNum != null) {
            short s2 = (short)HoLoFactory.getPreFTGSdhFlatNum(iLoNum);
            s = VtNumUtil.getVtNumInGroup(s2, false);
        }
        return s;
    }

    private static ILoNum sdhLoStruct2LoNum(SdhLoStructure sdhLoStructure, boolean bl) {
        if (sdhLoStructure.isVc3Structure()) {
            return HoLoFactory.MakeSdhAu4LoNum(sdhLoStructure.getVc3(), 0, 0, 1, true, bl);
        }
        return HoLoFactory.MakeSdhAu4LoNum(sdhLoStructure.getVc3(), sdhLoStructure.getTug2(), sdhLoStructure.getVc12(), 3, true, bl);
    }

    private static ILoNum vtOfSdhLoStruct2LoNum(int n, int n2, boolean bl) {
        boolean bl2 = n2 == 1;
        boolean bl3 = n2 == 3;
        return HoLoFactory.sdhLoStruct2LoNum(new SdhLoStructure((short)n, bl2, bl3), bl);
    }

    public static IHoLoNum addOffset(IHoLoNum iHoLoNum, int n) {
        if (iHoLoNum == null) {
            throw new IllegalArgumentException("The HO/LO number cannot be null.");
        }
        if (n == 0) {
            return iHoLoNum;
        }
        int n2 = iHoLoNum.getFramingType();
        IHoLoNum iHoLoNum2 = null;
        switch (n2) {
            case 0: {
                iHoLoNum2 = HoLoFactory.addOffsetSonet(iHoLoNum, n);
                break;
            }
            case 1: {
                iHoLoNum2 = HoLoFactory.addOffsetSdhAu4(iHoLoNum, n, false);
                break;
            }
            case 2: {
                iHoLoNum2 = HoLoFactory.addOffsetSdhAu3(iHoLoNum, n);
            }
        }
        return iHoLoNum2;
    }

    protected static IHoLoNum addOffsetSonet(IHoLoNum iHoLoNum, int n) {
        int n2;
        IHoLoNum iHoLoNum2 = HoLoFactory.createHoLoNum(iHoLoNum);
        SonetLoNum sonetLoNum = (SonetLoNum)iHoLoNum.getLoNum();
        if (sonetLoNum == null) {
            throw new IllegalArgumentException("The LO number cannot be null.");
        }
        int n3 = sonetLoNum.getGroupNum();
        int n4 = sonetLoNum.getNumInGroup();
        int n5 = sonetLoNum.groupSize();
        int n6 = sonetLoNum.numOfGroups();
        int n7 = n;
        int n8 = 0;
        if ((n4 += n7) <= 0 || n4 > n5) {
            n8 += n4 / n5;
            if ((n4 %= n5) <= 0) {
                n4 += n5;
                --n8;
            }
        }
        if ((n3 += n8) <= 0 || n3 > n6) {
            int n9 = n3 % n6;
            IHoNum iHoNum = iHoLoNum.getHoNum();
            if (iHoNum != null) {
                n2 = n3 / n6;
                iHoNum = HoLoFactory.addOffset(iHoNum, n2);
                iHoLoNum2.setHoNum(iHoNum);
                n3 = n9;
            } else if (n3 < 0) {
                throw new ArithmeticException("An underflow occurred.");
            }
            n3 = n9;
            if (n3 <= 0) {
                n3 += n6;
            }
        }
        int n10 = sonetLoNum.getLoPathWidth();
        n2 = CircuitSize.width2sizeOfLoCircuit((int)n10).getEnum();
        ILoNum iLoNum = null;
        try {
            iLoNum = HoLoFactory.idlVtStruct2LoNum(0, n2, n3, n4);
        }
        catch (IllegalStateException illegalStateException) {
            throw new ArithmeticException("An overflow occurred.");
        }
        iHoLoNum2.setLoNum(iLoNum);
        return iHoLoNum2;
    }

    protected static IHoLoNum addOffsetSdhAu4(IHoLoNum iHoLoNum, int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        IHoLoNum iHoLoNum2 = HoLoFactory.createHoLoNum(iHoLoNum);
        SdhAu4LoNum sdhAu4LoNum = (SdhAu4LoNum)iHoLoNum.getLoNum();
        if (sdhAu4LoNum == null) {
            throw new IllegalArgumentException("The LO number cannot be null.");
        }
        int n5 = sdhAu4LoNum.getType();
        int n6 = sdhAu4LoNum.getVc3();
        int n7 = sdhAu4LoNum.getTug2();
        int n8 = sdhAu4LoNum.getVc12() != 0 ? sdhAu4LoNum.getVc12() : sdhAu4LoNum.getVc11();
        int n9 = n5 == 3 ? 3 : 4;
        int n10 = n5 == 1 ? 0 : n % n9;
        int n11 = n4 = n5 == 1 ? 0 : n / n9;
        if (n5 != 1 && ((n8 += n10) <= 0 || n8 > n9)) {
            n4 += n8 / n9;
            if ((n8 %= n9) <= 0) {
                n8 += n9;
                --n4;
            }
        }
        int n12 = n3 = n5 == 1 ? n : 0;
        if (n5 != 1 && ((n7 += n4) <= 0 || n7 > 7)) {
            n3 += n7 / 7;
            if ((n7 %= 7) <= 0) {
                n7 += 7;
                --n3;
            }
        }
        if ((n6 += n3) <= 0 || n6 > 3) {
            n2 = 0;
            int n13 = n6 % 3;
            IHoNum iHoNum = iHoLoNum.getHoNum();
            if (iHoNum != null) {
                n2 = n6 / 3;
            } else {
                if (n6 <= 0) {
                    throw new ArithmeticException("An underflow occurred.");
                }
                if (n6 > 3) {
                    throw new ArithmeticException("An overflow occurred.");
                }
            }
            n6 = n13;
            if (n6 <= 0) {
                n6 += 3;
                --n2;
            }
            iHoNum = HoLoFactory.addOffset(iHoNum, n2);
            iHoLoNum2.setHoNum(iHoNum);
        }
        n2 = sdhAu4LoNum.getLoPathWidth();
        int n14 = CircuitSize.width2sizeOfLoCircuit((int)n2).getEnum();
        SdhAu4LoNum sdhAu4LoNum2 = null;
        try {
            sdhAu4LoNum2 = HoLoFactory.createSdhAu4LoNum(n14, n6, n7, n8, bl, true);
        }
        catch (IllegalStateException illegalStateException) {
            throw new ArithmeticException("An overflow occurred.");
        }
        iHoLoNum2.setLoNum((ILoNum)sdhAu4LoNum2);
        return iHoLoNum2;
    }

    protected static IHoLoNum addOffsetSdhAu3(IHoLoNum iHoLoNum, int n) {
        int n2;
        IHoLoNum iHoLoNum2 = HoLoFactory.createHoLoNum(iHoLoNum);
        SdhAu3LoNum sdhAu3LoNum = (SdhAu3LoNum)iHoLoNum.getLoNum();
        if (sdhAu3LoNum == null) {
            throw new IllegalArgumentException("The LO number cannot be null.");
        }
        int n3 = sdhAu3LoNum.getType();
        int n4 = sdhAu3LoNum.getTug2();
        int n5 = sdhAu3LoNum.getVc12() != 0 ? sdhAu3LoNum.getVc12() : sdhAu3LoNum.getVc11();
        int n6 = n3 == 3 ? 3 : 4;
        int n7 = n3 == 3 || n3 == 2 ? n % n6 : 0;
        int n8 = n / n6;
        if ((n5 += n7) <= 0 || n5 > n6) {
            n8 += n5 / n6;
            if ((n5 %= n6) <= 0) {
                n5 += n6;
                --n8;
            }
        }
        if ((n4 += n8) <= 0 || n4 > 7) {
            n2 = 0;
            int n9 = n4 % 7;
            IHoNum iHoNum = iHoLoNum.getHoNum();
            if (iHoNum != null) {
                n2 = n4 / 7;
            } else {
                if (n4 < 0) {
                    throw new ArithmeticException("An underflow occured.");
                }
                if (n4 > 7) {
                    throw new ArithmeticException("An overflow occurred.");
                }
            }
            n4 = n9;
            if (n4 <= 0) {
                n4 += 7;
                --n2;
            }
            iHoNum = HoLoFactory.addOffset(iHoNum, n2);
            iHoLoNum2.setHoNum(iHoNum);
        }
        n2 = sdhAu3LoNum.getLoPathWidth();
        int n10 = CircuitSize.width2sizeOfLoCircuit((int)n2).getEnum();
        SdhAu3LoNum sdhAu3LoNum2 = null;
        try {
            sdhAu3LoNum2 = HoLoFactory.createSdhAu3LoNum(n10, n4, n5, true);
        }
        catch (IllegalStateException illegalStateException) {
            throw new ArithmeticException("An overflow occurred.");
        }
        iHoLoNum2.setLoNum((ILoNum)sdhAu3LoNum2);
        return iHoLoNum2;
    }

    public static IHoLoNum addNeBasedOffset(IHoLoNum iHoLoNum, int n) {
        if (iHoLoNum == null) {
            throw new IllegalArgumentException("The HO/LO number cannot be null.");
        }
        if (n == 0) {
            return iHoLoNum;
        }
        int n2 = iHoLoNum.getFramingType();
        IHoLoNum iHoLoNum2 = null;
        switch (n2) {
            case 0: {
                iHoLoNum2 = HoLoFactory.addOffsetSonetByGroup(iHoLoNum, n);
                break;
            }
            case 1: {
                iHoLoNum2 = HoLoFactory.addOffsetSdhAu4(iHoLoNum, n, false);
                break;
            }
            case 2: {
                iHoLoNum2 = HoLoFactory.addOffsetSdhAu3(iHoLoNum, n);
            }
        }
        return iHoLoNum2;
    }

    protected static IHoLoNum addOffsetSonetByGroup(IHoLoNum iHoLoNum, int n) {
        int n2;
        IHoLoNum iHoLoNum2 = HoLoFactory.createHoLoNum(iHoLoNum);
        SonetLoNum sonetLoNum = (SonetLoNum)iHoLoNum.getLoNum();
        if (sonetLoNum == null) {
            throw new IllegalArgumentException("The LO number cannot be null.");
        }
        int n3 = sonetLoNum.getGroupNum();
        int n4 = sonetLoNum.getNumInGroup();
        int n5 = sonetLoNum.groupSize();
        int n6 = sonetLoNum.numOfGroups();
        int n7 = n;
        int n8 = 0;
        if ((n3 += n7) <= 0 || n3 > n6) {
            n8 += n3 / n6;
            if ((n3 %= n6) <= 0) {
                n3 += n6;
                --n8;
            }
        }
        if ((n4 += n8) <= 0 || n4 > n5) {
            n2 = 0;
            int n9 = n4 % n5;
            IHoNum iHoNum = iHoLoNum.getHoNum();
            if (iHoNum != null) {
                n2 = n4 / n5;
                n4 = n9;
            } else if (n4 < 0) {
                throw new ArithmeticException("An underflow occurred.");
            }
            n4 = n9;
            if (n4 <= 0) {
                n4 += n5;
                --n2;
            }
            iHoNum = HoLoFactory.addOffset(iHoNum, n2);
            iHoLoNum2.setHoNum(iHoNum);
        }
        n2 = sonetLoNum.getLoPathWidth();
        int n10 = CircuitSize.width2sizeOfLoCircuit((int)n2).getEnum();
        ILoNum iLoNum = null;
        try {
            iLoNum = HoLoFactory.idlVtStruct2LoNum(0, n10, n3, n4);
        }
        catch (IllegalStateException illegalStateException) {
            throw new ArithmeticException("An overflow occurred.");
        }
        iHoLoNum2.setLoNum(iLoNum);
        return iHoLoNum2;
    }

    public static IHoNum addOffset(IHoNum iHoNum, int n) {
        int n2 = iHoNum.getFramingType();
        IFramingType iFramingType = FramingType.getFramingType((int)n2);
        return HoLoFactory.addStsOffset(iHoNum, n *= iFramingType.getMinimumHoPathWidth());
    }

    public static IHoNum addOffset(IHoNum iHoNum, ICircuitSize iCircuitSize) {
        return HoLoFactory.addStsOffset(iHoNum, iCircuitSize.size2widthOfHoCircuit());
    }

    public static IHoNum addOffset(IHoNum iHoNum, IHoNum iHoNum2) {
        if (iHoNum == null) {
            return iHoNum2;
        }
        if (iHoNum2 == null) {
            return iHoNum;
        }
        if (iHoNum.getFramingType() != iHoNum2.getFramingType()) {
            throw new IllegalArgumentException("The HO framing types must be the same.");
        }
        int n = iHoNum2.getIdlHoNum() - 1;
        return HoLoFactory.addStsOffset(iHoNum, n);
    }

    public static IHoNum subtractOffset(IHoNum iHoNum, ICircuitSize iCircuitSize) {
        try {
            return HoLoFactory.addStsOffset(iHoNum, -iCircuitSize.size2widthOfHoCircuit());
        }
        catch (Exception exception) {
            return HoLoFactory.idlSts2HoNum(iHoNum.getFramingType(), 1);
        }
    }

    public static IHoNum removeOffset(IHoNum iHoNum, IHoNum iHoNum2) {
        if (iHoNum == null || iHoNum2 == null) {
            return iHoNum;
        }
        if (iHoNum.getFramingType() != iHoNum2.getFramingType()) {
            throw new IllegalArgumentException("The HO framing types must be the same.");
        }
        int n = iHoNum2.getIdlHoNum() - 1;
        return HoLoFactory.addStsOffset(iHoNum, -n);
    }

    public static IHoNum addHoNums(IHoNum iHoNum, IHoNum iHoNum2) {
        if (iHoNum == null) {
            return iHoNum2;
        }
        if (iHoNum2 == null) {
            return iHoNum;
        }
        if (iHoNum.getFramingType() != iHoNum2.getFramingType()) {
            throw new IllegalArgumentException("The HO framing types must be the same.");
        }
        int n = iHoNum.getHoNum() + iHoNum2.getHoNum();
        return HoLoFactory.ho2HoNum(iHoNum.getFramingType(), n);
    }

    private static IHoNum addStsOffset(IHoNum iHoNum, int n) {
        if (n == 0) {
            return iHoNum;
        }
        int n2 = iHoNum.getFramingType();
        int n3 = iHoNum.getIdlHoNum();
        if ((n3 += n) <= 0) {
            throw new ArithmeticException("An underflow occurred.");
        }
        IHoNum iHoNum2 = null;
        try {
            iHoNum2 = HoLoFactory.idlSts2HoNum(n2, n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ArithmeticException("An underflow occurred.");
        }
        return iHoNum2;
    }

    protected static int numOfGroups(int n, int n2) {
        int n3 = 0;
        switch (n) {
            case 0: {
                n3 = SonetLoNum.NumOfGroups();
                break;
            }
            case 1: {
                n3 = SdhAu4LoNum.NumOfGroups((int)n2);
                break;
            }
            case 2: {
                n3 = SdhAu3LoNum.NumOfGroups();
            }
        }
        return n3;
    }

    private static IHoLoNum _addGroupOffset(IHoLoNum iHoLoNum, int n, boolean bl) {
        int n2;
        IHoLoNum iHoLoNum2 = !bl ? HoLoFactory.createHoLoNum(iHoLoNum) : iHoLoNum;
        ILoNum iLoNum = iHoLoNum.getLoNum();
        if (iLoNum == null) {
            throw new IllegalArgumentException("The LO number cannot be null.");
        }
        if (n == 0) {
            return iHoLoNum2;
        }
        AbstractLoNum abstractLoNum = (AbstractLoNum)iLoNum;
        n *= abstractLoNum.getGroupIncrementSize();
        int n3 = iLoNum.getFramingType();
        int n4 = iLoNum.getLoPathWidth();
        int n5 = CircuitSize.width2sizeOfLoCircuit((int)n4).getEnum();
        int n6 = HoLoFactory.maxNumInGroup(n4);
        int n7 = abstractLoNum.numOfGroupsInVc3();
        int n8 = 7 * n6;
        int n9 = n2 = n / n8;
        short s = iLoNum.getIdlGroupNum();
        int n10 = HoLoFactory.vc3Pos(s);
        int n11 = s + (n -= n2 * n8) % n7;
        short s2 = iLoNum.getIdlNumInGroup();
        int n12 = s2 == 0 ? 0 : s2 + n / n7;
        int n13 = HoLoFactory.vc3Pos(n11);
        int n14 = abstractLoNum.numOfGroups();
        if (n12 > 0) {
            if (n10 < n13) {
                n11 -= 7;
                ++n12;
            } else if (n10 > n13) {
                n11 += 7;
                --n12;
            }
        }
        if (n12 > n6) {
            n12 -= n6;
            ++n9;
        } else if (n12 <= 0) {
            n12 += n6;
            --n9;
        }
        try {
            iLoNum = HoLoFactory.idlVtStruct2LoNum(n3, n5, n11, n12);
            iHoLoNum2.setLoNum(iLoNum);
        }
        catch (IllegalStateException illegalStateException) {
            throw new ArithmeticException("An overflow occurred.");
        }
        if (n9 != 0) {
            HoLoFactory.addVc3Offset(iHoLoNum2, n9);
        }
        return iHoLoNum2;
    }

    public static IHoLoNum addGroupOffset(IHoLoNum iHoLoNum, int n) {
        return HoLoFactory._addGroupOffset(iHoLoNum, n, false);
    }

    public static void increaseGroupOffset(IHoLoNum iHoLoNum, int n) {
        HoLoFactory._addGroupOffset(iHoLoNum, n, true);
    }

    protected static int vc3Pos(int n) {
        int n2;
        int n3;
        int n4 = n3 = n > 0 ? 1 : 0;
        if (n < 0) {
            n2 = -1 + n / 7;
            n -= n2 * 7;
            n3 -= n2;
        }
        n2 = n3 + (n - 1) / 7;
        return n2;
    }

    public static ILoNum addGroupOffset(ILoNum iLoNum, int n) {
        HoLoNum hoLoNum = new HoLoNum(null, iLoNum);
        HoLoFactory.increaseGroupOffset(hoLoNum, n);
        return hoLoNum.getLoNum();
    }

    private static void addVc3Offset(IHoLoNum iHoLoNum, int n) {
        ILoNum iLoNum = iHoLoNum.getLoNum();
        if (iLoNum == null) {
            throw new IllegalArgumentException("The LO number cannot be null.");
        }
        if (n == 0) {
            return;
        }
        int n2 = iLoNum.getFramingType();
        int n3 = iLoNum.getLoPathWidth();
        int n4 = CircuitSize.width2sizeOfLoCircuit((int)n3).getEnum();
        short s = iLoNum.getIdlNumInGroup();
        int n5 = 0;
        int n6 = iLoNum.getIdlGroupNum() + n * 7;
        int n7 = ((AbstractLoNum)iLoNum)._numOfGroups();
        while (true) {
            if (n6 > n7) {
                n6 -= n7;
                ++n5;
                continue;
            }
            if (n6 > 0) break;
            n6 += n7;
            --n5;
        }
        if (n5 != 0) {
            IHoNum iHoNum;
            IHoNum iHoNum2 = iHoNum = iHoLoNum == null ? null : iHoLoNum.getHoNum();
            if (iHoNum != null) {
                iHoNum = HoLoFactory.addOffset(iHoNum, n5);
                if (iHoLoNum != null) {
                    iHoLoNum.setHoNum(iHoNum);
                }
            } else if (n5 != 0) {
                throw new ArithmeticException(n5 < 0 ? "An underflow occurred." : "An overflow occurred.");
            }
        }
        try {
            iLoNum = HoLoFactory.idlVtStruct2LoNum(n2, n4, n6, s);
            iHoLoNum.setLoNum(iLoNum);
        }
        catch (IllegalStateException illegalStateException) {
            throw new ArithmeticException("An overflow occurred.");
        }
    }

    static ILoNum createLastLoNum(int n, int n2) {
        return HoLoFactory.createLastLoNum(n, false, n2);
    }

    static ILoNum createLastLoNum(int n, boolean bl, int n2) {
        int n3 = AbstractLoNum.GetType((int)n2);
        int n4 = 0;
        int n5 = 0;
        switch (n) {
            case 0: {
                n5 = SonetLoNum.NumOfGroups();
                n4 = SonetLoNum.GroupSize((int)n3);
                break;
            }
            case 2: {
                n5 = SdhAu3LoNum.NumOfGroups();
                n4 = SdhAu3LoNum.GroupSize((int)n3);
                break;
            }
            case 1: {
                n5 = SdhAu4LoNum.NumOfGroups((int)n3);
                n4 = SdhAu4LoNum.GroupSize((int)n3);
            }
        }
        return HoLoFactory.idlVtStruct2LoNum(n, n2, n5, n4);
    }

    protected static ILoNum createLastVc3LoNum(ILoNum iLoNum) {
        if (iLoNum == null) {
            throw new IllegalArgumentException("The LO number cannot be null.");
        }
        AbstractLoNum abstractLoNum = (AbstractLoNum)iLoNum;
        int n = iLoNum.getFramingType();
        int n2 = iLoNum.getLoPathWidth();
        int n3 = CircuitSize.width2sizeOfLoCircuit((int)n2).getEnum();
        int n4 = AbstractLoNum.GetType((int)n3);
        int n5 = iLoNum.getIdlGroupNum();
        int n6 = HoLoFactory.vc3Pos(n5);
        int n7 = abstractLoNum.groupSize();
        int n8 = abstractLoNum.lastTug2Group();
        n5 = (n6 - 1) * 7 + n8;
        ILoNum iLoNum2 = HoLoFactory.idlVtStruct2LoNum(n, n3, n5, n7);
        return iLoNum2;
    }

    public static List splitGap(ILoNum iLoNum, ILoNum iLoNum2, Comparator comparator) {
        AbstractLoNum abstractLoNum = (AbstractLoNum)iLoNum;
        AbstractLoNum abstractLoNum2 = (AbstractLoNum)iLoNum2;
        if (abstractLoNum == null || abstractLoNum2 == null) {
            throw new IllegalArgumentException("The low and high values must not be null.");
        }
        if (abstractLoNum.getType() != abstractLoNum2.getType()) {
            throw new IllegalArgumentException("The low and high values must be of the same type.");
        }
        ArrayList<IHoLoRange> arrayList = new ArrayList<IHoLoRange>();
        AbstractLoNum abstractLoNum3 = abstractLoNum;
        while (comparator.compare(abstractLoNum3, abstractLoNum2) <= 0) {
            ILoNum iLoNum3 = HoLoFactory.createLastVc3LoNum((ILoNum)abstractLoNum3);
            if (comparator.compare(iLoNum3, abstractLoNum2) > 0) {
                iLoNum3 = abstractLoNum2;
            }
            IHoLoRange iHoLoRange = HoLoFactory.createRange((ILoNum)abstractLoNum3, iLoNum3);
            arrayList.add(iHoLoRange);
            abstractLoNum3 = HoLoFactory.addGroupOffset(iLoNum3, 1);
        }
        return arrayList;
    }

    public static List splitGap(IHoLoRange iHoLoRange, Comparator comparator) {
        ILoNum iLoNum = iHoLoRange.getFirst().getLoNum();
        ILoNum iLoNum2 = iHoLoRange.getFirst().getLoNum();
        return HoLoFactory.splitGap(iLoNum, iLoNum2, comparator);
    }

    public static ILoNum adjustLoNum(ILoNum iLoNum, int n) {
        ILoNum iLoNum2 = iLoNum.getFramingType() != 1 ? HoLoFactory.addGroupOffset(iLoNum, n) : HoLoFactory.addOffsetSdhAu4(new HoLoNum(null, iLoNum), n, true).getLoNum();
        return iLoNum2;
    }

    static int maxNumInGroup(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 4;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 1;
                break;
            }
            case 6: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 4;
            }
        }
        return n2;
    }

    protected static IHoLoRange createLegalHoLoRange(IHoNum iHoNum, IHoNum iHoNum2, Comparator comparator) {
        if (iHoNum == null || iHoNum2 == null || comparator.compare(iHoNum, iHoNum2) > 0) {
            return null;
        }
        return new HoLoRange(iHoNum, iHoNum2);
    }

    protected static IHoNum decrement(IHoNum iHoNum) {
        return HoLoFactory.addOffset(iHoNum, -1);
    }

    protected static IHoNum increment(IHoNum iHoNum) {
        return HoLoFactory.addOffset(iHoNum, 1);
    }

    protected static IHoLoRange createLegalHoLoRange(ILoNum iLoNum, ILoNum iLoNum2, Comparator comparator) {
        if (iLoNum == null || iLoNum2 == null || comparator.compare(iLoNum, iLoNum2) > 0) {
            return null;
        }
        return new HoLoRange(iLoNum, iLoNum2);
    }

    public static IHoLoRange createRange(IHoLoNum iHoLoNum, IHoLoNum iHoLoNum2) {
        return new HoLoRange(iHoLoNum, iHoLoNum2);
    }

    public static IHoLoRange createRange(IHoLoRange iHoLoRange) {
        return iHoLoRange == null ? null : new HoLoRange(iHoLoRange.getFirst(), iHoLoRange.getLast());
    }

    public static IHoLoRange createRange(ILoNum iLoNum, ILoNum iLoNum2) {
        return new HoLoRange(new HoLoNum(null, iLoNum), new HoLoNum(null, iLoNum2));
    }

    public static IHoLoRange createGap(IHoNum iHoNum, IHoNum iHoNum2, Comparator comparator) {
        try {
            int n;
            if (iHoNum == null && iHoNum2 == null) {
                return null;
            }
            if (!AbstractHoNum.areSameType((IHoNum)iHoNum, (IHoNum)iHoNum2)) {
                throw new IllegalArgumentException("The left-hand side and right-hand side values must be of the same type.");
            }
            int n2 = n = iHoNum != null ? iHoNum.getFramingType() : iHoNum2.getFramingType();
            if (comparator.compare(iHoNum, iHoNum2) >= 0) {
                return null;
            }
            if (iHoNum == null) {
                return HoLoFactory.createLegalHoLoRange(HoLoFactory.createFirstHoNum(n), HoLoFactory.decrement(iHoNum2), comparator);
            }
            if (iHoNum2 == null) {
                return null;
            }
            return HoLoFactory.createLegalHoLoRange(HoLoFactory.increment(iHoNum), HoLoFactory.decrement(iHoNum2), comparator);
        }
        catch (ArithmeticException arithmeticException) {
            return null;
        }
    }

    public static List createGaps(ILoNum iLoNum, ILoNum iLoNum2, Comparator comparator) {
        ArrayList arrayList;
        block6: {
            arrayList = new ArrayList();
            try {
                ILoNum iLoNum3;
                if (iLoNum == null && iLoNum2 == null) {
                    return arrayList;
                }
                ILoNum iLoNum4 = iLoNum != null ? iLoNum : iLoNum2;
                int n = iLoNum4.getFramingType();
                int n2 = CircuitSize.width2sizeOfLoCircuit((int)iLoNum4.getLoPathWidth()).getEnum();
                ILoNum iLoNum5 = iLoNum == null ? HoLoFactory.createFirstLoNum(n, n2) : HoLoFactory.adjustLoNum(iLoNum, 1);
                ILoNum iLoNum6 = iLoNum3 = iLoNum2 == null ? HoLoFactory.createLastLoNum(n, false, n2) : HoLoFactory.adjustLoNum(iLoNum2, -1);
                if (iLoNum5.getFramingType() == 1) {
                    ILoNum[] iLoNumArray = HoLoFactory.adjustSdhAu4IntervalNums((SdhAu4LoNum)iLoNum5, (SdhAu4LoNum)iLoNum3);
                    iLoNum5 = iLoNumArray[0];
                    iLoNum3 = iLoNumArray[1];
                }
                if (db.on()) {
                    db.fine("lhs=" + (iLoNum == null ? null : iLoNum.prettyString()));
                    db.fine("rhs=" + (iLoNum2 == null ? null : iLoNum2.prettyString()));
                    db.fine("startNum=" + iLoNum5.prettyString());
                    db.fine("endNum=" + iLoNum3.prettyString());
                }
                if (comparator.compare(iLoNum5, iLoNum3) <= 0) {
                    HoLoFactory.splitGaps(arrayList, iLoNum5, iLoNum3, comparator);
                }
            }
            catch (ArithmeticException arithmeticException) {
                if (!db.on()) break block6;
                SDebug.printStackTrace((Throwable)arithmeticException);
            }
        }
        return arrayList;
    }

    private static ILoNum[] adjustSdhAu4IntervalNums(SdhAu4LoNum sdhAu4LoNum, SdhAu4LoNum sdhAu4LoNum2) {
        if (sdhAu4LoNum.getVc3() == sdhAu4LoNum2.getVc3() && !sdhAu4LoNum.isVc3Num() && sdhAu4LoNum2.isVc3Num()) {
            sdhAu4LoNum2 = HoLoFactory.createSdhAu4LoNum(sdhAu4LoNum.getCorrespondingCircuitSize(), sdhAu4LoNum2.getVc3(), 7, sdhAu4LoNum.getMaxVc11_12NumInTug2());
        }
        return new ILoNum[]{sdhAu4LoNum, sdhAu4LoNum2};
    }

    private static void splitGaps(List list, ILoNum iLoNum, ILoNum iLoNum2, Comparator comparator) {
        if (iLoNum.getFramingType() != 1) {
            list.add(HoLoFactory.createLegalHoLoRange(iLoNum, iLoNum2, comparator));
        } else {
            HoLoFactory.splitSdhAu4Gaps(list, (SdhAu4LoNum)iLoNum, (SdhAu4LoNum)iLoNum2, comparator);
        }
    }

    private static SdhAu4LoNum[] validateIntervalNums(SdhAu4LoNum sdhAu4LoNum, SdhAu4LoNum sdhAu4LoNum2) {
        if (db.on()) {
            db.fine(sdhAu4LoNum.isFirstElementInVc3() + " " + sdhAu4LoNum2.isLastElementInVc3());
        }
        if (sdhAu4LoNum.isFirstElementInVc3() && sdhAu4LoNum2.isLastElementInVc3()) {
            if (!sdhAu4LoNum.isVc3Num()) {
                sdhAu4LoNum = HoLoFactory.createVc3SdhAu4LoNum(sdhAu4LoNum.getVc3());
            }
            if (!sdhAu4LoNum2.isVc3Num()) {
                sdhAu4LoNum2 = HoLoFactory.createVc3SdhAu4LoNum(sdhAu4LoNum2.getVc3());
            }
        } else if (sdhAu4LoNum.isFirstElementInVc3()) {
            if (sdhAu4LoNum.getVc3() != sdhAu4LoNum2.getVc3()) {
                if (!sdhAu4LoNum.isVc3Num()) {
                    sdhAu4LoNum = HoLoFactory.createVc3SdhAu4LoNum(sdhAu4LoNum.getVc3());
                }
            } else if (sdhAu4LoNum.getType() != sdhAu4LoNum2.getType()) {
                sdhAu4LoNum = HoLoFactory.createSdhAu4LoNum(sdhAu4LoNum2.getCorrespondingCircuitSize(), sdhAu4LoNum.getVc3(), 1, 1);
            }
        } else if (sdhAu4LoNum2.isLastElementInVc3()) {
            if (sdhAu4LoNum.getVc3() != sdhAu4LoNum2.getVc3()) {
                if (!sdhAu4LoNum2.isVc3Num()) {
                    sdhAu4LoNum2 = HoLoFactory.createVc3SdhAu4LoNum(sdhAu4LoNum2.getVc3());
                }
            } else if (sdhAu4LoNum.getType() != sdhAu4LoNum2.getType()) {
                sdhAu4LoNum2 = HoLoFactory.createSdhAu4LoNum(sdhAu4LoNum.getCorrespondingCircuitSize(), sdhAu4LoNum2.getVc3(), 7, sdhAu4LoNum.getMaxVc11_12NumInTug2());
            }
        }
        return new SdhAu4LoNum[]{sdhAu4LoNum, sdhAu4LoNum2};
    }

    private static void splitSdhAu4Gaps(List list, SdhAu4LoNum sdhAu4LoNum, SdhAu4LoNum sdhAu4LoNum2, Comparator comparator) {
        if (db.on()) {
            db.fine("startNum1=" + sdhAu4LoNum.prettyString());
            db.fine("endNum1=" + sdhAu4LoNum2.prettyString());
        }
        SdhAu4LoNum[] sdhAu4LoNumArray = HoLoFactory.validateIntervalNums(sdhAu4LoNum, sdhAu4LoNum2);
        sdhAu4LoNum = sdhAu4LoNumArray[0];
        sdhAu4LoNum2 = sdhAu4LoNumArray[1];
        if (db.on()) {
            db.fine("startNum2=" + sdhAu4LoNum.prettyString());
            db.fine("endNum2=" + sdhAu4LoNum2.prettyString() + "\n");
        }
        if (sdhAu4LoNum.getType() != sdhAu4LoNum2.getType()) {
            if (sdhAu4LoNum.getVc3() == sdhAu4LoNum2.getVc3()) {
                throw new IllegalArgumentException("The start and end numbers have the same VC3.");
            }
            int n = sdhAu4LoNum.getVc3();
            int n2 = sdhAu4LoNum2.getVc3();
            if (!sdhAu4LoNum.isVc3Num()) {
                ++n;
                HoLoFactory.splitSdhAu4Gaps(list, sdhAu4LoNum, HoLoFactory.createSdhAu4LoNum(sdhAu4LoNum.getCorrespondingCircuitSize(), sdhAu4LoNum.getVc3(), 7, sdhAu4LoNum.getMaxVc11_12NumInTug2()), comparator);
            }
            if (!sdhAu4LoNum2.isVc3Num()) {
                --n2;
                HoLoFactory.splitSdhAu4Gaps(list, HoLoFactory.createSdhAu4LoNum(sdhAu4LoNum2.getCorrespondingCircuitSize(), sdhAu4LoNum2.getVc3(), 1, 1), sdhAu4LoNum2, comparator);
            }
            if (n <= n2) {
                HoLoFactory.splitSdhAu4Gaps(list, HoLoFactory.createVc3SdhAu4LoNum(n), HoLoFactory.createVc3SdhAu4LoNum(n2), comparator);
            }
        } else {
            switch (sdhAu4LoNum.getType()) {
                case 1: {
                    list.add(HoLoFactory.createLegalHoLoRange((ILoNum)sdhAu4LoNum, (ILoNum)sdhAu4LoNum2, comparator));
                    break;
                }
                case 2: 
                case 3: {
                    int[] nArray = new int[]{sdhAu4LoNum.getVc3(), sdhAu4LoNum.getTug2(), sdhAu4LoNum.getVc11_12()};
                    int[] nArray2 = new int[]{sdhAu4LoNum2.getVc3(), sdhAu4LoNum2.getTug2(), sdhAu4LoNum2.getVc11_12()};
                    int[] nArray3 = new int[]{3, 7, sdhAu4LoNum.getMaxVc11_12NumInTug2()};
                    List list2 = GapSplitter.splitGap(nArray, nArray2, nArray3);
                    int n = sdhAu4LoNum.getCorrespondingCircuitSize();
                    for (List list3 : list2) {
                        int[] nArray4 = (int[])list3.get(0);
                        int[] nArray5 = (int[])list3.get(1);
                        list.add(HoLoFactory.createLegalHoLoRange((ILoNum)HoLoFactory.createSdhAu4LoNum(n, nArray4[0], nArray4[1], nArray4[2]), (ILoNum)HoLoFactory.createSdhAu4LoNum(n, nArray5[0], nArray5[1], nArray5[2]), comparator));
                    }
                    break;
                }
            }
        }
    }

    protected static IHoLoRange createFullSonetLoGap(int n) {
        int n2 = AbstractLoNum.GetType((int)n);
        int n3 = SonetLoNum.NumOfGroups();
        int n4 = SonetLoNum.GroupSize((int)n2);
        int n5 = 0;
        ILoNum iLoNum = HoLoFactory.createFirstLoNum(0, n);
        ILoNum iLoNum2 = HoLoFactory.idlVtStruct2LoNum(n5, n, n3, n4);
        return new HoLoRange(iLoNum, iLoNum2);
    }

    protected static IHoLoRange createFullSdhAu3LoGap(int n) {
        int n2 = AbstractLoNum.GetType((int)n);
        int n3 = SdhAu3LoNum.NumOfGroups();
        int n4 = SdhAu3LoNum.GroupSize((int)n2);
        int n5 = 2;
        ILoNum iLoNum = HoLoFactory.createFirstLoNum(n5, n);
        ILoNum iLoNum2 = HoLoFactory.idlVtStruct2LoNum(n5, n, n3, n4);
        return new HoLoRange(iLoNum, iLoNum2);
    }

    protected static IHoLoRange createFullSdhAu4LoGap(boolean bl, int n) {
        return HoLoFactory.createFullSdhAu4LoGap(n);
    }

    protected static IHoLoRange createFullSdhAu4LoGap(int n) {
        int n2 = AbstractLoNum.GetType((int)n);
        int n3 = SdhAu4LoNum.NumOfGroups((int)n2);
        int n4 = SdhAu4LoNum.GroupSize((int)n2);
        int n5 = 1;
        ILoNum iLoNum = HoLoFactory.createFirstLoNum(n5, n);
        ILoNum iLoNum2 = HoLoFactory.idlVtStruct2LoNum(n5, n, n3, n4);
        return new HoLoRange(iLoNum, iLoNum2);
    }

    public static IHoLoRange createFullLoGap(int n, int n2) {
        switch (n) {
            case 0: {
                return HoLoFactory.createFullSonetLoGap(n2);
            }
            case 2: {
                return HoLoFactory.createFullSdhAu3LoGap(n2);
            }
            case 1: {
                return HoLoFactory.createFullSdhAu4LoGap(false, n2);
            }
        }
        throw new IllegalArgumentException("The framing type is unknown.");
    }

    private HoLoFactory() {
    }

    static {
        HoLoFactory._GetSonetHoCache();
        HoLoFactory._GetSdhAu3HoCache();
        HoLoFactory._GetSdhAu4HoCache();
        HoLoFactory._GetSonetLoCache();
        HoLoFactory._GetSdhAu3LoCache();
        HoLoFactory._GetSdhAu4LoCache();
    }

    static class SdhLoStructure {
        public static final short VC12_IN_TUG2 = 3;
        public static final short TUG2_IN_VC3 = 7;
        public static final short VC3_IN_VC4 = 3;
        public static final short NUM_OF_TUG2_GROUPS = 21;
        private static final short BASE1 = 4;
        private static final short BASE2 = 8;
        private static final short BASE3 = 4;
        public static final short MIN_VALID_VT = SdhLoStructure.struct2Vt((short)1, (short)0, (short)0);
        public static final short MAX_VALID_VT = SdhLoStructure.struct2Vt((short)3, (short)7, (short)3);
        public static final short MIN_VT_4_VC3_STRUCTURE = MIN_VALID_VT;
        public static final short MAX_VT_4_VC3_STRUCTURE = SdhLoStructure.struct2Vt((short)3, (short)0, (short)0);
        public static final short MIN_VT_4_VC12_STRUCTURE = SdhLoStructure.struct2Vt((short)1, (short)1, (short)1);
        public static final short MAX_VT_4_VC12_STRUCTURE = MAX_VALID_VT;
        private short vc3 = 0;
        private short tug2 = 0;
        private short vc12 = 0;

        public SdhLoStructure(Integer n, Integer n2, Integer n3, boolean bl, boolean bl2) {
            this(n.shortValue(), n2 == null ? (short)0 : n2.shortValue(), n3 == null ? (short)0 : n3.shortValue(), bl, bl2);
        }

        public SdhLoStructure(short s, boolean bl, boolean bl2) {
            this(SdhLoStructure.getVc3FromVt(s), SdhLoStructure.getTug2FromVt(s), SdhLoStructure.getVc12FromVt(s), bl, bl2);
        }

        public SdhLoStructure(short s) {
            this(s, true, true);
        }

        public SdhLoStructure(short s, short s2, short s3, boolean bl, boolean bl2) {
            this.vc3 = s;
            this.tug2 = s2;
            this.vc12 = s3;
            if (!this.isValid(bl, bl2)) {
                throw new IllegalArgumentException("This is not a legal SDH LO structure: VC3=" + s + ", TUG2=" + s2 + ", VC12=" + s3);
            }
        }

        public SdhLoStructure(short s, short s2, short s3) {
            this(s, s2, s3, true, true);
        }

        public static short getVc3FromVt(short s) {
            return (short)(s / 32);
        }

        public static short getTug2FromVt(short s) {
            return (short)(s % 32 / 4);
        }

        public static short getVc12FromVt(short s) {
            return (short)(s % 4);
        }

        public static short struct2Vt(short s, short s2, short s3) {
            if (!SdhLoStructure.isValid(s, s2, s3)) {
                throw new IllegalArgumentException("This is not a valid SDH LO structure.");
            }
            return (short)(s3 + s2 * 4 + s * 32);
        }

        public short toVt() {
            return SdhLoStructure.struct2Vt(this.vc3, this.tug2, this.vc12);
        }

        public static boolean isValid(short s, short s2, short s3) {
            return SdhLoStructure.isValid(s, s2, s3, true, true);
        }

        public static boolean isValid(short s, short s2, short s3, boolean bl, boolean bl2) {
            boolean bl3 = false;
            if (1 <= s && s <= 3) {
                if (s2 == 0) {
                    if (bl) {
                        bl3 = s3 == 0;
                    }
                } else {
                    bl3 = bl2 && s2 >= 1 && s2 <= 7 && s3 >= 1 && s3 <= 3;
                }
            }
            return bl3;
        }

        static boolean IsValid(short s, boolean bl, boolean bl2) {
            return SdhLoStructure.isValid(SdhLoStructure.getVc3FromVt(s), SdhLoStructure.getTug2FromVt(s), SdhLoStructure.getVc12FromVt(s), bl, bl2);
        }

        public boolean isValid(boolean bl, boolean bl2) {
            return SdhLoStructure.isValid(this.vc3, this.tug2, this.vc12, bl, bl2);
        }

        public static boolean isValidVt(short s) {
            return SdhLoStructure.isValid(SdhLoStructure.getVc3FromVt(s), SdhLoStructure.getTug2FromVt(s), SdhLoStructure.getVc12FromVt(s));
        }

        public static boolean isValidVc3(short s) {
            return SdhLoStructure.isValidVt(s) && SdhLoStructure.getTug2FromVt(s) == 0;
        }

        public static boolean isValidVc12(short s) {
            return SdhLoStructure.isValidVt(s) && SdhLoStructure.getTug2FromVt(s) != 0;
        }

        public String toString() {
            return this.prettyString('=', ',');
        }

        public String prettyString(char c, char c2) {
            if (this.isVc3Structure()) {
                return "vc3" + c + this.vc3;
            }
            return "tug3" + c + this.vc3 + c2 + "tug2" + c + this.tug2 + c2 + "vc12" + c + this.vc12;
        }

        public short getVc3() {
            return this.vc3;
        }

        public short getTug2() {
            return this.tug2;
        }

        public short getVc12() {
            return this.vc12;
        }

        public static boolean isVc3Structure(short s) {
            if (!SdhLoStructure.isValidVt(s)) {
                throw new IllegalArgumentException("This is not a valid VT.");
            }
            return SdhLoStructure.getTug2FromVt(s) == 0;
        }

        public boolean isVc3Structure() {
            return this.tug2 == 0;
        }

        public static boolean isVc12Structure(short s) {
            if (!SdhLoStructure.isValidVt(s)) {
                throw new IllegalArgumentException("This is not a valid VT.");
            }
            return SdhLoStructure.getTug2FromVt(s) != 0;
        }

        public boolean isVc12Structure() {
            return this.tug2 != 0;
        }

        public static short getClosestValidVc12(short s, char c) {
            if (SdhLoStructure.isValidVt(s) && SdhLoStructure.isVc12Structure(s)) {
                return s;
            }
            if (c == '+') {
                return SdhLoStructure.getNextValidVc12(s);
            }
            return SdhLoStructure.getPreviousValidVc12(s);
        }

        public static short getNextValidVc12(short s) {
            for (short s2 = (short)(s + 1); s2 <= MAX_VT_4_VC12_STRUCTURE; s2 = (short)(s2 + 1)) {
                if (!SdhLoStructure.isValidVt(s2) || !SdhLoStructure.isVc12Structure(s2)) continue;
                return s2;
            }
            throw new IllegalArgumentException("A valid VC12 cannot be found.");
        }

        public static short getPreviousValidVc12(short s) {
            for (short s2 = (short)(s - 1); s2 >= MIN_VT_4_VC12_STRUCTURE; s2 = (short)(s2 - 1)) {
                if (!SdhLoStructure.isValidVt(s2) || !SdhLoStructure.isVc12Structure(s2)) continue;
                return s2;
            }
            throw new IllegalArgumentException("A valid VC12 cannot be found.");
        }

        public static boolean isFirstVc12InVc3(short s) {
            return SdhLoStructure.isValidVt(s) && SdhLoStructure.getTug2FromVt(s) == 1 && SdhLoStructure.getVc12FromVt(s) == 1;
        }

        public static boolean isLastVc12InVc3(short s) {
            return SdhLoStructure.isValidVt(s) && SdhLoStructure.getTug2FromVt(s) == 7 && SdhLoStructure.getVc12FromVt(s) == 3;
        }

        static int CalcIdlVt(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("This is an invalid VT value: " + n + ".");
            }
            if (n == 0) {
                return 0;
            }
            SdhLoStructure sdhLoStructure = new SdhLoStructure((short)n);
            short s = sdhLoStructure.getVc3();
            short s2 = sdhLoStructure.getTug2();
            short s3 = sdhLoStructure.getVc12();
            int n2 = (s - 1) * 7 + (sdhLoStructure.isVc3Structure() ? (short)1 : s2);
            short s4 = sdhLoStructure.isVc3Structure() ? (short)1 : s3;
            return n2 + (s4 - 1) * 21;
        }

        static int CalcCtcVt(int n, int n2) {
            if (n < 0) {
                throw new IllegalArgumentException("This is an invalid VT value: " + n + ".");
            }
            if (n == 0) {
                return 0;
            }
            int n3 = (n - 1) % 21 + 1;
            int n4 = (n - 1) / 21 + 1;
            boolean bl = n2 == 11;
            int n5 = (n3 - 1) / 7 + 1;
            int n6 = bl ? 0 : (n3 - 1) % 7 + 1;
            int n7 = bl ? 0 : n4;
            return SdhLoStructure.struct2Vt((short)n5, (short)n6, (short)n7);
        }
    }

    static class VtNumUtil {
        VtNumUtil() {
        }

        public static short getVtGroupNum(short s) {
            return VtNumUtil.getVtGroupNum(s, false);
        }

        public static short getVtGroupNum(short s, boolean bl) {
            if (s == 0) {
                return 0;
            }
            return bl ? VtNumUtil.getSonetVtGroupNum(s) : VtNumUtil.getSdhVtGroupNum(s);
        }

        public static short getSonetVtGroupNum(short s) {
            return (short)((s - 1) % 7 + 1);
        }

        public static short getSdhVtGroupNum(short s) {
            SdhLoStructure sdhLoStructure = new SdhLoStructure(s);
            if (sdhLoStructure.isVc3Structure()) {
                return (short)(7 * (sdhLoStructure.getVc3() - 1) + 1);
            }
            return (short)(7 * (sdhLoStructure.getVc3() - 1) + sdhLoStructure.getTug2());
        }

        public static short getVtNumInGroup(short s) {
            return VtNumUtil.getVtNumInGroup(s, false);
        }

        public static short getVtNumInGroup(short s, boolean bl) {
            if (s == 0) {
                return 0;
            }
            return bl ? VtNumUtil.getSonetVtNumInGroup(s) : VtNumUtil.getSdhVtNumInGroup(s);
        }

        public static short getSonetVtNumInGroup(short s) {
            return (short)((s - 1) / 7 + 1);
        }

        public static short getSdhVtNumInGroup(short s) {
            return SdhLoStructure.getVc12FromVt(s);
        }

        public static short getVtNum(short s, short s2, short s3) {
            return VtNumUtil.getSdhVtNum(s, s2, s3);
        }

        public static short getSonetVtNum(short s, short s2) {
            return (short)((s2 - 1) * 7 + s);
        }

        public static short getSdhVtNum(short s, short s2, short s3) {
            return VtNumUtil.getVtNum(s, s2, s3);
        }

        public static short getVtNum(short s, short s2, int n) {
            short s3;
            if (n == 0) {
                return VtNumUtil.getSonetVtNum(s, s2);
            }
            short s4 = (short)((s - 1) / 7 + 1);
            if (n == 7) {
                s3 = 0;
                s2 = 0;
            } else {
                s3 = (short)(s - 7 * (s4 - 1));
            }
            return SdhLoStructure.struct2Vt(s4, s3, s2);
        }
    }
}

