/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.ColorUtil;
import cerent.util.gui.AbstractPropertyEditor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.colorchooser.AbstractColorChooserPanel;

public class ColorPropertyEditor
extends AbstractPropertyEditor
implements ActionListener {
    JButton colorButton = new JButton("");
    Color selectedColor = Color.blue;
    JColorChooser chooser = new JColorChooser();

    public ColorPropertyEditor(String string, Color color) {
        this.colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractColorChooserPanel[] abstractColorChooserPanelArray = new AbstractColorChooserPanel[]{ColorPropertyEditor.this.chooser.getChooserPanels()[0]};
                ColorPropertyEditor.this.chooser.setChooserPanels(abstractColorChooserPanelArray);
                ColorPropertyEditor.this.chooser.setColor(ColorPropertyEditor.this.selectedColor);
                JDialog jDialog = JColorChooser.createDialog(ColorPropertyEditor.this.getTopLevelAncestor(), "Pick a Color", true, ColorPropertyEditor.this.chooser, ColorPropertyEditor.this, ColorPropertyEditor.this);
                jDialog.show();
                if (ColorPropertyEditor.this.selectedColor != null) {
                    ColorPropertyEditor.this.colorButton.setBackground(ColorPropertyEditor.this.selectedColor);
                    ColorPropertyEditor.this.setDirty(true);
                }
            }
        });
        this.colorButton.setPreferredSize(new Dimension(20, 20));
        this.colorButton.setBorder(BorderFactory.createLineBorder(Color.black));
        this.colorButton.setBackground(color);
        if (string.length() > 0) {
            this.add(new JLabel(string));
        }
        this.add(this.colorButton);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        String string = jButton.getText();
        if (string.equals("OK")) {
            this.selectedColor = this.chooser.getColor();
        }
    }

    @Override
    public Object getValue() {
        return ColorUtil.getRGBString(this.selectedColor);
    }

    @Override
    public void setValue(Object object) {
        this.selectedColor = ColorUtil.getColor((String)object, Color.blue);
        this.colorButton.setBackground(this.selectedColor);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.colorButton.setEnabled(bl);
    }
}

