/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.gui.AbstractPropertyEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class IntegerPropertyEditor
extends AbstractPropertyEditor
implements DocumentListener {
    private JTextField txtInput = new JTextField(10);
    private boolean fromSetValue = false;
    private String lastSetValue;
    private IntegerDocument doc = new IntegerDocument();
    int minValue = Integer.MIN_VALUE;
    int maxValue = Integer.MAX_VALUE;
    protected JLabel prefixLabel;
    protected JLabel suffixLabel;

    public IntegerPropertyEditor(String string) {
        this.init(string, "");
    }

    public IntegerPropertyEditor(String string, String string2) {
        this.init(string, string2);
    }

    private void init(String string, String string2) {
        this.doc.addDocumentListener(this);
        this.txtInput.setDocument(this.doc);
        this.setLayout(new BorderLayout());
        if (string != null && string.length() > 0) {
            this.prefixLabel = new JLabel(string);
            this.add((Component)this.prefixLabel, "West");
        }
        this.add((Component)this.txtInput, "Center");
        if (string2 != null && string2.length() > 0) {
            this.suffixLabel = new JLabel(string2);
            this.add((Component)this.suffixLabel, "East");
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    private void setDirty() {
        if (!this.fromSetValue) {
            this.setDirty(true);
        }
        this.fromSetValue = false;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int n) {
        this.minValue = n;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int n) {
        this.maxValue = n;
    }

    public void setEditorSize(int n) {
        if (n > 0) {
            this.txtInput.setColumns(n);
        }
    }

    @Override
    public Object getValue() {
        return this.txtInput.getText();
    }

    @Override
    public void setValue(Object object) {
        if (object != null) {
            String string;
            this.fromSetValue = true;
            this.lastSetValue = string = (String)object;
            this.txtInput.setText(string);
            this.fromSetValue = false;
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.txtInput.setEnabled(bl);
    }

    public JTextField getTxtInput() {
        return this.txtInput;
    }

    public String getLastSetValue() {
        return this.lastSetValue;
    }

    public void setEditorPreferredSize(int n, int n2) {
        this.txtInput.setPreferredSize(new Dimension(n, n2));
    }

    public void setLabelPreferredSize(int n, int n2) {
        this.prefixLabel.setPreferredSize(new Dimension(n, n2));
    }

    public void setSuffixLabelPreferredSize(int n, int n2) {
        this.suffixLabel.setPreferredSize(new Dimension(n, n2));
    }

    class IntegerDocument
    extends PlainDocument {
        IntegerDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string != null && string.length() > 0) {
                try {
                    int n2 = Integer.parseInt(string);
                    if (n2 < IntegerPropertyEditor.this.minValue || n2 > IntegerPropertyEditor.this.maxValue) {
                        throw new Exception();
                    }
                }
                catch (Exception exception) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
            }
            super.insertString(n, string, attributeSet);
        }
    }
}

