/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.gui.AbstractPropertyEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.InvalidParameterException;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;

public class StringChoicePropertyEditor
extends AbstractPropertyEditor {
    protected JComboBox cbxInput;
    protected JLabel inputLabel;
    protected Object[] values;
    protected boolean wasSet;
    protected boolean fromSetValue;

    public StringChoicePropertyEditor(String string) {
        this.init(string, new Object[0]);
    }

    public StringChoicePropertyEditor(String string, Object[] objectArray) {
        this.init(string, objectArray);
    }

    public StringChoicePropertyEditor(String string, List list) {
        this.init(string, list.toArray());
    }

    private void init(String string, Object[] objectArray) {
        this.values = objectArray;
        this.cbxInput = new JComboBox<Object>(objectArray);
        this.setLayout(new BorderLayout());
        if (string.length() > 0) {
            this.inputLabel = new JLabel(string);
            this.add((Component)this.inputLabel, "West");
        }
        this.add((Component)this.cbxInput, "Center");
        this.cbxInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                if (jComboBox.isEnabled()) {
                    if (!StringChoicePropertyEditor.this.fromSetValue) {
                        StringChoicePropertyEditor.this.setDirty(true);
                    }
                    StringChoicePropertyEditor.this.fromSetValue = false;
                }
            }
        });
    }

    @Override
    public void requestEditorFocus() {
        this.cbxInput.requestFocus();
    }

    private void setDirty() {
        if (!this.fromSetValue) {
            this.setDirty(true);
        }
        this.fromSetValue = false;
    }

    public void setEditorSize(int n) {
        if (n > 0) {
            this.cbxInput.setSize(n, this.cbxInput.getSize().height);
        }
    }

    public void setEditorPreferredSize(int n, int n2) {
        this.cbxInput.setPreferredSize(new Dimension(n, n2));
    }

    public void setEditorRenderer(ListCellRenderer listCellRenderer) {
        this.cbxInput.setRenderer(listCellRenderer);
    }

    public void setLabelPreferredSize(int n, int n2) {
        this.inputLabel.setPreferredSize(new Dimension(n, n2));
    }

    @Override
    public Object getValue() {
        return this.cbxInput.getSelectedItem();
    }

    @Override
    public void setValue(Object object) {
        this.fromSetValue = true;
        boolean bl = false;
        if (object == null) {
            this.setEmptyValue();
            bl = true;
        }
        if (!bl) {
            for (int i = 0; i < this.values.length; ++i) {
                if (!this.values[i].equals(object)) continue;
                bl = true;
                this.cbxInput.setSelectedIndex(i);
                break;
            }
        }
        if (!bl) {
            throw new InvalidParameterException("The value " + object + " could not be mapped to any" + " existing choices. Please supply a valid value.");
        }
        this.fromSetValue = false;
    }

    public void setEmptyValue() {
        this.cbxInput.setSelectedItem(null);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.cbxInput.setEnabled(bl);
    }

    public int getNumberOfChoices() {
        return this.cbxInput.getItemCount();
    }

    public void removeChoice(Object object) {
        this.cbxInput.removeItem(object);
        Object[] objectArray = new Object[this.values.length - 1];
        int n = 0;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i].equals(object)) continue;
            objectArray[n] = this.values[i];
            ++n;
        }
        this.values = objectArray;
    }

    public void insertChoiceAt(Object object, int n) {
        this.cbxInput.insertItemAt(object, n);
        Object[] objectArray = new Object[this.values.length + 1];
        int n2 = 0;
        for (int i = 0; i < this.values.length; ++i) {
            if (n2 == n) {
                objectArray[n2] = object;
                ++n2;
            }
            objectArray[n2] = this.values[i];
            ++n2;
        }
        this.values = objectArray;
    }

    public boolean containsChoice(Object object) {
        if (this.values == null || object == null) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.values[i].equals(object)) continue;
            return true;
        }
        return false;
    }
}

