/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.cms.model.VlanList;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.gui.AbstractPropertyEditor;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class VlanListPropertyEditor
extends AbstractPropertyEditor
implements ActionListener,
FocusListener {
    public static final String VLAN_LIST_PROP_NAME = "vanlist";
    public static final String SVLAN_LABEL_TXT = "Set of SVLANs: ";
    public static final int SVLAN_FIELD_LENGTH = 20;
    public static final String CVLAN_LABEL_TXT = "Set of CVLANs: ";
    public static final int CVLAN_FIELD_LENGTH = 20;
    private JLabel lbl;
    private JTextField tf;
    private VlanList vlanList;
    private boolean notifyOnFocusLost = false;
    private boolean isSVLAN = false;

    public VlanListPropertyEditor(String string, int n, boolean bl) {
        this(string, bl ? 20 : 20, false, bl);
    }

    public VlanListPropertyEditor(String string, int n, boolean bl, boolean bl2) {
        this.isSVLAN = bl2;
        this.setLayout(new FlowLayout(0));
        this.lbl = new JLabel(string);
        this.add(this.lbl);
        this.tf = new JTextField(n);
        this.add(this.tf);
        this.tf.addActionListener(this);
        this.tf.addFocusListener(this);
        this.notifyOnFocusLost = bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this._handleTextChange();
    }

    private void _handleTextChange() {
        String string = this.tf.getText();
        VlanList vlanList = this.vlanList;
        try {
            this.vlanList = new VlanList(string, this.isSVLAN ? VlanList.VLANListType.SVLAN : VlanList.VLANListType.CVLAN);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorMsg.displayError((Component)SwingUtilities.getWindowAncestor(this), (EID)(this.isSVLAN ? CEMC.EID_SVLAN_OUT_OF_RANGE : CEMC.EID_CVLAN_OUT_OF_RANGE));
            this.tf.requestFocus();
        }
        this.firePropertyChange(VLAN_LIST_PROP_NAME, vlanList, this.vlanList);
    }

    public String getText() {
        return this.tf.getText();
    }

    public void setText(String string) {
        this.tf.setText(string);
        this._handleTextChange();
    }

    public VlanList getVlanList() {
        return this.vlanList;
    }

    @Override
    public String toString() {
        return "VlanListPropertyEditor list of cvlans: " + (this.vlanList == null ? "-" : this.vlanList.toString());
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.notifyOnFocusLost) {
            this._handleTextChange();
        }
    }
}

