/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.stats;

import cerent.util.ComparisonUtil;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.stats.StatsBin;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;

public class StatsColumnRenderer
extends AbstractColumnRenderer {
    public static final int ID = 0;
    public static final int CV = 1;
    public static final int COUNT = 2;
    public static final int SUM = 3;
    public static final int AVE = 4;
    public static final int MIN = 5;
    public static final int MAX = 6;
    private static final int COLUMN_NO = 7;
    public static final String ID_NAME = "Name";
    public static final String CV_NAME = "CV";
    public static final String COUNT_NAME = "Count";
    public static final String AVE_NAME = "Avg(ms)";
    public static final String SUM_NAME = "Total(ms)";
    public static final String MIN_NAME = "Min(ms)";
    public static final String MAX_NAME = "Max(ms)";
    private DefaultTableCellRenderer tcr = new DefaultTableCellRenderer();
    private int mode;
    private static final EmptyBorder emptyBorder = new EmptyBorder(0, 2, 0, 2);

    public StatsColumnRenderer(int n, String string, int n2, boolean bl, int n3) {
        super(string, n2, bl, n3);
        this.mode = n;
        this.tcr.setBorder(emptyBorder);
        this.tcr.setHorizontalAlignment(n3);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        String string = "";
        StatsBin statsBin = (StatsBin)object;
        switch (this.mode) {
            case 0: {
                string = statsBin.name;
                break;
            }
            case 1: {
                if (!statsBin.cv) break;
                string = "C";
                break;
            }
            case 2: {
                string = Long.toString(statsBin.count);
                break;
            }
            case 4: {
                string = Long.toString(statsBin.getAve());
                break;
            }
            case 3: {
                if (statsBin.count <= 0L) break;
                string = Long.toString(statsBin.sum);
                break;
            }
            case 5: {
                if (statsBin.count <= 0L) break;
                string = Long.toString(statsBin.min);
                break;
            }
            case 6: {
                if (statsBin.count <= 0L) break;
                string = Long.toString(statsBin.max);
                break;
            }
            default: {
                string = "???";
            }
        }
        return this.tcr.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
    }

    static ColumnRenderer[] createTableRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[7];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = StatsColumnRenderer.createColumnRenderer(i);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createColumnRenderer(int n) {
        String string;
        int n2 = 60;
        boolean bl = false;
        int n3 = 4;
        switch (n) {
            case 0: {
                string = ID_NAME;
                n2 = 300;
                n3 = 2;
                bl = true;
                break;
            }
            case 1: {
                string = CV_NAME;
                n2 = 30;
                n3 = 0;
                break;
            }
            case 2: {
                string = COUNT_NAME;
                break;
            }
            case 4: {
                string = AVE_NAME;
                break;
            }
            case 3: {
                string = SUM_NAME;
                n2 = 80;
                break;
            }
            case 5: {
                string = MIN_NAME;
                break;
            }
            case 6: {
                string = MAX_NAME;
                break;
            }
            default: {
                string = "???";
            }
        }
        return new StatsColumnRenderer(n, string, n2, bl, n3);
    }

    @Override
    public int compareColumn(Object object, Object object2, int n) {
        int n2 = 0;
        StatsBin statsBin = (StatsBin)object;
        StatsBin statsBin2 = (StatsBin)object2;
        switch (this.mode) {
            case 0: {
                n2 = statsBin.name.compareTo(statsBin2.name);
                break;
            }
            case 1: {
                n2 = ComparisonUtil.compare((boolean)statsBin.cv, (boolean)statsBin2.cv);
                break;
            }
            case 2: {
                n2 = ComparisonUtil.compare((long)statsBin.count, (long)statsBin2.count);
                break;
            }
            case 4: {
                n2 = ComparisonUtil.compare((long)statsBin.getAve(), (long)statsBin2.getAve());
                break;
            }
            case 3: {
                n2 = ComparisonUtil.compare((long)statsBin.sum, (long)statsBin2.sum);
                break;
            }
            case 5: {
                n2 = ComparisonUtil.compare((long)statsBin.min, (long)statsBin2.min);
                break;
            }
            case 6: {
                n2 = ComparisonUtil.compare((long)statsBin.max, (long)statsBin2.max);
                break;
            }
        }
        return n2;
    }
}

