/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.ui;

import cerent.cms.loader.ElementFactoryFinder;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NodeModel;
import cerent.cms.topo.Network;
import cerent.util.BuildInfo;
import cerent.util.gui.UScrollPane;
import cerent.version.NetInterfaceVersion;
import com.cisco.ctc.ui.CUESSplashWindow;
import com.cisco.ctc.ui.LicenseDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;

public class AboutDialog
extends JDialog
implements ActionListener {
    private static final String PROD_NAME = "Cisco Transport Controller";
    private static final int GAP = 10;
    private static AboutDialog _instance;
    private static JLabel lblMemUsage;
    private Timer timer = new Timer(2000, new TimerListener());
    private static NumberFormat nf;
    private JPanel aboutPanel;
    private JPanel buttonPanel;
    private JPanel buildPanel = new JPanel(new BorderLayout());
    private UScrollPane scrollPane;
    private LicenseDialog ld;

    public static AboutDialog instance(JFrame jFrame, String string) {
        if (_instance == null) {
            _instance = new AboutDialog(jFrame, string);
        }
        return _instance;
    }

    private AboutDialog(JFrame jFrame, String string) {
        super(jFrame, string, true);
        this.buildPanel.setBackground(Color.white);
        this.buildPanel.setPreferredSize(new Dimension(350, 100));
        this.aboutPanel = new JPanel(new BorderLayout());
        this.aboutPanel.setBackground(Color.white);
        this.aboutPanel.add((Component)((Object)new LocalCUESSplashWindow("Initializing CTC", PROD_NAME, BuildInfo.getShortVersionString(), this.getCopyright())), "North");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.buildPanel, "North");
        jPanel.add((Component)this.getJvmPanel(), "South");
        jPanel.setBackground(Color.white);
        this.aboutPanel.add((Component)jPanel, "South");
        nf.setMaximumFractionDigits(1);
        this.updateMemoryUsage();
        this.timer.start();
        this.buttonPanel = new JPanel();
        JButton jButton = new JButton("Show Licenses");
        jButton.addActionListener(this);
        jButton.setActionCommand("License");
        this.buttonPanel.add(jButton);
        JButton jButton2 = new JButton("Close");
        jButton2.addActionListener(this);
        jButton2.setActionCommand("Close");
        this.buttonPanel.add(jButton2);
        this.buttonPanel.setBackground(Color.white);
        JPanel jPanel2 = (JPanel)this.getContentPane();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.setLayout(new BorderLayout(10, 10));
        jPanel2.setBackground(Color.white);
        jPanel2.add((Component)this.aboutPanel, "Center");
        jPanel2.add((Component)this.buttonPanel, "South");
        this.pack();
        this.setLocationRelativeTo(jFrame);
        this.setResizable(false);
    }

    private String getCopyright() {
        NetInterfaceVersion netInterfaceVersion = new NetInterfaceVersion();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(netInterfaceVersion.getBuildInformation().getDate());
        return "2000-" + calendar.get(1);
    }

    private JPanel getJvmPanel() {
        JPanel jPanel = new JPanel(new GridLayout(2, 0));
        jPanel.setBackground(Color.white);
        jPanel.add(new JLabel("Java Heap Usage (MB): "));
        jPanel.add(lblMemUsage);
        return jPanel;
    }

    private void updateMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.maxMemory();
        long l2 = runtime.totalMemory();
        long l3 = runtime.freeMemory();
        double d = 1048576.0;
        String string = nf.format((double)(l2 - l3) / d) + " used, " + nf.format((double)l3 / d) + " free, " + nf.format((double)l2 / d) + " allocated (maximum=" + nf.format((double)l / d) + ")";
        lblMemUsage.setText(string);
    }

    private void queryNodes() {
        List<Object> list;
        String string;
        INodeModel iNodeModel;
        Object object2;
        JTextArea jTextArea = new JTextArea("Versions:");
        jTextArea.setEditable(false);
        jTextArea.setBackground(Color.white);
        String string2 = BuildInfo.sanitize(BuildInfo.version) + " - " + BuildInfo.date;
        jTextArea.append("\n  CTC Core: " + string2);
        TreeMap<String, ArrayList<INodeModel>> treeMap = new TreeMap<String, ArrayList<INodeModel>>();
        for (Object object2 : Network.instance().getElements()) {
            iNodeModel = object2.getNodeModel();
            if (!iNodeModel.isInited() || !(iNodeModel instanceof NodeModel)) continue;
            string = iNodeModel.getNeType() + " Support: " + ElementFactoryFinder.getElementFactory(iNodeModel).getBuildInfo((INodeModel)((NodeModel)iNodeModel));
            list = (List)treeMap.get(string);
            if (list == null) {
                list = new ArrayList<INodeModel>();
                treeMap.put(string, (ArrayList<INodeModel>)list);
            }
            list.add(iNodeModel);
        }
        object2 = treeMap.keySet();
        iNodeModel = object2.iterator();
        while (iNodeModel.hasNext()) {
            string = (String)iNodeModel.next();
            list = (ArrayList<INodeModel>)treeMap.get(string);
            jTextArea.append("\n  " + string);
            for (INodeModel iNodeModel2 : list) {
                jTextArea.append("\n    - " + iNodeModel2.getName());
            }
        }
        jTextArea.append("\n  JRE version: " + System.getProperty("java.version"));
        if (this.scrollPane != null) {
            this.buildPanel.remove((Component)this.scrollPane);
        }
        this.scrollPane = new UScrollPane((Component)jTextArea);
        this.scrollPane.setBackground(Color.white);
        this.scrollPane.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.buildPanel.add((Component)this.scrollPane, "Center");
    }

    @Override
    public void show() {
        this.queryNodes();
        super.show();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Close")) {
            this.setVisible(false);
        }
        if (actionEvent.getActionCommand().equals("License")) {
            this.ld = LicenseDialog.instance(this, "License Dialog");
            this.ld.pack();
            this.ld.setVisible(true);
        }
    }

    static {
        lblMemUsage = new JLabel();
        nf = NumberFormat.getInstance();
    }

    private class LocalCUESSplashWindow
    extends CUESSplashWindow {
        public LocalCUESSplashWindow(String string, String string2, String string3, String string4) {
            super(string, string2, string3, string4);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setFont(new Font("Arial", 0, 10));
            graphics2D.drawString(this.copyrightYear, 5, this.getBottomBannerArea().y + 17);
        }

        public Dimension getPreferredSize() {
            return new Dimension(360, 260);
        }

        public Dimension getPhotoDimension() {
            return new Dimension(118, 152);
        }

        public Dimension getProductNameDimension() {
            return new Dimension(240, 152);
        }

        public Rectangle getProductNameArea() {
            return new Rectangle(0, 80, 240, 152);
        }

        protected JScrollPane createCopyrightPane(String string) {
            return new JScrollPane();
        }

        protected Border createDefaultBorder() {
            return null;
        }
    }

    class TimerListener
    implements ActionListener,
    Runnable {
        TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            AboutDialog.this.updateMemoryUsage();
        }
    }
}

