/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.ui;

import cerent.cms.model.ProgressEvent;
import cerent.cms.model.ProgressManager;
import cerent.util.BuildInfo;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UDialog;
import cerent.util.gui.UScrollPane;
import com.cisco.ctc.core.ClassLoaderManager;
import com.cisco.ctc.core.IClassLoaderManager;
import com.cisco.ctc.core.INgrp;
import com.cisco.ctc.ui.CUESSplashWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class ProgressDialog
extends UDialog
implements Observer,
Runnable,
ActionListener {
    private static final IClassLoaderManager clm = ClassLoaderManager.instance();
    private static final String PROD_NAME = "Cisco Transport Controller";
    private LocalCUESSplashWindow localWindow = null;
    private JPanel contentPane;
    private JPanel detailsPane;
    private JTextArea detailsArea;
    private JButton bDetails;
    private JProgressBar progressBar;
    private boolean stopProgress = false;
    private boolean detailsOn = false;
    private boolean needToggle = false;
    private LinkedList detailsList = new LinkedList();
    private JDialog warningDialog;
    private JOptionPane warningPane;
    private static final int PREF_WIDTH = 350;
    private static final int PREF_DETAILS_HEIGHT = 150;

    public static ProgressDialog instance(Frame frame, String string) {
        return new ProgressDialog(frame, string);
    }

    private ProgressDialog(Frame frame, String string) {
        super(frame, string, true);
        ProgressManager.instance().addObserver(this);
        this.setResizable(false);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        this.contentPane = jPanel;
        this.contentPane.setBackground(Color.white);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.localWindow = new LocalCUESSplashWindow("Initializing CTC", PROD_NAME, BuildInfo.getShortVersionString(), this.getCopyright());
        this.contentPane.add((Component)((Object)this.localWindow), "North");
        this.contentPane.add((Component)this.createProgressBar(), "Center");
        this.detailsPane = this.createDetailsPane();
        this.contentPane.add((Component)this.detailsPane, "South");
    }

    private JPanel createProgressBar() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBackground(Color.white);
        Font font = new Font("Arial", 0, 12);
        this.progressBar = new JProgressBar(0, 100);
        jPanel.add((Component)this.progressBar, "North");
        this.progressBar.setForeground(Color.decode("#336666"));
        this.progressBar.setBackground(Color.white);
        this.progressBar.setPreferredSize(new Dimension(100, 7));
        JLabel jLabel = new JLabel("Initializing CTC... Please Wait");
        jLabel.setFont(font);
        jLabel.setBackground(Color.white);
        jLabel.setOpaque(true);
        jPanel.add((Component)jLabel, "Center");
        this.bDetails = new JButton("Details >>");
        jPanel.add((Component)this.bDetails, "East");
        this.bDetails.setFont(font);
        this.bDetails.setMargin(new Insets(1, 7, 1, 7));
        this.bDetails.addActionListener(this);
        this.updateDetailsButton();
        return jPanel;
    }

    private JPanel createDetailsPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.detailsArea = new JTextArea("\n");
        this.detailsArea.setEditable(false);
        this.detailsArea.setLineWrap(true);
        this.detailsArea.setTabSize(5);
        jPanel.add((Component)new UScrollPane((Component)this.detailsArea), "Center");
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel.setBackground(Color.white);
        jPanel.setPreferredSize(new Dimension(350, 150));
        jPanel.setVisible(false);
        return jPanel;
    }

    private String getCopyright() {
        INgrp iNgrp = clm.getSystemNgrp();
        Date date = iNgrp.getRebuildDateAsDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return "2000-" + calendar.get(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void append(String string) {
        LinkedList linkedList = this.detailsList;
        synchronized (linkedList) {
            this.detailsList.add(string);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof ProgressManager && object instanceof ProgressEvent) {
            ProgressEvent progressEvent = (ProgressEvent)object;
            int n = this.progressBar.getValue();
            switch (progressEvent.eventCode) {
                case 1: {
                    this.append("\t" + progressEvent.stepDescriptor + "...\n");
                    n += 5;
                    break;
                }
                case 3: {
                    this.append("\t\t" + progressEvent.stepDescriptor + "\n");
                    n += 5;
                    break;
                }
                case 4: {
                    this.append("\n\tALL DONE SUCCESSFULLY\n");
                    n = 100;
                    ProgressManager.instance().deleteObserver(this);
                    if (this.warningDialog == null || !this.warningDialog.isVisible()) break;
                    this.warningDialog.setVisible(false);
                    this.warningDialog.dispose();
                    this.warningDialog = null;
                    break;
                }
                case 5: {
                    this.append("\t ERROR: Failed in " + progressEvent.stepDescriptor + "\n");
                    if (this.warningDialog == null || !this.warningDialog.isVisible()) {
                        this.showWarningDialog("CTC Initialization", "A failure occurred during " + progressEvent.stepDescriptor + ".\nPlease wait.  CTC will try again.");
                        this.stopProgress = true;
                        break;
                    }
                    this.warningPane.setMessage("A failure occurred during " + progressEvent.stepDescriptor + ".\nPlease wait.  CTC will try again.");
                    this.warningDialog.pack();
                    this.warningDialog.setVisible(true);
                    break;
                }
                default: {
                    if (progressEvent.exception == null) break;
                    this.append("\t\tWARNING: " + progressEvent.exception + "\n");
                }
            }
            if (!this.stopProgress) {
                this.progressBar.setValue(n);
            }
        }
    }

    private void showWarningDialog(final String string, final String string2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.warningPane = new JOptionPane(string2, 2, -1, CerentDialog.WARNING_ICON);
                ProgressDialog.this.warningDialog = ProgressDialog.this.warningPane.createDialog((Component)((Object)ProgressDialog.this), string);
                ProgressDialog.this.warningDialog.pack();
                ProgressDialog.this.warningDialog.setModal(false);
                ProgressDialog.this.warningDialog.setVisible(true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl = false;
        LinkedList linkedList = this.detailsList;
        synchronized (linkedList) {
            for (String string : this.detailsList) {
                this.detailsArea.append(string);
                bl = true;
            }
            this.detailsList.clear();
        }
        if (bl) {
            this.detailsArea.paintImmediately(this.detailsArea.getBounds());
            this.contentPane.repaint();
        }
        if (this.needToggle) {
            this.toggleDetails();
        }
    }

    private void toggleDetails() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.detailsOn = !this.detailsOn;
            this.detailsPane.setVisible(this.detailsOn);
            this.updateDetailsButton();
            this.pack();
            this.center();
            this.needToggle = false;
        } else {
            this.needToggle = true;
            SwingUtilities.invokeLater(this);
        }
    }

    private void updateDetailsButton() {
        if (this.detailsOn) {
            this.bDetails.setText("Details <<");
        } else {
            this.bDetails.setText("Details >>");
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isVisible() && actionEvent.getSource() == this.bDetails) {
            this.toggleDetails();
        }
    }

    public void showDetails() {
        if (!this.detailsOn) {
            this.toggleDetails();
        }
    }

    public void setVisible(boolean bl) {
        if (!bl) {
            super.setVisible(false);
            if (this.getParent() != null) {
                this.getParent().requestFocus();
            }
        } else {
            super.setVisible(true);
        }
    }

    public void dispose() {
        if (this.isVisible()) {
            this.setVisible(false);
        }
        super.dispose();
    }

    private class LocalCUESSplashWindow
    extends CUESSplashWindow {
        public LocalCUESSplashWindow(String string, String string2, String string3, String string4) {
            super(string, string2, string3, string4);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setFont(new Font("Arial", 0, 10));
            graphics2D.drawString(this.copyrightYear, 5, this.getBottomBannerArea().y + 17);
        }

        public Dimension getPreferredSize() {
            return new Dimension(370, 270);
        }

        public Dimension getPhotoDimension() {
            return new Dimension(128, 152);
        }

        public Dimension getProductNameDimension() {
            return new Dimension(240, 152);
        }

        public Rectangle getProductNameArea() {
            return new Rectangle(0, 80, 240, 152);
        }

        protected JScrollPane createCopyrightPane(String string) {
            return new JScrollPane();
        }

        protected Border createDefaultBorder() {
            return null;
        }
    }
}

