/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.ui.sot;

import cerent.cms.model.NetworkModel;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.TablePropertyMgr;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import com.cisco.ctc.ui.sot.SoTl1ColumnRenderer;
import com.cisco.ctc.ui.sot.SoTl1DataSource;
import com.cisco.ctc.ui.sot.SoTl1Dialog;
import com.cisco.sot.Tl1Tunnel;
import com.cisco.sot.Tl1TunnelAddr;
import com.cisco.sot.Tl1TunnelAddrBook;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class SoTl1Frame
extends JFrame
implements ActionListener,
ListSelectionListener {
    private static final String TITLE = "TL1 Tunnels";
    private static final String PROP_GEN_PATH = "ctc.sotl1.window";
    private static final String PROP_WINX = "x";
    private static final String PROP_WINY = "y";
    private static final String PROP_WINH = "h";
    private static final String PROP_WINW = "w";
    private static SoTl1Frame _instance;
    private JButton createButton;
    private JButton editButton;
    private JButton deleteButton;
    private JButton connectButton;
    private JButton disconnectButton;
    private JButton closeButton;
    private static SDebug db;
    private SoTl1DataSource dataSource;
    private SortableRowTableModel tableModel;
    private UTable table;
    private static final String TL_TUNNEL_MODIFY_WARNING_TITLE = "Modify Tunnel Profile";

    private SoTl1Frame() {
    }

    private SoTl1Frame(Frame frame) {
        super(TITLE);
        this.init(frame);
        this.setIconImage(frame.getIconImage());
    }

    public static synchronized SoTl1Frame instance(Frame frame) {
        if (_instance == null) {
            _instance = new SoTl1Frame(frame);
        }
        return _instance;
    }

    private void init(Component component) {
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SoTl1Frame.this.dispose();
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        ColumnRenderer[] columnRendererArray = SoTl1ColumnRenderer.createTableRenderers();
        this.dataSource = new SoTl1DataSource();
        this.tableModel = new SortableRowTableModel((RowDataSource)this.dataSource, columnRendererArray);
        this.table = new UTable((TableModel)((Object)this.tableModel));
        this.tableModel.initTable((JTable)this.table);
        jPanel.add((Component)new UScrollPane((Component)this.table));
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(NetCSHelpConst.SotTunnelPane);
        this.createButton = new JButton("Create...");
        this.createButton.addActionListener(this);
        cSHelpButtonPane.addLeft(this.createButton);
        this.editButton = new JButton("Edit...");
        this.editButton.addActionListener(this);
        cSHelpButtonPane.addLeft(this.editButton);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(this);
        cSHelpButtonPane.addLeft(this.deleteButton);
        cSHelpButtonPane.addLeft(Box.createHorizontalStrut(20));
        this.connectButton = new JButton("Open Tunnel");
        this.connectButton.addActionListener(this);
        cSHelpButtonPane.addLeft(this.connectButton);
        this.disconnectButton = new JButton("Close Tunnel");
        this.disconnectButton.addActionListener(this);
        cSHelpButtonPane.addLeft(this.disconnectButton);
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(this);
        cSHelpButtonPane.addRight(this.closeButton);
        jPanel.add((Component)cSHelpButtonPane, "South");
        TablePropertyMgr.getColumnPrefs((JTable)this.table, this.getClass().getName());
        this.getContentPane().add(jPanel);
        this.pack();
        Preferences preferences = Preferences.instance();
        try {
            int n = Integer.parseInt(preferences.getProperty(PROP_GEN_PATH, PROP_WINX, ""));
            int n2 = Integer.parseInt(preferences.getProperty(PROP_GEN_PATH, PROP_WINY, ""));
            int n3 = Integer.parseInt(preferences.getProperty(PROP_GEN_PATH, PROP_WINW, ""));
            int n4 = Integer.parseInt(preferences.getProperty(PROP_GEN_PATH, PROP_WINH, ""));
            if (n3 > 0 && n4 > 0) {
                this.setSize(n3, n4);
            }
            if (n >= 0 && n2 >= 0) {
                this.setLocation(n, n2);
            }
        }
        catch (Exception exception) {
            this.setLocationRelativeTo(component);
        }
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.setSelectionMode(0);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.syncButtons();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = this.table.getSelectedRow();
        SoTl1DataSource.TunnelEntry tunnelEntry = null;
        Tl1TunnelAddr tl1TunnelAddr = null;
        Tl1Tunnel tl1Tunnel = null;
        if (n >= 0) {
            tunnelEntry = (SoTl1DataSource.TunnelEntry)this.table.getValueAt(n, 0);
            tl1TunnelAddr = tunnelEntry.addr;
            tl1Tunnel = tunnelEntry.tunnel;
        }
        Tl1TunnelAddrBook tl1TunnelAddrBook = Tl1TunnelAddrBook.instance();
        try {
            if (object == this.createButton) {
                SoTl1Dialog soTl1Dialog = new SoTl1Dialog(this);
                tl1TunnelAddr = soTl1Dialog.getTl1TunnelAddr(null);
                if (tl1TunnelAddr != null) {
                    if (tl1TunnelAddrBook.tunnelExists(tl1TunnelAddr)) {
                        boolean bl = false;
                        bl = CerentDialog.yesNoWarningDialog((Component)this, (String)ErrorMsg.getString((EID)NEMC.WID_TL1_TUNNEL_MODIFY), (String)TL_TUNNEL_MODIFY_WARNING_TITLE);
                        if (!bl) {
                            return;
                        }
                    }
                    tl1TunnelAddrBook.setMruTunnel(tl1TunnelAddr);
                }
            } else if (object == this.deleteButton) {
                if (CerentDialog.yesNoWarningDialog((Component)this, (String)"This tunnel profile will be permanently removed from your preferences.\nAre you sure you want to delete this tunnel profile?", (String)("Delete Tunnel Profile (" + tl1TunnelAddr.pneTid + ")"))) {
                    tl1TunnelAddrBook.deleteTunnel(tl1TunnelAddr, true);
                }
            } else if (object == this.editButton) {
                SoTl1Dialog soTl1Dialog = new SoTl1Dialog(this);
                Tl1TunnelAddr tl1TunnelAddr2 = soTl1Dialog.getTl1TunnelAddr(tl1TunnelAddr);
                if (tl1TunnelAddr2 != null) {
                    tl1TunnelAddrBook.deleteTunnel(tl1TunnelAddr, false);
                    tl1TunnelAddrBook.setMruTunnel(tl1TunnelAddr2);
                }
            } else if (object == this.connectButton) {
                SoTl1Dialog soTl1Dialog = new SoTl1Dialog(this);
                tl1Tunnel = soTl1Dialog.getTl1Tunnel(tl1TunnelAddr);
                if (tl1Tunnel != null) {
                    this.addNode(tl1Tunnel.getPneIp());
                }
            } else if (object == this.disconnectButton) {
                if (tl1Tunnel != null && CerentDialog.yesNoWarningDialog((Component)this, (String)"Closing a tunnel might cause some nodes to become unreachable.\nAre you sure you want to close this tunnel?", (String)("Closing Tunnel to " + tl1Tunnel.getAddress().pneTid))) {
                    tl1Tunnel.close();
                }
            } else if (object == this.closeButton) {
                this.dispose();
                return;
            }
            this.dataSource.reload();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    private void addNode(InetAddress inetAddress) {
        try {
            NetworkModel.instance().addNetElement(inetAddress.getHostAddress(), null, null);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    @Override
    public void dispose() {
        Preferences preferences = Preferences.instance();
        Point point = this.getLocation();
        Dimension dimension = this.getSize();
        preferences.setProperty(PROP_GEN_PATH, PROP_WINX, Integer.toString(point.x));
        preferences.setProperty(PROP_GEN_PATH, PROP_WINY, Integer.toString(point.y));
        preferences.setProperty(PROP_GEN_PATH, PROP_WINH, Integer.toString(dimension.height));
        preferences.setProperty(PROP_GEN_PATH, PROP_WINW, Integer.toString(dimension.width));
        TablePropertyMgr.setColumnPrefs((JTable)this.table, this.getClass().getName());
        this.setVisible(false);
        super.dispose();
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            if (!this.isVisible()) {
                this.dataSource.reload();
                if (this.table.getModel().getRowCount() > 0) {
                    this.table.getSelectionModel().setSelectionInterval(0, 0);
                }
            }
        } else {
            this.dataSource.unload();
        }
        super.setVisible(bl);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.syncButtons();
    }

    private void syncButtons() {
        int n = this.table.getSelectedRow();
        SoTl1DataSource.TunnelEntry tunnelEntry = null;
        if (n >= 0) {
            boolean bl = this.dataSource.isRowActive(n);
            this.editButton.setEnabled(!bl);
            this.deleteButton.setEnabled(!bl);
            tunnelEntry = (SoTl1DataSource.TunnelEntry)this.table.getValueAt(n, 0);
            String string = Tl1Tunnel.NOTINITED.toString();
            string = tunnelEntry.getState();
            if (string.compareToIgnoreCase(Tl1Tunnel.OPEN.toString()) == 0 || string.compareToIgnoreCase(Tl1Tunnel.OPENING.toString()) == 0) {
                this.disconnectButton.setEnabled(true);
                this.connectButton.setEnabled(false);
            } else {
                this.disconnectButton.setEnabled(false);
                this.connectButton.setEnabled(true);
            }
        } else {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.connectButton.setEnabled(false);
            this.disconnectButton.setEnabled(false);
        }
    }

    static {
        db = new SDebug("SoTl1Dialog");
    }
}

