/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import cerent.util.gui.CerentDialog;
import cerent.util.gui.UPopupMenu;
import com.cisco.ctc.util.map.DomainNameEditDialog;
import com.cisco.ctc.util.map.MapGraph;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.MapToolkit;
import com.cisco.ctc.util.map.Node;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JComponent;

public class MapDomain
extends Node {
    public static final String CMD_OPEN_DOMAIN = "Open Domain";
    public static final String CMD_RENAME_DOMAIN = "Rename Domain...";
    public static final String CMD_REMOVE_DOMAIN = "Remove Domain";
    protected MapGraph childGraph = null;

    public MapDomain(MapToolkit mapToolkit) {
        super(mapToolkit);
    }

    @Override
    public void init(Object object, double d, double d2, Object object2) {
        this.childGraph = new MapGraph(this.mtk, this);
        super.init(object, d, d2, object2);
    }

    public MapGraph getChildGraph() {
        return this.childGraph;
    }

    @Override
    protected void initPopupMenu(UPopupMenu uPopupMenu) {
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_OPEN_DOMAIN, 79);
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_RENAME_DOMAIN, 78);
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_REMOVE_DOMAIN, 82);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == CMD_OPEN_DOMAIN) {
            this.doOpenDomain();
        } else if (string == CMD_RENAME_DOMAIN) {
            new DomainNameEditDialog(this.mtk, this.getName(), 2);
        } else if (string == CMD_REMOVE_DOMAIN && CerentDialog.yesNoDialog((Component)this.mtk.getGraphWindow(), (String)"Do you really want to remove the domain?", (String)"Confirm Remove")) {
            this.doRemoveDomain();
        }
    }

    protected void doOpenDomain() {
        this.mtk.doubleClicked(this);
    }

    protected void doRemoveDomain() {
        this.mtk.deleteDomain(this.getName());
    }

    public MapNode[] getNodes() {
        if (this.childGraph == null) {
            return new MapNode[0];
        }
        ArrayList<MapNode> arrayList = new ArrayList<MapNode>();
        Object[] objectArray = this.childGraph.getComponents();
        for (int i = 0; i < objectArray.length; ++i) {
            MapNode mapNode;
            if (!(objectArray[i] instanceof MapNode) || (mapNode = (MapNode)objectArray[i]).isVirtual()) continue;
            arrayList.add(mapNode);
        }
        return arrayList.toArray(new MapNode[0]);
    }

    public int getChildrenCount() {
        return this.getNodes().length;
    }

    public MapGraph getMapGraph() {
        return (MapGraph)this.getGraph();
    }

    @Override
    public String getToolTipText() {
        int n = this.getNodes().length;
        return this.getName() + ": " + n + " node" + (n > 1 ? "s" : "");
    }

    public void nodeAdded(MapNode mapNode) {
        if (mapNode != null && !mapNode.isVirtual()) {
            this.refreshUI();
        }
    }

    public void nodeRemoved(MapNode mapNode) {
        if (mapNode != null && !mapNode.isVirtual()) {
            this.refreshUI();
        }
    }

    protected void refreshUI() {
    }

    @Override
    public void destroy() {
        if (this.childGraph != null) {
            this.childGraph.cleanUp();
        }
        super.destroy();
    }
}

