/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.alarms;

import cerent.cms.model.ICircuitId;
import cerent.cms.model.INodeModel;
import cerent.cms.model.event.EventInfo;
import cerent.cms.model.event.StoreObservable;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.event.EventPanel;
import cerent.cms.ui.event.IEventPanelController;
import cerent.cms.ui.event.NetworkAlarmPane;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import com.cisco.fv.alarms.FVEventPanel;
import com.cisco.fv.alarms.FvNetworkAlarmStore;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class FVNetworkAlarmPane
extends NetworkAlarmPane {
    private boolean handleNewalarms;
    private SDebug sd;

    public FVNetworkAlarmPane(String string, TabbedView tabbedView, FvNetworkAlarmStore fvNetworkAlarmStore, IEventPanelController iEventPanelController) {
        super(string, tabbedView, fvNetworkAlarmStore, iEventPanelController);
        fvNetworkAlarmStore.getAlarmStore().getStoreObservable().addObserver((Observer)((Object)this));
        this.handleNewalarms = false;
        this.sd = new SDebug("FVNetworkAlarmPane");
    }

    @Override
    protected EventPanel createEventPanel(IEventPanelController iEventPanelController) {
        int n = 31457;
        FVEventPanel fVEventPanel = new FVEventPanel((FvNetworkAlarmStore)this.alarmStore, iEventPanelController, n);
        fVEventPanel.getTable().setName("Network Alarm");
        return fVEventPanel;
    }

    @Override
    protected int[] createDefaultSorting() {
        int n = this.table.getColumn("Sev").getModelIndex();
        int[] nArray = new int[]{n};
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void syncAlarms() {
        try {
            this.setCursor(3);
            this.alarmStore.flushAlarmStore();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_COMMUNICATION_ERROR_PARAM_1, (Object)exception.getMessage());
        }
        finally {
            this.setCursor(0);
        }
    }

    @Override
    public void enteringPage() {
        try {
            super.enteringPage();
            ((FVEventPanel)this.alrPanel).refresh();
            this.handleNewalarms = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void leavingPage() throws Exception {
        super.leavingPage();
        this.handleNewalarms = false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        ((FVEventPanel)this.alrPanel).refresh();
    }

    public boolean circuitAlarm(EventInfo eventInfo) {
        List list;
        this.setContextMenuEventInfo(eventInfo);
        try {
            list = this.getAffectedCircuitIds();
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
        for (Object e : list) {
            if (!(e instanceof ICircuitId)) continue;
            return true;
        }
        return false;
    }

    public boolean circuitAlarm(EventInfo eventInfo, ICircuitId iCircuitId) {
        List list;
        if (this.sd.on()) {
            this.sd.println("examining alarm");
        }
        try {
            list = this.getAffectedCircuitIds(eventInfo);
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
        if (this.sd.on()) {
            this.sd.println("found the specific circuit");
        }
        for (Object e : list) {
            if (!(e instanceof ICircuitId) || !iCircuitId.equals(e)) continue;
            if (this.sd.on()) {
                this.sd.println("     FOUND :)");
            }
            return true;
        }
        if (this.sd.on()) {
            this.sd.println("     NOT FOUND :(");
        }
        return false;
    }

    @Override
    protected void electricalAffectedCircuit(INodeModel iNodeModel, List list) {
    }

    @Override
    protected void opticalAffectedCircuit(INodeModel iNodeModel, List list) {
    }

    @Override
    public synchronized void update(Observable observable, Object object) {
        if (observable instanceof StoreObservable) {
            ((FvNetworkAlarmStore)this.alarmStore).updateReceived();
            ((FVEventPanel)this.alrPanel).refresh();
        }
        super.update(observable, object);
    }

    @Override
    public void destroy() {
        ((FvNetworkAlarmStore)this.alarmStore).getAlarmStore().getStoreObservable().deleteObserver((Observer)((Object)this));
        super.destroy();
    }
}

