/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.circuit;

import cerent.cms.fv.IFvSideModel;
import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchPortsHelper;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.model.circuits.CircuitDataSource;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.topo.INetElement;
import cerent.util.SDebug;
import cerent.util.gui.IFunctionalView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class FVCircuitDataSource
extends CircuitDataSource {
    private DwdmFvCircuitFilter dwdmFv;
    private Observer circuitObserver;

    public FVCircuitDataSource(IModel iModel, IFunctionalView iFunctionalView) {
        super(iModel);
        if (iModel != null) {
            if (Feature.provides((INodeModel)iModel.getNodeModel(), (Feature)Feature.NETWORK_FUNCTIONAL_VIEW)) {
                this.dwdmFv = new DwdmFvCircuitFilter(iFunctionalView.getSide());
            }
        } else {
            this.dwdmFv = new DwdmFvCircuitFilter(iFunctionalView.getSide());
        }
        this.circuitObserver = null;
    }

    @Override
    public synchronized void update(Observable observable, Object object) {
        super.update(observable, object);
        if (this.circuitObserver != null) {
            this.circuitObserver.update(observable, object);
        }
    }

    @Override
    protected Collection getCircuitsWithinScope() {
        Collection collection = super.getCircuitsWithinScope();
        if (this.dwdmFv != null) {
            this.dwdmFv.dwdmClearSide(collection);
        }
        return collection;
    }

    public void addObserverPane(Observer observer) {
        this.circuitObserver = observer;
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
    }

    private class DwdmFvCircuitFilter {
        private IFvSideModel side;

        public DwdmFvCircuitFilter(IFvSideModel iFvSideModel) {
            this.side = iFvSideModel;
        }

        private void dwdmClearSide(Collection collection) {
            if (this.side == null) {
                return;
            }
            ArrayList arrayList = new ArrayList();
            Iterator iterator = collection.iterator();
            INetElement iNetElement = FVCircuitDataSource.this.ncm.getNetwork().getNetElem(FVCircuitDataSource.this.uiModel.getNodeModel().getNodeId());
            while (iterator.hasNext()) {
                INetCircuit iNetCircuit = (INetCircuit)iterator.next();
                INetCircuitNode iNetCircuitNode = null;
                List list = iNetCircuit.getCircuitNodeFromNE(iNetElement);
                if (list != null) {
                    iNetCircuitNode = (INetCircuitNode)list.get(0);
                }
                if (iNetCircuit.getCircuitTypeObj().isOchncType() || iNetCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
                    if (list != null && list.size() > 1 && db.on()) {
                        db.println("Error !! MXPN in OchTrailTunnel OR Ochnc");
                    }
                    arrayList = this.filterOchNC(iNetCircuit, arrayList, iNetCircuitNode.getIngressPoints());
                }
                if (!iNetCircuit.getCircuitTypeObj().isOchccCircuitType()) continue;
                if (list != null && list.size() > 1 && db.on()) {
                    db.println("Error !! MXPN in Ochcc");
                }
                arrayList = this.filteOchCC(iNetCircuit, arrayList, iNetCircuitNode.getEgressPoints(), iNetCircuitNode.getIngressPoints());
            }
            if (arrayList.size() > 0) {
                collection.removeAll(arrayList);
            }
        }

        private ArrayList filteOchCC(INetCircuit iNetCircuit, ArrayList arrayList, List list, List list2) {
            boolean bl = true;
            for (int i = 0; i < list.size(); ++i) {
                try {
                    int n;
                    IEntityModel[] iEntityModelArray;
                    IEntityModel iEntityModel = ((NetCircuitEnd)list.get(i)).getEntityModel();
                    if (OchTrailHelper.isTrunkPort(FVCircuitDataSource.this.uiModel.getNodeModel(), iEntityModel.getEntityIndex())) {
                        iEntityModelArray = OchTrailHelper.getColocatedOchPorts(iEntityModel);
                        for (n = 0; n < iEntityModelArray.length; ++n) {
                            if (OchPortsHelper.getSide(iEntityModelArray[i]) != this.side.getId()) continue;
                            bl = false;
                        }
                    }
                    iEntityModel = ((NetCircuitEnd)list2.get(i)).getEntityModel();
                    if (!OchTrailHelper.isTrunkPort(FVCircuitDataSource.this.uiModel.getNodeModel(), iEntityModel.getEntityIndex())) continue;
                    iEntityModelArray = OchTrailHelper.getColocatedOchPorts(iEntityModel);
                    for (n = 0; n < iEntityModelArray.length; ++n) {
                        if (OchPortsHelper.getSide(iEntityModelArray[i]) != this.side.getId()) continue;
                        bl = false;
                    }
                    continue;
                }
                catch (ObjNotFound objNotFound) {
                    SDebug.printStackTrace((Throwable)objNotFound);
                }
            }
            if (bl) {
                arrayList.add(iNetCircuit);
            }
            return arrayList;
        }

        private ArrayList filterOchNC(INetCircuit iNetCircuit, ArrayList arrayList, List list) {
            boolean bl = true;
            for (int i = 0; i < list.size(); ++i) {
                try {
                    IEntityModel iEntityModel = ((NetCircuitEnd)list.get(i)).getEntityModel();
                    if (iEntityModel.getParent().getSide() != this.side.getId()) continue;
                    bl = false;
                    continue;
                }
                catch (ObjNotFound objNotFound) {
                    SDebug.printStackTrace((Throwable)objNotFound);
                }
            }
            if (bl) {
                arrayList.add(iNetCircuit);
            }
            return arrayList;
        }
    }
}

