/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.circuit;

import cerent.cms.fv.IFVPowerModel;
import cerent.cms.fv.net.IFvNetNode;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import com.cisco.fv.FunctObserverArgument;
import com.cisco.fv.FunctViewManagerDelegate;
import com.cisco.fv.circuit.FVPowerTableCellRender;
import com.cisco.fv.circuit.IFvNetToolPane;
import com.cisco.fv.circuit.model.FVCircuitTableModel;
import com.cisco.fv.circuit.model.FvSelectedCircuitModel;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class FvSelCircuitPwrPane
extends UScrollPane
implements IFvNetToolPane,
IObserver {
    private FVCircuitTableModel tableModel;
    private SDebug db = new SDebug("FvSelCircuitPwrPane");
    private JTable table;
    private FvSelectedCircuitModel circuit;
    private boolean columnVisible = false;
    private boolean yetOpen = false;
    FVPowerTableCellRender tcr = null;

    public FvSelCircuitPwrPane() {
        this.tableModel = new FVCircuitTableModel();
        this.table = new JTable(this.tableModel);
        this.setViewportView(this.table);
        this.tcr = new FVPowerTableCellRender();
        this.table.setRowHeight(48);
        this.table.getColumnModel().getColumn(0).setCellRenderer(this.tcr);
        this.table.setName("Circuit Power");
        TableColumn tableColumn = this.table.getColumn(this.tableModel.getColumnName(0));
        tableColumn.setWidth(200);
        tableColumn.setMinWidth(20);
        tableColumn.setMaxWidth(300);
        tableColumn.setPreferredWidth(200);
        TableColumn tableColumn2 = this.table.getColumn(this.tableModel.getColumnName(3));
        tableColumn2.setWidth(60);
        tableColumn2.setMinWidth(20);
        tableColumn2.setMaxWidth(100);
        this.adaptColumn();
        this.getViewport().setScrollMode(1);
        this.setVerticalScrollBarPolicy(20);
        this.setHorizontalScrollBarPolicy(30);
    }

    @Override
    public void newCircuit(FvSelectedCircuitModel fvSelectedCircuitModel) {
        this.circuit = fvSelectedCircuitModel;
        this.tableModel.addModel((IFVPowerModel)fvSelectedCircuitModel);
        this.adaptColumn();
    }

    public void update(IObservable iObservable, Object object) {
        if (iObservable instanceof FunctViewManagerDelegate) {
            this.updateFromViewManager((FunctObserverArgument)object);
            return;
        }
        if (object instanceof FunctObserverArgument) {
            int n = ((FunctObserverArgument)object).getType();
            if (this.db.on()) {
                this.db.print("type is = " + n);
                this.db.println(" The Power table need to be open = " + (n == 0));
            }
            if (n == 0) {
                boolean bl = this.columnVisible = n == 0;
                if (this.circuit != null) {
                    this.adaptColumn();
                } else {
                    return;
                }
            }
            if (this.circuit == null) {
                if (this.db.on()) {
                    this.db.println("The Panel is close exit");
                }
                return;
            }
            if (this.db.on()) {
                this.db.println("Update of Circuit Received: ");
                this.db.println("refresh the table");
            }
            this.tableModel.updateNodeModel((FunctObserverArgument)object);
        }
    }

    private void updateFromViewManager(FunctObserverArgument functObserverArgument) {
        int n = functObserverArgument.getType();
        switch (n) {
            case 1: {
                this.tableModel.updateNodeModel(functObserverArgument);
                if (functObserverArgument.hasMoreData() != 1) break;
                this.columnVisible = this.isCircuitNodeOpen();
                if (this.circuit == null || this.columnVisible) break;
                this.adaptColumn();
                break;
            }
        }
    }

    private void adaptColumn() {
        try {
            if (this.columnVisible && this.isCircuitNodeOpen()) {
                if (!this.yetOpen) {
                    this.yetOpen = true;
                    TableColumn tableColumn = new TableColumn(2);
                    TableColumn tableColumn2 = new TableColumn(1);
                    this.table.addColumn(tableColumn);
                    this.table.addColumn(tableColumn2);
                    tableColumn.setWidth(50);
                    tableColumn.setMinWidth(20);
                    tableColumn.setMaxWidth(60);
                    tableColumn2.setWidth(50);
                    tableColumn2.setMinWidth(20);
                    tableColumn2.setMaxWidth(60);
                }
            } else {
                TableColumn tableColumn = this.table.getColumn(this.tableModel.getColumnName(2));
                TableColumn tableColumn3 = this.table.getColumn(this.tableModel.getColumnName(1));
                this.table.removeColumn(tableColumn);
                this.table.removeColumn(tableColumn3);
                this.yetOpen = false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private boolean isCircuitNodeOpen() {
        if (this.circuit == null) {
            this.yetOpen = false;
            return false;
        }
        List<IFvNetNode> list = this.circuit.getSpanNodes();
        for (IFvNetNode iFvNetNode : list) {
            if (!iFvNetNode.isFVActive()) continue;
            return true;
        }
        return false;
    }

    public void refreshTable() {
        this.tableModel.fireTableDataChanged();
    }

    public void updateTable(IFvNetNode iFvNetNode) {
        this.tableModel.refreshNodeModel(iFvNetNode);
        this.refreshTable();
    }

    public JTable getTable() {
        return this.table;
    }

    public void destroy() {
        this.tableModel = null;
        this.table = null;
        this.tcr = null;
    }
}

