/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.grapher;

import cerent.cms.fv.IFvDwdmPortModel;
import cerent.cms.fv.IFvEntityModel;
import cerent.cms.fv.net.IFvLinkModel;
import cerent.cms.fv.net.IFvMapPersist;
import cerent.cms.fv.net.IFvNetElement;
import cerent.cms.fv.net.IFvNetLink;
import cerent.cms.fv.net.IFvNetNode;
import cerent.cms.fv.net.IFvNetProtLink;
import cerent.cms.fv.net.IFvNetworkModel;
import cerent.cms.fv.net.IFvVirtualLink;
import cerent.cms.fv.net.IFvVirtualLinksDirector;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.INodeModel;
import cerent.cms.model.MissingLink;
import cerent.cms.ui.network.MapPersist;
import cerent.cms.ui.network.NetMapNode;
import cerent.util.IFvDebug;
import cerent.util.gui.UPopupMenu;
import com.cisco.ctc.util.map.IMapFactory;
import com.cisco.ctc.util.map.MapDomain;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapLinkBundle;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.Node;
import com.cisco.fv.grapher.AbstractFvMap;
import com.cisco.fv.grapher.FunctNetMapLink;
import com.cisco.fv.grapher.FvNetworkMap;
import com.cisco.fv.grapher.util.FunctMapLinkBundle;
import com.cisco.fv.grapher.util.FvNetMapDomain;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class AbstractFvNetworkMap
extends AbstractFvMap
implements Observer {
    public static final String SONET_DCC = "DCC";
    public static final String SDH_DCC = "DCC";
    public static final String GCC = "GCC";
    public static final String OTS = "OTS";
    public static final String PPC = "PPC";
    public static final String ST = "Server Trail";
    public static final String LMP_DATA_LINK = "LMP_DATA_LINK";
    public static final int INIT_EMPTY = 0;
    public static final int INIT_NODES = 1;
    public static final int INIT_NODES_PHYLINKS = 2;
    private static final String PREFS_DOMAIN = "domain";
    protected IFvNetworkModel netModel;
    protected IFvDebug dbg;
    protected boolean loTopo;
    protected boolean pcaTopo;
    protected boolean showCompositeLink;
    protected IFvVirtualLinksDirector vld;

    public AbstractFvNetworkMap(IFvDebug iFvDebug, int n, IMapFactory iMapFactory, IFvNetworkModel iFvNetworkModel, IFvVirtualLinksDirector iFvVirtualLinksDirector, IFvMapPersist iFvMapPersist) {
        this(iFvDebug, n, iMapFactory, iFvNetworkModel, iFvVirtualLinksDirector, iFvMapPersist, false);
    }

    public AbstractFvNetworkMap(IFvDebug iFvDebug, int n, IMapFactory iMapFactory, IFvNetworkModel iFvNetworkModel, IFvVirtualLinksDirector iFvVirtualLinksDirector, IFvMapPersist iFvMapPersist, boolean bl) {
        this(iFvDebug, n, iMapFactory, iFvNetworkModel, iFvVirtualLinksDirector, iFvMapPersist, false, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractFvNetworkMap(IFvDebug iFvDebug, int n, IMapFactory iMapFactory, IFvNetworkModel iFvNetworkModel, IFvVirtualLinksDirector iFvVirtualLinksDirector, IFvMapPersist iFvMapPersist, boolean bl, boolean bl2) {
        super(iFvDebug, iMapFactory, iFvMapPersist);
        this.mapPersist = iFvMapPersist;
        if (bl) {
            this.reInitMapToDetailed();
        } else {
            this.reInitMap();
        }
        this.netModel = iFvNetworkModel;
        this.vld = iFvVirtualLinksDirector;
        this.dbg = iFvDebug;
        this.showCompositeLink = bl2;
        AbstractFvNetworkMap abstractFvNetworkMap = this;
        synchronized (abstractFvNetworkMap) {
            iFvNetworkModel.getNetElementCreationNotifier().addObserver((Observer)this);
            iFvNetworkModel.getNetLinkCreationNotifier().addObserver((Observer)this);
            iFvNetworkModel.getTopologyCreationNotifier().addObserver((Observer)this);
            this.initializeMap(n);
        }
        if (iFvDebug.on()) {
            iFvDebug.println("AbstractNetworkMap.<init> finished");
        }
    }

    public IFvVirtualLinksDirector getVirtualLinksDirector() {
        return this.vld;
    }

    public IFvNetworkModel getNetworkModel() {
        return this.netModel;
    }

    public void domainDisplayed(MapDomain mapDomain) {
    }

    protected void initializeMap(int n) {
        if (n == 0) {
            return;
        }
        Collection collection = this.netModel.getAllElements();
        try {
            for (IFvNetElement iFvNetElement : collection) {
                if (this.dbg.on()) {
                    this.dbg.println("initializeMap: adding NE " + iFvNetElement.getHostName());
                }
                this.addNode(iFvNetElement.getNetworkNode(), false, null);
                iFvNetElement.addObserver((Observer)this);
                if (this.dbg.on()) {
                    this.dbg.println("initializeMap: all nodes added");
                }
                if (n != 2) continue;
                if (this.dbg.on()) {
                    this.dbg.println("\tInitializing Links ...");
                }
                this.initializeMapLinks(this.netModel.getNetLinks());
            }
        }
        catch (Exception exception) {
            if (this.dbg.on()) {
                this.dbg.println("Error while Initializing NetworkView: " + exception);
            }
            this.dbg.rootPrintStackTrace((Throwable)exception);
        }
    }

    protected boolean updateCreatesNew() {
        return true;
    }

    protected synchronized MapNode addNode(IFvNetNode iFvNetNode, boolean bl, Object object) {
        MapNode mapNode = this.getMapNode(iFvNetNode);
        if (mapNode != null) {
            if (this.dbg.on()) {
                this.dbg.println("addNode: node=" + iFvNetNode.getName() + " exists, nodeId=" + iFvNetNode.getNodeId());
            }
            return mapNode;
        }
        Point2D.Double double_ = NetMapNode.getThePositionXY(this, iFvNetNode);
        mapNode = super.addNode(iFvNetNode, iFvNetNode.getNodeId(), MapPersist.getNodeDomain((INodeModel)iFvNetNode), double_.getX(), double_.getY(), object);
        if (mapNode == null) {
            if (this.dbg.on()) {
                this.dbg.println("addNode: fail to add " + iFvNetNode.getName());
            }
        } else if (this.dbg.on()) {
            this.dbg.println("addNode: " + iFvNetNode.getName() + " added to map");
        }
        return mapNode;
    }

    public void dispose() {
        if (this.dbg.on()) {
            this.dbg.println("dispose");
        }
        try {
            this.netModel.getNetElementCreationNotifier().deleteObserver((Observer)this);
            this.netModel.getNetLinkCreationNotifier().deleteObserver((Observer)this);
            this.netModel.getTopologyCreationNotifier().deleteObserver((Observer)this);
            this.deleteNetElementObservers();
            this.deleteNetLinkObservers();
            super.destroy();
        }
        catch (Exception exception) {
            this.dbg.rootPrintStackTrace((Throwable)exception);
        }
    }

    private void deleteNetElementObservers() {
        Collection collection = this.netModel.getAllElements();
        if (collection != null) {
            for (IFvNetElement iFvNetElement : collection) {
                if (iFvNetElement == null) continue;
                iFvNetElement.deleteObserver((Observer)this);
            }
        }
    }

    @Override
    public void deleteLink(Object object) {
        if (object instanceof IFvNetLink) {
            this.stopObservingNetLinkAndItsReverse((IFvNetLink)object);
        }
        super.deleteLink(object);
    }

    @Override
    protected void initAddLink(Object object) {
        if (object instanceof IFvNetLink) {
            this.initAddLink((IFvNetLink)object);
        }
        super.initAddLink(object);
    }

    protected void initAddLink(IFvNetLink iFvNetLink) {
        iFvNetLink.addObserver((Observer)this);
        if (this.dbg.on()) {
            this.dbg.println("Observing: " + iFvNetLink.prettyString());
        }
    }

    private void stopObservingNetLinkAndItsReverse(IFvNetLink iFvNetLink) {
        if (iFvNetLink != null) {
            IFvNetLink iFvNetLink2;
            iFvNetLink.deleteObserver((Observer)this);
            if (this.dbg.on()) {
                this.dbg.println("stopped observing " + iFvNetLink.prettyString());
            }
            if ((iFvNetLink2 = this.netModel.findTheReverseLink(iFvNetLink)) != null) {
                iFvNetLink2.deleteObserver((Observer)this);
                if (this.dbg.on()) {
                    this.dbg.println("stopped observing " + iFvNetLink2.prettyString());
                }
            }
        }
    }

    private void deleteNetLinkObservers() {
        Collection collection = this.netModel.getNetLinks();
        if (collection != null) {
            for (IFvNetLink iFvNetLink : collection) {
                this.stopObservingNetLinkAndItsReverse(iFvNetLink);
            }
        }
    }

    protected boolean isProvisioningAllowed() {
        return false;
    }

    protected boolean isSuperuser() {
        return true;
    }

    @Override
    protected void initPopupMenu(UPopupMenu uPopupMenu) {
        if (this.isNetworkMap()) {
            super.initPopupMenu(uPopupMenu);
            this.actOrg.removeMenuItem((JPopupMenu)uPopupMenu, "Create New Domain...");
            if (this.isRootGraph()) {
                // empty if block
            }
            uPopupMenu.addSeparator();
        } else {
            if (!this.isRootGraph()) {
                this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Go To Parent View", 71);
                uPopupMenu.addSeparator();
            }
            this.actOrg.addMenuItem((JComponent)uPopupMenu, "/images/icons/zoom_in16.gif", "Zoom In", 73);
            this.actOrg.addMenuItem((JComponent)uPopupMenu, "/images/icons/zoom_out16.gif", "Zoom Out", 79);
            this.actOrg.addMenuItem((JComponent)uPopupMenu, "/images/icons/zoom_selected.gif", "Zoom Selected Area", 83);
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Reset Zoom", 90);
            this.actOrg.getAbstractButton("Reset Zoom").setEnabled(this.getZoomCount() != 0);
            uPopupMenu.addSeparator();
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Center View", 67);
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Fit Content to View", 70);
            if (!this.isDetailed()) {
                uPopupMenu.addSeparator();
                this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Collapse/Expand Links...", 76);
            }
        }
    }

    protected void initializeMapLinks(Collection collection) {
        if (this.dbg.on()) {
            this.dbg.println("initializeMapLinks NB links=" + collection.size() + " loTopo=" + this.loTopo);
        }
        try {
            for (IFvNetLink iFvNetLink : collection) {
                if (!this.isLinkAcceptable(iFvNetLink)) continue;
                this.dbg.println(iFvNetLink + " is acceptable");
                this.addLink(iFvNetLink, null);
            }
        }
        catch (Exception exception) {
            if (this.dbg.on()) {
                this.dbg.println("Error while Initializing map links: " + exception);
            }
            exception.printStackTrace();
            this.dbg.rootPrintStackTrace((Throwable)exception);
        }
    }

    public synchronized void addLink(IFvNetLink iFvNetLink, Object object) {
        this.addLink(iFvNetLink, object, false);
    }

    public synchronized void addLink(IFvNetLink iFvNetLink, Object object, boolean bl) {
        MapLink mapLink;
        IFvNetLink[] iFvNetLinkArray;
        IFvNetLink iFvNetLink2;
        this.initAddLink(iFvNetLink);
        if (iFvNetLink.getTheLinkModel().physicalLinkType() == 5 || this.isDetailed() && iFvNetLink.getTheLinkModel().physicalLinkType() == 6) {
            MapLink mapLink2;
            IFvLinkModel iFvLinkModel = iFvNetLink.getTheLinkModel();
            if (this.getMapLink(iFvNetLink) == null && (mapLink2 = this.addLink(iFvNetLink, iFvLinkModel.source(), iFvLinkModel.destination(), this.getLinkClass(iFvNetLink), object)) != null) {
                if (this.dbg.on()) {
                    this.dbg.println("Link Model on src " + iFvLinkModel.source().getHostName());
                    this.dbg.println("Link Model on dst " + iFvLinkModel.source().getHostName());
                }
                this.updateLinkState(mapLink2);
            }
            return;
        }
        if (!this.isDetailed() && iFvNetLink.getTheLinkModel().physicalLinkType() == 6) {
            iFvNetLink2 = (IFvVirtualLink)iFvNetLink;
            try {
                iFvNetLinkArray = this.vld.getTheLinkTerminations((IFvVirtualLink)iFvNetLink2);
                if (!iFvNetLinkArray[0].equals(iFvNetLink2)) {
                    return;
                }
                for (int i = 0; i < iFvNetLinkArray.length; ++i) {
                    mapLink = (IFvVirtualLink)iFvNetLinkArray[i];
                    if (this.dbg.on()) {
                        this.dbg.println("Checking VL candidate: " + mapLink);
                    }
                    if (this.getMapLink(mapLink) == null) continue;
                    if (this.dbg.on()) {
                        this.dbg.println("Discarded VL - this peer is already in map: " + mapLink);
                    }
                    return;
                }
            }
            catch (MissingLink missingLink) {
                if (this.dbg.on()) {
                    this.dbg.println("Cannot state if vl[" + iFvNetLink2 + "] is complete.\n" + missingLink.getMessage());
                }
                return;
            }
        }
        if ((iFvNetLink2 = this.netModel.findTheReverseLink(iFvNetLink)) == null) {
            if (this.dbg.on()) {
                this.dbg.println("Cannot find reverse link");
            }
            return;
        }
        iFvNetLinkArray = iFvNetLink.getTheLinkModel();
        IFvLinkModel iFvLinkModel = iFvNetLink2.getTheLinkModel();
        mapLink = this.getMapLink(iFvNetLink);
        MapLink mapLink3 = this.getMapLink(iFvNetLink2);
        if (bl || mapLink3 == null && mapLink == null) {
            MapLink mapLink4;
            if (this.dbg.on()) {
                try {
                    this.dbg.println("New link: " + iFvNetLink.getSource().getNetworkNode().getName() + "/" + iFvNetLink.getSrcSlotNumber() + "/" + AbstractFvNetworkMap.getConcatenatedString(iFvNetLink.getSrcPortNumber(), '-') + "/" + iFvNetLink.getSrcHo() + " - " + iFvNetLink.getDestination().getNetworkNode().getName() + "/" + iFvNetLink.getDstSlotNumber() + "/" + AbstractFvNetworkMap.getConcatenatedString(iFvNetLink.getDstPortNumber(), '-') + "/" + iFvNetLink.getDstHo());
                }
                catch (Exception exception) {
                    this.dbg.println("problem printing debugged new link.");
                }
            }
            if ((mapLink4 = this.addLink(iFvNetLink, iFvNetLinkArray.source(), iFvNetLinkArray.destination(), this.getLinkClass(iFvNetLink), object)) != null) {
                this.updateLinkState(mapLink4);
            }
        } else {
            this.updateLinkState(mapLink3);
        }
    }

    private String getLinkClass(Object object) {
        if (object instanceof IFvNetLink) {
            IFvNetLink iFvNetLink = (IFvNetLink)object;
            int n = iFvNetLink.getTheLinkModel().physicalLinkType();
            if (n == 5) {
                return OTS;
            }
            if (n == 3) {
                IFvEntityModel iFvEntityModel = iFvNetLink.getTheLinkModel().getTheEndEntityModel(true);
                if (iFvEntityModel instanceof IFvDwdmPortModel) {
                    try {
                        IFvDwdmPortModel iFvDwdmPortModel = (IFvDwdmPortModel)iFvEntityModel;
                        if (iFvDwdmPortModel.isSonetDccTermination()) {
                            return "DCC";
                        }
                        return GCC;
                    }
                    catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                        this.dbg.println("Cannot manage Link Class for " + iFvEntityModel);
                        this.dbg.rootPrintStackTrace((Throwable)abstractCmsObjectNotExistException);
                    }
                }
                if (iFvNetLink.isSdccLink()) {
                    return "DCC";
                }
                return GCC;
            }
            if (n == 6) {
                return PPC;
            }
            if (n == 13) {
                return LMP_DATA_LINK;
            }
            if (n == 12) {
                return ST;
            }
            if (n == 1) {
                return "DCC";
            }
            if (n == 2) {
                return "DCC";
            }
        }
        return null;
    }

    protected boolean isLinkAcceptable(IFvNetLink iFvNetLink) {
        if (iFvNetLink.getTheLinkModel().physicalLinkType() == 1 || iFvNetLink.getTheLinkModel().physicalLinkType() == 2 || iFvNetLink.getTheLinkModel().physicalLinkType() == 3) {
            return false;
        }
        if (iFvNetLink.getTheLinkModel().physicalLinkType() == 4 || iFvNetLink.getTheLinkModel().physicalLinkType() == 7) {
            return false;
        }
        if (this.isNetworkMap() && iFvNetLink.getTheLinkModel().linkType() == 8) {
            return false;
        }
        if (iFvNetLink.getTheLinkModel().physicalLinkType() == 13) {
            return true;
        }
        if (iFvNetLink.getTheLinkModel().physicalLinkType() == 5 || iFvNetLink.isVirtual() || iFvNetLink.getTheLinkModel().physicalLinkType() == 3) {
            return true;
        }
        boolean bl = (iFvNetLink.isLOTunnel() || iFvNetLink.isLOCapable()) && !iFvNetLink.isLAP();
        boolean bl2 = this.notLot(iFvNetLink) && !iFvNetLink.isLAP();
        boolean bl3 = true;
        if (iFvNetLink.getTheLinkModel().physicalLinkType() == 12 || iFvNetLink.getTheLinkModel().physicalLinkType() == 3) {
            IFvNetProtLink iFvNetProtLink = (IFvNetProtLink)iFvNetLink;
            boolean bl4 = bl3 = iFvNetProtLink.inBLSR() && iFvNetProtLink.isPca() || !iFvNetProtLink.inBLSR();
        }
        if (this.loTopo && this.pcaTopo) {
            if (this.dbg.on()) {
                this.dbg.println(iFvNetLink.prettyString());
            }
            if (this.dbg.on()) {
                this.dbg.println("    vtTopo && pcaTopo returning " + (bl && bl3));
            }
            return bl && bl3;
        }
        if (this.loTopo) {
            if (this.dbg.on()) {
                this.dbg.println(iFvNetLink.prettyString());
            }
            if (this.dbg.on()) {
                this.dbg.println("    loTopo returning " + (bl && !iFvNetLink.isPca()));
            }
            return bl && !iFvNetLink.isPca();
        }
        if (this.pcaTopo) {
            if (this.dbg.on()) {
                this.dbg.println(iFvNetLink.prettyString());
            }
            if (this.dbg.on()) {
                this.dbg.println("    pcaTopo returning " + (bl3 && bl2));
            }
            return bl3 && bl2;
        }
        if (this.dbg.on()) {
            this.dbg.println(iFvNetLink.prettyString());
        }
        if (this.dbg.on()) {
            this.dbg.println("    neither topo returning " + (bl2 && !iFvNetLink.isPca()));
        }
        return bl2 && !iFvNetLink.isPca();
    }

    protected boolean notLot(IFvNetLink iFvNetLink) {
        return !iFvNetLink.isLOTunnel();
    }

    protected boolean isNetLinkUpBothDirection(IFvNetLink iFvNetLink) {
        boolean bl;
        boolean bl2 = bl = iFvNetLink.getTheLinkModel().state() == 1;
        if (iFvNetLink.getTheLinkModel().physicalLinkType() == 5) {
            return bl;
        }
        IFvNetLink iFvNetLink2 = this.netModel.findTheReverseLink(iFvNetLink);
        return iFvNetLink2 != null && bl && iFvNetLink2.getTheLinkModel().state() == 1;
    }

    protected void updateLinkState(MapLink mapLink) {
        int n;
        IFvNetLink iFvNetLink;
        block9: {
            if (mapLink == null || !(mapLink.getUserObject() instanceof IFvNetLink)) {
                return;
            }
            iFvNetLink = (IFvNetLink)mapLink.getUserObject();
            n = 1;
            if (iFvNetLink.getTheLinkModel().physicalLinkType() == 6) {
                if (this.vld.isTheLinkUp((IFvVirtualLink)iFvNetLink)) {
                    n = 2;
                }
            } else {
                try {
                    if (this.isNetLinkUpBothDirection(iFvNetLink)) {
                        n = 2;
                    }
                }
                catch (Exception exception) {
                    if (!this.dbg.on()) break block9;
                    this.dbg.rootPrintStackTrace((Throwable)exception);
                }
            }
        }
        if (this.dbg.on()) {
            this.dbg.println("\t" + iFvNetLink.prettyString() + " going to state: " + n);
        }
        ((FunctNetMapLink)mapLink).setState(n);
        if (this.dbg.on()) {
            this.dbg.println("updateLinkState state=" + n);
        }
    }

    public MapLink getDirectionalMapLink(IFvNetLink iFvNetLink) {
        MapLink mapLink = this.getMapLink(iFvNetLink);
        if (mapLink == null && (iFvNetLink = this.netModel.findTheReverseLink(iFvNetLink)) != null) {
            mapLink = this.getMapLink(iFvNetLink);
        }
        return mapLink;
    }

    protected void updateLink(IFvNetLink iFvNetLink) {
        if (this.dbg.on()) {
            this.dbg.println("updateLink link=" + iFvNetLink);
            if (iFvNetLink != null) {
                this.dbg.println("\t" + iFvNetLink.prettyString());
            }
        }
        MapLink mapLink = this.getMapLink(iFvNetLink);
        if (iFvNetLink.isDeleted()) {
            if (this.dbg.on()) {
                this.dbg.println("updateLink: link is deleted");
            }
            if (iFvNetLink.getTheLinkModel().physicalLinkType() == 6) {
                IFvNetLink[] iFvNetLinkArray = null;
                iFvNetLinkArray = this.vld.getTheAvailLinkTerminations((IFvVirtualLink)iFvNetLink);
                if (this.dbg.on()) {
                    this.dbg.println("updateLink: found " + iFvNetLinkArray.length + " VL terminations not deleted.");
                }
                if (mapLink == null) {
                    if (this.dbg.on()) {
                        this.dbg.println("updateLink: MapLink is: " + mapLink + " finding out the map link...");
                    }
                    IFvNetLink iFvNetLink2 = null;
                    for (int i = 0; mapLink == null && i < iFvNetLinkArray.length; ++i) {
                        mapLink = this.getMapLink(iFvNetLinkArray[i]);
                        iFvNetLink2 = iFvNetLinkArray[i];
                    }
                    if (mapLink != null) {
                        if (this.dbg.on()) {
                            this.dbg.println("updateLink: map link is " + iFvNetLink2.prettyString());
                        }
                        if (this.dbg.on()) {
                            this.dbg.println("updateLink: removing observer of NL " + iFvNetLink.prettyString());
                        }
                        iFvNetLink.deleteObserver((Observer)this);
                        if (this.dbg.on()) {
                            this.dbg.println("updateLink: deleting link " + iFvNetLink2.prettyString() + " from map");
                        }
                        this.deleteLink(iFvNetLink2);
                        return;
                    }
                    if (this.dbg.on()) {
                        this.dbg.println("updateLink: no map link found");
                    }
                }
            }
            if (this.dbg.on()) {
                this.dbg.println("updateLink: removing observer of NL " + iFvNetLink.prettyString());
            }
            iFvNetLink.deleteObserver((Observer)this);
            if (mapLink == null && (iFvNetLink = this.netModel.findTheReverseLink(iFvNetLink)) != null) {
                if (this.dbg.on()) {
                    this.dbg.println("updateLink: found reverse link");
                }
                mapLink = this.getMapLink(iFvNetLink);
            }
            if (mapLink != null) {
                if (this.dbg.on()) {
                    this.dbg.println("updateLink: deleting link " + iFvNetLink.prettyString() + " from map");
                }
                this.deleteLink(iFvNetLink);
            }
        } else {
            if (mapLink == null && (iFvNetLink = this.netModel.findTheReverseLink(iFvNetLink)) != null) {
                mapLink = this.getMapLink(iFvNetLink);
                if (this.dbg.on()) {
                    this.dbg.println("use reverse for: " + mapLink);
                }
            }
            if (mapLink != null) {
                this.updateLinkState(mapLink);
            } else if (this.dbg.on() && iFvNetLink != null) {
                this.dbg.println("Could not find a maplink for " + iFvNetLink.prettyString() + " or its reverse link");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void update(Observable observable, Object object) {
        if (this.dbg.on()) {
            this.dbg.println("Received an update from:" + observable + " arg=" + object);
        }
        if (observable instanceof IFvNetLink) {
            if (this.dbg.on()) {
                this.dbg.println("\tUpdate from link: " + ((IFvNetLink)observable).prettyString());
            }
            this.updateLink((IFvNetLink)observable);
            return;
        } else {
            if (observable instanceof IFvNetElement) {
                MapNode mapNode;
                IFvNetElement iFvNetElement = (IFvNetElement)observable;
                if (observable == null) return;
                if (this.dbg.on()) {
                    this.dbg.println("receive topology update from " + iFvNetElement.getName() + " topoHost=" + (iFvNetElement.isTopoHost() ? "true" : "false"));
                }
                if ((mapNode = this.getMapNode(iFvNetElement.getNetworkNode())) == null) return;
            }
            if (this.netModel.isNetElementCreationNotifier(observable)) {
                if (this.dbg.on()) {
                    this.dbg.println("update: received NetElementCreationNotifier event");
                }
                if (!this.updateCreatesNew()) return;
                IFvNetNode iFvNetNode = ((IFvNetElement)object).getNetworkNode();
                ((IFvNetElement)object).addObserver((Observer)this);
                this.addNode(iFvNetNode, true, null);
                return;
            } else if (this.netModel.isNetLinkCreationNotifier(observable)) {
                IFvNetLink iFvNetLink;
                if (this.dbg.on()) {
                    this.dbg.println("update: received NetLinkCreationNotifier event");
                }
                if (!this.isLinkAcceptable(iFvNetLink = (IFvNetLink)object) || !this.updateCreatesNew()) return;
                this.addLink(iFvNetLink, null);
                return;
            } else {
                if (!this.netModel.isTopologyCreationNotifier(observable) || !this.dbg.on()) return;
                this.dbg.println("update: received TopologyCreationNotifier event");
                this.dbg.println("update: NOT IMPLEMENTED");
            }
        }
    }

    @Override
    protected void doubleClicked(MapNode mapNode) {
        this.openNode(mapNode);
    }

    @Override
    protected void doubleClicked(MapDomain mapDomain) {
        super.doubleClicked(mapDomain);
    }

    private void openNode(MapNode mapNode) {
        if (mapNode == null) {
            return;
        }
        IFvNetNode iFvNetNode = (IFvNetNode)mapNode.getUserObject();
        if (!this.isNodeOperational(iFvNetNode) || this.isNodeManageable(iFvNetNode)) {
            // empty if block
        }
    }

    protected boolean isNodeOperational(IFvNetNode iFvNetNode) {
        return iFvNetNode.isInited() && iFvNetNode.getConnectionState();
    }

    protected boolean isNodeManageable(IFvNetNode iFvNetNode) {
        return iFvNetNode.isManageable();
    }

    @Override
    public MapDomain createDomain(Object object) {
        return new FvNetMapDomain(this);
    }

    @Override
    protected MapLinkBundle createLinkBundle(Node node, Node node2, String string, int n) {
        return new FunctMapLinkBundle(this, node, node2, string, n);
    }

    @Override
    public boolean getMapProperty(Object object, int n) {
        if (this.isNetworkMap()) {
            if (this.mapPersist != null) {
                return this.mapPersist.getThePersistProperty(object, n);
            }
            return true;
        }
        if (n == 101) {
            return true;
        }
        if (n == 110 || n == 112) {
            return this.mapPersist.getThePersistProperty(object, n);
        }
        return false;
    }

    @Override
    public void mapPropertyChanged(Object object, int n, String string, String string2) {
        if (this.isNetworkMap() || n == 101) {
            // empty if block
        }
    }

    @Override
    public void domainRemoved(MapDomain mapDomain) {
        if (this.isNetworkMap()) {
            // empty if block
        }
    }

    @Override
    public void domainCreated(MapDomain mapDomain) {
        if (this.isNetworkMap()) {
            // empty if block
        }
    }

    @Override
    public void domainNameChanged(MapDomain mapDomain, String string, String string2) {
        if (this.isNetworkMap()) {
            // empty if block
        }
    }

    public boolean nodeIsForwardable(MapNode mapNode) {
        Object object = mapNode.getUserObject();
        return object != null && object instanceof IFvNetNode;
    }

    private void doOpenDomain(MapDomain mapDomain) {
        if (this.isNetworkMap()) {
            if (mapDomain == null) {
                // empty if block
            }
        } else {
            super.displayDomain(mapDomain);
        }
    }

    @Override
    protected void doGoToRootGraph() {
        if (!((Object)((Object)this.getGraph())).equals((Object)this.rootGraph)) {
            super.doGoToRootGraph();
        }
    }

    @Override
    protected void doGoToNodeDomain(MapNode mapNode) {
        if (!this.isNetworkMap()) {
            super.doGoToNodeDomain(mapNode);
        } else if (mapNode != null) {
            this.doOpenDomain(mapNode.getRealNode().getDomain());
        }
    }

    protected void tryJumpView(String string) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == this.CMD_SAVE_NODE_POSITION) {
            this.doSaveNodePositions();
        } else if (string == this.CMD_NODE_RESET_POS) {
            this.doResetNodePosition();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    private boolean isNetworkMap() {
        return this instanceof FvNetworkMap;
    }

    @Override
    protected JButton getAutoLayoutHelpButton() {
        return null;
    }

    public void setNetMapLinkState(String string, MapLink mapLink, int n) {
        if (mapLink != null) {
            // empty if block
        }
    }

    public void setViewToCenter() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractFvNetworkMap.this.centerView();
            }
        });
    }

    public static String getConcatenatedString(int[] nArray, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]);
            if (i == nArray.length - 1) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

