/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.grapher.circuit;

import cerent.cms.fv.IFVSelectedPowerModel;
import cerent.cms.fv.net.IFVCircuitSpan;
import cerent.cms.fv.net.IFvNetElement;
import cerent.cms.fv.net.IFvNetLink;
import cerent.cms.fv.net.IFvNetNode;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.util.SDebug;
import cerent.util.UObservable;
import cerent.util.view.fv.ViewGrapher;
import cerent.util.view.fv.ViewManager;
import cerent.util.view.fv.ViewManagerToolKit;
import cerent.util.view.fv.ViewPin;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.fv.FunctObserverArgument;
import com.cisco.fv.FunctViewManagerDelegate;
import com.cisco.fv.alarms.FVPaintAlarm;
import com.cisco.fv.circuit.FvSelCircuitToolPane;
import com.cisco.fv.circuit.model.FvSelectedCircuitModel;
import com.cisco.fv.grapher.FunctNetMapNode;
import com.cisco.fv.grapher.FvNetworkMap;
import com.cisco.fv.grapher.circuit.FVNetCircuitPathElements;
import com.cisco.fv.grapher.circuit.FvNodeCircuitPath;
import com.cisco.fv.power.PowerBallon;
import com.cisco.fv.power.SpanLossBalloon;
import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.graphic.composite.IlvCompositeGraphic;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class FvNetworkCircuitPath
extends UObservable
implements Observer,
Runnable {
    private static final int ALL_THREAD_END = 0;
    private static FvNetworkCircuitPath netCircuitPath;
    private HashMap<MapLink, Color> linksOriginalStates;
    private int prevSelectedCircuitId = -1;
    private LinkedList<ViewManager> openNodeVms;
    private Thread threadPaint;
    private IFVSelectedPowerModel activeCircuit;
    private IFVSelectedPowerModel selectedCircuit;
    private int circuitId;
    private boolean threadWorking;
    private FVNetCircuitPathElements activeElements = null;
    private int allThreadFinish;
    public static long circuitDbgtime;
    private LinkedList<ViewPin> sourceDestination = new LinkedList();
    public static SDebug sd;

    private FvNetworkCircuitPath() {
        this.openNodeVms = new LinkedList();
        this.sourceDestination = new LinkedList();
        this.linksOriginalStates = new HashMap();
        this.addObserver(FvSelCircuitToolPane.getInstance());
    }

    public static SDebug getSd() {
        return sd;
    }

    public static FvNetworkCircuitPath getInstance() {
        if (netCircuitPath == null) {
            netCircuitPath = new FvNetworkCircuitPath();
            FunctViewManagerDelegate.getInstance().addObserver(netCircuitPath);
        }
        return netCircuitPath;
    }

    public void paintCircuit(IFVSelectedPowerModel iFVSelectedPowerModel, int n) {
        boolean bl = true;
        if (this.prevSelectedCircuitId != -1 && this.prevSelectedCircuitId == n) {
            bl = false;
        }
        if (bl) {
            if (!this.threadWorking) {
                if (sd.on()) {
                    sd.println("Paint start after " + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
                }
                this.selectedCircuit = iFVSelectedPowerModel;
                this.circuitId = n;
                String string = "Paint CircuitId " + n;
                this.threadWorking = true;
                this.threadPaint = new Thread((Runnable)this, string);
                this.threadPaint.start();
            } else if (sd.on()) {
                sd.println("already Running");
            }
        }
    }

    boolean isInActivePath(IFvNetElement iFvNetElement, List<IFvNetLink> list, List<IFVCircuitSpan> list2) {
        boolean bl = true;
        boolean bl2 = true;
        for (IFVCircuitSpan iFVCircuitSpan : list2) {
            boolean bl3;
            if (iFVCircuitSpan.getIFvLink().getDestination() == iFvNetElement) {
                boolean bl4 = bl3 = ((NetCircuitSpan)iFVCircuitSpan).getSpanState(((NetCircuitSpan)iFVCircuitSpan).getDstNCN().getNodeModel()) != 1;
                if (bl != bl3 && !bl2) {
                    return true;
                }
                bl = bl3;
                bl2 = false;
            }
            if (iFVCircuitSpan.getIFvLink().getSource() != iFvNetElement) continue;
            boolean bl5 = bl3 = ((NetCircuitSpan)iFVCircuitSpan).getSpanState(((NetCircuitSpan)iFVCircuitSpan).getSrcNCN().getNodeModel()) != 1;
            if (bl != bl3 && !bl2) {
                return true;
            }
            bl = bl3;
            bl2 = false;
        }
        return bl;
    }

    public void clearActiveCircuit(FvNetworkMap fvNetworkMap, boolean bl) {
        ViewManager viewManager;
        int n;
        List list;
        if (sd.on()) {
            sd.println("Clear Enter after " + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
        }
        if (bl) {
            PowerBallon.getInstance().setForCircuit(false);
            SpanLossBalloon.getInstance().setForCircuit(false);
        }
        if (this.openNodeVms != null && this.openNodeVms.size() > 0) {
            list = (LinkedList)this.openNodeVms.clone();
            this.openNodeVms.clear();
            for (n = 0; n < ((LinkedList)list).size(); ++n) {
                viewManager = (ViewManager)((LinkedList)list).get(n);
                viewManager.getCircuitsPathManager().clearActiveCircuit();
                viewManager.getNode().setPowerCalculated(false);
                if (!sd.on()) continue;
                sd.println("\t after cleared " + viewManager.getNode().getName() + " " + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
            }
        }
        if (sd.on()) {
            sd.println("\t after clearActiveCircuit" + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
        }
        if (this.sourceDestination != null && this.sourceDestination.size() != 0) {
            while (this.sourceDestination.size() != 0) {
                list = this.sourceDestination.removeFirst();
                IlvCompositeGraphic ilvCompositeGraphic = ((ViewPin)list).pinCompo;
                if (ilvCompositeGraphic == null) continue;
                viewManager = ilvCompositeGraphic.getGraphicBag();
                if (viewManager == null) {
                    ((ViewPin)list).pinCompo.setChildren(5, null);
                    ((ViewPin)list).pinCompo.setChildren(1, null);
                } else {
                    viewManager.applyToObject((IlvGraphic)((ViewPin)list).pinCompo, new IlvApplyObject(){

                        public void apply(IlvGraphic ilvGraphic, Object object) {
                            ((IlvCompositeGraphic)ilvGraphic).setChildren(5, (IlvGraphic)object);
                            ((IlvCompositeGraphic)ilvGraphic).setChildren(1, (IlvGraphic)object);
                        }
                    }, null, false);
                }
                ((ViewPin)list).grapher.allSourceDestination.remove(list.getKey());
            }
            this.sourceDestination.clear();
        }
        if (sd.on()) {
            sd.println("\t after Source/Destination" + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
        }
        fvNetworkMap.restoreLinkStates(this.linksOriginalStates);
        this.linksOriginalStates.clear();
        if (this.activeElements != null) {
            this.activeElements.setPowerBallon(false);
        }
        if (this.activeCircuit != null) {
            list = this.activeCircuit.getSpanNodes();
            for (n = 0; n < list.size(); ++n) {
                viewManager = (IFvNetNode)list.get(n);
                viewManager.setInCircuit(false);
            }
        }
        this.clearGraphTool(bl);
        this.prevSelectedCircuitId = -1;
        this.activeCircuit = null;
        if (sd.on()) {
            sd.println("Clear Exit after " + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
        }
    }

    private void clearGraphTool(boolean bl) {
        FVPaintAlarm.getInstance().setAlarmMask(false);
        if (bl) {
            FvNetworkMap.getInstance().calculatePowerBalloon();
            FvNetworkMap.getInstance().calculateSpanLossBalloon();
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof FunctObserverArgument) {
            int n = ((FunctObserverArgument)object).getType();
            IFvNetNode iFvNetNode = ((FunctObserverArgument)object).getNode();
            FvNetworkMap fvNetworkMap = FunctViewManagerDelegate.getInstance().getNetworkMap();
            switch (n) {
                case 1: {
                    ViewManager viewManager;
                    this.updateNodeCircuits(false, iFvNetNode, fvNetworkMap);
                    ViewManagerToolKit viewManagerToolKit = fvNetworkMap.getTk(iFvNetNode);
                    ViewGrapher viewGrapher = viewManagerToolKit.getGraph();
                    if (viewGrapher == null || !this.openNodeVms.contains(viewManager = viewGrapher.getViewManager())) break;
                    this.openNodeVms.remove(viewManager);
                    break;
                }
                case 0: 
                case 3: {
                    if (((FunctObserverArgument)object).hasMoreData() == 2) break;
                    this.updateNodeCircuits(true, iFvNetNode, fvNetworkMap);
                }
            }
        }
    }

    public void updateCircuits(boolean bl) {
        if (bl && this.prevSelectedCircuitId != -1 && this.activeCircuit != null) {
            int n = this.prevSelectedCircuitId;
            IFVSelectedPowerModel iFVSelectedPowerModel = this.activeCircuit;
            if (iFVSelectedPowerModel instanceof FvSelectedCircuitModel) {
                ((FvSelectedCircuitModel)iFVSelectedPowerModel).addPortsForCircuitNodes();
            }
            this.prevSelectedCircuitId = -1;
            this.paintCircuit(iFVSelectedPowerModel, n);
        }
    }

    @Override
    public void run() {
        Thread thread;
        LinkedList linkedList = (LinkedList)FunctViewManagerDelegate.getInstance().getAllOpenNodes().clone();
        if (sd.on()) {
            sd.println("");
            sd.println("");
            sd.println("Circuit " + ((INetCircuit)this.selectedCircuit.getCircuitModel()).getCircuitName());
            sd.println("Task started " + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
            sd.println("DEACTIVATE BUTTON");
        }
        FunctViewManagerDelegate.getInstance().circuitTableAndToolsButtonEnable(false, false);
        FvNetworkMap fvNetworkMap = FunctViewManagerDelegate.getInstance().getNetworkMap();
        if (this.selectedCircuit.getCircuitModel() == null) {
            return;
        }
        this.prepareCircuitNetLink(fvNetworkMap);
        this.activeElements.setPowerBallon(true);
        if (sd.on()) {
            sd.println("\t end setPowerBallon after " + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
        }
        this.placeSpanLossBalloon(fvNetworkMap);
        List list = this.selectedCircuit.getSpanNodes();
        block0: for (int i = 0; i < list.size(); ++i) {
            Object object = (IFvNetNode)list.get(i);
            object.setInCircuit(true);
            if (!object.isFVActive()) continue;
            thread = new Thread((Runnable)new FvNodeCircuitPath(this, (IFvNetNode)object, fvNetworkMap, true), "nodePaint");
            thread.start();
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                FunctNetMapNode functNetMapNode = (FunctNetMapNode)iterator.next();
                if (functNetMapNode.getNodeModel() != object) continue;
                iterator.remove();
                continue block0;
            }
        }
        for (Object object : linkedList) {
            thread = new Thread((Runnable)new FvNodeCircuitPath(this, ((FunctNetMapNode)object).getNodeModel(), fvNetworkMap, false), "nodePaint");
            thread.start();
        }
        this.paintFinished(false);
    }

    public IFVSelectedPowerModel getSelectedCircuit() {
        return this.selectedCircuit;
    }

    private void updateNodeCircuits(boolean bl, IFvNetNode iFvNetNode, FvNetworkMap fvNetworkMap) {
        if (this.activeCircuit == null) {
            return;
        }
        if (iFvNetNode.isFVActive() && iFvNetNode.isInCircuit()) {
            if (sd.on()) {
                sd.println("DEACTIVATE BUTTON");
            }
            FunctViewManagerDelegate.getInstance().circuitTableAndToolsButtonEnable(false, false);
            ((FvSelectedCircuitModel)this.activeCircuit).addPortsForCircuitNode(iFvNetNode);
            Thread thread = new Thread((Runnable)new FvNodeCircuitPath(this, iFvNetNode, fvNetworkMap, true), "nodePaint");
            thread.start();
        }
    }

    synchronized void paintFinished(boolean bl) {
        if (bl) {
            this.nodeThreadFinish();
            if (sd.on()) {
                sd.println("Decremented Thread = " + this.allThreadFinish);
            }
        }
        if (this.allThreadFinish == 0) {
            FunctObserverArgument functObserverArgument = new FunctObserverArgument(null, 5);
            this.setChanged();
            this.notifyObservers(functObserverArgument);
            FVPaintAlarm.getInstance().setAlarmMask(true);
            this.threadWorking = false;
            if (sd.on()) {
                sd.println("Paint finish after " + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
                sd.println("ACTIVATE BUTTON");
            }
            FunctViewManagerDelegate.getInstance().circuitTableAndToolsButtonEnable(true, true);
        }
    }

    private void prepareCircuitNetLink(FvNetworkMap fvNetworkMap) {
        List list = this.selectedCircuit.getCircuitLink();
        List list2 = this.selectedCircuit.getCircuitSpans();
        this.activeElements = new FVNetCircuitPathElements(list2, list, this.selectedCircuit.isBidirectional());
        if (sd.on()) {
            sd.println("\t prepare Link start after " + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
        }
        this.linksOriginalStates = fvNetworkMap.showSelectedCircuit(this.activeElements);
        this.prevSelectedCircuitId = this.circuitId;
        this.activeCircuit = this.selectedCircuit;
        if (sd.on()) {
            sd.println("\t prepare Link finish after " + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
        }
    }

    public void dispose() {
        this.prevSelectedCircuitId = -1;
        this.linksOriginalStates.clear();
        this.linksOriginalStates = null;
        this.openNodeVms.clear();
        this.openNodeVms = null;
        FunctViewManagerDelegate.getInstance().deleteObserver(netCircuitPath);
        netCircuitPath = null;
        this.sourceDestination.clear();
    }

    public void printDbgStr(String string) {
        if (sd.on()) {
            sd.println(string);
        }
    }

    private void placeSpanLossBalloon(FvNetworkMap fvNetworkMap) {
        fvNetworkMap.showPower(false, 0);
        boolean bl = FunctViewManagerDelegate.getInstance().isSpanLossPowerVisible();
        if (bl) {
            FunctViewManagerDelegate.getInstance().powerButtonAction(bl, 0);
        }
        if (sd.on()) {
            sd.println("\t\t spanLoss placed after " + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
        }
    }

    public void nodeThreadStart() {
        ++this.allThreadFinish;
    }

    public void nodeThreadFinish() {
        --this.allThreadFinish;
    }

    public int getRunningNodeThread() {
        return this.allThreadFinish;
    }

    public void addDestination(ViewPin viewPin) {
        this.sourceDestination.add(viewPin);
    }

    public boolean addNewOpenNode(ViewManager viewManager) {
        if (!this.openNodeVms.contains(viewManager)) {
            this.openNodeVms.add(viewManager);
            return true;
        }
        return false;
    }

    static {
        sd = new SDebug("FvNetworkCircuitPath");
    }
}

