/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.gui;

import cerent.cms.ui.functional.FVActionListener;
import cerent.cms.ui.functional.FunctMenuBar;
import cerent.util.EID;
import cerent.util.KEMC;
import cerent.util.KErrorMsg;
import cerent.util.view.fv.ViewMagnifier;
import cerent.util.view.fv.ViewPrintingHelper;
import cerent.util.view.fv.helper.FunctDebug;
import com.cisco.ctc.ui.AboutDialog;
import com.cisco.ctc.ui.KeystrokeDialog;
import com.cisco.fv.FunctExportTables;
import com.cisco.fv.FunctViewManagerDelegate;
import com.cisco.fv.grapher.FvNetworkMap;
import com.cisco.fv.gui.FunctionalNetworkDialog;
import com.cisco.fv.gui.NfvMenuToolBar;
import ilog.views.IlvManagerViewInteractor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class NfvMenuToolListener
extends FVActionListener {
    private FunctMenuBar menuBar;
    private FvNetworkMap view;
    private FunctExportTables export;
    private FunctionalNetworkDialog functionalNetworkDialog;
    private NfvMenuToolBar toolBar;

    public NfvMenuToolListener(FunctionalNetworkDialog functionalNetworkDialog, NfvMenuToolBar nfvMenuToolBar) {
        this.container = functionalNetworkDialog.getFrame();
        this.toolBar = nfvMenuToolBar;
        this.functionalNetworkDialog = functionalNetworkDialog;
        KeystrokeDialog.instance((JFrame)this.container, "Keystroke Network Functional View");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (actionEvent.getActionCommand() == "Fit to View") {
                this.view.fitView();
            } else if (actionEvent.getActionCommand() == "Magnifier") {
                this.doMagn((AbstractButton)actionEvent.getSource());
            } else if (actionEvent.getActionCommand() == "Show Power") {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                boolean bl = this.toolBar.synchronizeButtons(abstractButton);
                FunctViewManagerDelegate.getInstance().powerButtonAction(bl, 1);
            } else if (actionEvent.getActionCommand() == "Show SpanLoss") {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                boolean bl = this.toolBar.synchronizeButtons(abstractButton);
                FunctViewManagerDelegate.getInstance().powerButtonAction(bl, 0);
            } else if (actionEvent.getActionCommand() == "About") {
                AboutDialog.instance((JFrame)this.container, "About CTC").show();
            } else if (actionEvent.getActionCommand() == "Keystroke commands") {
                KeystrokeDialog.getInstance().show();
            } else if (actionEvent.getActionCommand() == "User Manuals") {
                String string = KErrorMsg.getString((EID)KEMC.EID_HELP_MANUAL_ERROR);
                JOptionPane.showMessageDialog(null, string, "Error", 0);
            } else if (actionEvent.getActionCommand() == "Verify Patchcords") {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                boolean bl = this.toolBar.synchronizeButtons(abstractButton);
                FunctViewManagerDelegate.getInstance().patchCordVerify(bl);
            } else if (actionEvent.getActionCommand() == "Refresh Power Info") {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                FunctViewManagerDelegate.getInstance().refreshButtonAction();
                abstractButton.setSelected(false);
            } else if (actionEvent.getActionCommand() == "Export...") {
                this.export.setTable(this.functionalNetworkDialog.getExportableTables());
                this.export.setTitle(this.functionalNetworkDialog.getExportableTitle());
                this.export.export();
            } else if (actionEvent.getActionCommand() == "Close Expanded Nodes") {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                abstractButton.setSelected(false);
                this.doCloseAllNodes();
            } else if (actionEvent.getActionCommand() == "Reset Nodes Zoom") {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                abstractButton.setSelected(false);
                this.doResetZoomNodes();
            } else {
                super.actionPerformed(actionEvent);
            }
        }
        catch (NfvMenuToolBar.NfvMenuTollBarException nfvMenuTollBarException) {
            FunctDebug.printStackTrace((Throwable)nfvMenuTollBarException);
        }
    }

    private void doMagn(AbstractButton abstractButton) {
        try {
            if (this.toolBar.synchronizeButtons(abstractButton)) {
                ViewMagnifier viewMagnifier = new ViewMagnifier();
                viewMagnifier.setMode((short)1);
                viewMagnifier.setPermanent(true);
                viewMagnifier.setFactor(3.0f);
                this.view.pushInteractor((IlvManagerViewInteractor)viewMagnifier);
                this.view.setZoomFactorRange(0.1, 10.0);
            } else {
                this.view.popInteractor();
            }
        }
        catch (NfvMenuToolBar.NfvMenuTollBarException nfvMenuTollBarException) {
            FunctDebug.printStackTrace((Throwable)nfvMenuTollBarException);
        }
    }

    private void doCloseAllNodes() {
        this.view.closeAllOpenNodes();
    }

    private void doResetZoomNodes() {
        this.view.resetZoomNodes();
    }

    public void addMenu(FunctMenuBar functMenuBar) {
        this.menuBar = functMenuBar;
    }

    public FunctMenuBar getMenuBar() {
        return this.menuBar;
    }

    public void addExecutor(FvNetworkMap fvNetworkMap, Component component) {
        this.view = fvNetworkMap;
        this.print = new ViewPrintingHelper(component);
        this.export = new FunctExportTables(this.functionalNetworkDialog.getViewController(), this.print);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.menuBar.destroy();
        this.container = null;
    }
}

