/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.forms;

import COM.livingston.forms.LEAddDialog;
import COM.livingston.forms.LECmdErrorDialog;
import COM.livingston.forms.LEFormLine;
import COM.livingston.forms.LEFormLineFactory;
import COM.livingston.forms.LETableForm;
import COM.livingston.model.LEBGPPolicies;
import COM.livingston.model.LEBGPPolicy;
import COM.livingston.model.LEDataSpec;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LETable;
import COM.livingston.ui.LEErrorDialog;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEAlphaNumericCompare;
import COM.livingston.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEBGPPoliciesForm
extends LETableForm {
    String m_name;

    public void setContext(LEVector lEVector) {
        this.m_context = lEVector;
        this.m_tags.addElement("entry");
        this.m_cols = this.m_tags.size();
        this.initialize(1, 2, this.m_cols);
        this.setSortable(0, true);
        this.setSortable(1, true);
        this.setSortable(2, true);
        this.setSortObject(1, new LEAlphaNumericCompare());
        Object[] objectArray = new String[this.m_cols + 2];
        objectArray[0] = "PortMaster";
        objectArray[1] = "BGP Policy";
        objectArray[2] = "Rule Count";
        this.setTitles(0, objectArray);
    }

    void addEntry(String string, LETable lETable, String string2) {
        Object[] objectArray = new Object[this.m_cols + 2];
        objectArray[0] = string;
        objectArray[1] = string2;
        Object object = lETable.get(string2);
        if (object instanceof LEBGPPolicy) {
            LEBGPPolicy lEBGPPolicy = (LEBGPPolicy)object;
            objectArray[2] = Integer.toString(lEBGPPolicy.size());
        }
        this.addRow(objectArray);
    }

    boolean addNewEntry(LEDataSpec lEDataSpec, LEDataSpec lEDataSpec2) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Label label = new Label("BGP Policy Name:");
        label.setFont(LEFont.getBoldFont());
        panel.add("West", label);
        Component component = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec);
        panel.add("Center", component);
        LEAddDialog lEAddDialog = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add BGP Policy", panel);
        if (lEAddDialog.okay()) {
            this.m_name = ((LEFormLine)((Object)component)).getValue();
            if (this.m_name.length() > 0) {
                return true;
            }
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "A BGP policy name must be entered");
        }
        return false;
    }

    void addNewEntryTo(LEPortMaster lEPortMaster) {
        LEBGPPolicies lEBGPPolicies = (LEBGPPolicies)this.getTable(lEPortMaster);
        if (lEBGPPolicies.get(this.m_name) == null) {
            LEVector lEVector = lEBGPPolicies.add(this.m_name);
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConfigFacility(), lEVector);
            }
            this.addEntry(lEPortMaster.getHostname(), lEBGPPolicies, this.m_name);
            return;
        }
        new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(lEPortMaster.getHostname()) + " already contains a bgp policy named " + this.m_name);
    }

    void delete(LEPortMaster lEPortMaster, LETable lETable, String string) {
        if (!(lETable instanceof LEBGPPolicies)) {
            return;
        }
        LEBGPPolicies lEBGPPolicies = (LEBGPPolicies)lETable;
        LEVector lEVector = lEBGPPolicies.delete(string);
        if (lEVector != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConfigFacility(), lEVector);
        }
    }

    void pasteEntryTo(LEPortMaster lEPortMaster, Object object) {
        String string = this.getPasteKey(lEPortMaster, object);
        if (string == null) {
            return;
        }
        this.updateEntry(lEPortMaster.getHostname(), this.getTable(lEPortMaster), string);
    }

    String getPasteKey(LEPortMaster lEPortMaster, Object object) {
        String string;
        if (!(object instanceof LEBGPPolicy)) {
            return null;
        }
        LEBGPPolicy lEBGPPolicy = (LEBGPPolicy)object;
        LEBGPPolicies lEBGPPolicies = (LEBGPPolicies)this.getTable(lEPortMaster);
        if (lEBGPPolicies.get(string = lEBGPPolicy.getName()) != null) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(lEPortMaster.getHostname()) + " already contains a bgp policy named " + string);
            string = null;
        } else {
            LEVector lEVector = lEBGPPolicies.add(string);
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConfigFacility(), lEVector);
                string = null;
            }
        }
        return string;
    }
}

