/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.forms;

import COM.livingston.forms.LEAddDialog;
import COM.livingston.forms.LECmdErrorDialog;
import COM.livingston.forms.LEFormLine;
import COM.livingston.forms.LEFormLineFactory;
import COM.livingston.forms.LEIPSecSAsForm;
import COM.livingston.forms.LETableForm;
import COM.livingston.model.LEDataSpec;
import COM.livingston.model.LEIPIPSA;
import COM.livingston.model.LEIPIPSAs;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LESAs;
import COM.livingston.model.LETable;
import COM.livingston.ui.LEErrorDialog;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEIPIPSAsForm
extends LETableForm {
    String m_addName;

    boolean addNewEntry(LEDataSpec lEDataSpec, LEDataSpec lEDataSpec2) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Label label = new Label(String.valueOf(lEDataSpec.getDescription()) + ":");
        label.setFont(LEFont.getBoldFont());
        panel.add("West", label);
        Component component = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec);
        panel.add("Center", component);
        LEAddDialog lEAddDialog = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add IPIP SA", panel);
        if (lEAddDialog.okay()) {
            this.m_addName = ((LEFormLine)((Object)component)).getValue();
            if (this.m_addName.length() > 0) {
                return true;
            }
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "An SA name must be specified");
        }
        return false;
    }

    void addNewEntryTo(LEPortMaster lEPortMaster) {
        LESAs lESAs = (LESAs)lEPortMaster.get("2424832");
        if (lESAs.getSA(this.m_addName) == null) {
            LEIPIPSAs lEIPIPSAs = (LEIPIPSAs)this.getTable(lEPortMaster);
            LEVector lEVector = lEIPIPSAs.add(this.m_addName);
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConfigFacility(), lEVector);
            }
            this.addEntry(lEPortMaster.getHostname(), lEIPIPSAs, this.m_addName);
            return;
        }
        new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(lEPortMaster.getHostname()) + " already contains an SA named " + this.m_addName);
    }

    void delete(LEPortMaster lEPortMaster, LETable lETable, String string) {
        if (!(lETable instanceof LEIPIPSAs)) {
            return;
        }
        LEIPIPSAs lEIPIPSAs = (LEIPIPSAs)lETable;
        LEVector lEVector = lEIPIPSAs.delete(string);
        if (lEVector != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConfigFacility(), lEVector);
        }
    }

    String getPasteKey(LEPortMaster lEPortMaster, Object object) {
        LEVector lEVector;
        if (!(object instanceof LEIPIPSA)) {
            return null;
        }
        LEIPIPSA lEIPIPSA = (LEIPIPSA)object;
        LEIPIPSAs lEIPIPSAs = (LEIPIPSAs)this.getTable(lEPortMaster);
        String string = lEIPIPSA.getName();
        LESAs lESAs = (LESAs)lEPortMaster.get("2424832");
        if (lESAs.getSA(string) != null) {
            string = LEIPSecSAsForm.GetUniqueKey(lESAs, string, 8);
        }
        if ((lEVector = lEIPIPSAs.add(string)) != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConfigFacility(), lEVector);
            string = null;
        }
        return string;
    }
}

