/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.forms;

import COM.livingston.forms.LEAddDialog;
import COM.livingston.forms.LECmdErrorDialog;
import COM.livingston.forms.LEForm;
import COM.livingston.model.LEAttributes;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LEDataSpec;
import COM.livingston.model.LEDataSpecFactory;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LETable;
import COM.livingston.ui.LECompGrid;
import COM.livingston.ui.LEErrorDialog;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LEMultiList;
import COM.livingston.ui.LEStatusDialog;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEAlphaNumericCompare;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEObservable;
import COM.livingston.util.LEObserver;
import COM.livingston.util.LEVector;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Label;
import java.util.Hashtable;

public class LETableForm
extends LEMultiList
implements LEForm,
LEObserver {
    static final String PORTMASTER = "PortMaster";
    static final String BLANK = "";
    LEPortMaster[] m_pms;
    LEVector m_context;
    LEVector m_tags = new LEVector();
    Hashtable m_objs = new Hashtable();
    int m_cols;
    boolean m_keyReadonly;
    boolean m_simpleTable;

    public boolean isKeyReadonly() {
        return this.m_keyReadonly;
    }

    public void setContext(LEVector lEVector) {
        LEDataSpec lEDataSpec;
        this.m_context = lEVector;
        LEDataSpec lEDataSpec2 = null;
        String string = BLANK;
        try {
            lEDataSpec2 = LEDataSpecFactory.GetPortMasterSpec();
            int n = this.m_context.size();
            int n2 = 0;
            while (n2 < n) {
                lEDataSpec2 = lEDataSpec2.getSpecFor((String)this.m_context.elementAt(n2));
                ++n2;
            }
            LEDataSpec lEDataSpec3 = lEDataSpec2.getSpecFor("key");
            if (lEDataSpec3.getAttribute(LEAttributes.READONLY) != null) {
                this.m_keyReadonly = true;
            }
            string = lEDataSpec3.getDescription();
            LEVector lEVector2 = (lEDataSpec2 = lEDataSpec2.getSpecFor("entry")).getAllSpecs();
            if (lEVector2 == null) {
                this.m_tags.addElement("entry");
                this.m_simpleTable = true;
            } else {
                n = lEVector2.size();
                int n3 = 0;
                while (n3 < n) {
                    lEDataSpec = (LEDataSpec)lEVector2.elementAt(n3);
                    if (lEDataSpec.getAllSpecs() == null && lEDataSpec.getAttribute(LEAttributes.WRITEONLY) == null && lEDataSpec.getAttribute(LEAttributes.INVISIBLE) == null) {
                        this.m_tags.addElement(lEDataSpec.getTag());
                    }
                    ++n3;
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        this.m_cols = this.m_tags.size();
        this.initialize(1, 2, this.m_cols);
        this.setSortable(0, true);
        this.setSortable(1, true);
        this.setSortObject(1, new LEAlphaNumericCompare());
        Object[] objectArray = new String[this.m_cols + 2];
        objectArray[0] = PORTMASTER;
        objectArray[1] = string;
        int n = 0;
        while (n < this.m_cols) {
            if (this.m_simpleTable) {
                lEDataSpec = lEDataSpec2;
            } else {
                String string2 = (String)this.m_tags.elementAt(n);
                lEDataSpec = lEDataSpec2.getSpecFor(string2);
            }
            objectArray[n + 2] = lEDataSpec.getDescription();
            this.setSortable(n + 2, true);
            ++n;
        }
        this.setTitles(0, objectArray);
    }

    public void setPortMasters(LEPortMaster[] lEPortMasterArray) {
        int n;
        boolean bl;
        int n2;
        if (this.m_pms != null) {
            n2 = 0;
            while (n2 < this.m_pms.length) {
                bl = false;
                n = 0;
                while (!bl && n < lEPortMasterArray.length) {
                    if (this.m_pms[n2] == lEPortMasterArray[n]) {
                        bl = true;
                    }
                    ++n;
                }
                if (!bl) {
                    this.removePortMaster(this.m_pms[n2]);
                }
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < lEPortMasterArray.length) {
            bl = false;
            if (this.m_pms != null) {
                n = 0;
                while (!bl && n < this.m_pms.length) {
                    if (lEPortMasterArray[n2] == this.m_pms[n]) {
                        bl = true;
                    }
                    ++n;
                }
            }
            if (!bl) {
                this.addPortMaster(lEPortMasterArray[n2]);
            }
            ++n2;
        }
        this.m_pms = lEPortMasterArray;
        this.repaint();
    }

    public Object getEntry(int n) {
        LETable lETable;
        Object object = null;
        LEPortMaster lEPortMaster = this.getPortMaster(n);
        if (lEPortMaster != null && (lETable = this.getTable(lEPortMaster)) != null) {
            String string = (String)this.getCellItem(n, 1);
            object = lETable.get(string);
        }
        return object;
    }

    public LETable getTable(String string) {
        LETable lETable = null;
        int n = 0;
        while (lETable == null && n < this.m_pms.length) {
            if (string.equals(this.m_pms[n].getHostname())) {
                lETable = this.getTable(this.m_pms[n]);
            }
            ++n;
        }
        return lETable;
    }

    public boolean isSimpleTable() {
        return this.m_simpleTable;
    }

    public void refresh() {
        LEStatusDialog lEStatusDialog = new LEStatusDialog(LEUiUtils.GetBaseFrame());
        int n = 0;
        while (n < this.m_pms.length) {
            this.removePortMaster(this.m_pms[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.m_pms.length) {
            LETable lETable = this.getTable(this.m_pms[n2]);
            if (lETable != null) {
                lETable.refresh();
            }
            this.addPortMaster(this.m_pms[n2]);
            ++n2;
        }
        lEStatusDialog.hideStatus();
    }

    public void gone() {
        int n = 0;
        while (n < this.m_pms.length) {
            this.removePortMaster(this.m_pms[n]);
            ++n;
        }
    }

    public void add() {
        if (LEAppInfo.DemoMode()) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "This feature is disabled in demo mode.");
            return;
        }
        int n = 0;
        LEDataSpec lEDataSpec = null;
        LEDataSpec lEDataSpec2 = null;
        int n2 = 0;
        while (n2 < this.m_pms.length) {
            LETable lETable = this.getTable(this.m_pms[n2]);
            if (lETable != null) {
                ++n;
                if (lEDataSpec == null) {
                    lEDataSpec = lETable.getKeySpec();
                }
                if (lEDataSpec2 == null) {
                    lEDataSpec2 = lETable.getSpecFor("entry");
                }
            }
            ++n2;
        }
        if (n == 0) {
            return;
        }
        if (!this.addNewEntry(lEDataSpec, lEDataSpec2)) {
            return;
        }
        LEVector lEVector = this.determinePMs("Add");
        if (lEVector != null) {
            LEStatusDialog lEStatusDialog = new LEStatusDialog(LEUiUtils.GetBaseFrame());
            int n3 = lEVector.size();
            int n4 = 0;
            while (n4 < n3) {
                this.addNewEntryTo((LEPortMaster)lEVector.elementAt(n4));
                ++n4;
            }
            lEStatusDialog.hideStatus();
            this.layoutGrid();
        }
    }

    public void delete() {
        if (LEAppInfo.DemoMode()) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "This feature is disabled in demo mode.");
            return;
        }
        LEStatusDialog lEStatusDialog = new LEStatusDialog(LEUiUtils.GetBaseFrame());
        int[] nArray = this.getSelectedRows();
        int n = nArray.length - 1;
        while (n > -1) {
            LEPortMaster lEPortMaster = this.getPortMaster(nArray[n]);
            String string = (String)this.getCellItem(nArray[n], 1);
            LETable lETable = this.getTable(lEPortMaster);
            this.delete(lEPortMaster, lETable, string);
            --n;
        }
        int n2 = 0;
        while (n2 < this.m_pms.length) {
            this.removePortMaster(this.m_pms[n2]);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.m_pms.length) {
            this.addPortMaster(this.m_pms[n3]);
            ++n3;
        }
        lEStatusDialog.hideStatus();
    }

    public void paste(Object object) {
        if (LEAppInfo.DemoMode()) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "This feature is disabled in demo mode.");
            return;
        }
        LEVector lEVector = this.determinePMs("Paste");
        LEStatusDialog lEStatusDialog = new LEStatusDialog(LEUiUtils.GetBaseFrame());
        int n = lEVector.size();
        int n2 = 0;
        while (n2 < n) {
            this.pasteTo((LEPortMaster)lEVector.elementAt(n2), object);
            ++n2;
        }
        lEStatusDialog.hideStatus();
        this.layoutGrid();
    }

    public void clone(Object object) {
        if (LEAppInfo.DemoMode()) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "This feature is disabled in demo mode.");
            return;
        }
        if (!(object instanceof LEConfig)) {
            return;
        }
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        LEStatusDialog lEStatusDialog = new LEStatusDialog(LEUiUtils.GetBaseFrame());
        LEConfig lEConfig = (LEConfig)object;
        int n = 0;
        while (n < nArray.length) {
            LEConfig lEConfig2 = (LEConfig)this.getEntry(nArray[n]);
            if (lEConfig2 != null) {
                LEConfigFacility lEConfigFacility = lEConfig2.getConfigFacility();
                lEConfig2.copy(lEConfig);
                LEVector lEVector = lEConfig2.saveChanges();
                if (lEVector != null) {
                    new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEConfigFacility, lEVector);
                }
                this.updateEntry(lEConfigFacility.getDescription(), (LETable)lEConfig2.getOwner(), (String)this.getCellItem(nArray[n], 1));
            }
            ++n;
        }
        lEStatusDialog.hideStatus();
    }

    public void update(LEObservable lEObservable, Object object) {
        String string = (String)this.m_objs.get(lEObservable);
        if (string == null) {
            return;
        }
        LETable lETable = (LETable)((LEConfig)lEObservable).getOwner();
        String string2 = lETable.getConfigFacility().getDescription();
        this.updateEntry(string2, lETable, string);
    }

    LEPortMaster getPortMaster(int n) {
        LEPortMaster lEPortMaster = null;
        String string = (String)this.getCellItem(n, 0);
        int n2 = 0;
        while (lEPortMaster == null && n2 < this.m_pms.length) {
            if (string.equals(this.m_pms[n2].getHostname())) {
                lEPortMaster = this.m_pms[n2];
            }
            ++n2;
        }
        return lEPortMaster;
    }

    void addPortMaster(LEPortMaster lEPortMaster) {
        LETable lETable = this.getTable(lEPortMaster);
        if (lETable != null) {
            LEVector lEVector = lETable.getKeys();
            String string = lEPortMaster.getHostname();
            int n = lEVector.size();
            int n2 = 0;
            while (n2 < n) {
                String string2 = (String)lEVector.elementAt(n2);
                this.addEntry(string, lETable, string2);
                ++n2;
            }
        }
    }

    void addEntry(String string, LETable lETable, String string2) {
        Object object = lETable.get(string2);
        if (object == null) {
            return;
        }
        Object[] objectArray = new Object[this.m_cols + 2];
        objectArray[0] = string;
        objectArray[1] = string2;
        if (this.m_cols > 0) {
            if (object instanceof LEConfig) {
                LEConfig lEConfig = (LEConfig)object;
                lEConfig.addObserver(this);
                this.m_objs.put(lEConfig, string2);
                int n = this.m_tags.size();
                int n2 = 0;
                while (n2 < n) {
                    String string3 = (String)this.m_tags.elementAt(n2);
                    object = lEConfig.get(string3);
                    objectArray[n2 + 2] = object == null ? BLANK : object.toString();
                    ++n2;
                }
            } else {
                objectArray[2] = object.toString();
            }
        }
        this.addRow(objectArray);
    }

    void updateEntry(String string, LETable lETable, String string2) {
        Object object = lETable.get(string2);
        if (object == null || this.m_cols == 0) {
            return;
        }
        int n = this.getNumRows();
        int n2 = -1;
        int n3 = 0;
        while (n2 == -1 && n3 < n) {
            String string3 = (String)this.getCellItem(n3, 0);
            String string4 = (String)this.getCellItem(n3, 1);
            if (string3.equals(string) && string4.equals(string2)) {
                n2 = n3;
            }
            ++n3;
        }
        if (n2 > -1) {
            if (object instanceof LEConfig) {
                LEConfig lEConfig = (LEConfig)object;
                int n4 = this.m_tags.size();
                int n5 = 0;
                while (n5 < n4) {
                    String string5 = (String)this.m_tags.elementAt(n5);
                    object = lEConfig.get(string5);
                    if (object == null) {
                        this.setCellItem(n2, n5 + 2, BLANK);
                    } else {
                        this.setCellItem(n2, n5 + 2, object);
                    }
                    ++n5;
                }
                return;
            }
            this.setCellItem(n2, 2, object);
            return;
        }
        this.addEntry(string, lETable, string2);
    }

    synchronized void removePortMaster(LEPortMaster lEPortMaster) {
        LETable lETable = this.getTable(lEPortMaster);
        if (lETable == null) {
            return;
        }
        String string = lEPortMaster.getHostname();
        int n = this.getNumRows();
        int n2 = n - 1;
        while (n2 > -1) {
            String string2 = (String)this.getCellItem(n2, 0);
            if (string2.equals(string)) {
                String string3 = (String)this.getCellItem(n2, 1);
                Object object = lETable.get(string3);
                if (object instanceof LEConfig) {
                    ((LEConfig)object).deleteObserver(this);
                    this.m_objs.remove(object);
                }
                this.deleteRow(n2);
            }
            --n2;
        }
    }

    LETable getTable(LEPortMaster lEPortMaster) {
        LETable lETable = null;
        LEConfig lEConfig = lEPortMaster;
        int n = this.m_context.size();
        int n2 = 0;
        while (lEConfig != null && n2 < n) {
            Object object = ((LEConfig)lEConfig).get((String)this.m_context.elementAt(n2));
            lEConfig = object instanceof LEConfig ? (LEConfig)object : null;
            ++n2;
        }
        if (lEConfig instanceof LETable) {
            lETable = (LETable)lEConfig;
        }
        return lETable;
    }

    LEVector determinePMs(String string) {
        LEVector lEVector = new LEVector();
        String string2 = null;
        int n = 0;
        while (n < this.m_pms.length) {
            LETable lETable = this.getTable(this.m_pms[n]);
            if (lETable != null) {
                lEVector.addElement(this.m_pms[n]);
                if (string2 == null) {
                    LEDataSpec lEDataSpec = lETable.getSpecFor("entry");
                    string2 = lEDataSpec.getDescription();
                }
            }
            ++n;
        }
        int n2 = lEVector.size();
        if (n2 > 1) {
            Component[][] componentArray = new Component[n2][2];
            componentArray[0][0] = new Label(String.valueOf(string) + " " + string2 + " to:");
            componentArray[0][0].setFont(LEFont.getBoldFont());
            int n3 = 0;
            while (n3 < n2) {
                componentArray[n3][1] = new Checkbox(((LEPortMaster)lEVector.elementAt(n3)).getHostname(), true, null);
                ++n3;
            }
            LEAddDialog lEAddDialog = new LEAddDialog(LEUiUtils.GetBaseFrame(), String.valueOf(string) + " " + string2, new LECompGrid(componentArray, 2, false));
            if (lEAddDialog.okay()) {
                int n4 = n2 - 1;
                while (n4 > -1) {
                    if (!((Checkbox)componentArray[n4][1]).getState()) {
                        lEVector.removeElementAt(n4);
                    }
                    --n4;
                }
                if (lEVector.size() == 0) {
                    lEVector = null;
                }
            } else {
                lEVector = null;
            }
        } else if (n2 == 0) {
            lEVector = null;
        }
        return lEVector;
    }

    void pasteTo(LEPortMaster lEPortMaster, Object object) {
        if (object instanceof LEVector) {
            LEVector lEVector = (LEVector)object;
            int n = lEVector.size();
            int n2 = 0;
            while (n2 < n) {
                this.pasteEntryTo(lEPortMaster, lEVector.elementAt(n2));
                ++n2;
            }
            return;
        }
        this.pasteEntryTo(lEPortMaster, object);
    }

    void pasteEntryTo(LEPortMaster lEPortMaster, Object object) {
        String string = this.getPasteKey(lEPortMaster, object);
        if (string == null) {
            return;
        }
        LETable lETable = this.getTable(lEPortMaster);
        Object object2 = lETable.get(string);
        if (object2 instanceof LEConfig) {
            LEConfig lEConfig = (LEConfig)object;
            LEConfig lEConfig2 = (LEConfig)object2;
            lEConfig2.copy(lEConfig);
            lEConfig2.setConfigFacility(lEPortMaster.getConfigFacility());
            LEVector lEVector = lEConfig2.saveChanges();
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConfigFacility(), lEVector);
            }
        }
        this.updateEntry(lEPortMaster.getHostname(), lETable, string);
    }

    String getPasteKey(LEPortMaster lEPortMaster, Object object) {
        return null;
    }

    boolean addNewEntry(LEDataSpec lEDataSpec, LEDataSpec lEDataSpec2) {
        return false;
    }

    void addNewEntryTo(LEPortMaster lEPortMaster) {
    }

    void delete(LEPortMaster lEPortMaster, LETable lETable, String string) {
    }

    static String GetUniqueKey(LETable lETable, String string, int n) {
        boolean bl = false;
        int n2 = 1;
        String string2 = string;
        while (!bl) {
            String string3 = Integer.toString(n2);
            if (string.length() + string3.length() > n) {
                string = string.substring(0, n - string3.length());
            }
            if (lETable.get(string2 = String.valueOf(string) + string3) == null) {
                bl = true;
                continue;
            }
            ++n2;
        }
        return string2;
    }
}

