/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEAttributes;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LEDataSpec;
import COM.livingston.model.LEEthernets;
import COM.livingston.model.LELines;
import COM.livingston.model.LEModems;
import COM.livingston.model.LEPorts;
import COM.livingston.util.LEVector;

public class LEBoard
extends LEConfig {
    public static final String ASSIGNED_ADDR = Integer.toString(164);
    public static final String ASSIGNED_POOL = Integer.toString(165);
    public static final String BOARD_TYPE = Integer.toString(272);
    public static final String ETHERNETS = Integer.toString(720896);
    public static final String PRI_SWITCH = Integer.toString(172);
    public static final String LINES = Integer.toString(131072);
    public static final String MODEMS = Integer.toString(196608);
    public static final String OS_VERSION = Integer.toString(276);
    public static final String PORTS = Integer.toString(262144);
    public static final String POWER = Integer.toString(279);
    public static final String SERIAL_NUMBER = Integer.toString(273);
    public static final String SLOT = Integer.toString(274);
    public static final int KEY_COUNT = 12;
    public static final String ETHERNET = "Ethernet";
    public static final String PRESENT = "Present";
    public static final String QUAD_T1 = "Quad T1";
    public static final String TRI_E1 = "Tri E1";
    public static final String SYSTEM_MANAGER = "System Manager";
    public static final String UNKNOWN = "Unknown";
    public static final String BOOTING = "booting";
    public static final String SYSTEM_MANAGER_ID = "4";
    public static final String ETHERNET_DAUGHTER_ID = "10";
    public static final String SET_MGR_VIEW = "set view 4";
    static String[] s_keys = null;
    String m_name;
    boolean m_reboot;
    LEDataSpec m_powerSpec;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[12];
            int i = 0;
            LEBoard.s_keys[i++] = ASSIGNED_ADDR;
            LEBoard.s_keys[i++] = ASSIGNED_POOL;
            LEBoard.s_keys[i++] = BOARD_TYPE;
            LEBoard.s_keys[i++] = ETHERNETS;
            LEBoard.s_keys[i++] = PRI_SWITCH;
            LEBoard.s_keys[i++] = LINES;
            LEBoard.s_keys[i++] = MODEMS;
            LEBoard.s_keys[i++] = OS_VERSION;
            LEBoard.s_keys[i++] = PORTS;
            LEBoard.s_keys[i++] = POWER;
            LEBoard.s_keys[i++] = SERIAL_NUMBER;
            LEBoard.s_keys[i++] = SLOT;
        }
        return s_keys;
    }

    public LEBoard(LEConfigFacility facility, String name) {
        super(facility);
        this.m_name = name;
        this.m_board = name;
    }

    public Object clone() {
        LEBoard config = new LEBoard(this.m_facility, this.m_name);
        config.copy(this);
        return config;
    }

    public LEDataSpec getSpecFor(String key) {
        LEDataSpec spec = super.getSpecFor(key);
        if (spec != null && key.equals(POWER) && (this.m_board.equals(SYSTEM_MANAGER_ID) || this.m_board.equals(ETHERNET_DAUGHTER_ID))) {
            if (this.m_powerSpec == null) {
                this.m_powerSpec = (LEDataSpec)spec.clone();
                this.m_powerSpec.addAttribute(LEAttributes.READONLY, "");
            }
            spec = this.m_powerSpec;
        }
        return spec;
    }

    public String getType() {
        String type = (String)this.get(BOARD_TYPE);
        if (type == null) {
            type = "";
        }
        return type;
    }

    public String getStatus() {
        String type = this.getType();
        String power = (String)this.get(POWER);
        if (power == null) {
            return "";
        }
        if (type.equals(PRESENT) && power.equals("on")) {
            return BOOTING;
        }
        return power;
    }

    LEConfig createConfig(String key) {
        if (key.equals(PORTS)) {
            return new LEPorts(this.m_facility, this.m_name, PORTS);
        }
        if (key.equals(LINES)) {
            return new LELines(this.m_facility, this.m_name, LINES);
        }
        if (key.equals(ETHERNETS)) {
            return new LEEthernets(this.m_facility, this.m_name, ETHERNETS);
        }
        if (key.equals(MODEMS)) {
            return new LEModems(this.m_facility, this.m_name, MODEMS);
        }
        return new LEConfig(this.m_facility);
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        boolean allCmds = keys == null;
        int start = cmds.size();
        if (allCmds || keys.contains(POWER)) {
            String slot = (String)this.get(SLOT);
            String power = (String)this.get(POWER);
            if (slot != null && power != null) {
                cmds.addElement(SET_MGR_VIEW);
                StringBuffer buf = new StringBuffer(14);
                buf.append("set ");
                buf.append("slot");
                buf.append(slot);
                buf.append(" ");
                buf.append(power);
                cmds.addElement(buf.toString());
            }
        }
        if (allCmds || keys.contains(ASSIGNED_ADDR)) {
            this.makeSetCommand(cmds, null, ASSIGNED_ADDR, "assigned_address");
        }
        if (allCmds || keys.contains(ASSIGNED_POOL)) {
            this.makeSetCommand(cmds, null, ASSIGNED_POOL, "pool");
        }
        if (allCmds || keys.contains(PRI_SWITCH)) {
            this.makeSetCommand(cmds, null, PRI_SWITCH, "isdn-switch");
        }
        return cmds.size() > start;
    }
}

