/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEFilter;
import COM.livingston.model.LEFilterFileParser;
import COM.livingston.model.LEFilterRules;
import COM.livingston.model.LEFilters;
import COM.livingston.model.LEIPRule;
import COM.livingston.model.LEIPRules;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEVector;
import java.util.StringTokenizer;

public class LEChoiceNetFilterParser
extends LEFilterFileParser {
    LEFilters m_filters = new LEFilters(null);
    LEFilter m_filter;
    String m_filtername;

    public LEChoiceNetFilterParser(String filtername) {
        this.m_filter = new LEFilter(null, filtername);
        this.m_filter.initialize();
        this.m_filters.set(filtername, this.m_filter);
        this.m_filtername = filtername;
    }

    public void readFilters(LEVector cmds) {
        int len = cmds.size();
        try {
            int i = 0;
            while (i < len) {
                String line = (String)cmds.elementAt(i);
                if (!line.startsWith("#") && line.length() >= 3) {
                    if (line.regionMatches(true, 0, "deny", 0, 4)) {
                        this.parseRule(line);
                    } else if (line.regionMatches(true, 0, "permit", 0, 6)) {
                        this.parseRule(line);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    public LEFilter getFilter() {
        return this.m_filter;
    }

    public static LEVector WriteFilter(LEFilter filter) {
        LEVector cmds = new LEVector();
        LEVector output = new LEVector();
        LEIPRules rules = (LEIPRules)filter.get("ip_rule");
        rules.getCommands(cmds);
        int len = cmds.size();
        int i = 0;
        while (i < len) {
            int chop = 0;
            int j = 0;
            String pmrule = (String)cmds.elementAt(i);
            while (j < 4 && chop != -1) {
                chop = pmrule.indexOf(32, chop + 1);
                ++j;
            }
            if (chop != -1) {
                String choicerule = pmrule.substring(chop + 1);
                output.add(choicerule);
            }
            ++i;
        }
        return output;
    }

    protected void parseRule(String rule) {
        StringTokenizer tokenizer = new StringTokenizer(rule);
        try {
            LEIPRules rules;
            LEFilterRules filter_rules = (LEFilterRules)this.m_filter.get("ip_rule");
            int rulenumber = filter_rules.size() + 1;
            LEIPRule iprule = new LEIPRule(null, this.m_filtername, Integer.toString(rulenumber));
            this.parseIPRule(iprule, tokenizer);
            if (this.m_filter != null && (rules = (LEIPRules)this.m_filter.getConfig("ip_rule")) != null) {
                rules.setField(Integer.toString(rulenumber), iprule);
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }
}

