/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.ui.LEBorderPanel;
import COM.livingston.ui.LECompGrid;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LEImageView;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEResource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;

public class LEAboutPanel
extends Panel {
    public LEAboutPanel() {
        this.setLayout(new BorderLayout(5, 5));
        this.add("North", this.buildTopPanel());
        this.add("Center", this.buildMainPanel());
    }

    Component buildTopPanel() {
        LEBorderPanel b1 = new LEBorderPanel(3);
        LEBorderPanel b2 = new LEBorderPanel(2);
        b1.setLayout(new BorderLayout(0, 0));
        b2.setLayout(new BorderLayout(0, 0));
        LEImageView iv = new LEImageView(LEResource.GetImage("lucent.gif"), 4);
        iv.setBackground(Color.white);
        b2.add("Center", iv);
        b1.add("Center", b2);
        return b1;
    }

    Component buildMainPanel() {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(0, 0));
        Font font = new Font("TimesRoman", 1, 36);
        Label lbl = new Label(LEAppInfo.getAppTitle(), 1);
        lbl.setFont(font);
        Panel sub = new Panel();
        sub.setLayout(new BorderLayout(0, 0));
        sub.add("North", lbl);
        lbl = new Label("(c) 1998 Lucent Technologies, Inc. All rights reserved.", 1);
        sub.add("South", lbl);
        panel.add("North", sub);
        sub = new Panel();
        sub.setLayout(new FlowLayout(1));
        Component[][] comps = new Component[3][2];
        comps[0][0] = new Label("Build Date:");
        comps[1][0] = new Label("Debug Level:");
        comps[2][0] = new Label("Debug Log:");
        comps[0][0].setFont(LEFont.getBoldFont());
        comps[1][0].setFont(LEFont.getBoldFont());
        comps[2][0].setFont(LEFont.getBoldFont());
        comps[0][1] = new Label(LEAppInfo.GetBuildDate(), 0);
        int level = LEDebug.getLog().getLogLevel();
        comps[1][1] = level >= 40 ? new Label("Verbose", 0) : (level >= 30 ? new Label("Debug", 0) : (level >= 20 ? new Label("Errors Only", 0) : (level >= 0 ? new Label("Fatal Errors Only", 0) : new Label("No Debugging", 0))));
        String path = LEAppInfo.getUserAppDirPath("debuglog.txt");
        comps[2][1] = new Label(path, 0);
        LECompGrid grid = new LECompGrid(comps, 0, false);
        sub = new Panel();
        sub.setLayout(new FlowLayout(1));
        sub.add(grid);
        panel.add("Center", sub);
        return panel;
    }
}

