/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.ui.LEActionClient;
import COM.livingston.ui.LEBusyPanel;
import COM.livingston.ui.LEStatusBar;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEStatusManager;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class LEActionDialog
extends Dialog
implements Runnable,
ActionListener {
    LEStatusBar m_statusBar;
    Button m_cancel;
    LEActionClient m_client;
    LEBusyPanel m_busy;

    public LEActionDialog(Frame parent, String title, LEActionClient client, LEStatusManager manager) {
        this(parent, title, client, manager, false);
    }

    public LEActionDialog(Frame parent, String title, LEActionClient client, LEStatusManager manager, boolean modal) {
        super(parent, modal);
        this.setLayout(new BorderLayout(0, 0));
        this.m_statusBar = new LEStatusBar(0, 1, manager);
        this.m_statusBar.setCursor(Cursor.getPredefinedCursor(3));
        this.add("Center", this.m_statusBar);
        Panel bottomPanel = new Panel(new BorderLayout(0, 0));
        this.m_busy = new LEBusyPanel(0);
        this.m_busy.setCursor(Cursor.getPredefinedCursor(3));
        bottomPanel.add("East", this.m_busy);
        Panel btnPanel = new Panel();
        btnPanel.setLayout(new FlowLayout(1, 0, 0));
        this.m_cancel = new Button("Cancel");
        this.m_cancel.setCursor(Cursor.getPredefinedCursor(0));
        this.m_cancel.addActionListener(this);
        btnPanel.add(this.m_cancel);
        bottomPanel.add("Center", btnPanel);
        this.add("South", bottomPanel);
        this.setTitle(title);
        this.m_client = client;
    }

    public void addNotify() {
        super.addNotify();
        Insets insets = this.getInsets();
        LEUiUtils.CenterDialog(this, 300 + insets.left + insets.right, 100 + insets.top + insets.bottom);
    }

    public void run() {
        if (this.m_client != null) {
            this.m_busy.start();
            this.m_client.actionStart(this);
        }
        this.dispose();
        if (this.m_client != null) {
            this.m_busy.stop();
            this.m_statusBar.stop();
            this.m_client.actionDone(this);
        }
    }

    public LEStatusBar getStatusBar() {
        return this.m_statusBar;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.m_client != null) {
            this.m_client.actionCancel(this);
        }
        this.m_client = null;
        this.m_busy.stop();
        this.m_statusBar.stop();
        ((Component)this).setVisible(false);
    }
}

