/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;

public class LEBorderPanel
extends Panel {
    public static final int BORDER_NONE = 0;
    public static final int BORDER_LINE = 1;
    public static final int BORDER_INSET = 2;
    public static final int BORDER_RAISED = 3;
    public static final int BORDER_ETCHED = 4;
    static final int DEFAULT_INSET = 3;
    int m_border;
    int m_borderWidth;
    Insets m_insets = new Insets(3, 3, 3, 3);

    public LEBorderPanel() {
        this.setBorder(0);
    }

    public LEBorderPanel(int border) {
        this.setBorder(border);
    }

    public void setBorderType(int border) {
        this.setBorder(border);
        this.invalidate();
        this.validate();
    }

    public void setInsets(int top, int left, int bottom, int right) {
        this.m_insets = new Insets(top, left, bottom, right);
    }

    public Insets getInsets() {
        return new Insets(this.m_insets.top + this.m_borderWidth, this.m_insets.left + this.m_borderWidth, this.m_insets.bottom + this.m_borderWidth, this.m_insets.right + this.m_borderWidth);
    }

    public void paint(Graphics gc) {
        super.paint(gc);
        Color light = this.getBackground().brighter();
        Color dark = Color.black;
        Dimension size = this.getSize();
        int x1 = 0;
        int y1 = 0;
        int x2 = size.width - 1;
        int y2 = size.height - 1;
        switch (this.m_border) {
            case 2: {
                gc.setColor(light);
                gc.drawLine(x1, y2, x2, y2);
                gc.drawLine(x2, y1, x2, y2);
                gc.setColor(dark);
                gc.drawLine(x1, y1, x2, y1);
                gc.drawLine(x1, y1, x1, y2);
                break;
            }
            case 3: {
                gc.setColor(dark);
                gc.drawLine(x1, y2, x2, y2);
                gc.drawLine(x2, y1, x2, y2);
                gc.setColor(light);
                gc.drawLine(x1, y1, x2, y1);
                gc.drawLine(x1, y1, x1, y2);
                break;
            }
            case 4: {
                gc.setColor(dark);
                gc.drawLine(x1, y1, x2, y1);
                gc.drawLine(x1, y1, x1, y2);
                gc.drawLine(x1 + 2, y2 - 1, x2 - 1, y2 - 1);
                gc.drawLine(x2 - 1, y1 - 2, x2 - 1, y2 - 1);
                gc.setColor(light);
                gc.drawRect(x1 + 1, y1 + 1, x2 - x1 - 1, y2 - y1 - 1);
                break;
            }
            case 1: {
                gc.setColor(dark);
                gc.drawRect(x1, y1, x2 - x1, y2 - y1);
                break;
            }
        }
    }

    void setBorder(int border) {
        this.m_border = border;
        switch (this.m_border) {
            case 2: 
            case 3: {
                this.m_borderWidth = 1;
                break;
            }
            case 4: {
                this.m_borderWidth = 2;
            }
            default: {
                this.m_borderWidth = 0;
            }
        }
    }
}

