/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.util.LEDebug;
import COM.livingston.util.LEObservable;
import java.awt.Component;
import java.awt.Container;
import java.awt.MenuItem;
import java.awt.TextComponent;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

public class LEClipboard
extends LEObservable
implements ActionListener,
FocusListener,
ContainerListener {
    public static final Integer CUT = new Integer(1);
    public static final Integer COPY = new Integer(2);
    public static final Integer PASTE = new Integer(3);
    public static final Integer DELETE = new Integer(4);
    public static final Integer CONTENT = new Integer(5);
    public static final String ACTION_CUT = new String("cut");
    public static final String ACTION_COPY = new String("copy");
    public static final String ACTION_PASTE = new String("paste");
    public static final String ACTION_DELETE = new String("delete");
    static LEClipboard s_clipboard = null;
    MenuItem m_cut;
    MenuItem m_copy;
    MenuItem m_paste;
    MenuItem m_delete;
    boolean m_cutable;
    boolean m_copyable;
    boolean m_pasteable;
    boolean m_deleteable;
    TextComponent m_text;
    Object m_contents;

    public static LEClipboard GetClipboard() {
        if (s_clipboard == null) {
            s_clipboard = new LEClipboard();
        }
        return s_clipboard;
    }

    public Object getContents() {
        return this.m_contents;
    }

    public void watchContainer(Container container) {
        container.addContainerListener(this);
    }

    public void setMenuItems(MenuItem cut, MenuItem copy, MenuItem paste, MenuItem delete) {
        this.m_cut = cut;
        this.m_copy = copy;
        this.m_paste = paste;
        this.m_delete = delete;
        this.m_cut.setActionCommand(ACTION_CUT);
        this.m_copy.setActionCommand(ACTION_COPY);
        this.m_paste.setActionCommand(ACTION_PASTE);
        this.m_delete.setActionCommand(ACTION_DELETE);
        this.m_cut.addActionListener(this);
        this.m_copy.addActionListener(this);
        this.m_paste.addActionListener(this);
        this.m_delete.addActionListener(this);
    }

    public void setState(boolean cut, boolean copy, boolean paste, boolean delete) {
        this.setCut(cut);
        this.setCopy(copy);
        this.setPaste(paste);
        this.setDelete(delete);
    }

    public void setCut(boolean flag) {
        this.m_cutable = flag;
        if (this.m_cut != null) {
            this.m_cut.setEnabled(this.m_cutable);
        }
    }

    public void setCopy(boolean flag) {
        this.m_copyable = flag;
        if (this.m_copy != null) {
            this.m_copy.setEnabled(this.m_copyable);
        }
    }

    public void setPaste(boolean flag) {
        this.m_pasteable = flag;
        if (this.m_paste != null) {
            this.m_paste.setEnabled(this.m_pasteable);
        }
    }

    public void setDelete(boolean flag) {
        this.m_deleteable = flag;
        if (this.m_delete != null) {
            this.m_delete.setEnabled(this.m_deleteable);
        }
    }

    public void reset() {
        if (this.m_cut != null) {
            this.m_cut.setEnabled(false);
        }
        if (this.m_copy != null) {
            this.m_copy.setEnabled(false);
        }
        if (this.m_paste != null) {
            this.m_paste.setEnabled(false);
        }
        if (this.m_delete != null) {
            this.m_delete.setEnabled(false);
        }
    }

    public void setContents(Object contents) {
        this.m_contents = contents;
        this.notifyObservers(CONTENT);
    }

    public void watch(Component comp) {
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            int count = cont.getComponentCount();
            int i = 0;
            while (i < count) {
                this.watch(cont.getComponent(i));
                ++i;
            }
        } else if (comp instanceof TextComponent) {
            comp.addFocusListener(this);
        }
    }

    public void forget(Component comp) {
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            int count = cont.getComponentCount();
            int i = 0;
            while (i < count) {
                this.forget(cont.getComponent(i));
                ++i;
            }
        } else if (comp instanceof TextComponent) {
            comp.removeFocusListener(this);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(ACTION_CUT)) {
            if (this.m_text != null) {
                this.cutText();
            } else {
                this.notifyObservers(CUT);
            }
        } else if (cmd.equals(ACTION_COPY)) {
            if (this.m_text != null) {
                this.copyText();
            } else {
                this.notifyObservers(COPY);
            }
        } else if (cmd.equals(ACTION_PASTE)) {
            if (this.m_text != null) {
                this.pasteText();
            } else {
                this.notifyObservers(PASTE);
            }
        } else if (cmd.equals(ACTION_DELETE)) {
            if (this.m_text != null) {
                this.deleteText();
            } else {
                this.notifyObservers(DELETE);
            }
        }
    }

    public void componentAdded(ContainerEvent event) {
        this.m_text = null;
        this.watch(event.getChild());
    }

    public void componentRemoved(ContainerEvent event) {
        this.forget(event.getChild());
        this.m_text = null;
    }

    public void focusGained(FocusEvent event) {
        this.m_text = (TextComponent)event.getSource();
        this.setState(true, true, true, true);
    }

    public void focusLost(FocusEvent event) {
        this.reset();
        this.m_text = null;
    }

    void cutText() {
        String text = this.m_text.getSelectedText();
        StringSelection selection = new StringSelection(text);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
        this.deleteSelection(this.m_text);
    }

    void copyText() {
        String text = this.m_text.getSelectedText();
        StringSelection selection = new StringSelection(text);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
    }

    void deleteText() {
        this.deleteSelection(this.m_text);
    }

    void pasteText() {
        Transferable data = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
        try {
            String str = (String)data.getTransferData(DataFlavor.stringFlavor);
            this.pasteSelection(this.m_text, str);
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    void deleteSelection(TextComponent comp) {
        int start = comp.getSelectionStart();
        int end = comp.getSelectionEnd();
        if (end > start) {
            String text = comp.getText();
            String newText = String.valueOf(text.substring(0, start)) + text.substring(end);
            comp.setText(newText);
        }
    }

    void pasteSelection(TextComponent comp, String paste) {
        int start = comp.getSelectionStart();
        int end = comp.getSelectionEnd();
        String text = comp.getText();
        String newText = String.valueOf(text.substring(0, start)) + paste + text.substring(end);
        comp.setText(newText);
    }
}

