/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEProperties;
import java.awt.Color;
import java.util.Hashtable;

public class LEColor {
    public static final String SELECT_BACKGROUND_FLAG = "-sb";
    public static final String SELECT_FOREGROUND_FLAG = "-sf";
    public static final String BLACK = "Black";
    public static final String BLUE = "Blue";
    public static final String CYAN = "Cyan";
    public static final String DARK_GRAY = "Dark Gray";
    public static final String GRAY = "Gray";
    public static final String GREEN = "Green";
    public static final String LIGHT_GRAY = "Light Gray";
    public static final String MAGENTA = "Magenta";
    public static final String ORANGE = "Orange";
    public static final String PINK = "Pink";
    public static final String RED = "Red";
    public static final String WHITE = "White";
    public static final String YELLOW = "Yellow";
    static Color m_background;
    static Color m_foreground;
    static Color m_shadowDark;
    static Color m_shadowLight;
    static Color m_selectBackground;
    static Color m_selectForeground;
    static Color m_selectShadowDark;
    static Color m_selectShadowLight;
    static Color m_textBackground;
    static Hashtable s_colorToName;
    static Hashtable s_nameToColor;

    public static void convertCMYK2RGB(double c, double m, double y, double k, int[] rgb) {
        rgb[0] = (int)(2.55 * (100.0 - ((100.0 - k) * (c / 100.0) + k)));
        rgb[1] = (int)(2.55 * (100.0 - ((100.0 - k) * (m / 100.0) + k)));
        rgb[2] = (int)(2.55 * (100.0 - ((100.0 - k) * (y / 100.0) + k)));
    }

    public static Color getForeground() {
        if (m_foreground == null) {
            m_foreground = Color.black;
        }
        return m_foreground;
    }

    public static Color getBackground() {
        if (m_background == null) {
            m_background = Color.lightGray;
        }
        return m_background;
    }

    public static Color getShadowDark() {
        if (m_shadowDark == null) {
            m_shadowDark = Color.black;
        }
        return m_shadowDark;
    }

    public static Color getShadowLight() {
        if (m_shadowLight == null) {
            m_shadowLight = LEColor.getForeground().brighter();
        }
        return m_shadowLight;
    }

    public static Color getSelectBackground() {
        if (m_selectBackground == null) {
            m_selectBackground = new Color(0, 92, 209);
        }
        return m_selectBackground;
    }

    public static Color getSelectForeground() {
        if (m_selectForeground == null) {
            m_selectForeground = Color.white;
        }
        return m_selectForeground;
    }

    public static Color getSelectShadowDark() {
        if (m_selectShadowDark == null) {
            m_selectShadowDark = Color.black;
        }
        return m_selectShadowDark;
    }

    public static Color getSelectShadowLight() {
        if (m_selectShadowLight == null) {
            m_selectShadowLight = new Color(186, 239, 254);
        }
        return m_selectShadowLight;
    }

    public static Color getTextBackground() {
        if (m_textBackground == null) {
            m_textBackground = Color.white;
        }
        return m_textBackground;
    }

    public static void setForeground(Color c) {
        m_foreground = c;
    }

    public static void setSelectBackground(Color c) {
        m_selectBackground = c;
        m_selectShadowLight = c.brighter().brighter();
        m_selectShadowDark = c.darker().darker();
    }

    public static void setSelectForeground(Color c) {
        m_selectForeground = c;
    }

    public static void CheckColorFlags() {
        Color clr;
        String sf;
        Color clr2;
        String sb = LEAppInfo.getFlag(SELECT_BACKGROUND_FLAG);
        if (sb != null && (clr2 = LEColor.GetColorForSpec(sb)) != null) {
            LEColor.setSelectBackground(clr2);
        }
        if ((sf = LEAppInfo.getFlag(SELECT_FOREGROUND_FLAG)) != null && (clr = LEColor.GetColorForSpec(sf)) != null) {
            LEColor.setSelectForeground(clr);
        }
    }

    public static Color GetColorForSpec(String spec) {
        Color color = null;
        try {
            int first = spec.indexOf(46);
            if (first == -1) {
                return null;
            }
            String tmp = spec.substring(0, first);
            int r = Integer.parseInt(tmp);
            int second = spec.indexOf(46, first + 1);
            if (second == -1) {
                return null;
            }
            tmp = spec.substring(first + 1, second);
            int g = Integer.parseInt(tmp);
            tmp = spec.substring(second + 1);
            int b = Integer.parseInt(tmp);
            color = new Color(r, g, b);
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return color;
    }

    public static String GetSpecForColor(Color clr) {
        StringBuffer buf = new StringBuffer(11);
        buf.append(clr.getRed());
        buf.append('.');
        buf.append(clr.getGreen());
        buf.append('.');
        buf.append(clr.getBlue());
        return buf.toString();
    }

    public static Color GetColorForName(String name) {
        if (s_nameToColor == null) {
            LEColor.InitializeColorTables();
        }
        return (Color)s_nameToColor.get(name);
    }

    public static String GetNameForColor(Color color) {
        if (s_colorToName == null) {
            LEColor.InitializeColorTables();
        }
        return (String)s_colorToName.get(color);
    }

    public static Color GetColorProperty(String key) {
        Color clr = null;
        String name = LEProperties.GetProperty(key);
        if (name != null && name.length() > 0 && (clr = LEColor.GetColorForName(name)) == null) {
            clr = LEColor.GetColorForSpec(name);
        }
        return clr;
    }

    public static void SetColorProperty(String key, Color clr) {
        String name = LEColor.GetNameForColor(clr);
        if (name == null) {
            name = LEColor.GetSpecForColor(clr);
        }
        LEProperties.SetProperty(key, name);
    }

    static void InitializeColorTables() {
        s_colorToName = new Hashtable();
        s_nameToColor = new Hashtable();
        s_colorToName.put(Color.black, BLACK);
        s_colorToName.put(Color.blue, BLUE);
        s_colorToName.put(Color.cyan, CYAN);
        s_colorToName.put(Color.darkGray, DARK_GRAY);
        s_colorToName.put(Color.gray, GRAY);
        s_colorToName.put(Color.green, GREEN);
        s_colorToName.put(Color.lightGray, LIGHT_GRAY);
        s_colorToName.put(Color.magenta, MAGENTA);
        s_colorToName.put(Color.orange, ORANGE);
        s_colorToName.put(Color.pink, PINK);
        s_colorToName.put(Color.red, RED);
        s_colorToName.put(Color.white, WHITE);
        s_colorToName.put(Color.yellow, YELLOW);
        s_nameToColor.put(BLACK, Color.black);
        s_nameToColor.put(BLUE, Color.blue);
        s_nameToColor.put(CYAN, Color.cyan);
        s_nameToColor.put(DARK_GRAY, Color.darkGray);
        s_nameToColor.put(GRAY, Color.gray);
        s_nameToColor.put(GREEN, Color.green);
        s_nameToColor.put(LIGHT_GRAY, Color.lightGray);
        s_nameToColor.put(MAGENTA, Color.magenta);
        s_nameToColor.put(ORANGE, Color.orange);
        s_nameToColor.put(PINK, Color.pink);
        s_nameToColor.put(RED, Color.red);
        s_nameToColor.put(WHITE, Color.white);
        s_nameToColor.put(YELLOW, Color.yellow);
    }

    static {
        s_colorToName = null;
        s_nameToColor = null;
    }
}

