/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.util.LEDebug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;

public class LECompGrid
extends Panel {
    int[] m_widths;
    int[] m_heights;
    Component[][] m_comps;
    boolean m_colDiv;
    boolean m_bottomDiv;
    int m_border;
    int m_totalWidth;
    int m_totalHeight;

    public LECompGrid(Component[][] comps, int border, boolean colDiv) {
        this.setLayout(null);
        this.m_comps = comps;
        this.m_border = border;
        this.m_colDiv = colDiv;
        int rows = this.m_comps.length;
        int cols = rows > 0 ? this.m_comps[0].length : 0;
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                if (this.m_comps[i][j] != null) {
                    this.add(this.m_comps[i][j]);
                }
                ++j;
            }
            ++i;
        }
    }

    public LECompGrid(Component[][] comps, int border) {
        this(comps, border, false);
    }

    public void setColumnDivider(boolean state) {
        this.m_colDiv = state;
    }

    public void setBottomDivider(boolean state) {
        this.m_bottomDiv = state;
    }

    public int getHeight() {
        return this.m_totalHeight;
    }

    public int getWidth() {
        return this.m_totalWidth;
    }

    public int[] getHeights() {
        if (this.m_heights == null) {
            this.calculateLayout();
        }
        return this.m_heights;
    }

    public int[] getWidths() {
        if (this.m_widths == null) {
            this.calculateLayout();
        }
        return this.m_widths;
    }

    public int getRows() {
        return this.m_comps.length;
    }

    public int getColumns() {
        if (this.m_comps.length == 0) {
            return 0;
        }
        return this.m_comps[0].length;
    }

    public Component getComponent(int row, int col) {
        if (this.m_comps != null && this.m_comps.length > 0 && row < this.m_comps.length && col < this.m_comps[0].length) {
            return this.m_comps[row][col];
        }
        return null;
    }

    public void setHeights(int[] heights) {
        this.m_heights = heights;
        this.m_totalHeight = 0;
        int i = 0;
        while (i < this.m_heights.length) {
            this.m_totalHeight += this.m_heights[i];
            ++i;
        }
    }

    public void setWidths(int[] widths) {
        this.m_widths = widths;
        this.m_totalWidth = 0;
        int i = 0;
        while (i < this.m_widths.length) {
            this.m_totalWidth += this.m_widths[i];
            ++i;
        }
        if (this.m_colDiv) {
            this.m_totalWidth += 2 * this.m_widths.length;
        }
    }

    public Dimension getMinimumSize() {
        if (this.m_heights == null) {
            this.calculateLayout();
        }
        return new Dimension(this.m_totalWidth, this.m_totalHeight);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void redraw() {
        this.doLayout();
    }

    public synchronized void doLayout() {
        try {
            if (this.m_heights == null) {
                this.calculateLayout();
            }
            int y = 0;
            int pad = 2 * this.m_border;
            int i = 0;
            while (i < this.m_heights.length) {
                int x = 0;
                int j = 0;
                while (j < this.m_widths.length) {
                    if (this.m_comps[i][j] != null) {
                        Dimension dim = this.m_comps[i][j].getPreferredSize();
                        int height = Math.min(dim.height, this.m_heights[i]);
                        int width = Math.min(dim.width, this.m_widths[j] - pad);
                        this.m_comps[i][j].setBounds(x + this.m_border, y + (this.m_heights[i] - height) / 2, width, height);
                    }
                    x += this.m_widths[j];
                    if (this.m_colDiv) {
                        x += 2;
                    }
                    ++j;
                }
                y += this.m_heights[i];
                ++i;
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    public void paint(Graphics gc) {
        super.paint(gc);
        if (this.m_widths != null && this.m_colDiv) {
            gc.setColor(Color.gray);
            int len = this.m_widths.length;
            int x = 0;
            int i = 0;
            while (i < len) {
                gc.drawLine(x += this.m_widths[i], 0, x, this.m_totalHeight + 1);
                gc.drawLine(++x, 0, x, this.m_totalHeight + 1);
                ++x;
                ++i;
            }
        }
        if (this.m_bottomDiv) {
            gc.setColor(Color.gray);
            gc.drawLine(0, this.m_totalHeight - 2, this.m_totalWidth, this.m_totalHeight - 2);
            gc.drawLine(0, this.m_totalHeight - 1, this.m_totalWidth, this.m_totalHeight - 1);
        }
    }

    void calculateLayout() {
        try {
            this.m_totalHeight = 0;
            this.m_heights = new int[this.m_comps.length];
            int cols = this.m_comps.length > 0 ? this.m_comps[0].length : 0;
            this.m_widths = new int[cols];
            int pad = 2 * this.m_border;
            int i = 0;
            while (i < this.m_heights.length) {
                this.m_heights[i] = 0;
                int j = 0;
                while (j < this.m_widths.length) {
                    if (i == 0) {
                        this.m_widths[j] = 0;
                    }
                    if (this.m_comps[i][j] != null) {
                        Dimension dim = this.m_comps[i][j].getPreferredSize();
                        this.m_widths[j] = Math.max(this.m_widths[j], dim.width + pad);
                        this.m_heights[i] = Math.max(this.m_heights[i], dim.height + pad);
                    }
                    ++j;
                }
                this.m_totalHeight += this.m_heights[i];
                ++i;
            }
            if (this.m_bottomDiv) {
                this.m_totalHeight += 2;
            }
            this.m_totalWidth = 0;
            int i2 = 0;
            while (i2 < this.m_widths.length) {
                this.m_totalWidth += this.m_widths[i2];
                ++i2;
            }
            if (this.m_colDiv) {
                this.m_totalWidth += 2 * this.m_widths.length;
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }
}

