/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.ui.LECompGrid;
import COM.livingston.ui.LEFiller;
import COM.livingston.ui.LEGridColTitles;
import COM.livingston.ui.LEGridRowTitles;
import COM.livingston.ui.LEScrollPanel;
import COM.livingston.ui.LEScrollable;
import COM.livingston.ui.LEScrollablePanel;
import COM.livingston.util.LEDebug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;

public class LECompMatrix
extends Panel
implements LEScrollable {
    static final int BORDER = 2;
    int m_rows;
    int m_cols;
    LECompGrid m_cgrid;
    LEGridRowTitles m_rowTitles;
    LEGridColTitles m_colTitles;
    LEScrollablePanel m_gridScroll;
    LEFiller m_filler;
    boolean m_colDiv;

    public LECompMatrix(String[] rowTitles, String[] colTitles, Component[][] components) {
        this(rowTitles, colTitles, components, false);
    }

    public LECompMatrix(String[] rowTitles, String[] colTitles, Component[][] components, boolean colDiv) {
        this.setLayout(null);
        this.m_colDiv = colDiv;
        this.m_cgrid = new LECompGrid(components, 2, colDiv);
        this.m_rowTitles = new LEGridRowTitles(rowTitles, 2);
        this.m_colTitles = new LEGridColTitles(colTitles, 2, colDiv);
        this.m_gridScroll = new LEScrollablePanel(this.m_cgrid, false, false);
        this.m_filler = new LEFiller();
        this.add(this.m_gridScroll);
        this.add(this.m_rowTitles);
        this.add(this.m_colTitles);
        this.add(this.m_filler);
        this.m_rows = rowTitles.length;
        this.m_cols = colTitles.length;
    }

    public void setColumnDivider(boolean state) {
        if (this.m_cgrid != null) {
            this.m_cgrid.setColumnDivider(state);
        }
    }

    public Component getComponent(int row, int col) {
        if (this.m_cgrid != null) {
            return this.m_cgrid.getComponent(row, col);
        }
        return null;
    }

    public String getRowTitle(int row) {
        if (this.m_rowTitles != null) {
            return this.m_rowTitles.getTitle(row);
        }
        return null;
    }

    public String getColTitle(int col) {
        if (this.m_colTitles != null) {
            return this.m_colTitles.getTitle(col);
        }
        return null;
    }

    public void doLayout() {
        try {
            this.calculateLayout();
            Dimension dim = this.getSize();
            int width = this.m_rowTitles.getWidth();
            int height = this.m_colTitles.getHeight();
            this.m_filler.setBounds(0, 0, width, height);
            this.m_colTitles.setBounds(width, 0, dim.width - width, height);
            this.m_rowTitles.setBounds(0, height, width, dim.height - height);
            this.m_gridScroll.setBounds(width, height, dim.width - width, dim.height - height);
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    public void setScrollPanel(LEScrollPanel panel) {
    }

    public void setOrigin(int x, int y) {
        this.m_colTitles.setOrigin(x, 0);
        this.m_rowTitles.setOrigin(0, y);
        this.m_gridScroll.setOrigin(x, y);
    }

    public void startScroll() {
        this.m_colTitles.startScroll();
        this.m_rowTitles.startScroll();
        this.m_gridScroll.startScroll();
    }

    public void scrollTo(int x, int y) {
        this.m_colTitles.scrollTo(x, 0);
        this.m_rowTitles.scrollTo(0, y);
        this.m_gridScroll.scrollTo(x, y);
    }

    public void endScroll() {
        this.m_colTitles.endScroll();
        this.m_rowTitles.endScroll();
        this.m_gridScroll.endScroll();
        this.m_cgrid.redraw();
    }

    public Dimension getMinimumSize() {
        return this.totalArea();
    }

    public Dimension getPreferredSize() {
        return this.totalArea();
    }

    public Dimension totalArea() {
        this.calculateLayout();
        int width = this.m_rowTitles.getWidth() + this.m_cgrid.getWidth();
        int height = this.m_colTitles.getHeight() + this.m_cgrid.getHeight();
        return new Dimension(width, height);
    }

    void calculateLayout() {
        try {
            int title;
            int grid;
            int[] gridWidths = this.m_cgrid.getWidths();
            int[] titleWidths = this.m_colTitles.getWidths();
            int[] widths = new int[this.m_cols];
            if (gridWidths == null || titleWidths == null) {
                return;
            }
            int i = 0;
            while (i < this.m_cols) {
                grid = i < gridWidths.length ? gridWidths[i] : 0;
                title = i < titleWidths.length ? titleWidths[i] : 0;
                widths[i] = Math.max(grid, title);
                ++i;
            }
            int[] gridHeights = this.m_cgrid.getHeights();
            int[] titleHeights = this.m_rowTitles.getHeights();
            int[] heights = new int[this.m_rows];
            int i2 = 0;
            while (i2 < heights.length) {
                grid = i2 < gridHeights.length ? gridHeights[i2] : 0;
                title = i2 < titleHeights.length ? titleHeights[i2] : 0;
                heights[i2] = Math.max(grid, title);
                ++i2;
            }
            this.m_cgrid.setHeights(heights);
            this.m_cgrid.setWidths(widths);
            this.m_rowTitles.setHeights(heights);
            this.m_colTitles.setWidths(widths);
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }
}

