/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.ui.LECompGrid;
import COM.livingston.ui.LEFiller;
import COM.livingston.ui.LEScrollPanel;
import COM.livingston.ui.LEScrollable;
import COM.livingston.ui.LEScrollablePanel;
import COM.livingston.util.LEDebug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;

public class LECompMatrix2
extends Panel
implements LEScrollable {
    static final int BORDER = 2;
    int m_rows;
    int m_cols;
    LECompGrid m_cgrid;
    LECompGrid m_rowTitles;
    LECompGrid m_colTitles;
    LEScrollablePanel m_gridScroll;
    LEScrollablePanel m_ctScroll;
    LEScrollablePanel m_rtScroll;
    LEFiller m_filler;
    boolean m_colDiv;

    public LECompMatrix2(Component[][] rowTitles, Component[][] colTitles, Component[][] components) {
        this(rowTitles, colTitles, components, false);
    }

    public LECompMatrix2(Component[][] rowTitles, Component[][] colTitles, Component[][] components, boolean colDiv) {
        this.setLayout(null);
        this.m_colDiv = colDiv;
        this.m_cgrid = new LECompGrid(components, 2, colDiv);
        this.m_rowTitles = new LECompGrid(rowTitles, 2, colDiv);
        this.m_colTitles = new LECompGrid(colTitles, 2, colDiv);
        this.m_colTitles.setBottomDivider(true);
        this.m_gridScroll = new LEScrollablePanel(this.m_cgrid, false, false);
        this.m_ctScroll = new LEScrollablePanel(this.m_colTitles, false, false);
        this.m_rtScroll = new LEScrollablePanel(this.m_rowTitles, false, false);
        this.m_filler = new LEFiller();
        this.add(this.m_gridScroll);
        this.add(this.m_rtScroll);
        this.add(this.m_ctScroll);
        this.add(this.m_filler);
        this.m_rows = rowTitles.length;
        this.m_cols = colTitles[0].length;
    }

    public void setColumnDivider(boolean state) {
        if (this.m_cgrid != null) {
            this.m_cgrid.setColumnDivider(state);
        }
    }

    public Component getComponent(int row, int col) {
        if (this.m_cgrid != null) {
            return this.m_cgrid.getComponent(row, col);
        }
        return null;
    }

    public Component getRowTitle(int row, int col) {
        if (this.m_rowTitles != null) {
            return this.m_rowTitles.getComponent(row, col);
        }
        return null;
    }

    public Component getColTitle(int row, int col) {
        if (this.m_colTitles != null) {
            return this.m_colTitles.getComponent(row, col);
        }
        return null;
    }

    public void doLayout() {
        try {
            this.calculateLayout();
            Dimension dim = this.getSize();
            int width = this.m_rowTitles.getWidth();
            int height = this.m_colTitles.getHeight();
            this.m_filler.setBounds(0, 0, width, height);
            this.m_ctScroll.setBounds(width, 0, dim.width - width, height);
            this.m_rtScroll.setBounds(0, height, width, dim.height - height);
            this.m_gridScroll.setBounds(width, height, dim.width - width, dim.height - height);
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    public void setScrollPanel(LEScrollPanel panel) {
    }

    public void setOrigin(int x, int y) {
        this.m_ctScroll.setOrigin(x, 0);
        this.m_rtScroll.setOrigin(0, y);
        this.m_gridScroll.setOrigin(x, y);
    }

    public void startScroll() {
        this.m_ctScroll.startScroll();
        this.m_rtScroll.startScroll();
        this.m_gridScroll.startScroll();
    }

    public void scrollTo(int x, int y) {
        this.m_ctScroll.scrollTo(x, 0);
        this.m_rtScroll.scrollTo(0, y);
        this.m_gridScroll.scrollTo(x, y);
    }

    public void endScroll() {
        this.m_ctScroll.endScroll();
        this.m_rtScroll.endScroll();
        this.m_gridScroll.endScroll();
        this.m_cgrid.redraw();
        this.m_colTitles.redraw();
        this.m_rowTitles.redraw();
    }

    public Dimension getMinimumSize() {
        return this.totalArea();
    }

    public Dimension getPreferredSize() {
        return this.totalArea();
    }

    public Dimension totalArea() {
        this.calculateLayout();
        int width = this.m_rowTitles.getWidth() + this.m_cgrid.getWidth();
        int height = this.m_colTitles.getHeight() + this.m_cgrid.getHeight();
        return new Dimension(width, height);
    }

    void calculateLayout() {
        try {
            int title;
            int grid;
            int[] gridWidths = this.m_cgrid.getWidths();
            int[] titleWidths = this.m_colTitles.getWidths();
            int[] widths = new int[this.m_cols];
            if (gridWidths == null || titleWidths == null) {
                return;
            }
            int i = 0;
            while (i < this.m_cols) {
                grid = i < gridWidths.length ? gridWidths[i] : 0;
                title = i < titleWidths.length ? titleWidths[i] : 0;
                widths[i] = Math.max(grid, title);
                ++i;
            }
            int[] gridHeights = this.m_cgrid.getHeights();
            int[] titleHeights = this.m_rowTitles.getHeights();
            int[] heights = new int[this.m_rows];
            int i2 = 0;
            while (i2 < heights.length) {
                grid = i2 < gridHeights.length ? gridHeights[i2] : 0;
                title = i2 < titleHeights.length ? titleHeights[i2] : 0;
                heights[i2] = Math.max(grid, title);
                ++i2;
            }
            this.m_cgrid.setHeights(heights);
            this.m_cgrid.setWidths(widths);
            this.m_rowTitles.setHeights(heights);
            this.m_colTitles.setWidths(widths);
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }
}

