/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.ui.LEColor;
import COM.livingston.ui.LEConfirmClient;
import COM.livingston.ui.LEUiUtils;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class LEConfirmDialog
extends Dialog
implements ActionListener,
WindowListener {
    public static final String CANCEL = new String("Cancel");
    public static final String NO = new String("No");
    public static final String OK = new String("OK");
    public static final String YES = new String("Yes");
    LEConfirmClient m_client;
    Object m_data;

    public LEConfirmDialog(Frame parent, LEConfirmClient client, String msg, String[] btns, Object data) {
        super(parent, false);
        this.m_client = client;
        this.m_data = data;
        this.initDialog(new Label(msg, 1), btns);
    }

    public LEConfirmDialog(Frame parent, LEConfirmClient client, Component comp, String[] btns, Object data) {
        super(parent, false);
        this.m_client = client;
        this.m_data = data;
        this.initDialog(comp, btns);
    }

    public void addNotify() {
        super.addNotify();
        Dimension dim = this.getPreferredSize();
        LEUiUtils.CenterDialog(this, dim.width, dim.height);
    }

    public void actionPerformed(ActionEvent e) {
        ((Component)this).setVisible(false);
        if (this.m_client != null) {
            this.m_client.confirmAction(e.getActionCommand(), this.m_data);
        }
        this.dispose();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        ((Component)this).setVisible(false);
        if (this.m_client != null) {
            this.m_client.cancelAction(this.m_data);
        }
        this.dispose();
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    void initDialog(Component msg, String[] btns) {
        this.addWindowListener(this);
        this.setLayout(new BorderLayout(0, 0));
        ((Component)this).setBackground(LEColor.getBackground());
        this.add("Center", msg);
        if (btns == null || btns.length == 0) {
            btns = new String[]{OK};
        }
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1, 5, 5));
        int i = 0;
        while (i < btns.length) {
            Button btn = new Button(btns[i]);
            btn.addActionListener(this);
            panel.add(btn);
            ++i;
        }
        this.add("South", panel);
        this.setTitle("Confirm");
    }
}

