/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.ui.LEColor;
import COM.livingston.ui.LECompGrid;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LELoginClient;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEIPCompare;
import COM.livingston.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Hashtable;

public class LEConnectPanel
extends Panel
implements ItemListener,
ActionListener {
    static final String CONNECT_DATA = new String("connect.cfg");
    TextField m_pm;
    TextField m_user;
    TextField m_pw;
    Choice m_choice;
    Button m_connect;
    Button m_clear;
    LECompGrid m_grid;
    LELoginClient m_client;
    static String s_path = null;
    static Hashtable s_users;
    static LEVector s_history;
    static LEVector s_panels;

    public LEConnectPanel(LELoginClient client, ActionListener closer) {
        this.m_client = client;
        if (s_path == null) {
            this.initialize();
        }
        this.setLayout(new BorderLayout(0, 0));
        Component[][] comps = new Component[4][2];
        comps[0][0] = new Label("PortMaster:");
        comps[0][0].setFont(LEFont.getBoldFont());
        this.m_pm = new TextField(40);
        comps[0][1] = this.m_pm;
        ((Component)this.m_pm).setBackground(LEColor.getTextBackground());
        this.m_choice = new Choice();
        comps[1][1] = this.m_choice;
        this.m_choice.addItemListener(this);
        int len = s_history.size();
        int i = 0;
        while (i < len) {
            this.m_choice.add((String)s_history.elementAt(i));
            ++i;
        }
        comps[2][0] = new Label("Username:");
        comps[2][0].setFont(LEFont.getBoldFont());
        this.m_user = new TextField("!root", 40);
        comps[2][1] = this.m_user;
        ((Component)this.m_user).setBackground(LEColor.getTextBackground());
        comps[3][0] = new Label("Password:");
        comps[3][0].setFont(LEFont.getBoldFont());
        this.m_pw = new TextField(40);
        comps[3][1] = this.m_pw;
        ((Component)this.m_pw).setBackground(LEColor.getTextBackground());
        this.m_pw.setEchoChar('*');
        this.m_pw.addActionListener(this);
        this.m_grid = new LECompGrid(comps, 2);
        Panel sub = new Panel();
        sub.setLayout(new FlowLayout(1));
        sub.add(this.m_grid);
        this.add("North", sub);
        Panel btns = new Panel();
        btns.setLayout(new FlowLayout(1));
        sub = new Panel();
        sub.setLayout(new GridLayout(1, 2, 5, 5));
        this.m_connect = new Button("Connect");
        this.m_connect.addActionListener(this);
        sub.add(this.m_connect);
        this.m_clear = new Button("Clear");
        this.m_clear.addActionListener(this);
        sub.add(this.m_clear);
        if (closer != null) {
            Button btn = new Button("Close");
            btn.addActionListener(closer);
            sub.add(btn);
        }
        btns.add(sub);
        this.add("South", btns);
        s_panels.addElement(this);
    }

    public void set(String pm, String user, String pw) {
        ((TextComponent)this.m_pm).setText(pm);
        ((TextComponent)this.m_user).setText(user);
        ((TextComponent)this.m_pw).setText(pw);
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.m_clear) {
            ((TextComponent)this.m_pm).setText(null);
            ((TextComponent)this.m_user).setText("!root");
            ((TextComponent)this.m_pw).setText(null);
        } else if (src == this.m_connect || src == this.m_pw) {
            String tmp;
            String pm = this.m_pm.getText();
            if (pm.length() == 0 && (tmp = this.m_choice.getSelectedItem()) != null) {
                pm = tmp;
            }
            String user = this.m_user.getText();
            String pw = this.m_pw.getText();
            if (pm.length() > 0 && user.length() > 0) {
                this.addLogin(pm, user);
                ((TextComponent)this.m_pw).setText(null);
                this.m_pm.select(0, pm.length());
                this.m_pm.requestFocus();
            }
            if (this.m_client != null) {
                this.m_client.loginTo(pm, user, pw);
            }
        }
    }

    public void itemStateChanged(ItemEvent event) {
        String pm = (String)event.getItem();
        String user = (String)s_users.get(pm);
        ((TextComponent)this.m_pm).setText(pm);
        ((TextComponent)this.m_user).setText(user);
        this.m_pw.requestFocus();
    }

    void addLogin(String pm, String user) {
        block5: {
            s_users.put(pm, user);
            if (s_history.contains(pm)) break block5;
            s_history.addElement(pm);
            s_history.quickSort(new LEIPCompare());
            int len = s_panels.size();
            int histLen = s_history.size();
            int i = 0;
            while (i < len) {
                LEConnectPanel panel = (LEConnectPanel)s_panels.elementAt(i);
                panel.m_choice.removeAll();
                int j = 0;
                while (j < histLen) {
                    panel.m_choice.add((String)s_history.elementAt(j));
                    ++j;
                }
                panel.m_choice.invalidate();
                panel.m_grid.invalidate();
                panel.m_grid.validate();
                ++i;
            }
            File file = new File(s_path);
            try {
                FileWriter filew = new FileWriter(file);
                PrintWriter prw = new PrintWriter((Writer)filew, true);
                len = s_history.size();
                int i2 = 0;
                while (i2 < len) {
                    pm = (String)s_history.elementAt(i2);
                    user = (String)s_users.get(pm);
                    prw.print(pm);
                    prw.print(',');
                    prw.println(user);
                    ++i2;
                }
                prw = null;
                filew.close();
            }
            catch (IOException iOException) {}
        }
    }

    void initialize() {
        block5: {
            s_users = new Hashtable();
            s_history = new LEVector();
            s_panels = new LEVector();
            s_path = LEAppInfo.getUserDirPath(CONNECT_DATA);
            File file = new File(s_path);
            if (!file.exists()) break block5;
            try {
                FileReader filer = new FileReader(file);
                BufferedReader reader = new BufferedReader(filer);
                String line = reader.readLine();
                while (line != null) {
                    int len = line.length();
                    int index = line.indexOf(44);
                    if (index > -1 && index < len) {
                        String pm = line.substring(0, index);
                        String user = line.substring(index + 1, len);
                        s_history.addElement(pm);
                        s_users.put(pm, user);
                    }
                    line = reader.readLine();
                }
                reader = null;
                filer.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {}
        }
    }
}

