/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.ui.LEBorderPanel;
import COM.livingston.ui.LECompGrid;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LEScrollPanel;
import COM.livingston.ui.LEScrollablePanel;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class LEErrorListDialog
extends Dialog
implements ActionListener,
WindowListener {
    static final int WIDTH = 340;
    static final int HEIGHT = 200;

    public LEErrorListDialog(Frame parent, LEVector errors) {
        super(parent, "Error", true);
        this.addWindowListener(this);
        this.setLayout(new BorderLayout(5, 5));
        Label label = new Label("The following filters were not able to be copied.");
        label.setFont(LEFont.getBoldFont());
        Panel toppanel = new Panel(new FlowLayout(1));
        toppanel.add(label);
        this.add("North", toppanel);
        this.add("Center", this.createErrorList(errors));
        Panel buttonpanel = new Panel(new FlowLayout(1));
        Button btn = new Button("OK");
        btn.addActionListener(this);
        buttonpanel.add(btn);
        this.add("South", buttonpanel);
        ((Component)this).setSize(340, 200);
        ((Component)this).setVisible(true);
    }

    public void addNotify() {
        super.addNotify();
        LEUiUtils.CenterDialog(this, 340, 200);
    }

    public void actionPerformed(ActionEvent e) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    private Panel createErrorList(LEVector errors) {
        int len = errors.size();
        Component[][] errmsgs = new Label[len][1];
        int i = 0;
        while (i < len) {
            String msg = (String)errors.elementAt(i);
            errmsgs[i][0] = new Label(msg);
            ++i;
        }
        LECompGrid err_grid = new LECompGrid(errmsgs, 0);
        LEScrollablePanel scrollablepanel = new LEScrollablePanel(err_grid, true, false);
        LEScrollPanel scrollpanel = new LEScrollPanel(scrollablepanel);
        LEBorderPanel border = new LEBorderPanel(2);
        border.setLayout(new BorderLayout());
        border.add("Center", scrollpanel);
        return border;
    }
}

