/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.util.LEDebug;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class LEFlashingText
extends Canvas
implements Runnable {
    static Color[] s_colors = null;
    String m_text;
    Font m_font;
    Thread m_thread;
    int m_index;

    public LEFlashingText(String text) {
        this.m_text = text;
    }

    public void addNotify() {
        super.addNotify();
        Font font = this.getFont();
        String name = font.getName();
        this.m_font = new Font(name, 1, 48);
        if (s_colors == null) {
            s_colors = new Color[3];
            LEFlashingText.s_colors[0] = Color.blue;
            LEFlashingText.s_colors[1] = Color.red;
            LEFlashingText.s_colors[2] = Color.white;
        }
        this.m_thread = new Thread(this);
        this.m_thread.start();
    }

    public void stop() {
        if (this.m_thread != null) {
            this.m_thread.stop();
        }
    }

    public void update(Graphics gc) {
        this.paint(gc);
    }

    public void paint(Graphics gc) {
        if (this.m_text == null) {
            return;
        }
        if (this.m_index > 2) {
            this.m_index = 0;
        }
        gc.setColor(s_colors[this.m_index]);
        gc.setFont(this.m_font);
        FontMetrics fm = gc.getFontMetrics();
        int width = fm.stringWidth(this.m_text);
        int height = fm.getHeight();
        Dimension dim = this.getSize();
        int x = (dim.width - width) / 2;
        int y = (dim.height - height) / 2 + fm.getAscent();
        gc.drawString(this.m_text, x, y);
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    ++this.m_index;
                    this.repaint();
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                LEDebug.getLog().logln(20, e);
                continue;
            }
            break;
        }
    }
}

