/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.ui.LEGridTitles;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class LEGridColTitles
extends LEGridTitles {
    int[] m_widths;
    boolean m_colDiv;

    public LEGridColTitles(String[] titles, int border, boolean colDiv) {
        super(titles, border);
        this.m_colDiv = colDiv;
    }

    public int[] getWidths() {
        if (this.m_widths == null) {
            this.calculateLayout();
        }
        return this.m_widths;
    }

    public void setWidths(int[] widths) {
        this.m_widths = widths;
        this.m_width = 0;
        int i = 0;
        while (i < this.m_widths.length) {
            this.m_width += this.m_widths[i];
            ++i;
        }
        if (this.m_colDiv) {
            this.m_width += 2 * this.m_widths.length;
        }
    }

    void drawTitles() {
        Dimension dim = this.getSize();
        int width = Math.max(this.m_width, dim.width);
        int height = Math.max(this.m_height, dim.height);
        this.m_buf = this.createImage(width, height);
        Graphics gc = this.m_buf.getGraphics();
        gc.setColor(this.getBackground());
        gc.fillRect(0, 0, width, height);
        gc.setColor(this.getForeground());
        gc.setFont(this.getFont());
        FontMetrics fm = gc.getFontMetrics();
        int x = 0;
        int y = this.m_border + fm.getAscent();
        int i = 0;
        while (i < this.m_titles.length) {
            if (this.m_titles[i] != null) {
                int pad = (this.m_widths[i] - fm.stringWidth(this.m_titles[i])) / 2;
                gc.drawString(this.m_titles[i], x + pad, y);
            }
            x += this.m_widths[i];
            if (this.m_colDiv) {
                gc.setColor(Color.gray);
                gc.drawLine(x, height / 2, x, height);
                gc.drawLine(++x, height / 2, x, height);
                ++x;
                gc.setColor(Color.black);
            }
            ++i;
        }
        gc.setColor(Color.gray);
        gc.drawLine(0, height - 2, width - 1, height - 2);
        gc.drawLine(0, height - 1, width - 1, height - 1);
        gc.dispose();
    }

    void calculateLayout() {
        Graphics gc = this.getGraphics();
        if (gc == null) {
            return;
        }
        gc.dispose();
        Font f = this.getFont();
        this.setFont(new Font(f.getFamily(), 1, f.getSize()));
        gc = this.getGraphics();
        FontMetrics fm = gc.getFontMetrics();
        int pad = 2 * this.m_border;
        this.m_height = fm.getHeight() + pad + 2;
        this.m_widths = new int[this.m_titles.length];
        int i = 0;
        while (i < this.m_titles.length) {
            this.m_widths[i] = pad;
            if (this.m_titles[i] != null) {
                int n = i;
                this.m_widths[n] = this.m_widths[n] + fm.stringWidth(this.m_titles[i]);
            }
            ++i;
        }
    }
}

