/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.ui.LEGridTitles;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class LEGridRowTitles
extends LEGridTitles {
    int[] m_heights;

    public LEGridRowTitles(String[] titles, int border) {
        super(titles, border);
    }

    public int[] getHeights() {
        if (this.m_heights == null) {
            this.calculateLayout();
        }
        return this.m_heights;
    }

    public void setHeights(int[] heights) {
        this.m_heights = heights;
        this.m_height = 0;
        int i = 0;
        while (i < this.m_heights.length) {
            this.m_height += this.m_heights[i];
            ++i;
        }
    }

    void drawTitles() {
        Dimension dim = this.getSize();
        int width = Math.max(this.m_width, dim.width);
        int height = Math.max(this.m_height, dim.height);
        if (this.m_buf == null) {
            this.m_buf = this.createImage(width, height);
        }
        Graphics gc = this.m_buf.getGraphics();
        gc.setColor(this.getBackground());
        gc.fillRect(0, 0, width, height);
        gc.setColor(this.getForeground());
        gc.setFont(this.getFont());
        FontMetrics fm = gc.getFontMetrics();
        int fontHeight = fm.getHeight();
        int x = this.m_border;
        int y = 0;
        int i = 0;
        while (i < this.m_titles.length) {
            if (this.m_titles[i] != null) {
                int pad = (this.m_heights[i] - fontHeight) / 2 + fm.getAscent();
                gc.drawString(this.m_titles[i], x, y + pad);
            }
            y += this.m_heights[i];
            ++i;
        }
        gc.setColor(Color.gray);
        gc.drawLine(width - 2, 0, width - 2, height - 1);
        gc.drawLine(width - 1, 0, width - 1, height - 1);
    }

    void calculateLayout() {
        Graphics gc = this.getGraphics();
        if (gc == null) {
            return;
        }
        gc.dispose();
        Font f = this.getFont();
        this.setFont(new Font(f.getFamily(), 1, f.getSize()));
        gc = this.getGraphics();
        FontMetrics fm = gc.getFontMetrics();
        int pad = 2 * this.m_border + 2;
        this.m_height = fm.getHeight() + pad;
        this.m_heights = new int[this.m_titles.length];
        this.m_width = pad;
        int i = 0;
        while (i < this.m_titles.length) {
            this.m_heights[i] = this.m_height;
            if (this.m_titles[i] != null) {
                this.m_width = Math.max(this.m_width, fm.stringWidth(this.m_titles[i]) + pad);
            }
            ++i;
        }
    }
}

