/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.ui.LEScrollPanel;
import COM.livingston.ui.LEScrollable;
import COM.livingston.util.LEDebug;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public abstract class LEGridTitles
extends Canvas
implements LEScrollable {
    String[] m_titles;
    int m_height = -1;
    int m_border;
    int m_width = -1;
    Image m_buf;
    int m_x;
    int m_y;

    public LEGridTitles(String[] titles, int border) {
        this.m_titles = titles;
        this.m_border = border;
    }

    public int getHeight() {
        if (this.m_height == -1) {
            this.calculateLayout();
        }
        return this.m_height;
    }

    public int getWidth() {
        if (this.m_width == -1) {
            this.calculateLayout();
        }
        return this.m_width;
    }

    public String getTitle(int index) {
        if (this.m_titles != null && index < this.m_titles.length) {
            return this.m_titles[index];
        }
        return null;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.m_width, this.m_height);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void paint(Graphics gc) {
        this.update(gc);
    }

    public void update(Graphics g) {
        try {
            if (this.m_buf == null) {
                this.drawTitles();
            }
            g.drawImage(this.m_buf, this.m_x, this.m_y, null);
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    public void setScrollPanel(LEScrollPanel panel) {
    }

    public void setOrigin(int x, int y) {
        this.m_x = x;
        this.m_y = y;
    }

    public void startScroll() {
    }

    public void scrollTo(int x, int y) {
        this.m_x = x;
        this.m_y = y;
        this.repaint();
    }

    public void endScroll() {
    }

    public Dimension totalArea() {
        return new Dimension(this.m_width, this.m_height);
    }

    abstract void drawTitles();

    abstract void calculateLayout();
}

